// Endogenous variables
var 
Util1,
Util2,
c1c,
c1cd,
c1mc,
c1y,
c1g,
c1rpcpd,
c1pid,
c1hp,
c1gp,
c1pstar,
c1deltad,
c1rn,
c1rer
c1dcore,
c2c,
c2cd,
c2mc,
c2y,
c2g,
c2rpcpd,
c2pid,
c2hp,
c2gp,
c2pstar,
c2deltad,
c2rn,
c2dcore;

// Exogenous variables 
var c1shockgy,
c1z,
c1taupvar,
c2shockgy,
c2z,
c2taupvar;

varexo  c1shockgyerr
c1zerr
c2shockgyerr
c2zerr
c2taupvarerr
c1taupvarerr
c1monerr
c2monerr;

parameters  
c1sigma,
c1beta,
c1rhoc,             
c1sharegy,          
c1rhogy,            
c1sigmagy,  
c1rhoz,           
c1sigmaz,       
c2sigma,            
c2beta,             
c2rhoc,             
c2sharegy,          
c2rhogy,            
c2sigmagy, 
c2rhoz,           
c2sigmaz,       
c2rhotaupvar,     
c2sigmataupvarerr,
c1rhotaupvar,     
c1sigmataupvarerr,
c2chi,              
c1chi,              
c2nup,           
c1nup,           
c2xip,              
c1xip,              
c1chi0,
c1omegac,
c1omegamc,
c1relc2,
c1pistar,
c1taup,
c2chi0,
c2omegac,
c2omegamc,
c2pistar,
c2taup,
c1rnss,
c2rnss,
c1gamrn,                      
c1gamdpc,                        
c2gamrn,            
c2gamdpc,
c2lambdaqss,
c2rpcpdss,
c1rerss,
c1lambdaqss,
c1rpcpdss;

model;

//////////////////////////////////
// Monetary policy bloc
//////////////////////////////////

// Utility, country 1
Util1 = (exp(c1c))^(1-c1sigma)/(1-c1sigma)-c1chi0*(exp(c1z))^(-c1chi)*(exp(c1y))^(1+c1chi)/(1+c1chi)*exp(c1deltad);

// Utility, country 2
Util2 = (exp(c2c))^(1-c2sigma)/(1-c2sigma)-c2chi0*(exp(c2z))^(-c2chi)*(exp(c2y))^(1+c2chi)/(1+c2chi)*exp(c2deltad);

// Policy Rule, country 1
c1rn = (1+c1rnss)*(((1+c1rn(-1))/(1+c1rnss))^c1gamrn*((c1pid/c1pistar)*(c1pid/c1pistar)^c1gamdpc)^(1-c1gamrn))*(1+c1monerr)-1;

// Policy Rule, country 2
c2rn = (1+c2rnss)*(((1+c2rn(-1))/(1+c2rnss))^c2gamrn*((c2pid/c2pistar)*(c2pid/c2pistar)^c2gamdpc)^(1-c2gamrn))*(1+c2monerr)-1;


//////////////////////////////////
// Home country bloc 
//////////////////////////////////

// definition of nominal interest rate 
1/(1+(c1rn)) = c1beta*(((exp(c1c(+1)))^(-c1sigma)/exp(c1rpcpd(+1))))/(((exp(c1c))^(-c1sigma)/exp(c1rpcpd)))/c1pid(+1);

// fonc domestic consumption good
exp(c1rpcpd)*(c1omegac*exp(c1c)/exp(c1cd))^(c1rhoc/(1+c1rhoc)) = 1;

// fonc imported good
(exp(c1rer))/(exp(c2rpcpd))= (c1omegamc*exp(c1c)/exp(c1mc))^(c1rhoc/(1+c1rhoc));

// final consumption 
exp(c1c) = ((c1omegac)^(c1rhoc/(1+c1rhoc))*exp(c1cd)^(1/(1+c1rhoc))+(c1omegamc)^(c1rhoc/(1+c1rhoc))*(exp(c1mc))^(1/(1+c1rhoc)))^(1+c1rhoc);

// definition of pstar
(exp(c1pstar))^(1+(1+c1nup)/(c1nup)*c1chi) = (exp(c1hp))/(exp(c1gp));

// definition of hp
(exp(c1hp)) = (1+(c1nup))/(c1nup)
*c1chi0*(exp(c1y)/exp(c1z))^(c1chi)/((exp(c1c))^(-c1sigma)/exp(c1rpcpd))*exp(c1y)
+ c1xip*c1beta*(((exp(c1c(+1)))^(-c1sigma)/exp(c1rpcpd(+1))))/(((exp(c1c))^(-c1sigma)/exp(c1rpcpd)))*((c1pistar)/(c1pid(+1)))^(-(1
+(c1nup))/(c1nup)*(1+c1chi))*(exp(c1hp(+1)));

// definition of gp
(exp(c1gp)) = (1+c1taup*exp(c1taupvar))/(c1nup)*(exp(c1y))+c1xip*c1beta*(((exp(c1c(+1)))^(-c1sigma)/exp(c1rpcpd(+1))))/(((exp(c1c))^(-c1sigma)/exp(c1rpcpd)))*((c1pistar)/(c1pid(+1)))^(1
-(1+(c1nup))/(c1nup))*(exp(c1gp(+1)));

// price evolution
(1-c1xip)*((exp(c1pstar)))^(-1/(c1nup))+c1xip*((c1pistar)/(c1pid))^(-1/(c1nup)) = 1;

// evolution of price dispersion
(exp(c1deltad)) = (1-c1xip)*((exp(c1pstar)))^(-(1+(c1nup))/(c1nup)*(1+c1chi))
+c1xip*((c1pistar)/(c1pid))^(-(1+(c1nup))/(c1nup)*(1+c1chi))*(exp(c1deltad(-1)));

// resource constraint goods
exp(c1y) = exp(c1cd)+exp(c1g)+1/c1relc2*(exp(c2mc));

// government spending
exp(c1g) = c1sharegy*exp(c1y)*exp(c1shockgy);

// core inflation
c1dcore = exp(c1rpcpd)/exp(c1rpcpd(-1))*c1pid;

//////////////////////////////////
// Foreign country bloc 
//////////////////////////////////

// definition of nominal interest rate
1/(1+(c2rn)) = c2beta*(((exp(c2c(+1)))^(-c2sigma)/exp(c2rpcpd(+1))))/(((exp(c2c))^(-c2sigma)/exp(c2rpcpd)))/c2pid(+1);

// fonc domestic consumption good
(exp(c2rpcpd))*(c2omegac*(exp(c2c))/(exp(c2cd)))^(c2rhoc/(1+c2rhoc)) = 1;

// fonc imported good
1/(exp(c1rer))/(exp(c1rpcpd)) = (c2omegamc*(exp(c2c))/(exp(c2mc)))^(c2rhoc/(1+c2rhoc));

// final consumption
(exp(c2c)) = ((c2omegac)^(c2rhoc/(1+c2rhoc))*(exp(c2cd))^(1/(1+c2rhoc))+(c2omegamc)^(c2rhoc/(1+c2rhoc))*((exp(c2mc)))^(1/(1+c2rhoc)))^(1+c2rhoc);

// definition of pstar
(exp(c2pstar))^(1+(1+c2nup)/(c2nup)*c2chi) = (exp(c2hp))/(exp(c2gp));

// definition of hp
(exp(c2hp)) = (1+(c2nup))/(c2nup)
*c2chi0*(exp(c2y)/exp(c2z))^c2chi/((exp(c2c))^(-c2sigma)/exp(c2rpcpd))*exp(c2y)
+ c2xip*c2beta*(((exp(c2c(+1)))^(-c2sigma)/exp(c2rpcpd(+1))))/(((exp(c2c))^(-c2sigma)/exp(c2rpcpd)))*((c2pistar)/(c2pid(+1)))^(-(1
+(c2nup))/(c2nup)*(1+c2chi))*(exp(c2hp(+1)));

// definition of gp
(exp(c2gp)) = (1+c2taup*exp(c2taupvar))/(c2nup)*(exp(c2y))+c2xip*c2beta*(((exp(c2c(+1)))^(-c2sigma)/exp(c2rpcpd(+1))))/(((exp(c2c))^(-c2sigma)/exp(c2rpcpd)))*((c2pistar)/(c2pid(+1)))^(1
-(1+(c2nup))/(c2nup))*(exp(c2gp(+1)));

// price evolution
(1-c2xip)*((exp(c2pstar)))^(-1/(c2nup))+c2xip*((c2pistar)/(c2pid))^(-1/(c2nup)) = 1;

// evolution of price dispersion
(exp(c2deltad)) = (1-c2xip)*((exp(c2pstar)))^(-(1+(c2nup))/(c2nup)*(1+c2chi))
+c2xip*((c2pistar)/(c2pid))^(-(1+(c2nup))/(c2nup)*(1+c2chi))*(exp(c2deltad(-1)));

// resource constraint goods
(exp(c2y)) = (exp(c2cd))+(exp(c2g))+(c1relc2*(exp(c1mc)));

// government spending
(exp(c2g)) = c2sharegy*(exp(c2y))*(exp(c2shockgy));

// core inflation
c2dcore = exp(c2rpcpd)/exp(c2rpcpd(-1))*c2pid;


////////////////////////
// international links
////////////////////////

// risk sharing 
c2lambdaqss/((exp(c2c))^(-c2sigma))*c2rpcpdss = c1rerss/(exp(c1rer))*c1lambdaqss/((exp(c1c))^(-c1sigma))*c1rpcpdss;


/////////////////////////
// exogenous variables
/////////////////////////

c1shockgy = c1rhogy*c1shockgy(-1) + c1sigmagy*c1shockgyerr;

c1z = c1rhoz*c1z(-1) + c1sigmaz*c1zerr;

c1taupvar = c1rhotaupvar*c1taupvar(-1)+c1sigmataupvarerr*c1taupvarerr;

c2shockgy = c2rhogy*c2shockgy(-1) + c2sigmagy*c2shockgyerr;

c2z = c2rhoz*c2z(-1) + c2sigmaz*c2zerr;

c2taupvar = c2rhotaupvar*c2taupvar(-1)+c2sigmataupvarerr*c2taupvarerr;

end;


//shocks;
//var c1shockgyerr = 1; 
//var c1zcerr = 1; 
//var c2shockgyerr = 0; 
//var c2zcerr = 1;
//var c2taupvarerr = 0;
//var c1taupvarerr = 1;
//end;

steady;

check;

stoch_simul(order=2,nocorr,noprint,irf=0);
