function [residual, g1, g2, g3] = BBCDLmodelcomp_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [M_.exo_nbr by nperiods] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(35, 1);
T21 = params(27)*exp(y(43))^(-params(22));
T23 = exp(y(18));
T25 = T23^(1+params(22));
T30 = T21*T25/(1+params(22))*exp(y(25));
T46 = params(33)*exp(y(46))^(-params(21));
T48 = exp(y(32));
T50 = T48^(1+params(21));
T55 = T46*T50/(1+params(21))*exp(y(39));
T65 = ((1+y(3))/(1+params(38)))^params(40);
T68 = y(21)/params(31);
T70 = T68^params(41);
T73 = (T68*T70)^(1-params(40));
T88 = ((1+y(6))/(1+params(39)))^params(42);
T91 = y(35)/params(36);
T93 = T91^params(43);
T96 = (T91*T93)^(1-params(42));
T113 = exp(y(48))^(-params(1))/exp(y(49));
T115 = exp(y(15))^(-params(1));
T118 = T115/exp(y(20));
T127 = exp(y(15))*params(28)/exp(y(16));
T130 = params(3)/(1+params(3));
T132 = exp(y(20))*T127^T130;
T138 = exp(y(27))/exp(y(34));
T143 = exp(y(15))*params(29)/exp(y(17));
T147 = 1/(1+params(3));
T153 = params(28)^T130*exp(y(16))^T147+params(29)^T130*exp(y(17))^T147;
T162 = 1+params(22)*(1+params(24))/params(24);
T170 = params(27)*(1+params(24))/params(24);
T171 = T23/exp(y(43));
T173 = T170*T171^params(22);
T179 = T113*params(2)*params(26)/T118;
T180 = params(31)/y(50);
T183 = (1+params(22))*(-(1+params(24)))/params(24);
T184 = T180^T183;
T199 = T180^(1-(1+params(24))/params(24));
T207 = (-1)/params(24);
T210 = params(31)/y(21);
T255 = exp(y(53))^(-params(9))/exp(y(54));
T257 = exp(y(29))^(-params(9));
T258 = T257/exp(y(34));
T267 = exp(y(29))*params(34)/exp(y(30));
T270 = params(11)/(1+params(11));
T272 = exp(y(34))*T267^T270;
T278 = exp(y(29))*params(35)/exp(y(31));
T282 = 1/(1+params(11));
T288 = params(34)^T270*exp(y(30))^T282+params(35)^T270*exp(y(31))^T282;
T297 = 1+params(21)*(1+params(23))/params(23);
T305 = params(33)*(1+params(23))/params(23);
T306 = T48/exp(y(46));
T308 = T305*T306^params(21);
T314 = T255*params(10)*params(25)/T258;
T315 = params(36)/y(55);
T318 = (1+params(21))*(-(1+params(23)))/params(23);
T319 = T315^T318;
T334 = T315^(1-(1+params(23))/params(23));
T342 = (-1)/params(23);
T345 = params(36)/y(35);
T384 = params(46)/exp(y(27))*params(47);
T442 = exp(y(15))*getPowerDeriv(exp(y(15)),(-params(1)),1);
T443 = T442/exp(y(20));
T462 = (-(T113*params(2)*params(26)*T443))/(T118*T118);
T477 = exp(y(48))*getPowerDeriv(exp(y(48)),(-params(1)),1);
T478 = T477/exp(y(49));
T484 = params(2)*params(26)*T478/T118;
T494 = (-(exp(y(15))*params(28)*exp(y(16))))/(exp(y(16))*exp(y(16)));
T495 = getPowerDeriv(T127,T130,1)*T494;
T499 = params(28)^T130*exp(y(16))*getPowerDeriv(exp(y(16)),T147,1);
T500 = getPowerDeriv(T153,1+params(3),1);
T507 = (-(exp(y(15))*params(29)*exp(y(17))))/(exp(y(17))*exp(y(17)));
T508 = getPowerDeriv(T143,T130,1)*T507;
T512 = params(29)^T130*exp(y(17))*getPowerDeriv(exp(y(17)),T147,1);
T517 = T23*getPowerDeriv(T23,1+params(22),1);
T520 = exp(y(25))*T21*T517/(1+params(22));
T524 = T170*T171*getPowerDeriv(T171,params(22),1);
T527 = T23*T173/T118+T23*T524/T118;
T535 = (-(exp(y(20))*exp(y(1))))/(exp(y(1))*exp(y(1)));
T537 = (-(y(21)*T535));
T540 = exp(y(20))*exp(y(20));
T541 = (-(T115*exp(y(20))))/T540;
T553 = (-(T113*params(2)*params(26)*T541))/(T118*T118);
T563 = (-(exp(y(20))*1/exp(y(27))));
T566 = (-(exp(y(48))^(-params(1))*exp(y(49))));
T568 = T566/(exp(y(49))*exp(y(49)));
T574 = params(2)*params(26)*T568/T118;
T581 = 1/params(31);
T583 = T581*getPowerDeriv(T68,params(41),1);
T590 = (1+params(38))*T65*(T70*T581+T68*T583)*getPowerDeriv(T68*T70,1-params(40),1);
T595 = (-params(31))/(y(21)*y(21));
T609 = (-params(31))/(y(50)*y(50));
T611 = T609*getPowerDeriv(T180,T183,1);
T615 = getPowerDeriv(T180,1-(1+params(24))/params(24),1);
T616 = T609*T615;
T626 = (-((-(exp(y(22))*exp(y(23))))/(exp(y(23))*exp(y(23)))));
T629 = exp(y(24))*getPowerDeriv(exp(y(24)),T162,1);
T641 = 1/(1+params(38))*getPowerDeriv((1+y(3))/(1+params(38)),params(40),1);
T655 = params(47)*(-(exp(y(27))*params(46)))/(exp(y(27))*exp(y(27)));
T664 = exp(y(29))*getPowerDeriv(exp(y(29)),(-params(9)),1);
T665 = T664/exp(y(34));
T684 = (-(T255*params(10)*params(25)*T665))/(T258*T258);
T698 = exp(y(53))*getPowerDeriv(exp(y(53)),(-params(9)),1);
T699 = T698/exp(y(54));
T705 = params(10)*params(25)*T699/T258;
T715 = (-(exp(y(29))*params(34)*exp(y(30))))/(exp(y(30))*exp(y(30)));
T716 = getPowerDeriv(T267,T270,1)*T715;
T720 = params(34)^T270*exp(y(30))*getPowerDeriv(exp(y(30)),T282,1);
T721 = getPowerDeriv(T288,1+params(11),1);
T729 = (-(exp(y(31))*exp(y(29))*params(35)))/(exp(y(31))*exp(y(31)));
T730 = getPowerDeriv(T278,T270,1)*T729;
T734 = params(35)^T270*exp(y(31))*getPowerDeriv(exp(y(31)),T282,1);
T738 = T48*getPowerDeriv(T48,1+params(21),1);
T741 = exp(y(39))*T46*T738/(1+params(21));
T745 = T305*T306*getPowerDeriv(T306,params(21),1);
T748 = T48*T308/T258+T48*T745/T258;
T756 = (-(exp(y(34))*exp(y(4))))/(exp(y(4))*exp(y(4)));
T758 = (-(y(35)*T756));
T761 = exp(y(34))*exp(y(34));
T762 = (-(exp(y(27))*exp(y(34))))/T761;
T765 = (-(exp(y(34))*T257))/T761;
T777 = (-(T255*params(10)*params(25)*T765))/(T258*T258);
T787 = (-(exp(y(53))^(-params(9))*exp(y(54))));
T789 = T787/(exp(y(54))*exp(y(54)));
T795 = params(10)*params(25)*T789/T258;
T802 = 1/params(36);
T804 = T802*getPowerDeriv(T91,params(43),1);
T811 = (1+params(39))*T88*(T93*T802+T91*T804)*getPowerDeriv(T91*T93,1-params(42),1);
T816 = (-params(36))/(y(35)*y(35));
T830 = (-params(36))/(y(55)*y(55));
T832 = T830*getPowerDeriv(T315,T318,1);
T836 = getPowerDeriv(T315,1-(1+params(23))/params(23),1);
T837 = T830*T836;
T847 = (-((-(exp(y(36))*exp(y(37))))/(exp(y(37))*exp(y(37)))));
T850 = exp(y(38))*getPowerDeriv(exp(y(38)),T297,1);
T862 = 1/(1+params(39))*getPowerDeriv((1+y(6))/(1+params(39)),params(42),1);
T876 = exp(y(25))*T25*params(27)*exp(y(43))*getPowerDeriv(exp(y(43)),(-params(22)),1)/(1+params(22));
T881 = (-(exp(y(43))*T23))/(exp(y(43))*exp(y(43)));
T882 = getPowerDeriv(T171,params(22),1)*T881;
T883 = T170*T882;
T890 = (-(T23*params(32)*exp(y(44))/params(24)));
T898 = exp(y(39))*T50*params(33)*exp(y(46))*getPowerDeriv(exp(y(46)),(-params(21)),1)/(1+params(21));
T903 = (-(exp(y(46))*T48))/(exp(y(46))*exp(y(46)));
T904 = getPowerDeriv(T306,params(21),1)*T903;
T905 = T305*T904;
T912 = (-(T48*params(37)*exp(y(47))/params(23)));
T1030 = T442+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),(-params(1)),2);
T1031 = T1030/exp(y(20));
T1052 = (T477+exp(y(48))*exp(y(48))*getPowerDeriv(exp(y(48)),(-params(1)),2))/exp(y(49));
T1059 = (-(exp(y(20))*T442))/T540;
T1078 = ((-(T115*exp(y(20))))*T540-(-(T115*exp(y(20))))*(T540+T540))/(T540*T540);
T1111 = (T566*exp(y(49))*exp(y(49))-T566*(exp(y(49))*exp(y(49))+exp(y(49))*exp(y(49))))/(exp(y(49))*exp(y(49))*exp(y(49))*exp(y(49)));
T1228 = (T118*T118*(-(T113*params(2)*params(26)*T1031))-(-(T113*params(2)*params(26)*T443))*(T118*T443+T118*T443))/(T118*T118*T118*T118);
T1272 = (T118*T118*(-(T113*params(2)*params(26)*T1059))-(-(T113*params(2)*params(26)*T541))*(T118*T443+T118*T443))/(T118*T118*T118*T118);
T1301 = (T118*T118*(-(T113*params(2)*params(26)*T1078))-(-(T113*params(2)*params(26)*T541))*(T118*T541+T118*T541))/(T118*T118*T118*T118);
T1313 = params(2)*params(26)*(-(exp(y(49))*T477))/(exp(y(49))*exp(y(49)))/T118;
T1476 = T664+exp(y(29))*exp(y(29))*getPowerDeriv(exp(y(29)),(-params(9)),2);
T1477 = T1476/exp(y(34));
T1498 = (T698+exp(y(53))*exp(y(53))*getPowerDeriv(exp(y(53)),(-params(9)),2))/exp(y(54));
T1505 = (-(exp(y(34))*T664))/T761;
T1522 = (T761*(-(exp(y(34))*T257))-(-(exp(y(34))*T257))*(T761+T761))/(T761*T761);
T1555 = (T787*exp(y(54))*exp(y(54))-T787*(exp(y(54))*exp(y(54))+exp(y(54))*exp(y(54))))/(exp(y(54))*exp(y(54))*exp(y(54))*exp(y(54)));
T1680 = (T258*T258*(-(T255*params(10)*params(25)*T1477))-(-(T255*params(10)*params(25)*T665))*(T258*T665+T258*T665))/(T258*T258*T258*T258);
T1724 = (T258*T258*(-(T255*params(10)*params(25)*T1505))-(-(T255*params(10)*params(25)*T765))*(T258*T665+T258*T665))/(T258*T258*T258*T258);
T1753 = (T258*T258*(-(T255*params(10)*params(25)*T1522))-(-(T255*params(10)*params(25)*T765))*(T258*T765+T258*T765))/(T258*T258*T258*T258);
T1765 = params(10)*params(25)*(-(exp(y(54))*T698))/(exp(y(54))*exp(y(54)))/T258;
lhs =y(13);
rhs =exp(y(15))^(1-params(1))/(1-params(1))-T30;
residual(1)= lhs-rhs;
lhs =y(14);
rhs =exp(y(29))^(1-params(9))/(1-params(9))-T55;
residual(2)= lhs-rhs;
lhs =y(26);
rhs =(1+params(38))*T65*T73*(1+x(it_, 7))-1;
residual(3)= lhs-rhs;
lhs =y(40);
rhs =(1+params(39))*T88*T96*(1+x(it_, 8))-1;
residual(4)= lhs-rhs;
lhs =1/(1+y(26));
rhs =params(2)*T113/T118/y(50);
residual(5)= lhs-rhs;
lhs =T132;
rhs =1;
residual(6)= lhs-rhs;
lhs =T138;
rhs =T143^T130;
residual(7)= lhs-rhs;
lhs =exp(y(15));
rhs =T153^(1+params(3));
residual(8)= lhs-rhs;
lhs =exp(y(24))^T162;
rhs =exp(y(22))/exp(y(23));
residual(9)= lhs-rhs;
lhs =exp(y(22));
rhs =T23*T173/T118+T179*T184*exp(y(51));
residual(10)= lhs-rhs;
lhs =exp(y(23));
rhs =T23*(1+params(32)*exp(y(44)))/params(24)+T179*T199*exp(y(52));
residual(11)= lhs-rhs;
lhs =(1-params(26))*exp(y(24))^T207+params(26)*T210^T207;
rhs =1;
residual(12)= lhs-rhs;
lhs =exp(y(25));
rhs =(1-params(26))*exp(y(24))^T183+params(26)*T210^T183*exp(y(2));
residual(13)= lhs-rhs;
lhs =T23;
rhs =exp(y(16))+exp(y(19))+1/params(30)*exp(y(31));
residual(14)= lhs-rhs;
lhs =exp(y(19));
rhs =T23*params(4)*exp(y(42));
residual(15)= lhs-rhs;
lhs =y(28);
rhs =y(21)*exp(y(20))/exp(y(1));
residual(16)= lhs-rhs;
lhs =1/(1+y(40));
rhs =params(10)*T255/T258/y(55);
residual(17)= lhs-rhs;
lhs =T272;
rhs =1;
residual(18)= lhs-rhs;
lhs =1/exp(y(27))/exp(y(20));
rhs =T278^T270;
residual(19)= lhs-rhs;
lhs =exp(y(29));
rhs =T288^(1+params(11));
residual(20)= lhs-rhs;
lhs =exp(y(38))^T297;
rhs =exp(y(36))/exp(y(37));
residual(21)= lhs-rhs;
lhs =exp(y(36));
rhs =T48*T308/T258+T314*T319*exp(y(56));
residual(22)= lhs-rhs;
lhs =exp(y(37));
rhs =T48*(1+params(37)*exp(y(47)))/params(23)+T314*T334*exp(y(57));
residual(23)= lhs-rhs;
lhs =(1-params(25))*exp(y(38))^T342+params(25)*T345^T342;
rhs =1;
residual(24)= lhs-rhs;
lhs =exp(y(39));
rhs =(1-params(25))*exp(y(38))^T318+params(25)*T345^T318*exp(y(5));
residual(25)= lhs-rhs;
lhs =T48;
rhs =exp(y(30))+exp(y(33))+exp(y(17))*params(30);
residual(26)= lhs-rhs;
lhs =exp(y(33));
rhs =T48*params(12)*exp(y(45));
residual(27)= lhs-rhs;
lhs =y(41);
rhs =y(35)*exp(y(34))/exp(y(4));
residual(28)= lhs-rhs;
lhs =params(44)/T257*params(45);
rhs =T384/T115*params(48);
residual(29)= lhs-rhs;
lhs =y(42);
rhs =params(5)*y(7)+params(6)*x(it_, 1);
residual(30)= lhs-rhs;
lhs =y(43);
rhs =params(7)*y(8)+params(8)*x(it_, 2);
residual(31)= lhs-rhs;
lhs =y(44);
rhs =params(19)*y(9)+params(20)*x(it_, 6);
residual(32)= lhs-rhs;
lhs =y(45);
rhs =params(13)*y(10)+params(14)*x(it_, 3);
residual(33)= lhs-rhs;
lhs =y(46);
rhs =params(15)*y(11)+params(16)*x(it_, 4);
residual(34)= lhs-rhs;
lhs =y(47);
rhs =params(17)*y(12)+params(18)*x(it_, 5);
residual(35)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(35, 65);

  %
  % Jacobian matrix
  %

  g1(1,13)=1;
  g1(1,15)=(-(exp(y(15))*getPowerDeriv(exp(y(15)),1-params(1),1)/(1-params(1))));
  g1(1,18)=T520;
  g1(1,25)=T30;
  g1(1,43)=T876;
  g1(2,14)=1;
  g1(2,29)=(-(exp(y(29))*getPowerDeriv(exp(y(29)),1-params(9),1)/(1-params(9))));
  g1(2,32)=T741;
  g1(2,39)=T55;
  g1(2,46)=T898;
  g1(3,21)=(-((1+x(it_, 7))*T590));
  g1(3,3)=(-((1+x(it_, 7))*(1+params(38))*T73*T641));
  g1(3,26)=1;
  g1(3,64)=(-((1+params(38))*T65*T73));
  g1(4,35)=(-((1+x(it_, 8))*T811));
  g1(4,6)=(-((1+x(it_, 8))*(1+params(39))*T96*T862));
  g1(4,40)=1;
  g1(4,65)=(-((1+params(39))*T88*T96));
  g1(5,15)=(-((-(params(2)*T113*T443))/(T118*T118)/y(50)));
  g1(5,48)=(-(params(2)*T478/T118/y(50)));
  g1(5,20)=(-((-(params(2)*T113*T541))/(T118*T118)/y(50)));
  g1(5,49)=(-(params(2)*T568/T118/y(50)));
  g1(5,50)=(-((-(params(2)*T113/T118))/(y(50)*y(50))));
  g1(5,26)=(-1)/((1+y(26))*(1+y(26)));
  g1(6,15)=exp(y(20))*T127*getPowerDeriv(T127,T130,1);
  g1(6,16)=exp(y(20))*T495;
  g1(6,20)=T132;
  g1(7,15)=(-(T143*getPowerDeriv(T143,T130,1)));
  g1(7,17)=(-T508);
  g1(7,27)=T138;
  g1(7,34)=T762;
  g1(8,15)=exp(y(15));
  g1(8,16)=(-(T499*T500));
  g1(8,17)=(-(T500*T512));
  g1(9,22)=(-(exp(y(22))/exp(y(23))));
  g1(9,23)=T626;
  g1(9,24)=T629;
  g1(10,15)=(-(T23*(-(T173*T443))/(T118*T118)+exp(y(51))*T184*T462));
  g1(10,48)=(-(exp(y(51))*T184*T484));
  g1(10,18)=(-T527);
  g1(10,20)=(-(T23*(-(T173*T541))/(T118*T118)+exp(y(51))*T184*T553));
  g1(10,49)=(-(exp(y(51))*T184*T574));
  g1(10,50)=(-(exp(y(51))*T179*T611));
  g1(10,22)=exp(y(22));
  g1(10,51)=(-(T179*T184*exp(y(51))));
  g1(10,43)=(-(T23*T883/T118));
  g1(11,15)=(-(exp(y(52))*T199*T462));
  g1(11,48)=(-(exp(y(52))*T199*T484));
  g1(11,18)=(-(T23*(1+params(32)*exp(y(44)))/params(24)));
  g1(11,20)=(-(exp(y(52))*T199*T553));
  g1(11,49)=(-(exp(y(52))*T199*T574));
  g1(11,50)=(-(exp(y(52))*T179*T616));
  g1(11,23)=exp(y(23));
  g1(11,52)=(-(T179*T199*exp(y(52))));
  g1(11,44)=T890;
  g1(12,21)=params(26)*T595*getPowerDeriv(T210,T207,1);
  g1(12,24)=(1-params(26))*exp(y(24))*getPowerDeriv(exp(y(24)),T207,1);
  g1(13,21)=(-(exp(y(2))*params(26)*T595*getPowerDeriv(T210,T183,1)));
  g1(13,24)=(-((1-params(26))*exp(y(24))*getPowerDeriv(exp(y(24)),T183,1)));
  g1(13,2)=(-(params(26)*T210^T183*exp(y(2))));
  g1(13,25)=exp(y(25));
  g1(14,16)=(-exp(y(16)));
  g1(14,18)=T23;
  g1(14,19)=(-exp(y(19)));
  g1(14,31)=(-(1/params(30)*exp(y(31))));
  g1(15,18)=(-(T23*params(4)*exp(y(42))));
  g1(15,19)=exp(y(19));
  g1(15,42)=(-(T23*params(4)*exp(y(42))));
  g1(16,1)=T537;
  g1(16,20)=(-(y(21)*exp(y(20))/exp(y(1))));
  g1(16,21)=(-(exp(y(20))/exp(y(1))));
  g1(16,28)=1;
  g1(17,29)=(-((-(params(10)*T255*T665))/(T258*T258)/y(55)));
  g1(17,53)=(-(params(10)*T699/T258/y(55)));
  g1(17,34)=(-((-(params(10)*T255*T765))/(T258*T258)/y(55)));
  g1(17,54)=(-(params(10)*T789/T258/y(55)));
  g1(17,55)=(-((-(params(10)*T255/T258))/(y(55)*y(55))));
  g1(17,40)=(-1)/((1+y(40))*(1+y(40)));
  g1(18,29)=exp(y(34))*T267*getPowerDeriv(T267,T270,1);
  g1(18,30)=exp(y(34))*T716;
  g1(18,34)=T272;
  g1(19,20)=T563/T540;
  g1(19,27)=(-exp(y(27)))/(exp(y(27))*exp(y(27)))/exp(y(20));
  g1(19,29)=(-(T278*getPowerDeriv(T278,T270,1)));
  g1(19,31)=(-T730);
  g1(20,29)=exp(y(29));
  g1(20,30)=(-(T720*T721));
  g1(20,31)=(-(T721*T734));
  g1(21,36)=(-(exp(y(36))/exp(y(37))));
  g1(21,37)=T847;
  g1(21,38)=T850;
  g1(22,29)=(-(T48*(-(T308*T665))/(T258*T258)+exp(y(56))*T319*T684));
  g1(22,53)=(-(exp(y(56))*T319*T705));
  g1(22,32)=(-T748);
  g1(22,34)=(-(T48*(-(T308*T765))/(T258*T258)+exp(y(56))*T319*T777));
  g1(22,54)=(-(exp(y(56))*T319*T795));
  g1(22,55)=(-(exp(y(56))*T314*T832));
  g1(22,36)=exp(y(36));
  g1(22,56)=(-(T314*T319*exp(y(56))));
  g1(22,46)=(-(T48*T905/T258));
  g1(23,29)=(-(exp(y(57))*T334*T684));
  g1(23,53)=(-(exp(y(57))*T334*T705));
  g1(23,32)=(-(T48*(1+params(37)*exp(y(47)))/params(23)));
  g1(23,34)=(-(exp(y(57))*T334*T777));
  g1(23,54)=(-(exp(y(57))*T334*T795));
  g1(23,55)=(-(exp(y(57))*T314*T837));
  g1(23,37)=exp(y(37));
  g1(23,57)=(-(T314*T334*exp(y(57))));
  g1(23,47)=T912;
  g1(24,35)=params(25)*T816*getPowerDeriv(T345,T342,1);
  g1(24,38)=(1-params(25))*exp(y(38))*getPowerDeriv(exp(y(38)),T342,1);
  g1(25,35)=(-(exp(y(5))*params(25)*T816*getPowerDeriv(T345,T318,1)));
  g1(25,38)=(-((1-params(25))*exp(y(38))*getPowerDeriv(exp(y(38)),T318,1)));
  g1(25,5)=(-(params(25)*T345^T318*exp(y(5))));
  g1(25,39)=exp(y(39));
  g1(26,17)=(-(exp(y(17))*params(30)));
  g1(26,30)=(-exp(y(30)));
  g1(26,32)=T48;
  g1(26,33)=(-exp(y(33)));
  g1(27,32)=(-(T48*params(12)*exp(y(45))));
  g1(27,33)=exp(y(33));
  g1(27,45)=(-(T48*params(12)*exp(y(45))));
  g1(28,4)=T758;
  g1(28,34)=(-(y(35)*exp(y(34))/exp(y(4))));
  g1(28,35)=(-(exp(y(34))/exp(y(4))));
  g1(28,41)=1;
  g1(29,15)=(-(params(48)*(-(T384*T442))/(T115*T115)));
  g1(29,27)=(-(params(48)*T655/T115));
  g1(29,29)=params(45)*(-(params(44)*T664))/(T257*T257);
  g1(30,7)=(-params(5));
  g1(30,42)=1;
  g1(30,58)=(-params(6));
  g1(31,8)=(-params(7));
  g1(31,43)=1;
  g1(31,59)=(-params(8));
  g1(32,9)=(-params(19));
  g1(32,44)=1;
  g1(32,63)=(-params(20));
  g1(33,10)=(-params(13));
  g1(33,45)=1;
  g1(33,60)=(-params(14));
  g1(34,11)=(-params(15));
  g1(34,46)=1;
  g1(34,61)=(-params(16));
  g1(35,12)=(-params(17));
  g1(35,47)=1;
  g1(35,62)=(-params(18));
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  v2 = zeros(377,3);
  v2(1,1)=1;
  v2(1,2)=925;
  v2(1,3)=(-((exp(y(15))*getPowerDeriv(exp(y(15)),1-params(1),1)+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),1-params(1),2))/(1-params(1))));
  v2(2,1)=1;
  v2(2,2)=1123;
  v2(2,3)=exp(y(25))*T21*(T517+T23*T23*getPowerDeriv(T23,1+params(22),2))/(1+params(22));
  v2(3,1)=1;
  v2(3,2)=1578;
  v2(3,3)=T520;
  v2(4,1)=1;
  v2(4,2)=1130;
  v2(4,3)=  v2(3,3);
  v2(5,1)=1;
  v2(5,2)=1585;
  v2(5,3)=T30;
  v2(6,1)=1;
  v2(6,2)=2748;
  v2(6,3)=exp(y(25))*T517*params(27)*exp(y(43))*getPowerDeriv(exp(y(43)),(-params(22)),1)/(1+params(22));
  v2(7,1)=1;
  v2(7,2)=1148;
  v2(7,3)=  v2(6,3);
  v2(8,1)=1;
  v2(8,2)=2755;
  v2(8,3)=T876;
  v2(9,1)=1;
  v2(9,2)=1603;
  v2(9,3)=  v2(8,3);
  v2(10,1)=1;
  v2(10,2)=2773;
  v2(10,3)=exp(y(25))*T25*params(27)*(exp(y(43))*getPowerDeriv(exp(y(43)),(-params(22)),1)+exp(y(43))*exp(y(43))*getPowerDeriv(exp(y(43)),(-params(22)),2))/(1+params(22));
  v2(11,1)=2;
  v2(11,2)=1849;
  v2(11,3)=(-((exp(y(29))*getPowerDeriv(exp(y(29)),1-params(9),1)+exp(y(29))*exp(y(29))*getPowerDeriv(exp(y(29)),1-params(9),2))/(1-params(9))));
  v2(12,1)=2;
  v2(12,2)=2047;
  v2(12,3)=exp(y(39))*T46*(T738+T48*T48*getPowerDeriv(T48,1+params(21),2))/(1+params(21));
  v2(13,1)=2;
  v2(13,2)=2502;
  v2(13,3)=T741;
  v2(14,1)=2;
  v2(14,2)=2054;
  v2(14,3)=  v2(13,3);
  v2(15,1)=2;
  v2(15,2)=2509;
  v2(15,3)=T55;
  v2(16,1)=2;
  v2(16,2)=2957;
  v2(16,3)=exp(y(39))*T738*params(33)*exp(y(46))*getPowerDeriv(exp(y(46)),(-params(21)),1)/(1+params(21));
  v2(17,1)=2;
  v2(17,2)=2061;
  v2(17,3)=  v2(16,3);
  v2(18,1)=2;
  v2(18,2)=2964;
  v2(18,3)=T898;
  v2(19,1)=2;
  v2(19,2)=2516;
  v2(19,3)=  v2(18,3);
  v2(20,1)=2;
  v2(20,2)=2971;
  v2(20,3)=exp(y(39))*T50*params(33)*(exp(y(46))*getPowerDeriv(exp(y(46)),(-params(21)),1)+exp(y(46))*exp(y(46))*getPowerDeriv(exp(y(46)),(-params(21)),2))/(1+params(21));
  v2(21,1)=3;
  v2(21,2)=1321;
  v2(21,3)=(-((1+x(it_, 7))*(1+params(38))*T65*(getPowerDeriv(T68*T70,1-params(40),1)*(T581*T583+T581*T583+T68*T581*T581*getPowerDeriv(T68,params(41),2))+(T70*T581+T68*T583)*(T70*T581+T68*T583)*getPowerDeriv(T68*T70,1-params(40),2))));
  v2(22,1)=3;
  v2(22,2)=151;
  v2(22,3)=(-((1+x(it_, 7))*(1+params(38))*(T70*T581+T68*T583)*getPowerDeriv(T68*T70,1-params(40),1)*T641));
  v2(23,1)=3;
  v2(23,2)=1303;
  v2(23,3)=  v2(22,3);
  v2(24,1)=3;
  v2(24,2)=133;
  v2(24,3)=(-((1+x(it_, 7))*(1+params(38))*T73*1/(1+params(38))*1/(1+params(38))*getPowerDeriv((1+y(3))/(1+params(38)),params(40),2)));
  v2(25,1)=3;
  v2(25,2)=4116;
  v2(25,3)=(-T590);
  v2(26,1)=3;
  v2(26,2)=1364;
  v2(26,3)=  v2(25,3);
  v2(27,1)=3;
  v2(27,2)=4098;
  v2(27,3)=(-((1+params(38))*T73*T641));
  v2(28,1)=3;
  v2(28,2)=194;
  v2(28,3)=  v2(27,3);
  v2(29,1)=4;
  v2(29,2)=2245;
  v2(29,3)=(-((1+x(it_, 8))*(1+params(39))*T88*(getPowerDeriv(T91*T93,1-params(42),1)*(T802*T804+T802*T804+T91*T802*T802*getPowerDeriv(T91,params(43),2))+(T93*T802+T91*T804)*(T93*T802+T91*T804)*getPowerDeriv(T91*T93,1-params(42),2))));
  v2(30,1)=4;
  v2(30,2)=360;
  v2(30,3)=(-((1+x(it_, 8))*(1+params(39))*(T93*T802+T91*T804)*getPowerDeriv(T91*T93,1-params(42),1)*T862));
  v2(31,1)=4;
  v2(31,2)=2216;
  v2(31,3)=  v2(30,3);
  v2(32,1)=4;
  v2(32,2)=331;
  v2(32,3)=(-((1+x(it_, 8))*(1+params(39))*T96*1/(1+params(39))*1/(1+params(39))*getPowerDeriv((1+y(6))/(1+params(39)),params(42),2)));
  v2(33,1)=4;
  v2(33,2)=4195;
  v2(33,3)=(-T811);
  v2(34,1)=4;
  v2(34,2)=2275;
  v2(34,3)=  v2(33,3);
  v2(35,1)=4;
  v2(35,2)=4166;
  v2(35,3)=(-((1+params(39))*T96*T862));
  v2(36,1)=4;
  v2(36,2)=390;
  v2(36,3)=  v2(35,3);
  v2(37,1)=5;
  v2(37,2)=925;
  v2(37,3)=(-((T118*T118*(-(params(2)*T113*T1031))-(-(params(2)*T113*T443))*(T118*T443+T118*T443))/(T118*T118*T118*T118)/y(50)));
  v2(38,1)=5;
  v2(38,2)=3070;
  v2(38,3)=(-((-(T443*params(2)*T478))/(T118*T118)/y(50)));
  v2(39,1)=5;
  v2(39,2)=958;
  v2(39,3)=  v2(38,3);
  v2(40,1)=5;
  v2(40,2)=3103;
  v2(40,3)=(-(params(2)*T1052/T118/y(50)));
  v2(41,1)=5;
  v2(41,2)=1250;
  v2(41,3)=(-((T118*T118*(-(params(2)*T113*T1059))-(-(params(2)*T113*T541))*(T118*T443+T118*T443))/(T118*T118*T118*T118)/y(50)));
  v2(42,1)=5;
  v2(42,2)=930;
  v2(42,3)=  v2(41,3);
  v2(43,1)=5;
  v2(43,2)=1283;
  v2(43,3)=(-((-(params(2)*T478*T541))/(T118*T118)/y(50)));
  v2(44,1)=5;
  v2(44,2)=3075;
  v2(44,3)=  v2(43,3);
  v2(45,1)=5;
  v2(45,2)=1255;
  v2(45,3)=(-((T118*T118*(-(params(2)*T113*T1078))-(-(params(2)*T113*T541))*(T118*T541+T118*T541))/(T118*T118*T118*T118)/y(50)));
  v2(46,1)=5;
  v2(46,2)=3135;
  v2(46,3)=(-((-(T443*params(2)*T568))/(T118*T118)/y(50)));
  v2(47,1)=5;
  v2(47,2)=959;
  v2(47,3)=  v2(46,3);
  v2(48,1)=5;
  v2(48,2)=3168;
  v2(48,3)=(-(params(2)*(-(exp(y(49))*T477))/(exp(y(49))*exp(y(49)))/T118/y(50)));
  v2(49,1)=5;
  v2(49,2)=3104;
  v2(49,3)=  v2(48,3);
  v2(50,1)=5;
  v2(50,2)=3140;
  v2(50,3)=(-((-(T541*params(2)*T568))/(T118*T118)/y(50)));
  v2(51,1)=5;
  v2(51,2)=1284;
  v2(51,3)=  v2(50,3);
  v2(52,1)=5;
  v2(52,2)=3169;
  v2(52,3)=(-(params(2)*T1111/T118/y(50)));
  v2(53,1)=5;
  v2(53,2)=3200;
  v2(53,3)=(-((-((-(params(2)*T113*T443))/(T118*T118)))/(y(50)*y(50))));
  v2(54,1)=5;
  v2(54,2)=960;
  v2(54,3)=  v2(53,3);
  v2(55,1)=5;
  v2(55,2)=3233;
  v2(55,3)=(-((-(params(2)*T478/T118))/(y(50)*y(50))));
  v2(56,1)=5;
  v2(56,2)=3105;
  v2(56,3)=  v2(55,3);
  v2(57,1)=5;
  v2(57,2)=3205;
  v2(57,3)=(-((-((-(params(2)*T113*T541))/(T118*T118)))/(y(50)*y(50))));
  v2(58,1)=5;
  v2(58,2)=1285;
  v2(58,3)=  v2(57,3);
  v2(59,1)=5;
  v2(59,2)=3234;
  v2(59,3)=(-((-(params(2)*T568/T118))/(y(50)*y(50))));
  v2(60,1)=5;
  v2(60,2)=3170;
  v2(60,3)=  v2(59,3);
  v2(61,1)=5;
  v2(61,2)=3235;
  v2(61,3)=(-((-((-(params(2)*T113/T118))*(y(50)+y(50))))/(y(50)*y(50)*y(50)*y(50))));
  v2(62,1)=5;
  v2(62,2)=1651;
  v2(62,3)=(1+y(26)+1+y(26))/((1+y(26))*(1+y(26))*(1+y(26))*(1+y(26)));
  v2(63,1)=6;
  v2(63,2)=925;
  v2(63,3)=exp(y(20))*(T127*getPowerDeriv(T127,T130,1)+T127*T127*getPowerDeriv(T127,T130,2));
  v2(64,1)=6;
  v2(64,2)=990;
  v2(64,3)=exp(y(20))*(T495+T494*T127*getPowerDeriv(T127,T130,2));
  v2(65,1)=6;
  v2(65,2)=926;
  v2(65,3)=  v2(64,3);
  v2(66,1)=6;
  v2(66,2)=991;
  v2(66,3)=exp(y(20))*(T494*T494*getPowerDeriv(T127,T130,2)+getPowerDeriv(T127,T130,1)*((-(exp(y(15))*params(28)*exp(y(16))))*exp(y(16))*exp(y(16))-(-(exp(y(15))*params(28)*exp(y(16))))*(exp(y(16))*exp(y(16))+exp(y(16))*exp(y(16))))/(exp(y(16))*exp(y(16))*exp(y(16))*exp(y(16))));
  v2(67,1)=6;
  v2(67,2)=1250;
  v2(67,3)=exp(y(20))*T127*getPowerDeriv(T127,T130,1);
  v2(68,1)=6;
  v2(68,2)=930;
  v2(68,3)=  v2(67,3);
  v2(69,1)=6;
  v2(69,2)=1251;
  v2(69,3)=exp(y(20))*T495;
  v2(70,1)=6;
  v2(70,2)=995;
  v2(70,3)=  v2(69,3);
  v2(71,1)=6;
  v2(71,2)=1255;
  v2(71,3)=T132;
  v2(72,1)=7;
  v2(72,2)=925;
  v2(72,3)=(-(T143*getPowerDeriv(T143,T130,1)+T143*T143*getPowerDeriv(T143,T130,2)));
  v2(73,1)=7;
  v2(73,2)=1055;
  v2(73,3)=(-(T508+T507*T143*getPowerDeriv(T143,T130,2)));
  v2(74,1)=7;
  v2(74,2)=927;
  v2(74,3)=  v2(73,3);
  v2(75,1)=7;
  v2(75,2)=1057;
  v2(75,3)=(-(T507*T507*getPowerDeriv(T143,T130,2)+getPowerDeriv(T143,T130,1)*((-(exp(y(15))*params(29)*exp(y(17))))*exp(y(17))*exp(y(17))-(-(exp(y(15))*params(29)*exp(y(17))))*(exp(y(17))*exp(y(17))+exp(y(17))*exp(y(17))))/(exp(y(17))*exp(y(17))*exp(y(17))*exp(y(17)))));
  v2(76,1)=7;
  v2(76,2)=1717;
  v2(76,3)=T138;
  v2(77,1)=7;
  v2(77,2)=2172;
  v2(77,3)=T762;
  v2(78,1)=7;
  v2(78,2)=1724;
  v2(78,3)=  v2(77,3);
  v2(79,1)=7;
  v2(79,2)=2179;
  v2(79,3)=((-(exp(y(27))*exp(y(34))))*T761-(-(exp(y(27))*exp(y(34))))*(T761+T761))/(T761*T761);
  v2(80,1)=8;
  v2(80,2)=925;
  v2(80,3)=exp(y(15));
  v2(81,1)=8;
  v2(81,2)=991;
  v2(81,3)=(-(T500*params(28)^T130*(exp(y(16))*getPowerDeriv(exp(y(16)),T147,1)+exp(y(16))*exp(y(16))*getPowerDeriv(exp(y(16)),T147,2))+T499*T499*getPowerDeriv(T153,1+params(3),2)));
  v2(82,1)=8;
  v2(82,2)=1056;
  v2(82,3)=(-(T512*T499*getPowerDeriv(T153,1+params(3),2)));
  v2(83,1)=8;
  v2(83,2)=992;
  v2(83,3)=  v2(82,3);
  v2(84,1)=8;
  v2(84,2)=1057;
  v2(84,3)=(-(T512*T512*getPowerDeriv(T153,1+params(3),2)+T500*params(29)^T130*(exp(y(17))*getPowerDeriv(exp(y(17)),T147,1)+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),T147,2))));
  v2(85,1)=9;
  v2(85,2)=1387;
  v2(85,3)=(-(exp(y(22))/exp(y(23))));
  v2(86,1)=9;
  v2(86,2)=1452;
  v2(86,3)=T626;
  v2(87,1)=9;
  v2(87,2)=1388;
  v2(87,3)=  v2(86,3);
  v2(88,1)=9;
  v2(88,2)=1453;
  v2(88,3)=(-(((-(exp(y(22))*exp(y(23))))*exp(y(23))*exp(y(23))-(-(exp(y(22))*exp(y(23))))*(exp(y(23))*exp(y(23))+exp(y(23))*exp(y(23))))/(exp(y(23))*exp(y(23))*exp(y(23))*exp(y(23)))));
  v2(89,1)=9;
  v2(89,2)=1519;
  v2(89,3)=T629+exp(y(24))*exp(y(24))*getPowerDeriv(exp(y(24)),T162,2);
  v2(90,1)=10;
  v2(90,2)=925;
  v2(90,3)=(-(T23*(T118*T118*(-(T173*T1031))-(-(T173*T443))*(T118*T443+T118*T443))/(T118*T118*T118*T118)+exp(y(51))*T184*T1228));
  v2(91,1)=10;
  v2(91,2)=3070;
  v2(91,3)=(-(exp(y(51))*T184*(-(T443*params(2)*params(26)*T478))/(T118*T118)));
  v2(92,1)=10;
  v2(92,2)=958;
  v2(92,3)=  v2(91,3);
  v2(93,1)=10;
  v2(93,2)=3103;
  v2(93,3)=(-(exp(y(51))*T184*params(2)*params(26)*T1052/T118));
  v2(94,1)=10;
  v2(94,2)=1120;
  v2(94,3)=(-(T23*(-(T173*T443))/(T118*T118)+T23*(-(T443*T524))/(T118*T118)));
  v2(95,1)=10;
  v2(95,2)=928;
  v2(95,3)=  v2(94,3);
  v2(96,1)=10;
  v2(96,2)=1123;
  v2(96,3)=(-(T527+T23*T524/T118+T23*T170*(T171*getPowerDeriv(T171,params(22),1)+T171*T171*getPowerDeriv(T171,params(22),2))/T118));
  v2(97,1)=10;
  v2(97,2)=1250;
  v2(97,3)=(-(T23*(T118*T118*(-(T173*T1059))-(-(T173*T541))*(T118*T443+T118*T443))/(T118*T118*T118*T118)+exp(y(51))*T184*T1272));
  v2(98,1)=10;
  v2(98,2)=930;
  v2(98,3)=  v2(97,3);
  v2(99,1)=10;
  v2(99,2)=1283;
  v2(99,3)=(-(exp(y(51))*T184*(-(params(2)*params(26)*T478*T541))/(T118*T118)));
  v2(100,1)=10;
  v2(100,2)=3075;
  v2(100,3)=  v2(99,3);
  v2(101,1)=10;
  v2(101,2)=1253;
  v2(101,3)=(-(T23*(-(T173*T541))/(T118*T118)+T23*(-(T524*T541))/(T118*T118)));
  v2(102,1)=10;
  v2(102,2)=1125;
  v2(102,3)=  v2(101,3);
  v2(103,1)=10;
  v2(103,2)=1255;
  v2(103,3)=(-(T23*(T118*T118*(-(T173*T1078))-(-(T173*T541))*(T118*T541+T118*T541))/(T118*T118*T118*T118)+exp(y(51))*T184*T1301));
  v2(104,1)=10;
  v2(104,2)=3135;
  v2(104,3)=(-(exp(y(51))*T184*(-(T443*params(2)*params(26)*T568))/(T118*T118)));
  v2(105,1)=10;
  v2(105,2)=959;
  v2(105,3)=  v2(104,3);
  v2(106,1)=10;
  v2(106,2)=3168;
  v2(106,3)=(-(exp(y(51))*T184*T1313));
  v2(107,1)=10;
  v2(107,2)=3104;
  v2(107,3)=  v2(106,3);
  v2(108,1)=10;
  v2(108,2)=3140;
  v2(108,3)=(-(exp(y(51))*T184*(-(T541*params(2)*params(26)*T568))/(T118*T118)));
  v2(109,1)=10;
  v2(109,2)=1284;
  v2(109,3)=  v2(108,3);
  v2(110,1)=10;
  v2(110,2)=3169;
  v2(110,3)=(-(exp(y(51))*T184*params(2)*params(26)*T1111/T118));
  v2(111,1)=10;
  v2(111,2)=3200;
  v2(111,3)=(-(exp(y(51))*T462*T611));
  v2(112,1)=10;
  v2(112,2)=960;
  v2(112,3)=  v2(111,3);
  v2(113,1)=10;
  v2(113,2)=3233;
  v2(113,3)=(-(exp(y(51))*T484*T611));
  v2(114,1)=10;
  v2(114,2)=3105;
  v2(114,3)=  v2(113,3);
  v2(115,1)=10;
  v2(115,2)=3205;
  v2(115,3)=(-(exp(y(51))*T553*T611));
  v2(116,1)=10;
  v2(116,2)=1285;
  v2(116,3)=  v2(115,3);
  v2(117,1)=10;
  v2(117,2)=3234;
  v2(117,3)=(-(exp(y(51))*T574*T611));
  v2(118,1)=10;
  v2(118,2)=3170;
  v2(118,3)=  v2(117,3);
  v2(119,1)=10;
  v2(119,2)=3235;
  v2(119,3)=(-(exp(y(51))*T179*(getPowerDeriv(T180,T183,1)*(-((-params(31))*(y(50)+y(50))))/(y(50)*y(50)*y(50)*y(50))+T609*T609*getPowerDeriv(T180,T183,2))));
  v2(120,1)=10;
  v2(120,2)=1387;
  v2(120,3)=exp(y(22));
  v2(121,1)=10;
  v2(121,2)=3265;
  v2(121,3)=(-(exp(y(51))*T184*T462));
  v2(122,1)=10;
  v2(122,2)=961;
  v2(122,3)=  v2(121,3);
  v2(123,1)=10;
  v2(123,2)=3298;
  v2(123,3)=(-(exp(y(51))*T184*T484));
  v2(124,1)=10;
  v2(124,2)=3106;
  v2(124,3)=  v2(123,3);
  v2(125,1)=10;
  v2(125,2)=3270;
  v2(125,3)=(-(exp(y(51))*T184*T553));
  v2(126,1)=10;
  v2(126,2)=1286;
  v2(126,3)=  v2(125,3);
  v2(127,1)=10;
  v2(127,2)=3299;
  v2(127,3)=(-(exp(y(51))*T184*T574));
  v2(128,1)=10;
  v2(128,2)=3171;
  v2(128,3)=  v2(127,3);
  v2(129,1)=10;
  v2(129,2)=3300;
  v2(129,3)=(-(exp(y(51))*T179*T611));
  v2(130,1)=10;
  v2(130,2)=3236;
  v2(130,3)=  v2(129,3);
  v2(131,1)=10;
  v2(131,2)=3301;
  v2(131,3)=(-(T179*T184*exp(y(51))));
  v2(132,1)=10;
  v2(132,2)=2745;
  v2(132,3)=(-(T23*(-(T443*T883))/(T118*T118)));
  v2(133,1)=10;
  v2(133,2)=953;
  v2(133,3)=  v2(132,3);
  v2(134,1)=10;
  v2(134,2)=2748;
  v2(134,3)=(-(T23*T883/T118+T23*T170*(T882+T881*T171*getPowerDeriv(T171,params(22),2))/T118));
  v2(135,1)=10;
  v2(135,2)=1148;
  v2(135,3)=  v2(134,3);
  v2(136,1)=10;
  v2(136,2)=2750;
  v2(136,3)=(-(T23*(-(T541*T883))/(T118*T118)));
  v2(137,1)=10;
  v2(137,2)=1278;
  v2(137,3)=  v2(136,3);
  v2(138,1)=10;
  v2(138,2)=2773;
  v2(138,3)=(-(T23*T170*(T881*T881*getPowerDeriv(T171,params(22),2)+getPowerDeriv(T171,params(22),1)*((-(exp(y(43))*T23))*exp(y(43))*exp(y(43))-(-(exp(y(43))*T23))*(exp(y(43))*exp(y(43))+exp(y(43))*exp(y(43))))/(exp(y(43))*exp(y(43))*exp(y(43))*exp(y(43))))/T118));
  v2(139,1)=11;
  v2(139,2)=925;
  v2(139,3)=(-(exp(y(52))*T199*T1228));
  v2(140,1)=11;
  v2(140,2)=3070;
  v2(140,3)=(-(exp(y(52))*T199*(-(T443*params(2)*params(26)*T478))/(T118*T118)));
  v2(141,1)=11;
  v2(141,2)=958;
  v2(141,3)=  v2(140,3);
  v2(142,1)=11;
  v2(142,2)=3103;
  v2(142,3)=(-(exp(y(52))*T199*params(2)*params(26)*T1052/T118));
  v2(143,1)=11;
  v2(143,2)=1123;
  v2(143,3)=(-(T23*(1+params(32)*exp(y(44)))/params(24)));
  v2(144,1)=11;
  v2(144,2)=1250;
  v2(144,3)=(-(exp(y(52))*T199*T1272));
  v2(145,1)=11;
  v2(145,2)=930;
  v2(145,3)=  v2(144,3);
  v2(146,1)=11;
  v2(146,2)=1283;
  v2(146,3)=(-(exp(y(52))*T199*(-(params(2)*params(26)*T478*T541))/(T118*T118)));
  v2(147,1)=11;
  v2(147,2)=3075;
  v2(147,3)=  v2(146,3);
  v2(148,1)=11;
  v2(148,2)=1255;
  v2(148,3)=(-(exp(y(52))*T199*T1301));
  v2(149,1)=11;
  v2(149,2)=3135;
  v2(149,3)=(-(exp(y(52))*T199*(-(T443*params(2)*params(26)*T568))/(T118*T118)));
  v2(150,1)=11;
  v2(150,2)=959;
  v2(150,3)=  v2(149,3);
  v2(151,1)=11;
  v2(151,2)=3168;
  v2(151,3)=(-(exp(y(52))*T199*T1313));
  v2(152,1)=11;
  v2(152,2)=3104;
  v2(152,3)=  v2(151,3);
  v2(153,1)=11;
  v2(153,2)=3140;
  v2(153,3)=(-(exp(y(52))*T199*(-(T541*params(2)*params(26)*T568))/(T118*T118)));
  v2(154,1)=11;
  v2(154,2)=1284;
  v2(154,3)=  v2(153,3);
  v2(155,1)=11;
  v2(155,2)=3169;
  v2(155,3)=(-(exp(y(52))*T199*params(2)*params(26)*T1111/T118));
  v2(156,1)=11;
  v2(156,2)=3200;
  v2(156,3)=(-(exp(y(52))*T462*T616));
  v2(157,1)=11;
  v2(157,2)=960;
  v2(157,3)=  v2(156,3);
  v2(158,1)=11;
  v2(158,2)=3233;
  v2(158,3)=(-(exp(y(52))*T484*T616));
  v2(159,1)=11;
  v2(159,2)=3105;
  v2(159,3)=  v2(158,3);
  v2(160,1)=11;
  v2(160,2)=3205;
  v2(160,3)=(-(exp(y(52))*T553*T616));
  v2(161,1)=11;
  v2(161,2)=1285;
  v2(161,3)=  v2(160,3);
  v2(162,1)=11;
  v2(162,2)=3234;
  v2(162,3)=(-(exp(y(52))*T574*T616));
  v2(163,1)=11;
  v2(163,2)=3170;
  v2(163,3)=  v2(162,3);
  v2(164,1)=11;
  v2(164,2)=3235;
  v2(164,3)=(-(exp(y(52))*T179*(T615*(-((-params(31))*(y(50)+y(50))))/(y(50)*y(50)*y(50)*y(50))+T609*T609*getPowerDeriv(T180,1-(1+params(24))/params(24),2))));
  v2(165,1)=11;
  v2(165,2)=1453;
  v2(165,3)=exp(y(23));
  v2(166,1)=11;
  v2(166,2)=3330;
  v2(166,3)=(-(exp(y(52))*T199*T462));
  v2(167,1)=11;
  v2(167,2)=962;
  v2(167,3)=  v2(166,3);
  v2(168,1)=11;
  v2(168,2)=3363;
  v2(168,3)=(-(exp(y(52))*T199*T484));
  v2(169,1)=11;
  v2(169,2)=3107;
  v2(169,3)=  v2(168,3);
  v2(170,1)=11;
  v2(170,2)=3335;
  v2(170,3)=(-(exp(y(52))*T199*T553));
  v2(171,1)=11;
  v2(171,2)=1287;
  v2(171,3)=  v2(170,3);
  v2(172,1)=11;
  v2(172,2)=3364;
  v2(172,3)=(-(exp(y(52))*T199*T574));
  v2(173,1)=11;
  v2(173,2)=3172;
  v2(173,3)=  v2(172,3);
  v2(174,1)=11;
  v2(174,2)=3365;
  v2(174,3)=(-(exp(y(52))*T179*T616));
  v2(175,1)=11;
  v2(175,2)=3237;
  v2(175,3)=  v2(174,3);
  v2(176,1)=11;
  v2(176,2)=3367;
  v2(176,3)=(-(T179*T199*exp(y(52))));
  v2(177,1)=11;
  v2(177,2)=2813;
  v2(177,3)=T890;
  v2(178,1)=11;
  v2(178,2)=1149;
  v2(178,3)=  v2(177,3);
  v2(179,1)=11;
  v2(179,2)=2839;
  v2(179,3)=T890;
  v2(180,1)=12;
  v2(180,2)=1321;
  v2(180,3)=params(26)*(getPowerDeriv(T210,T207,1)*(-((-params(31))*(y(21)+y(21))))/(y(21)*y(21)*y(21)*y(21))+T595*T595*getPowerDeriv(T210,T207,2));
  v2(181,1)=12;
  v2(181,2)=1519;
  v2(181,3)=(1-params(26))*(exp(y(24))*getPowerDeriv(exp(y(24)),T207,1)+exp(y(24))*exp(y(24))*getPowerDeriv(exp(y(24)),T207,2));
  v2(182,1)=13;
  v2(182,2)=1321;
  v2(182,3)=(-(exp(y(2))*params(26)*(getPowerDeriv(T210,T183,1)*(-((-params(31))*(y(21)+y(21))))/(y(21)*y(21)*y(21)*y(21))+T595*T595*getPowerDeriv(T210,T183,2))));
  v2(183,1)=13;
  v2(183,2)=1519;
  v2(183,3)=(-((1-params(26))*(exp(y(24))*getPowerDeriv(exp(y(24)),T183,1)+exp(y(24))*exp(y(24))*getPowerDeriv(exp(y(24)),T183,2))));
  v2(184,1)=13;
  v2(184,2)=86;
  v2(184,3)=(-(exp(y(2))*params(26)*T595*getPowerDeriv(T210,T183,1)));
  v2(185,1)=13;
  v2(185,2)=1302;
  v2(185,3)=  v2(184,3);
  v2(186,1)=13;
  v2(186,2)=67;
  v2(186,3)=(-(params(26)*T210^T183*exp(y(2))));
  v2(187,1)=13;
  v2(187,2)=1585;
  v2(187,3)=exp(y(25));
  v2(188,1)=14;
  v2(188,2)=991;
  v2(188,3)=(-exp(y(16)));
  v2(189,1)=14;
  v2(189,2)=1123;
  v2(189,3)=T23;
  v2(190,1)=14;
  v2(190,2)=1189;
  v2(190,3)=(-exp(y(19)));
  v2(191,1)=14;
  v2(191,2)=1981;
  v2(191,3)=(-(1/params(30)*exp(y(31))));
  v2(192,1)=15;
  v2(192,2)=1123;
  v2(192,3)=(-(T23*params(4)*exp(y(42))));
  v2(193,1)=15;
  v2(193,2)=1189;
  v2(193,3)=exp(y(19));
  v2(194,1)=15;
  v2(194,2)=2683;
  v2(194,3)=(-(T23*params(4)*exp(y(42))));
  v2(195,1)=15;
  v2(195,2)=1147;
  v2(195,3)=  v2(194,3);
  v2(196,1)=15;
  v2(196,2)=2707;
  v2(196,3)=(-(T23*params(4)*exp(y(42))));
  v2(197,1)=16;
  v2(197,2)=1;
  v2(197,3)=(-(y(21)*((-(exp(y(20))*exp(y(1))))*exp(y(1))*exp(y(1))-(-(exp(y(20))*exp(y(1))))*(exp(y(1))*exp(y(1))+exp(y(1))*exp(y(1))))/(exp(y(1))*exp(y(1))*exp(y(1))*exp(y(1)))));
  v2(198,1)=16;
  v2(198,2)=1236;
  v2(198,3)=T537;
  v2(199,1)=16;
  v2(199,2)=20;
  v2(199,3)=  v2(198,3);
  v2(200,1)=16;
  v2(200,2)=1255;
  v2(200,3)=(-(y(21)*exp(y(20))/exp(y(1))));
  v2(201,1)=16;
  v2(201,2)=1301;
  v2(201,3)=(-T535);
  v2(202,1)=16;
  v2(202,2)=21;
  v2(202,3)=  v2(201,3);
  v2(203,1)=16;
  v2(203,2)=1320;
  v2(203,3)=(-(exp(y(20))/exp(y(1))));
  v2(204,1)=16;
  v2(204,2)=1256;
  v2(204,3)=  v2(203,3);
  v2(205,1)=17;
  v2(205,2)=1849;
  v2(205,3)=(-((T258*T258*(-(params(10)*T255*T1477))-(-(params(10)*T255*T665))*(T258*T665+T258*T665))/(T258*T258*T258*T258)/y(55)));
  v2(206,1)=17;
  v2(206,2)=3409;
  v2(206,3)=(-((-(T665*params(10)*T699))/(T258*T258)/y(55)));
  v2(207,1)=17;
  v2(207,2)=1873;
  v2(207,3)=  v2(206,3);
  v2(208,1)=17;
  v2(208,2)=3433;
  v2(208,3)=(-(params(10)*T1498/T258/y(55)));
  v2(209,1)=17;
  v2(209,2)=2174;
  v2(209,3)=(-((T258*T258*(-(params(10)*T255*T1505))-(-(params(10)*T255*T765))*(T258*T665+T258*T665))/(T258*T258*T258*T258)/y(55)));
  v2(210,1)=17;
  v2(210,2)=1854;
  v2(210,3)=  v2(209,3);
  v2(211,1)=17;
  v2(211,2)=2198;
  v2(211,3)=(-((-(params(10)*T699*T765))/(T258*T258)/y(55)));
  v2(212,1)=17;
  v2(212,2)=3414;
  v2(212,3)=  v2(211,3);
  v2(213,1)=17;
  v2(213,2)=2179;
  v2(213,3)=(-((T258*T258*(-(params(10)*T255*T1522))-(-(params(10)*T255*T765))*(T258*T765+T258*T765))/(T258*T258*T258*T258)/y(55)));
  v2(214,1)=17;
  v2(214,2)=3474;
  v2(214,3)=(-((-(T665*params(10)*T789))/(T258*T258)/y(55)));
  v2(215,1)=17;
  v2(215,2)=1874;
  v2(215,3)=  v2(214,3);
  v2(216,1)=17;
  v2(216,2)=3498;
  v2(216,3)=(-(params(10)*(-(exp(y(54))*T698))/(exp(y(54))*exp(y(54)))/T258/y(55)));
  v2(217,1)=17;
  v2(217,2)=3434;
  v2(217,3)=  v2(216,3);
  v2(218,1)=17;
  v2(218,2)=3479;
  v2(218,3)=(-((-(T765*params(10)*T789))/(T258*T258)/y(55)));
  v2(219,1)=17;
  v2(219,2)=2199;
  v2(219,3)=  v2(218,3);
  v2(220,1)=17;
  v2(220,2)=3499;
  v2(220,3)=(-(params(10)*T1555/T258/y(55)));
  v2(221,1)=17;
  v2(221,2)=3539;
  v2(221,3)=(-((-((-(params(10)*T255*T665))/(T258*T258)))/(y(55)*y(55))));
  v2(222,1)=17;
  v2(222,2)=1875;
  v2(222,3)=  v2(221,3);
  v2(223,1)=17;
  v2(223,2)=3563;
  v2(223,3)=(-((-(params(10)*T699/T258))/(y(55)*y(55))));
  v2(224,1)=17;
  v2(224,2)=3435;
  v2(224,3)=  v2(223,3);
  v2(225,1)=17;
  v2(225,2)=3544;
  v2(225,3)=(-((-((-(params(10)*T255*T765))/(T258*T258)))/(y(55)*y(55))));
  v2(226,1)=17;
  v2(226,2)=2200;
  v2(226,3)=  v2(225,3);
  v2(227,1)=17;
  v2(227,2)=3564;
  v2(227,3)=(-((-(params(10)*T789/T258))/(y(55)*y(55))));
  v2(228,1)=17;
  v2(228,2)=3500;
  v2(228,3)=  v2(227,3);
  v2(229,1)=17;
  v2(229,2)=3565;
  v2(229,3)=(-((-((-(params(10)*T255/T258))*(y(55)+y(55))))/(y(55)*y(55)*y(55)*y(55))));
  v2(230,1)=17;
  v2(230,2)=2575;
  v2(230,3)=(1+y(40)+1+y(40))/((1+y(40))*(1+y(40))*(1+y(40))*(1+y(40)));
  v2(231,1)=18;
  v2(231,2)=1849;
  v2(231,3)=exp(y(34))*(T267*getPowerDeriv(T267,T270,1)+T267*T267*getPowerDeriv(T267,T270,2));
  v2(232,1)=18;
  v2(232,2)=1914;
  v2(232,3)=exp(y(34))*(T716+T715*T267*getPowerDeriv(T267,T270,2));
  v2(233,1)=18;
  v2(233,2)=1850;
  v2(233,3)=  v2(232,3);
  v2(234,1)=18;
  v2(234,2)=1915;
  v2(234,3)=exp(y(34))*(T715*T715*getPowerDeriv(T267,T270,2)+getPowerDeriv(T267,T270,1)*((-(exp(y(29))*params(34)*exp(y(30))))*exp(y(30))*exp(y(30))-(-(exp(y(29))*params(34)*exp(y(30))))*(exp(y(30))*exp(y(30))+exp(y(30))*exp(y(30))))/(exp(y(30))*exp(y(30))*exp(y(30))*exp(y(30))));
  v2(235,1)=18;
  v2(235,2)=2174;
  v2(235,3)=exp(y(34))*T267*getPowerDeriv(T267,T270,1);
  v2(236,1)=18;
  v2(236,2)=1854;
  v2(236,3)=  v2(235,3);
  v2(237,1)=18;
  v2(237,2)=2175;
  v2(237,3)=exp(y(34))*T716;
  v2(238,1)=18;
  v2(238,2)=1919;
  v2(238,3)=  v2(237,3);
  v2(239,1)=18;
  v2(239,2)=2179;
  v2(239,3)=T272;
  v2(240,1)=19;
  v2(240,2)=1255;
  v2(240,3)=(T540*T563-T563*(T540+T540))/(T540*T540);
  v2(241,1)=19;
  v2(241,2)=1710;
  v2(241,3)=(-(exp(y(20))*(-exp(y(27)))/(exp(y(27))*exp(y(27)))))/T540;
  v2(242,1)=19;
  v2(242,2)=1262;
  v2(242,3)=  v2(241,3);
  v2(243,1)=19;
  v2(243,2)=1717;
  v2(243,3)=((-exp(y(27)))*exp(y(27))*exp(y(27))-(-exp(y(27)))*(exp(y(27))*exp(y(27))+exp(y(27))*exp(y(27))))/(exp(y(27))*exp(y(27))*exp(y(27))*exp(y(27)))/exp(y(20));
  v2(244,1)=19;
  v2(244,2)=1849;
  v2(244,3)=(-(T278*getPowerDeriv(T278,T270,1)+T278*T278*getPowerDeriv(T278,T270,2)));
  v2(245,1)=19;
  v2(245,2)=1979;
  v2(245,3)=(-(T730+T729*T278*getPowerDeriv(T278,T270,2)));
  v2(246,1)=19;
  v2(246,2)=1851;
  v2(246,3)=  v2(245,3);
  v2(247,1)=19;
  v2(247,2)=1981;
  v2(247,3)=(-(T729*T729*getPowerDeriv(T278,T270,2)+getPowerDeriv(T278,T270,1)*((-(exp(y(31))*exp(y(29))*params(35)))*exp(y(31))*exp(y(31))-(-(exp(y(31))*exp(y(29))*params(35)))*(exp(y(31))*exp(y(31))+exp(y(31))*exp(y(31))))/(exp(y(31))*exp(y(31))*exp(y(31))*exp(y(31)))));
  v2(248,1)=20;
  v2(248,2)=1849;
  v2(248,3)=exp(y(29));
  v2(249,1)=20;
  v2(249,2)=1915;
  v2(249,3)=(-(T721*params(34)^T270*(exp(y(30))*getPowerDeriv(exp(y(30)),T282,1)+exp(y(30))*exp(y(30))*getPowerDeriv(exp(y(30)),T282,2))+T720*T720*getPowerDeriv(T288,1+params(11),2)));
  v2(250,1)=20;
  v2(250,2)=1980;
  v2(250,3)=(-(T734*T720*getPowerDeriv(T288,1+params(11),2)));
  v2(251,1)=20;
  v2(251,2)=1916;
  v2(251,3)=  v2(250,3);
  v2(252,1)=20;
  v2(252,2)=1981;
  v2(252,3)=(-(T734*T734*getPowerDeriv(T288,1+params(11),2)+T721*params(35)^T270*(exp(y(31))*getPowerDeriv(exp(y(31)),T282,1)+exp(y(31))*exp(y(31))*getPowerDeriv(exp(y(31)),T282,2))));
  v2(253,1)=21;
  v2(253,2)=2311;
  v2(253,3)=(-(exp(y(36))/exp(y(37))));
  v2(254,1)=21;
  v2(254,2)=2376;
  v2(254,3)=T847;
  v2(255,1)=21;
  v2(255,2)=2312;
  v2(255,3)=  v2(254,3);
  v2(256,1)=21;
  v2(256,2)=2377;
  v2(256,3)=(-(((-(exp(y(36))*exp(y(37))))*exp(y(37))*exp(y(37))-(-(exp(y(36))*exp(y(37))))*(exp(y(37))*exp(y(37))+exp(y(37))*exp(y(37))))/(exp(y(37))*exp(y(37))*exp(y(37))*exp(y(37)))));
  v2(257,1)=21;
  v2(257,2)=2443;
  v2(257,3)=T850+exp(y(38))*exp(y(38))*getPowerDeriv(exp(y(38)),T297,2);
  v2(258,1)=22;
  v2(258,2)=1849;
  v2(258,3)=(-(T48*(T258*T258*(-(T308*T1477))-(-(T308*T665))*(T258*T665+T258*T665))/(T258*T258*T258*T258)+exp(y(56))*T319*T1680));
  v2(259,1)=22;
  v2(259,2)=3409;
  v2(259,3)=(-(exp(y(56))*T319*(-(T665*params(10)*params(25)*T699))/(T258*T258)));
  v2(260,1)=22;
  v2(260,2)=1873;
  v2(260,3)=  v2(259,3);
  v2(261,1)=22;
  v2(261,2)=3433;
  v2(261,3)=(-(exp(y(56))*T319*params(10)*params(25)*T1498/T258));
  v2(262,1)=22;
  v2(262,2)=2044;
  v2(262,3)=(-(T48*(-(T308*T665))/(T258*T258)+T48*(-(T665*T745))/(T258*T258)));
  v2(263,1)=22;
  v2(263,2)=1852;
  v2(263,3)=  v2(262,3);
  v2(264,1)=22;
  v2(264,2)=2047;
  v2(264,3)=(-(T748+T48*T745/T258+T48*T305*(T306*getPowerDeriv(T306,params(21),1)+T306*T306*getPowerDeriv(T306,params(21),2))/T258));
  v2(265,1)=22;
  v2(265,2)=2174;
  v2(265,3)=(-(T48*(T258*T258*(-(T308*T1505))-(-(T308*T765))*(T258*T665+T258*T665))/(T258*T258*T258*T258)+exp(y(56))*T319*T1724));
  v2(266,1)=22;
  v2(266,2)=1854;
  v2(266,3)=  v2(265,3);
  v2(267,1)=22;
  v2(267,2)=2198;
  v2(267,3)=(-(exp(y(56))*T319*(-(params(10)*params(25)*T699*T765))/(T258*T258)));
  v2(268,1)=22;
  v2(268,2)=3414;
  v2(268,3)=  v2(267,3);
  v2(269,1)=22;
  v2(269,2)=2177;
  v2(269,3)=(-(T48*(-(T308*T765))/(T258*T258)+T48*(-(T745*T765))/(T258*T258)));
  v2(270,1)=22;
  v2(270,2)=2049;
  v2(270,3)=  v2(269,3);
  v2(271,1)=22;
  v2(271,2)=2179;
  v2(271,3)=(-(T48*(T258*T258*(-(T308*T1522))-(-(T308*T765))*(T258*T765+T258*T765))/(T258*T258*T258*T258)+exp(y(56))*T319*T1753));
  v2(272,1)=22;
  v2(272,2)=3474;
  v2(272,3)=(-(exp(y(56))*T319*(-(T665*params(10)*params(25)*T789))/(T258*T258)));
  v2(273,1)=22;
  v2(273,2)=1874;
  v2(273,3)=  v2(272,3);
  v2(274,1)=22;
  v2(274,2)=3498;
  v2(274,3)=(-(exp(y(56))*T319*T1765));
  v2(275,1)=22;
  v2(275,2)=3434;
  v2(275,3)=  v2(274,3);
  v2(276,1)=22;
  v2(276,2)=3479;
  v2(276,3)=(-(exp(y(56))*T319*(-(T765*params(10)*params(25)*T789))/(T258*T258)));
  v2(277,1)=22;
  v2(277,2)=2199;
  v2(277,3)=  v2(276,3);
  v2(278,1)=22;
  v2(278,2)=3499;
  v2(278,3)=(-(exp(y(56))*T319*params(10)*params(25)*T1555/T258));
  v2(279,1)=22;
  v2(279,2)=3539;
  v2(279,3)=(-(exp(y(56))*T684*T832));
  v2(280,1)=22;
  v2(280,2)=1875;
  v2(280,3)=  v2(279,3);
  v2(281,1)=22;
  v2(281,2)=3563;
  v2(281,3)=(-(exp(y(56))*T705*T832));
  v2(282,1)=22;
  v2(282,2)=3435;
  v2(282,3)=  v2(281,3);
  v2(283,1)=22;
  v2(283,2)=3544;
  v2(283,3)=(-(exp(y(56))*T777*T832));
  v2(284,1)=22;
  v2(284,2)=2200;
  v2(284,3)=  v2(283,3);
  v2(285,1)=22;
  v2(285,2)=3564;
  v2(285,3)=(-(exp(y(56))*T795*T832));
  v2(286,1)=22;
  v2(286,2)=3500;
  v2(286,3)=  v2(285,3);
  v2(287,1)=22;
  v2(287,2)=3565;
  v2(287,3)=(-(exp(y(56))*T314*(getPowerDeriv(T315,T318,1)*(-((-params(36))*(y(55)+y(55))))/(y(55)*y(55)*y(55)*y(55))+T830*T830*getPowerDeriv(T315,T318,2))));
  v2(288,1)=22;
  v2(288,2)=2311;
  v2(288,3)=exp(y(36));
  v2(289,1)=22;
  v2(289,2)=3604;
  v2(289,3)=(-(exp(y(56))*T319*T684));
  v2(290,1)=22;
  v2(290,2)=1876;
  v2(290,3)=  v2(289,3);
  v2(291,1)=22;
  v2(291,2)=3628;
  v2(291,3)=(-(exp(y(56))*T319*T705));
  v2(292,1)=22;
  v2(292,2)=3436;
  v2(292,3)=  v2(291,3);
  v2(293,1)=22;
  v2(293,2)=3609;
  v2(293,3)=(-(exp(y(56))*T319*T777));
  v2(294,1)=22;
  v2(294,2)=2201;
  v2(294,3)=  v2(293,3);
  v2(295,1)=22;
  v2(295,2)=3629;
  v2(295,3)=(-(exp(y(56))*T319*T795));
  v2(296,1)=22;
  v2(296,2)=3501;
  v2(296,3)=  v2(295,3);
  v2(297,1)=22;
  v2(297,2)=3630;
  v2(297,3)=(-(exp(y(56))*T314*T832));
  v2(298,1)=22;
  v2(298,2)=3566;
  v2(298,3)=  v2(297,3);
  v2(299,1)=22;
  v2(299,2)=3631;
  v2(299,3)=(-(T314*T319*exp(y(56))));
  v2(300,1)=22;
  v2(300,2)=2954;
  v2(300,3)=(-(T48*(-(T665*T905))/(T258*T258)));
  v2(301,1)=22;
  v2(301,2)=1866;
  v2(301,3)=  v2(300,3);
  v2(302,1)=22;
  v2(302,2)=2957;
  v2(302,3)=(-(T48*T905/T258+T48*T305*(T904+T903*T306*getPowerDeriv(T306,params(21),2))/T258));
  v2(303,1)=22;
  v2(303,2)=2061;
  v2(303,3)=  v2(302,3);
  v2(304,1)=22;
  v2(304,2)=2959;
  v2(304,3)=(-(T48*(-(T765*T905))/(T258*T258)));
  v2(305,1)=22;
  v2(305,2)=2191;
  v2(305,3)=  v2(304,3);
  v2(306,1)=22;
  v2(306,2)=2971;
  v2(306,3)=(-(T48*T305*(T903*T903*getPowerDeriv(T306,params(21),2)+getPowerDeriv(T306,params(21),1)*((-(exp(y(46))*T48))*exp(y(46))*exp(y(46))-(-(exp(y(46))*T48))*(exp(y(46))*exp(y(46))+exp(y(46))*exp(y(46))))/(exp(y(46))*exp(y(46))*exp(y(46))*exp(y(46))))/T258));
  v2(307,1)=23;
  v2(307,2)=1849;
  v2(307,3)=(-(exp(y(57))*T334*T1680));
  v2(308,1)=23;
  v2(308,2)=3409;
  v2(308,3)=(-(exp(y(57))*T334*(-(T665*params(10)*params(25)*T699))/(T258*T258)));
  v2(309,1)=23;
  v2(309,2)=1873;
  v2(309,3)=  v2(308,3);
  v2(310,1)=23;
  v2(310,2)=3433;
  v2(310,3)=(-(exp(y(57))*T334*params(10)*params(25)*T1498/T258));
  v2(311,1)=23;
  v2(311,2)=2047;
  v2(311,3)=(-(T48*(1+params(37)*exp(y(47)))/params(23)));
  v2(312,1)=23;
  v2(312,2)=2174;
  v2(312,3)=(-(exp(y(57))*T334*T1724));
  v2(313,1)=23;
  v2(313,2)=1854;
  v2(313,3)=  v2(312,3);
  v2(314,1)=23;
  v2(314,2)=2198;
  v2(314,3)=(-(exp(y(57))*T334*(-(params(10)*params(25)*T699*T765))/(T258*T258)));
  v2(315,1)=23;
  v2(315,2)=3414;
  v2(315,3)=  v2(314,3);
  v2(316,1)=23;
  v2(316,2)=2179;
  v2(316,3)=(-(exp(y(57))*T334*T1753));
  v2(317,1)=23;
  v2(317,2)=3474;
  v2(317,3)=(-(exp(y(57))*T334*(-(T665*params(10)*params(25)*T789))/(T258*T258)));
  v2(318,1)=23;
  v2(318,2)=1874;
  v2(318,3)=  v2(317,3);
  v2(319,1)=23;
  v2(319,2)=3498;
  v2(319,3)=(-(exp(y(57))*T334*T1765));
  v2(320,1)=23;
  v2(320,2)=3434;
  v2(320,3)=  v2(319,3);
  v2(321,1)=23;
  v2(321,2)=3479;
  v2(321,3)=(-(exp(y(57))*T334*(-(T765*params(10)*params(25)*T789))/(T258*T258)));
  v2(322,1)=23;
  v2(322,2)=2199;
  v2(322,3)=  v2(321,3);
  v2(323,1)=23;
  v2(323,2)=3499;
  v2(323,3)=(-(exp(y(57))*T334*params(10)*params(25)*T1555/T258));
  v2(324,1)=23;
  v2(324,2)=3539;
  v2(324,3)=(-(exp(y(57))*T684*T837));
  v2(325,1)=23;
  v2(325,2)=1875;
  v2(325,3)=  v2(324,3);
  v2(326,1)=23;
  v2(326,2)=3563;
  v2(326,3)=(-(exp(y(57))*T705*T837));
  v2(327,1)=23;
  v2(327,2)=3435;
  v2(327,3)=  v2(326,3);
  v2(328,1)=23;
  v2(328,2)=3544;
  v2(328,3)=(-(exp(y(57))*T777*T837));
  v2(329,1)=23;
  v2(329,2)=2200;
  v2(329,3)=  v2(328,3);
  v2(330,1)=23;
  v2(330,2)=3564;
  v2(330,3)=(-(exp(y(57))*T795*T837));
  v2(331,1)=23;
  v2(331,2)=3500;
  v2(331,3)=  v2(330,3);
  v2(332,1)=23;
  v2(332,2)=3565;
  v2(332,3)=(-(exp(y(57))*T314*(T836*(-((-params(36))*(y(55)+y(55))))/(y(55)*y(55)*y(55)*y(55))+T830*T830*getPowerDeriv(T315,1-(1+params(23))/params(23),2))));
  v2(333,1)=23;
  v2(333,2)=2377;
  v2(333,3)=exp(y(37));
  v2(334,1)=23;
  v2(334,2)=3669;
  v2(334,3)=(-(exp(y(57))*T334*T684));
  v2(335,1)=23;
  v2(335,2)=1877;
  v2(335,3)=  v2(334,3);
  v2(336,1)=23;
  v2(336,2)=3693;
  v2(336,3)=(-(exp(y(57))*T334*T705));
  v2(337,1)=23;
  v2(337,2)=3437;
  v2(337,3)=  v2(336,3);
  v2(338,1)=23;
  v2(338,2)=3674;
  v2(338,3)=(-(exp(y(57))*T334*T777));
  v2(339,1)=23;
  v2(339,2)=2202;
  v2(339,3)=  v2(338,3);
  v2(340,1)=23;
  v2(340,2)=3694;
  v2(340,3)=(-(exp(y(57))*T334*T795));
  v2(341,1)=23;
  v2(341,2)=3502;
  v2(341,3)=  v2(340,3);
  v2(342,1)=23;
  v2(342,2)=3695;
  v2(342,3)=(-(exp(y(57))*T314*T837));
  v2(343,1)=23;
  v2(343,2)=3567;
  v2(343,3)=  v2(342,3);
  v2(344,1)=23;
  v2(344,2)=3697;
  v2(344,3)=(-(T314*T334*exp(y(57))));
  v2(345,1)=23;
  v2(345,2)=3022;
  v2(345,3)=T912;
  v2(346,1)=23;
  v2(346,2)=2062;
  v2(346,3)=  v2(345,3);
  v2(347,1)=23;
  v2(347,2)=3037;
  v2(347,3)=T912;
  v2(348,1)=24;
  v2(348,2)=2245;
  v2(348,3)=params(25)*(getPowerDeriv(T345,T342,1)*(-((-params(36))*(y(35)+y(35))))/(y(35)*y(35)*y(35)*y(35))+T816*T816*getPowerDeriv(T345,T342,2));
  v2(349,1)=24;
  v2(349,2)=2443;
  v2(349,3)=(1-params(25))*(exp(y(38))*getPowerDeriv(exp(y(38)),T342,1)+exp(y(38))*exp(y(38))*getPowerDeriv(exp(y(38)),T342,2));
  v2(350,1)=25;
  v2(350,2)=2245;
  v2(350,3)=(-(exp(y(5))*params(25)*(getPowerDeriv(T345,T318,1)*(-((-params(36))*(y(35)+y(35))))/(y(35)*y(35)*y(35)*y(35))+T816*T816*getPowerDeriv(T345,T318,2))));
  v2(351,1)=25;
  v2(351,2)=2443;
  v2(351,3)=(-((1-params(25))*(exp(y(38))*getPowerDeriv(exp(y(38)),T318,1)+exp(y(38))*exp(y(38))*getPowerDeriv(exp(y(38)),T318,2))));
  v2(352,1)=25;
  v2(352,2)=295;
  v2(352,3)=(-(exp(y(5))*params(25)*T816*getPowerDeriv(T345,T318,1)));
  v2(353,1)=25;
  v2(353,2)=2215;
  v2(353,3)=  v2(352,3);
  v2(354,1)=25;
  v2(354,2)=265;
  v2(354,3)=(-(params(25)*T345^T318*exp(y(5))));
  v2(355,1)=25;
  v2(355,2)=2509;
  v2(355,3)=exp(y(39));
  v2(356,1)=26;
  v2(356,2)=1057;
  v2(356,3)=(-(exp(y(17))*params(30)));
  v2(357,1)=26;
  v2(357,2)=1915;
  v2(357,3)=(-exp(y(30)));
  v2(358,1)=26;
  v2(358,2)=2047;
  v2(358,3)=T48;
  v2(359,1)=26;
  v2(359,2)=2113;
  v2(359,3)=(-exp(y(33)));
  v2(360,1)=27;
  v2(360,2)=2047;
  v2(360,3)=(-(T48*params(12)*exp(y(45))));
  v2(361,1)=27;
  v2(361,2)=2113;
  v2(361,3)=exp(y(33));
  v2(362,1)=27;
  v2(362,2)=2892;
  v2(362,3)=(-(T48*params(12)*exp(y(45))));
  v2(363,1)=27;
  v2(363,2)=2060;
  v2(363,3)=  v2(362,3);
  v2(364,1)=27;
  v2(364,2)=2905;
  v2(364,3)=(-(T48*params(12)*exp(y(45))));
  v2(365,1)=28;
  v2(365,2)=199;
  v2(365,3)=(-(y(35)*((-(exp(y(34))*exp(y(4))))*exp(y(4))*exp(y(4))-(-(exp(y(34))*exp(y(4))))*(exp(y(4))*exp(y(4))+exp(y(4))*exp(y(4))))/(exp(y(4))*exp(y(4))*exp(y(4))*exp(y(4)))));
  v2(366,1)=28;
  v2(366,2)=2149;
  v2(366,3)=T758;
  v2(367,1)=28;
  v2(367,2)=229;
  v2(367,3)=  v2(366,3);
  v2(368,1)=28;
  v2(368,2)=2179;
  v2(368,3)=(-(y(35)*exp(y(34))/exp(y(4))));
  v2(369,1)=28;
  v2(369,2)=2214;
  v2(369,3)=(-T756);
  v2(370,1)=28;
  v2(370,2)=230;
  v2(370,3)=  v2(369,3);
  v2(371,1)=28;
  v2(371,2)=2244;
  v2(371,3)=(-(exp(y(34))/exp(y(4))));
  v2(372,1)=28;
  v2(372,2)=2180;
  v2(372,3)=  v2(371,3);
  v2(373,1)=29;
  v2(373,2)=925;
  v2(373,3)=(-(params(48)*(T115*T115*(-(T384*T1030))-(-(T384*T442))*(T115*T442+T115*T442))/(T115*T115*T115*T115)));
  v2(374,1)=29;
  v2(374,2)=1705;
  v2(374,3)=(-(params(48)*(-(T442*T655))/(T115*T115)));
  v2(375,1)=29;
  v2(375,2)=937;
  v2(375,3)=  v2(374,3);
  v2(376,1)=29;
  v2(376,2)=1717;
  v2(376,3)=(-(params(48)*params(47)*(exp(y(27))*exp(y(27))*(-(exp(y(27))*params(46)))-(-(exp(y(27))*params(46)))*(exp(y(27))*exp(y(27))+exp(y(27))*exp(y(27))))/(exp(y(27))*exp(y(27))*exp(y(27))*exp(y(27)))/T115));
  v2(377,1)=29;
  v2(377,2)=1849;
  v2(377,3)=params(45)*(T257*T257*(-(params(44)*T1476))-(-(params(44)*T664))*(T257*T664+T257*T664))/(T257*T257*T257*T257);
  g2 = sparse(v2(:,1),v2(:,2),v2(:,3),35,4225);
end
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],35,274625);
end
end
