function [residual, g1, g2] = BBCDLmodelcomp_nash_c1dcore_c2dcore_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                    columns: equations in order of declaration
%                                                    rows: variables in declaration order
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: equations in order of declaration
%                                                       rows: variables in declaration order
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 113, 1);

%
% Model equations
%

T55 = exp(y(7));
T68 = exp(y(10));
T70 = T68^(1+params(25));
T74 = params(30)*exp(y(41))^(-params(25))*T70/(1+params(25))*exp(y(17));
T78 = exp(y(21));
T91 = exp(y(24));
T93 = T91^(1+params(24));
T97 = params(36)*exp(y(44))^(-params(24))*T93/(1+params(24))*exp(y(31));
T100 = T55^params(4);
T108 = exp(y(12));
T112 = T55^(params(4)-1);
T117 = (T68*exp((-y(41))))^params(25);
T122 = T68*T55*params(4)*params(30)*T108*T112*T117*(1+params(27))/params(27);
T128 = exp((-y(12)));
T132 = exp(y(14));
T138 = params(34)/y(13);
T140 = (1+params(25))*(1+params(27))/params(27);
T141 = T138^T140;
T143 = T112*T108*T55*params(4)*params(5)*params(29)*T128*T132/(T100*T141);
T144 = T122+T143;
T160 = params(6)/(1+params(6));
T162 = (T55*params(32)*exp((-y(9))))^(T160-1);
T164 = T55*params(32)*y(56)*params(6)*exp((-y(9)))*T162/(1+params(6));
T193 = (T55*params(31)*exp((-y(8))))^(T160-1);
T195 = T108*T55*params(6)*params(31)*y(55)*exp((-y(8)))*T193/(1+params(6));
T211 = params(3)*y(13)*T55^(1+params(4));
T221 = exp(y(15));
T223 = T108*T55*T128*params(29)*params(4)*params(5)*y(60)*T221;
T225 = (1+params(27))/params(27);
T227 = T138^(1-T225);
T233 = params(3)*T55^(1+params(4));
T245 = T100*T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)/(T141*T233);
T252 = params(31)^T160;
T255 = 1/(1+params(6));
T257 = exp(y(8))^(T255-1);
T261 = params(32)^T160;
T265 = T252*exp(y(8))^T255+T261*exp(y(9))^T255;
T266 = T265^params(6);
T282 = exp(y(41))^params(25);
T283 = (1+params(25))*T282;
T284 = T70*params(30)*exp(y(17))/T283;
T314 = T227*T100*T108*T221*T128*params(29)*params(5)*y(60)/(params(3)*T100);
T325 = T100*T108*T132*T128*params(29)*y(59)*params(5)/(T141*params(3)*T100);
T330 = exp(y(9))^(T255-1);
T344 = params(27)*y(13)^2;
T346 = 1+1/params(27);
T347 = T138^T346;
T348 = T344*T347;
T359 = T100*params(3)*y(13)^2;
T368 = T138^(1+T140);
T370 = (1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)*y(62)/(T344*T368);
T382 = T359*T138^T225;
T383 = T100*T108*T221*T128*params(29)*y(60)*params(5)*params(34)*(T225-1)/T382;
T396 = (1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*y(59)*params(5)*params(34)/(T368*T100*params(3)*T344);
T400 = exp(y(16));
T404 = T400^(params(25)*(1+params(27))/params(27));
T406 = 1+params(25)*(1+params(27))/params(27);
T412 = params(27)*T400^T346;
T420 = params(27)*T400^(1+T140);
T425 = exp((-y(26)));
T441 = (1+y(18))^2;
T447 = (T55*params(31)*exp((-y(8))))^T160;
T454 = (1+params(27))*T117*T100*T68*params(30)*T108/params(27);
T460 = T100*T108*T132*T128*params(5)*params(29)/(T100*T141);
T461 = T454+T460;
T493 = (T68*exp((-y(41))))^(params(25)-1);
T497 = T454+(1+params(27))*T100*T108*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*T493/params(27);
T518 = T68*params(30)*exp(y(17))*T68^params(25);
T527 = exp(y(26));
T531 = T78^(params(12)-1);
T536 = (T91*exp((-y(44))))^params(24);
T541 = T91*T78*params(12)*params(36)*T527*T531*T536*(1+params(26))/params(26);
T549 = exp(y(28));
T553 = T78^params(12);
T556 = params(39)/y(27);
T558 = (1+params(24))*(1+params(26))/params(26);
T559 = T556^T558;
T561 = T531*T527*T78*T425*params(12)*params(13)*params(28)*T549/(T553*T559);
T562 = T541+T561;
T585 = params(14)/(1+params(14));
T587 = (T78*params(38)*exp((-y(23))))^(T585-1);
T589 = T78*y(68)*params(38)*params(14)*exp((-y(23)))*T587/(1+params(14));
T603 = (T78*params(37)*exp((-y(22))))^(T585-1);
T605 = T527*T78*params(14)*params(37)*y(67)*exp((-y(22)))*T603/(1+params(14));
T621 = params(3)*y(27)*T78^(1+params(12));
T631 = exp(y(29));
T633 = T527*T78*T425*params(28)*params(12)*params(13)*y(72)*T631;
T635 = (1+params(26))/params(26);
T637 = T556^(1-T635);
T643 = params(3)*T78^(1+params(12));
T655 = T553*T527*T549*T78*T425*params(28)*params(12)*y(71)*params(13)/(T559*T643);
T661 = params(37)^T585;
T664 = 1/(1+params(14));
T666 = exp(y(22))^(T664-1);
T670 = params(38)^T585;
T674 = T661*exp(y(22))^T664+T670*exp(y(23))^T664;
T675 = T674^params(14);
T717 = T637*T553*T527*T631*T425*params(28)*params(13)*y(72)/(params(3)*T553);
T728 = T553*T527*T549*T425*params(28)*y(71)*params(13)/(T559*params(3)*T553);
T733 = exp(y(23))^(T664-1);
T745 = params(26)*y(27)^2;
T747 = 1+1/params(26);
T748 = T556^T747;
T749 = T745*T748;
T760 = T553*params(3)*y(27)^2;
T769 = T556^(1+T558);
T771 = (1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)*y(74)/(T745*T769);
T783 = T760*T556^T635;
T784 = T553*T527*T631*T425*params(28)*y(72)*params(13)*params(39)*(T635-1)/T783;
T797 = (1+params(26))*(1+params(24))*T553*T527*T549*T425*params(28)*y(71)*params(13)*params(39)/(T769*T553*params(3)*T745);
T801 = exp(y(30));
T805 = T801^(params(24)*(1+params(26))/params(26));
T807 = 1+params(24)*(1+params(26))/params(26);
T813 = params(26)*T801^T747;
T821 = params(26)*T801^(1+T558);
T829 = (1+y(32))^2;
T835 = (T78*params(37)*exp((-y(22))))^T585;
T842 = (1+params(26))*T536*T553*T91*params(36)*T527/params(26);
T848 = T553*T527*T549*T425*params(13)*params(28)/(T553*T559);
T849 = T842+T848;
T881 = (T91*exp((-y(44))))^(params(24)-1);
T885 = T842+(1+params(26))*T553*T527*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*T881/params(26);
T935 = T193*T108*T55*exp((-y(8)))*params(6)*params(31)*y(88)/(1+params(6));
T955 = T108*T221*T55*T128*params(29)*params(4)*params(5)*y(93);
T1016 = T227*T100*T108*T221*T128*params(29)*params(5)*y(93)/(params(3)*T100);
T1027 = T100*T108*T132*T128*params(29)*params(5)*y(92)/(T141*params(3)*T100);
T1057 = (1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)*y(95)/(T344*T368);
T1066 = (T225-1)*T100*T108*T221*T128*params(29)*params(5)*params(34)*y(93)/T382;
T1076 = (1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*params(5)*params(34)*y(92)/(T368*T100*params(3)*T344);
T1173 = T603*T527*T78*exp((-y(22)))*params(14)*params(37)*y(100)/(1+params(14));
T1192 = T527*T631*T78*T425*params(28)*params(12)*params(13)*y(105);
T1231 = exp(y(44))^params(24);
T1232 = (1+params(24))*T1231;
T1233 = T93*params(36)*exp(y(31))/T1232;
T1258 = T637*T553*T527*T631*T425*params(28)*params(13)*y(105)/(params(3)*T553);
T1269 = T553*T527*T549*T425*params(28)*params(13)*y(104)/(T559*params(3)*T553);
T1299 = (1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)*y(107)/(T745*T769);
T1308 = (T635-1)*T553*T527*T631*T425*params(28)*params(13)*params(39)*y(105)/T783;
T1318 = (1+params(26))*(1+params(24))*T553*T527*T549*T425*params(28)*params(13)*params(39)*y(104)/(T769*T553*params(3)*T745);
T1378 = T91*params(36)*exp(y(31))*T91^params(24);
T1379 = T1378/T1231;
T1385 = T55^(-params(4));
T1386 = T1385/T108;
T1392 = T55*params(31)/exp(y(8));
T1398 = T55*params(32)/exp(y(9));
T1411 = params(30)*T225*(T68/exp(y(41)))^params(25);
T1415 = params(5)*params(29)*T1386/T1386;
T1418 = (1+params(25))*(-(1+params(27)))/params(27);
T1419 = T138^T1418;
T1431 = (-1)/params(27);
T1458 = T78^(-params(12));
T1459 = T1458/T527;
T1465 = T78*params(37)/exp(y(22));
T1472 = T78*params(38)/exp(y(23));
T1485 = params(36)*T635*(T91/exp(y(44)))^params(24);
T1489 = params(13)*params(28)*T1459/T1459;
T1492 = (1+params(24))*(-(1+params(26)))/params(26);
T1493 = T556^T1492;
T1505 = (-1)/params(26);
T1586 = T55*getPowerDeriv(T55,params(4),1);
T1594 = T55*getPowerDeriv(T55,params(4)-1,1);
T1608 = (1+params(27))*T117*(T68*T55*params(4)*params(30)*T108*T112+T68*T55*params(4)*params(30)*T108*T1594)/params(27)+(T100*T141*(T112*T108*T55*params(4)*params(5)*params(29)*T128*T132+T108*T55*params(4)*params(5)*params(29)*T128*T132*T1594)-T112*T108*T55*params(4)*params(5)*params(29)*T128*T132*T141*T1586)/(T100*T141*T100*T141);
T1612 = T55*params(32)*exp((-y(9)))*getPowerDeriv(T55*params(32)*exp((-y(9))),T160-1,1);
T1615 = (T55*params(32)*y(56)*params(6)*exp((-y(9)))*T162+T55*params(32)*y(56)*params(6)*exp((-y(9)))*T1612)/(1+params(6));
T1621 = T55*params(31)*exp((-y(8)))*getPowerDeriv(T55*params(31)*exp((-y(8))),T160-1,1);
T1624 = (T108*T55*params(6)*params(31)*y(55)*exp((-y(8)))*T193+T108*T55*params(6)*params(31)*y(55)*exp((-y(8)))*T1621)/(1+params(6));
T1657 = params(3)*T55*getPowerDeriv(T55,1+params(4),1);
T1681 = (params(3)*T100*T227*T108*T221*T128*params(29)*params(5)*y(60)*T1586-T227*T100*T108*T221*T128*params(29)*params(5)*y(60)*params(3)*T1586)/(params(3)*T100*params(3)*T100);
T1689 = (T141*params(3)*T100*T108*T132*T128*params(29)*y(59)*params(5)*T1586-T100*T108*T132*T128*params(29)*y(59)*params(5)*T141*params(3)*T1586)/(T141*params(3)*T100*T141*params(3)*T100);
T1692 = params(3)*y(13)^2*T1586;
T1720 = T55*params(31)*exp((-y(8)))*getPowerDeriv(T55*params(31)*exp((-y(8))),T160,1);
T1731 = (1+params(27))*T117*T68*params(30)*T108*T1586/params(27)+(T100*T141*T108*T132*T128*params(5)*params(29)*T1586-T100*T108*T132*T128*params(5)*params(29)*T141*T1586)/(T100*T141*T100*T141);
T1757 = (1+params(27))*T117*T68*params(30)*T108*T1586/params(27)+(1+params(27))*T493*T108*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*T1586/params(27);
T1764 = (T162*T55*exp((-y(9)))*params(32)*params(6)*y(89)+T55*exp((-y(9)))*params(32)*params(6)*y(89)*T1612)/(1+params(6));
T1771 = (T193*T108*T55*exp((-y(8)))*params(6)*params(31)*y(88)+T108*T55*exp((-y(8)))*params(6)*params(31)*y(88)*T1621)/(1+params(6));
T1816 = (params(3)*T100*T227*T108*T221*T128*params(29)*params(5)*y(93)*T1586-T227*T100*T108*T221*T128*params(29)*params(5)*y(93)*params(3)*T1586)/(params(3)*T100*params(3)*T100);
T1822 = (T141*params(3)*T100*T108*T132*T128*params(29)*params(5)*y(92)*T1586-T100*T108*T132*T128*params(29)*params(5)*y(92)*T141*params(3)*T1586)/(T141*params(3)*T100*T141*params(3)*T100);
T1869 = T55*getPowerDeriv(T55,(-params(4)),1)/T108;
T1912 = getPowerDeriv(T55*params(31)*exp((-y(8))),T160-1,1)*T55*params(31)*(-exp((-y(8))));
T1916 = (T193*T108*T55*params(6)*params(31)*y(55)*(-exp((-y(8))))+T108*T55*params(6)*params(31)*y(55)*exp((-y(8)))*T1912)/(1+params(6));
T1925 = T252*exp(y(8))*getPowerDeriv(exp(y(8)),T255,1)*getPowerDeriv(T265,params(6),1);
T1933 = getPowerDeriv(T55*params(31)*exp((-y(8))),T160,1)*T55*params(31)*(-exp((-y(8))));
T1941 = (T108*T55*exp((-y(8)))*params(6)*params(31)*y(88)*T1912+T193*T108*T55*params(6)*params(31)*y(88)*(-exp((-y(8)))))/(1+params(6));
T1967 = getPowerDeriv(T55*params(32)*exp((-y(9))),T160-1,1)*T55*params(32)*(-exp((-y(9))));
T1971 = (T162*T55*params(32)*y(56)*params(6)*(-exp((-y(9))))+T55*params(32)*y(56)*params(6)*exp((-y(9)))*T1967)/(1+params(6));
T1976 = getPowerDeriv(T265,params(6),1)*T261*exp(y(9))*getPowerDeriv(exp(y(9)),T255,1);
T1993 = (T55*exp((-y(9)))*params(32)*params(6)*y(89)*T1967+T162*T55*params(32)*params(6)*y(89)*(-exp((-y(9)))))/(1+params(6));
T2020 = T68*exp((-y(41)))*getPowerDeriv(T68*exp((-y(41))),params(25),1);
T2024 = (1+params(27))*(T68*T55*params(4)*params(30)*T108*T112*T117+T68*T55*params(4)*params(30)*T108*T112*T2020)/params(27);
T2033 = (1+params(27))*(T117*T100*T68*params(30)*T108+T100*T68*params(30)*T108*T2020)/params(27);
T2048 = T2033+(1+params(27))*(T493*T100*T108*exp((-y(41)))*params(30)*params(25)*2*exp(2*y(10))+T100*T108*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*T68*exp((-y(41)))*getPowerDeriv(T68*exp((-y(41))),params(25)-1,1))/params(27);
T2067 = getPowerDeriv(T68/exp(y(41)),params(25),1);
T2085 = T122+T112*(T108*T55*params(4)*params(5)*params(29)*T128*T132+T108*T132*T55*params(4)*params(5)*params(29)*(-T128))/(T100*T141);
T2127 = T227*T100*(T108*T221*T128*params(29)*params(5)*y(60)+T108*T221*params(29)*params(5)*y(60)*(-T128))/(params(3)*T100);
T2134 = T100*(T108*T132*T128*params(29)*y(59)*params(5)+T108*T132*params(29)*y(59)*params(5)*(-T128))/(T141*params(3)*T100);
T2168 = T454+T100*(T108*T132*T128*params(5)*params(29)+T108*T132*params(5)*params(29)*(-T128))/(T100*T141);
T2223 = T227*T100*(T108*T221*T128*params(29)*params(5)*y(93)+T108*T221*params(29)*params(5)*y(93)*(-T128))/(params(3)*T100);
T2230 = T100*(T108*T132*T128*params(29)*params(5)*y(92)+T108*T132*params(29)*params(5)*y(92)*(-T128))/(T141*params(3)*T100);
T2274 = (-(T108*T1385))/(T108*T108);
T2304 = (-params(34))/(y(13)*y(13));
T2306 = T2304*getPowerDeriv(T138,T140,1);
T2310 = (-(T112*T108*T55*params(4)*params(5)*params(29)*T128*T132*T100*T2306))/(T100*T141*T100*T141);
T2322 = T2304*getPowerDeriv(T138,1-T225,1);
T2340 = T100*T108*T221*T128*params(29)*params(5)*y(60)*T2322/(params(3)*T100);
T2345 = (-(T100*T108*T132*T128*params(29)*y(59)*params(5)*params(3)*T100*T2306))/(T141*params(3)*T100*T141*params(3)*T100);
T2378 = T138^T225*T100*params(3)*2*y(13)+T359*T2304*getPowerDeriv(T138,T225,1);
T2387 = T100*params(3)*T344*T2304*getPowerDeriv(T138,1+T140,1)+T368*T100*params(3)*params(27)*2*y(13);
T2394 = (-(T100*T108*T132*T128*params(5)*params(29)*T100*T2306))/(T100*T141*T100*T141);
T2435 = T100*T108*T221*T128*params(29)*params(5)*y(93)*T2322/(params(3)*T100);
T2439 = (-(T100*T108*T132*T128*params(29)*params(5)*y(92)*params(3)*T100*T2306))/(T141*params(3)*T100*T141*params(3)*T100);
T2537 = T400*getPowerDeriv(T400,params(25)*(1+params(27))/params(27),1);
T2637 = T78*getPowerDeriv(T78,params(12)-1,1);
T2646 = T78*getPowerDeriv(T78,params(12),1);
T2653 = (1+params(26))*T536*(T91*T78*params(12)*params(36)*T527*T531+T91*T78*params(12)*params(36)*T527*T2637)/params(26)+(T553*T559*(T531*T527*T78*T425*params(12)*params(13)*params(28)*T549+T527*T78*T425*params(12)*params(13)*params(28)*T549*T2637)-T531*T527*T78*T425*params(12)*params(13)*params(28)*T549*T559*T2646)/(T553*T559*T553*T559);
T2660 = T78*params(38)*exp((-y(23)))*getPowerDeriv(T78*params(38)*exp((-y(23))),T585-1,1);
T2663 = (T78*y(68)*params(38)*params(14)*exp((-y(23)))*T587+T78*y(68)*params(38)*params(14)*exp((-y(23)))*T2660)/(1+params(14));
T2666 = T78*params(37)*exp((-y(22)))*getPowerDeriv(T78*params(37)*exp((-y(22))),T585-1,1);
T2669 = (T527*T78*params(14)*params(37)*y(67)*exp((-y(22)))*T603+T527*T78*params(14)*params(37)*y(67)*exp((-y(22)))*T2666)/(1+params(14));
T2703 = params(3)*T78*getPowerDeriv(T78,1+params(12),1);
T2727 = (params(3)*T553*T637*T527*T631*T425*params(28)*params(13)*y(72)*T2646-T637*T553*T527*T631*T425*params(28)*params(13)*y(72)*params(3)*T2646)/(params(3)*T553*params(3)*T553);
T2735 = (T559*params(3)*T553*T527*T549*T425*params(28)*y(71)*params(13)*T2646-T553*T527*T549*T425*params(28)*y(71)*params(13)*T559*params(3)*T2646)/(T559*params(3)*T553*T559*params(3)*T553);
T2738 = params(3)*y(27)^2*T2646;
T2765 = T78*params(37)*exp((-y(22)))*getPowerDeriv(T78*params(37)*exp((-y(22))),T585,1);
T2776 = (1+params(26))*T536*T91*params(36)*T527*T2646/params(26)+(T553*T559*T527*T549*T425*params(13)*params(28)*T2646-T553*T527*T549*T425*params(13)*params(28)*T559*T2646)/(T553*T559*T553*T559);
T2802 = (1+params(26))*T536*T91*params(36)*T527*T2646/params(26)+(1+params(26))*T881*T527*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*T2646/params(26);
T2817 = (T587*T78*exp((-y(23)))*y(101)*params(38)*params(14)+T78*exp((-y(23)))*y(101)*params(38)*params(14)*T2660)/(1+params(14));
T2821 = (T603*T527*T78*exp((-y(22)))*params(14)*params(37)*y(100)+T527*T78*exp((-y(22)))*params(14)*params(37)*y(100)*T2666)/(1+params(14));
T2866 = (params(3)*T553*T637*T527*T631*T425*params(28)*params(13)*y(105)*T2646-T637*T553*T527*T631*T425*params(28)*params(13)*y(105)*params(3)*T2646)/(params(3)*T553*params(3)*T553);
T2872 = (T559*params(3)*T553*T527*T549*T425*params(28)*params(13)*y(104)*T2646-T553*T527*T549*T425*params(28)*params(13)*y(104)*T559*params(3)*T2646)/(T559*params(3)*T553*T559*params(3)*T553);
T2918 = T78*getPowerDeriv(T78,(-params(12)),1)/T527;
T2960 = getPowerDeriv(T78*params(37)*exp((-y(22))),T585-1,1)*T78*params(37)*(-exp((-y(22))));
T2964 = (T603*T527*T78*params(14)*params(37)*y(67)*(-exp((-y(22))))+T527*T78*params(14)*params(37)*y(67)*exp((-y(22)))*T2960)/(1+params(14));
T2973 = T661*exp(y(22))*getPowerDeriv(exp(y(22)),T664,1)*getPowerDeriv(T674,params(14),1);
T2981 = getPowerDeriv(T78*params(37)*exp((-y(22))),T585,1)*T78*params(37)*(-exp((-y(22))));
T2989 = (T527*T78*exp((-y(22)))*params(14)*params(37)*y(100)*T2960+T603*T527*T78*params(14)*params(37)*y(100)*(-exp((-y(22)))))/(1+params(14));
T3015 = getPowerDeriv(T78*params(38)*exp((-y(23))),T585-1,1)*T78*params(38)*(-exp((-y(23))));
T3019 = (T587*T78*y(68)*params(38)*params(14)*(-exp((-y(23))))+T78*y(68)*params(38)*params(14)*exp((-y(23)))*T3015)/(1+params(14));
T3024 = getPowerDeriv(T674,params(14),1)*T670*exp(y(23))*getPowerDeriv(exp(y(23)),T664,1);
T3041 = (T78*exp((-y(23)))*y(101)*params(38)*params(14)*T3015+T587*T78*y(101)*params(38)*params(14)*(-exp((-y(23)))))/(1+params(14));
T3068 = T91*exp((-y(44)))*getPowerDeriv(T91*exp((-y(44))),params(24),1);
T3072 = (1+params(26))*(T91*T78*params(12)*params(36)*T527*T531*T536+T91*T78*params(12)*params(36)*T527*T531*T3068)/params(26);
T3078 = (1+params(26))*(T536*T553*T91*params(36)*T527+T553*T91*params(36)*T527*T3068)/params(26);
T3093 = T3078+(1+params(26))*(T881*T553*T527*exp((-y(44)))*params(36)*params(24)*2*exp(2*y(24))+T553*T527*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*T91*exp((-y(44)))*getPowerDeriv(T91*exp((-y(44))),params(24)-1,1))/params(26);
T3115 = getPowerDeriv(T91/exp(y(44)),params(24),1);
T3135 = T541+T531*(T527*T78*T425*params(12)*params(13)*params(28)*T549+T527*T549*T78*params(12)*params(13)*params(28)*(-T425))/(T553*T559);
T3177 = T637*T553*(T527*T631*T425*params(28)*params(13)*y(72)+T527*T631*params(28)*params(13)*y(72)*(-T425))/(params(3)*T553);
T3184 = T553*(T527*T549*T425*params(28)*y(71)*params(13)+T527*T549*params(28)*y(71)*params(13)*(-T425))/(T559*params(3)*T553);
T3216 = T842+T553*(T527*T549*T425*params(13)*params(28)+T527*T549*params(13)*params(28)*(-T425))/(T553*T559);
T3273 = T637*T553*(T527*T631*T425*params(28)*params(13)*y(105)+T527*T631*params(28)*params(13)*y(105)*(-T425))/(params(3)*T553);
T3280 = T553*(T527*T549*T425*params(28)*params(13)*y(104)+T527*T549*params(28)*params(13)*y(104)*(-T425))/(T559*params(3)*T553);
T3325 = (-(T527*T1458))/(T527*T527);
T3352 = (-params(39))/(y(27)*y(27));
T3354 = T3352*getPowerDeriv(T556,T558,1);
T3358 = (-(T531*T527*T78*T425*params(12)*params(13)*params(28)*T549*T553*T3354))/(T553*T559*T553*T559);
T3370 = T3352*getPowerDeriv(T556,1-T635,1);
T3388 = T553*T527*T631*T425*params(28)*params(13)*y(72)*T3370/(params(3)*T553);
T3393 = (-(T553*T527*T549*T425*params(28)*y(71)*params(13)*params(3)*T553*T3354))/(T559*params(3)*T553*T559*params(3)*T553);
T3426 = T556^T635*T553*params(3)*2*y(27)+T760*T3352*getPowerDeriv(T556,T635,1);
T3435 = T553*params(3)*T745*T3352*getPowerDeriv(T556,1+T558,1)+T769*T553*params(3)*params(26)*2*y(27);
T3442 = (-(T553*T527*T549*T425*params(13)*params(28)*T553*T3354))/(T553*T559*T553*T559);
T3483 = T553*T527*T631*T425*params(28)*params(13)*y(105)*T3370/(params(3)*T553);
T3487 = (-(T553*T527*T549*T425*params(28)*params(13)*y(104)*params(3)*T553*T3354))/(T559*params(3)*T553*T559*params(3)*T553);
T3585 = T801*getPowerDeriv(T801,params(24)*(1+params(26))/params(26),1);
T3704 = getPowerDeriv(T68*exp((-y(41))),params(25),1)*T68*(-exp((-y(41))));
T3720 = (1+params(27))*T100*T68*params(30)*T108*T3704/params(27);
T3732 = T3720+(1+params(27))*(T493*T100*T108*params(30)*params(25)*exp(2*y(10))*(-exp((-y(41))))+T100*T108*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*getPowerDeriv(T68*exp((-y(41))),params(25)-1,1)*T68*(-exp((-y(41)))))/params(27);
T3778 = getPowerDeriv(T91*exp((-y(44))),params(24),1)*T91*(-exp((-y(44))));
T3786 = (1+params(26))*T553*T91*params(36)*T527*T3778/params(26);
T3798 = T3786+(1+params(26))*(T881*T553*T527*params(36)*params(24)*exp(2*y(24))*(-exp((-y(44))))+T553*T527*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*getPowerDeriv(T91*exp((-y(44))),params(24)-1,1)*T91*(-exp((-y(44)))))/params(26);
T3849 = (-(T112*T108*T55*params(4)*params(5)*T128/(T100*y(13))))+T100*T108*T55*params(4)*params(5)*T128/T211;
T3859 = (-(T100*T108*params(5)*T128/(T100*y(13))))+T100*T108*params(5)*T128/(T100*params(3)*y(13));
T3864 = T193*T108*T55*exp((-y(8)))*params(6)*params(31)/(1+params(6));
T3870 = T162*T55*exp((-y(9)))*params(32)*params(6)/(1+params(6));
T3889 = (-T144)+T100*T108*T55*params(4)*params(5)*params(29)*T128*T132/(T141*T233);
T3900 = (-((1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*params(5)*params(34)/(T368*T100*params(3)*T344)));
T3913 = (-(T227*T112*T108*T55*params(4)*params(5)*params(29)*T128*T221/T100))+T227*T100*T108*T55*params(4)*params(5)*params(29)*T128*T221/T233;
T3919 = T221-T227*T100*T108*T221*T128*params(5)*params(29)/(params(3)*T100);
T3925 = (-((T225-1)*T100*T108*T221*T128*params(29)*params(5)*params(34)/T382));
T3928 = T227*T100*T108*T221*T128*params(5)*params(29)/(params(3)*T100)-T227*T100*T108*T221*T128*params(5)*params(29)/T100;
T3943 = (-((1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)/(T344*T368)));
T3967 = (-(T531*T527*T78*T425*params(12)*params(13)/(T553*y(27))))+T553*T527*T78*T425*params(12)*params(13)/T621;
T3977 = (-(T553*T527*T425*params(13)/(T553*y(27))))+T553*T527*T425*params(13)/(T553*params(3)*y(27));
T3982 = T603*T527*T78*exp((-y(22)))*params(14)*params(37)/(1+params(14));
T3990 = T587*T78*exp((-y(23)))*params(38)*params(14)/(1+params(14));
T4007 = (-T562)+T527*T78*T425*params(12)*params(13)*params(28)*T549*T553/(T559*T643);
T4018 = (-((1+params(26))*(1+params(24))*T553*T527*T549*T425*params(28)*params(13)*params(39)/(T769*T553*params(3)*T745)));
T4031 = (-(T637*T531*T527*T78*T425*params(12)*params(13)*params(28)*T631/T553))+T637*T553*T527*T78*T425*params(12)*params(13)*params(28)*T631/T643;
T4037 = T631-T637*T553*T527*T631*T425*params(13)*params(28)/(params(3)*T553);
T4043 = (-((T635-1)*T553*T527*T631*T425*params(28)*params(13)*params(39)/T783));
T4046 = T637*T553*T527*T631*T425*params(13)*params(28)/(params(3)*T553)-T637*T553*T527*T631*T425*params(13)*params(28)/T553;
T4061 = (-((1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)/(T745*T769)));
lhs =y(112);
rhs =params(1)*y(5)+params(2)*y(6);
residual(1)= lhs-rhs;
lhs =y(113);
rhs =y(112)+y(113)*params(3);
residual(2)= lhs-rhs;
lhs =y(1);
rhs =y(5)+params(3)*y(1);
residual(3)= lhs-rhs;
lhs =y(2);
rhs =y(6)+params(3)*y(2);
residual(4)= lhs-rhs;
lhs =y(3);
rhs =y(20);
residual(5)= lhs-rhs;
lhs =y(4);
rhs =y(33);
residual(6)= lhs-rhs;
lhs =y(34);
rhs =y(17);
residual(7)= lhs-rhs;
lhs =y(35);
rhs =y(18);
residual(8)= lhs-rhs;
lhs =y(36);
rhs =y(12);
residual(9)= lhs-rhs;
lhs =y(37);
rhs =y(31);
residual(10)= lhs-rhs;
lhs =y(38);
rhs =y(32);
residual(11)= lhs-rhs;
lhs =y(39);
rhs =y(26);
residual(12)= lhs-rhs;
lhs =y(5);
rhs =T55^(1-params(4))/(1-params(4))-T74;
residual(13)= lhs-rhs;
lhs =y(6);
rhs =T78^(1-params(12))/(1-params(12))-T97;
residual(14)= lhs-rhs;
residual(15) = T55/T100+T55*y(57)-y(59)*T144-T164-T112*T55*params(4)*params(50)*y(78)*params(49)*params(51)*exp((-y(19)))+T195-T112*T108*T55*T128*params(4)*params(5)*y(54)/(T100*y(13))+T100*T108*T55*T128*params(4)*params(5)*y(54)/T211-T112*T223*T227/T100+T227*T100*T223/T233+T245;
residual(16) = (-y(63))*exp(y(8))-exp(y(8))*y(57)*T252*T257*T266-T195;
residual(17) = y(65)-y(46);
residual(18) = exp(y(17))*y(62)-params(3)*y(48)-T284;
residual(19) = y(48)-params(29)*y(62)*exp(y(34))/T141;
residual(20) = y(64)*exp(y(11))-y(63)*exp(y(11));
residual(21) = y(60)*T221+T132*y(58)*exp((-y(15)))-T314;
residual(22) = y(59)*T132-T132*y(58)*exp((-y(15)))-T325;
residual(23) = T164-T266*exp(y(9))*y(57)*T261*T330-exp(y(9))*y(75)*params(33);
residual(24) = params(29)*params(34)*y(61)/T348-T108*y(65)*exp((-y(36)))+T100*T108*T128*params(5)*y(54)/T359-T370-T383-T396;
residual(25) = y(58)*T400*T404*T406+y(61)*T400*(params(29)-1)/T412-(params(29)-1)*(1+params(27))*(1+params(25))*y(62)*T400/T420;
residual(26) = y(56)*T425*exp(y(19))-T128*exp((-y(19)))*y(68)+T100*params(50)*y(78)*params(49)*params(51)*exp((-y(19)));
residual(27) = params(3)*(-y(49))-y(54)/T441;
residual(28) = y(49);
residual(29) = T314+T325+T108*y(55)*T447-y(59)*T461-T128*exp((-y(19)))*y(68)-params(3)*y(50)-T108*exp((-y(36)))*y(13)*y(65)-T100*T108*T128*params(5)*y(54)/(T100*y(13))+T100*T108*T128*params(5)*y(54)/(T100*params(3)*y(13))-T227*T100*T108*T221*T128*params(29)*params(5)*y(60)/T100;
residual(30) = y(50)+T108*exp((-y(36)))*y(13)*y(65);
residual(31) = T68*y(63)-y(59)*T497-T68*y(60)*(1+params(35)*exp(y(42)))/params(27)-T68*y(64)*params(7)*exp(y(40))-T518/T282;
residual(32) = T78*y(69)-y(71)*T562+T531*T78*params(12)*y(78)*params(47)*params(48)-T589+T605-T531*T527*T78*T425*params(12)*params(13)*y(66)/(T553*y(27))+T553*T527*T78*T425*params(12)*params(13)*y(66)/T621-T531*T633*T637/T553+T637*T553*T633/T643+T655;
residual(33) = (-y(75))*exp(y(22))-exp(y(22))*y(69)*T661*T666*T675-T605;
residual(34) = y(77)-y(47);
residual(35) = exp(y(31))*y(74)-params(3)*y(51);
residual(36) = y(51)-params(28)*y(74)*exp(y(37))/T559;
residual(37) = y(76)*exp(y(25))-y(75)*exp(y(25));
residual(38) = y(72)*T631+T549*y(70)*exp((-y(29)))-T717;
residual(39) = y(71)*T549-T549*y(70)*exp((-y(29)))-T728;
residual(40) = T589-T675*exp(y(23))*y(69)*T670*T733-y(63)*exp(y(23))/params(33);
residual(41) = params(28)*params(39)*y(73)/T749-T527*y(77)*exp((-y(39)))+T553*T527*T425*params(13)*y(66)/T760-T771-T784-T797;
residual(42) = y(70)*T801*T805*T807+y(73)*T801*(params(28)-1)/T813-(params(28)-1)*(1+params(26))*(1+params(24))*y(74)*T801/T821;
residual(43) = params(3)*(-y(52))-y(66)/T829;
residual(44) = y(52);
residual(45) = T717+T728+T527*y(67)*T835-y(71)*T849-params(3)*y(53)-y(56)*T425*exp(y(19))-T527*exp((-y(39)))*y(27)*y(77)-T553*T527*T425*params(13)*y(66)/(T553*y(27))+T553*T527*T425*params(13)*y(66)/(T553*params(3)*y(27))-T637*T553*T527*T631*T425*params(28)*params(13)*y(72)/T553;
residual(46) = y(53)+T527*exp((-y(39)))*y(27)*y(77);
residual(47) = T91*y(75)-y(71)*T885-T91*y(72)*(1+params(40)*exp(y(45)))/params(26)-T91*y(76)*params(15)*exp(y(43));
residual(48) = y(46);
residual(49) = T55*y(90)-T144*y(92)-T162*T55*exp((-y(9)))*params(32)*params(6)*y(89)/(1+params(6))-T112*T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)*y(111)+T935-T112*T108*T55*T128*params(4)*params(5)*y(87)/(T100*y(13))+T100*T108*T55*T128*params(4)*params(5)*y(87)/T211-T227*T112*T955/T100+T227*T100*T955/T233+T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)/(T141*T233);
residual(50) = exp(y(8))*(-y(96))-T266*T257*exp(y(8))*T252*y(90)-T935;
residual(51) = y(98)-y(79);
residual(52) = exp(y(17))*y(95)-params(3)*y(81);
residual(53) = y(81)-exp(y(34))*params(29)*y(95)/T141;
residual(54) = exp(y(11))*y(97)-exp(y(11))*y(96);
residual(55) = T221*y(93)+T132*exp((-y(15)))*y(91)-T1016;
residual(56) = T132*y(92)-T132*exp((-y(15)))*y(91)-T1027;
residual(57) = T162*T55*exp((-y(9)))*params(32)*params(6)*y(89)/(1+params(6))-T266*T330*exp(y(9))*T261*y(90)-exp(y(9))*params(33)*y(108);
residual(58) = params(29)*params(34)*y(94)/T348-T108*exp((-y(36)))*y(98)+T100*T108*T128*params(5)*y(87)/T359-T1057-T1066-T1076;
residual(59) = T406*T404*T400*y(91)+(params(29)-1)*T400*y(94)/T412-(params(29)-1)*(1+params(27))*(1+params(25))*T400*y(95)/T420;
residual(60) = exp(y(19))*T425*y(89)-T128*exp((-y(19)))*y(101)+T100*exp((-y(19)))*params(51)*params(50)*params(49)*y(111);
residual(61) = params(3)*(-y(82))-y(87)/T441;
residual(62) = y(82);
residual(63) = T1016+T1027+T447*T108*y(88)-T461*y(92)-T128*exp((-y(19)))*y(101)-params(3)*y(83)-T108*exp((-y(36)))*y(13)*y(98)-T100*T108*T128*params(5)*y(87)/(T100*y(13))+T100*T108*T128*params(5)*y(87)/(T100*params(3)*y(13))-T227*T100*T108*T221*T128*params(29)*params(5)*y(93)/T100;
residual(64) = y(83)+T108*exp((-y(36)))*y(13)*y(98);
residual(65) = T68*y(96)-T497*y(92)-(1+params(35)*exp(y(42)))*T68*y(93)/params(27)-T68*exp(y(40))*params(7)*y(97);
residual(66) = T78/T553+T78*y(102)-T562*y(104)+T531*T78*y(111)*params(12)*params(47)*params(48)-T587*T78*exp((-y(23)))*y(101)*params(38)*params(14)/(1+params(14))+T1173-T531*T527*T78*T425*params(12)*params(13)*y(99)/(T553*y(27))+T553*T527*T78*T425*params(12)*params(13)*y(99)/T621-T637*T531*T1192/T553+T637*T553*T1192/T643+T553*T527*T549*T78*T425*params(28)*params(12)*params(13)*y(104)/(T559*T643);
residual(67) = exp(y(22))*(-y(108))-T675*T666*exp(y(22))*T661*y(102)-T1173;
residual(68) = y(110)-y(80);
residual(69) = exp(y(31))*y(107)-params(3)*y(84)-T1233;
residual(70) = y(84)-exp(y(37))*params(28)*y(107)/T559;
residual(71) = exp(y(25))*y(109)-exp(y(25))*y(108);
residual(72) = T631*y(105)+T549*exp((-y(29)))*y(103)-T1258;
residual(73) = T549*y(104)-T549*exp((-y(29)))*y(103)-T1269;
residual(74) = T587*T78*exp((-y(23)))*y(101)*params(38)*params(14)/(1+params(14))-T675*T733*exp(y(23))*T670*y(102)-exp(y(23))*y(96)/params(33);
residual(75) = params(28)*params(39)*y(106)/T749-T527*exp((-y(39)))*y(110)+T553*T527*T425*params(13)*y(99)/T760-T1299-T1308-T1318;
residual(76) = T807*T805*T801*y(103)+(params(28)-1)*T801*y(106)/T813-(params(28)-1)*(1+params(26))*(1+params(24))*T801*y(107)/T821;
residual(77) = params(3)*(-y(85))-y(99)/T829;
residual(78) = y(85);
residual(79) = T1258+T1269+T835*T527*y(100)-T849*y(104)-params(3)*y(86)-exp(y(19))*T425*y(89)-T527*exp((-y(39)))*y(27)*y(110)-T553*T527*T425*params(13)*y(99)/(T553*y(27))+T553*T527*T425*params(13)*y(99)/(T553*params(3)*y(27))-T637*T553*T527*T631*T425*params(28)*params(13)*y(105)/T553;
residual(80) = y(86)+T527*exp((-y(39)))*y(27)*y(110);
residual(81) = T91*y(108)-T885*y(104)-(1+params(40)*exp(y(45)))*T91*y(105)/params(26)-T91*exp(y(43))*params(15)*y(109)-T1379;
residual(82) = y(80);
lhs =1/(1+y(18));
rhs =params(5)*T1386/T1386/y(13);
residual(83)= lhs-rhs;
lhs =T108*T1392^T160;
rhs =1;
residual(84)= lhs-rhs;
lhs =exp(y(19))/T527;
rhs =T1398^T160;
residual(85)= lhs-rhs;
lhs =T55;
rhs =T265^(1+params(6));
residual(86)= lhs-rhs;
lhs =T400^(1+params(25)*T225);
rhs =T132/T221;
residual(87)= lhs-rhs;
lhs =T132;
rhs =T68*T1411/T1386+T132*T1415*T1419;
residual(88)= lhs-rhs;
lhs =T221;
rhs =T68*(1+params(35)*exp(y(42)))/params(27)+T221*T227*T1415;
residual(89)= lhs-rhs;
lhs =(1-params(29))*T400^T1431+params(29)*T138^T1431;
rhs =1;
residual(90)= lhs-rhs;
lhs =exp(y(17));
rhs =(1-params(29))*T400^T1418+exp(y(34))*params(29)*T1419;
residual(91)= lhs-rhs;
lhs =T68;
rhs =exp(y(8))+exp(y(11))+exp(y(23))*1/params(33);
residual(92)= lhs-rhs;
lhs =exp(y(11));
rhs =exp(y(40))*T68*params(7);
residual(93)= lhs-rhs;
lhs =y(20);
rhs =y(13)*T108/exp(y(36));
residual(94)= lhs-rhs;
lhs =1/(1+y(32));
rhs =params(13)*T1459/T1459/y(27);
residual(95)= lhs-rhs;
lhs =T527*T1465^T585;
rhs =1;
residual(96)= lhs-rhs;
lhs =1/exp(y(19))/T108;
rhs =T1472^T585;
residual(97)= lhs-rhs;
lhs =T78;
rhs =T674^(1+params(14));
residual(98)= lhs-rhs;
lhs =T801^(1+params(24)*T635);
rhs =T549/T631;
residual(99)= lhs-rhs;
lhs =T549;
rhs =T91*T1485/T1459+T549*T1489*T1493;
residual(100)= lhs-rhs;
lhs =T631;
rhs =T91*(1+params(40)*exp(y(45)))/params(26)+T631*T637*T1489;
residual(101)= lhs-rhs;
lhs =(1-params(28))*T801^T1505+params(28)*T556^T1505;
rhs =1;
residual(102)= lhs-rhs;
lhs =exp(y(31));
rhs =(1-params(28))*T801^T1492+exp(y(37))*params(28)*T1493;
residual(103)= lhs-rhs;
lhs =T91;
rhs =exp(y(22))+exp(y(25))+exp(y(9))*params(33);
residual(104)= lhs-rhs;
lhs =exp(y(25));
rhs =exp(y(43))*T91*params(15);
residual(105)= lhs-rhs;
lhs =y(33);
rhs =y(27)*T527/exp(y(39));
residual(106)= lhs-rhs;
lhs =params(48)*params(47)/T1458;
rhs =params(51)*params(50)*params(49)/exp(y(19))/T1385;
residual(107)= lhs-rhs;
lhs =y(40);
rhs =y(40)*params(8)+params(9)*x(1);
residual(108)= lhs-rhs;
lhs =y(41);
rhs =y(41)*params(10)+params(11)*x(2);
residual(109)= lhs-rhs;
lhs =y(42);
rhs =y(42)*params(22)+params(23)*x(6);
residual(110)= lhs-rhs;
lhs =y(43);
rhs =y(43)*params(16)+params(17)*x(3);
residual(111)= lhs-rhs;
lhs =y(44);
rhs =y(44)*params(18)+params(19)*x(4);
residual(112)= lhs-rhs;
lhs =y(45);
rhs =y(45)*params(20)+params(21)*x(5);
residual(113)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(113, 113);

  %
  % Jacobian matrix
  %

  g1(1,5)=(-params(1));
  g1(1,6)=(-params(2));
  g1(1,112)=1;
  g1(2,112)=(-1);
  g1(2,113)=1-params(3);
  g1(3,1)=1-params(3);
  g1(3,5)=(-1);
  g1(4,2)=1-params(3);
  g1(4,6)=(-1);
  g1(5,3)=1;
  g1(5,20)=(-1);
  g1(6,4)=1;
  g1(6,33)=(-1);
  g1(7,17)=(-1);
  g1(7,34)=1;
  g1(8,18)=(-1);
  g1(8,35)=1;
  g1(9,12)=(-1);
  g1(9,36)=1;
  g1(10,31)=(-1);
  g1(10,37)=1;
  g1(11,32)=(-1);
  g1(11,38)=1;
  g1(12,26)=(-1);
  g1(12,39)=1;
  g1(13,5)=1;
  g1(13,7)=(-(T55*getPowerDeriv(T55,1-params(4),1)/(1-params(4))));
  g1(13,10)=exp(y(17))*params(30)*exp(y(41))^(-params(25))*T68*getPowerDeriv(T68,1+params(25),1)/(1+params(25));
  g1(13,17)=T74;
  g1(13,41)=exp(y(17))*T70*params(30)*exp(y(41))*getPowerDeriv(exp(y(41)),(-params(25)),1)/(1+params(25));
  g1(14,6)=1;
  g1(14,21)=(-(T78*getPowerDeriv(T78,1-params(12),1)/(1-params(12))));
  g1(14,24)=exp(y(31))*params(36)*exp(y(44))^(-params(24))*T91*getPowerDeriv(T91,1+params(24),1)/(1+params(24));
  g1(14,31)=T97;
  g1(14,44)=exp(y(31))*T93*params(36)*exp(y(44))*getPowerDeriv(exp(y(44)),(-params(24)),1)/(1+params(24));
  g1(15,7)=T55*y(57)+(T55*T100-T55*T1586)/(T100*T100)-y(59)*T1608-T1615-(T112*T55*params(4)*params(50)*y(78)*params(49)*params(51)*exp((-y(19)))+T55*params(4)*params(50)*y(78)*params(49)*params(51)*exp((-y(19)))*T1594)+T1624-(T100*y(13)*(T112*T108*T55*T128*params(4)*params(5)*y(54)+T108*T55*T128*params(4)*params(5)*y(54)*T1594)-T112*T108*T55*T128*params(4)*params(5)*y(54)*y(13)*T1586)/(T100*y(13)*T100*y(13))+(T211*(T100*T108*T55*T128*params(4)*params(5)*y(54)+T108*T55*T128*params(4)*params(5)*y(54)*T1586)-T100*T108*T55*T128*params(4)*params(5)*y(54)*params(3)*y(13)*T55*getPowerDeriv(T55,1+params(4),1))/(T211*T211)-(T100*T227*(T112*T223+T223*T1594)-T112*T223*T227*T1586)/(T100*T100)+(T233*T227*(T100*T223+T223*T1586)-T227*T100*T223*T1657)/(T233*T233)+(T141*T233*(T100*T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)+T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)*T1586)-T100*T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)*T141*T1657)/(T141*T233*T141*T233);
  g1(15,8)=T1916;
  g1(15,9)=(-T1971);
  g1(15,10)=(-(y(59)*T2024));
  g1(15,12)=T195+(-(y(59)*T2085))-T112*(T108*T55*T128*params(4)*params(5)*y(54)+T108*T55*params(4)*params(5)*y(54)*(-T128))/(T100*y(13))+T100*(T108*T55*T128*params(4)*params(5)*y(54)+T108*T55*params(4)*params(5)*y(54)*(-T128))/T211-T227*T112*(T223+T108*T221*T55*params(29)*params(4)*params(5)*y(60)*(-T128))/T100+T227*T100*(T223+T108*T221*T55*params(29)*params(4)*params(5)*y(60)*(-T128))/T233+T100*(T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)+T108*T132*T55*params(29)*params(4)*y(59)*params(5)*(-T128))/(T141*T233);
  g1(15,13)=(-(y(59)*T2310))-(-(T100*T112*T108*T55*T128*params(4)*params(5)*y(54)))/(T100*y(13)*T100*y(13))+(-(T100*T108*T55*T128*params(4)*params(5)*y(54)*T233))/(T211*T211)-T112*T223*T2322/T100+T100*T223*T2322/T233+(-(T100*T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)*T233*T2306))/(T141*T233*T141*T233);
  g1(15,14)=T245+(-(y(59)*T143));
  g1(15,15)=T227*T100*T223/T233+(-(T112*T223*T227/T100));
  g1(15,19)=(-(T112*T55*params(4)*params(50)*y(78)*params(49)*params(51)*(-exp((-y(19))))));
  g1(15,41)=(-(y(59)*(1+params(27))*T68*T55*params(4)*params(30)*T108*T112*T3704/params(27)));
  g1(15,54)=T3849;
  g1(15,55)=T3864;
  g1(15,56)=(-T3870);
  g1(15,57)=T55;
  g1(15,59)=T3889;
  g1(15,60)=T3913;
  g1(15,78)=(-(T112*T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)));
  g1(16,7)=(-T1624);
  g1(16,8)=(-y(63))*exp(y(8))-(T266*(exp(y(8))*y(57)*T252*T257+exp(y(8))*y(57)*T252*exp(y(8))*getPowerDeriv(exp(y(8)),T255-1,1))+exp(y(8))*y(57)*T252*T257*T1925)-T1916;
  g1(16,9)=(-(exp(y(8))*y(57)*T252*T257*T1976));
  g1(16,12)=(-T195);
  g1(16,55)=(-T3864);
  g1(16,57)=(-(T266*T257*exp(y(8))*T252));
  g1(16,63)=(-exp(y(8)));
  g1(17,46)=(-1);
  g1(17,65)=1;
  g1(18,10)=(-(params(30)*exp(y(17))*T68*getPowerDeriv(T68,1+params(25),1)/T283));
  g1(18,17)=exp(y(17))*y(62)-T284;
  g1(18,41)=(-((-(T70*params(30)*exp(y(17))*(1+params(25))*exp(y(41))*getPowerDeriv(exp(y(41)),params(25),1)))/(T283*T283)));
  g1(18,48)=(-params(3));
  g1(18,62)=exp(y(17));
  g1(19,13)=(-((-(params(29)*y(62)*exp(y(34))*T2306))/(T141*T141)));
  g1(19,34)=(-(params(29)*y(62)*exp(y(34))/T141));
  g1(19,48)=1;
  g1(19,62)=(-(params(29)*exp(y(34))/T141));
  g1(20,11)=y(64)*exp(y(11))-y(63)*exp(y(11));
  g1(20,63)=(-exp(y(11)));
  g1(20,64)=exp(y(11));
  g1(21,7)=(-T1681);
  g1(21,12)=(-T2127);
  g1(21,13)=(-T2340);
  g1(21,14)=T132*y(58)*exp((-y(15)));
  g1(21,15)=y(60)*T221+T132*y(58)*(-exp((-y(15))))-T314;
  g1(21,58)=T132*exp((-y(15)));
  g1(21,60)=T3919;
  g1(22,7)=(-T1689);
  g1(22,12)=(-T2134);
  g1(22,13)=(-T2345);
  g1(22,14)=y(59)*T132-T132*y(58)*exp((-y(15)))-T325;
  g1(22,15)=(-(T132*y(58)*(-exp((-y(15))))));
  g1(22,58)=(-(T132*exp((-y(15)))));
  g1(22,59)=T132-T100*T108*T132*T128*params(5)*params(29)/(T141*params(3)*T100);
  g1(23,7)=T1615;
  g1(23,8)=(-(exp(y(9))*y(57)*T261*T330*T1925));
  g1(23,9)=T1971-(exp(y(9))*y(57)*T261*T330*T1976+T266*(exp(y(9))*y(57)*T261*T330+exp(y(9))*y(57)*T261*exp(y(9))*getPowerDeriv(exp(y(9)),T255-1,1)))-exp(y(9))*y(75)*params(33);
  g1(23,56)=T3870;
  g1(23,57)=(-(T266*T330*T261*exp(y(9))));
  g1(23,75)=(-(exp(y(9))*params(33)));
  g1(24,7)=(T359*T108*T128*params(5)*y(54)*T1586-T100*T108*T128*params(5)*y(54)*T1692)/(T359*T359)-(T382*(T225-1)*T108*T221*T128*params(29)*y(60)*params(5)*params(34)*T1586-T100*T108*T221*T128*params(29)*y(60)*params(5)*params(34)*(T225-1)*T138^T225*T1692)/(T382*T382)-(T368*T100*params(3)*T344*(1+params(27))*(1+params(25))*T108*T132*T128*params(29)*y(59)*params(5)*params(34)*T1586-(1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*y(59)*params(5)*params(34)*T368*params(3)*T344*T1586)/(T368*T100*params(3)*T344*T368*T100*params(3)*T344);
  g1(24,12)=(-(T108*y(65)*exp((-y(36)))))+T100*(T108*T128*params(5)*y(54)+T108*params(5)*y(54)*(-T128))/T359-(T225-1)*T100*(T108*T221*T128*params(29)*y(60)*params(5)*params(34)+T108*T221*params(29)*y(60)*params(5)*params(34)*(-T128))/T382-(1+params(27))*(1+params(25))*T100*(T108*T132*T128*params(29)*y(59)*params(5)*params(34)+T108*T132*params(29)*y(59)*params(5)*params(34)*(-T128))/(T368*T100*params(3)*T344);
  g1(24,13)=(-(params(29)*params(34)*y(61)*(T347*params(27)*2*y(13)+T344*T2304*getPowerDeriv(T138,T346,1))))/(T348*T348)+(-(T100*T108*T128*params(5)*y(54)*T100*params(3)*2*y(13)))/(T359*T359)-(-((1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)*y(62)*(T368*params(27)*2*y(13)+T344*T2304*getPowerDeriv(T138,1+T140,1))))/(T344*T368*T344*T368)-(-(T100*T108*T221*T128*params(29)*y(60)*params(5)*params(34)*(T225-1)*T2378))/(T382*T382)-(-((1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*y(59)*params(5)*params(34)*T2387))/(T368*T100*params(3)*T344*T368*T100*params(3)*T344);
  g1(24,14)=(-T396);
  g1(24,15)=(-T383);
  g1(24,34)=(-T370);
  g1(24,36)=(-(T108*y(65)*(-exp((-y(36))))));
  g1(24,54)=T100*T108*params(5)*T128/T359;
  g1(24,59)=T3900;
  g1(24,60)=T3925;
  g1(24,61)=params(29)*params(34)/T348;
  g1(24,62)=T3943;
  g1(24,65)=(-(T108*exp((-y(36)))));
  g1(25,16)=T406*(y(58)*T400*T404+y(58)*T400*T2537)+(y(61)*T400*(params(29)-1)*T412-y(61)*T400*(params(29)-1)*params(27)*T400*getPowerDeriv(T400,T346,1))/(T412*T412)-((params(29)-1)*(1+params(27))*(1+params(25))*y(62)*T400*T420-(params(29)-1)*(1+params(27))*(1+params(25))*y(62)*T400*params(27)*T400*getPowerDeriv(T400,1+T140,1))/(T420*T420);
  g1(25,58)=T406*T400*T404;
  g1(25,61)=T400*(params(29)-1)/T412;
  g1(25,62)=(-((params(29)-1)*(1+params(27))*(1+params(25))*T400/T420));
  g1(26,7)=params(50)*y(78)*params(49)*params(51)*exp((-y(19)))*T1586;
  g1(26,12)=(-(exp((-y(19)))*y(68)*(-T128)));
  g1(26,19)=y(56)*T425*exp(y(19))-T128*y(68)*(-exp((-y(19))))+T100*params(50)*y(78)*params(49)*params(51)*(-exp((-y(19))));
  g1(26,26)=exp(y(19))*y(56)*(-T425);
  g1(26,56)=T425*exp(y(19));
  g1(26,68)=(-(T128*exp((-y(19)))));
  g1(26,78)=T100*exp((-y(19)))*params(51)*params(50)*params(49);
  g1(27,18)=(-((-(y(54)*2*(1+y(18))))/(T441*T441)));
  g1(27,49)=(-params(3));
  g1(27,54)=(-(1/T441));
  g1(28,49)=1;
  g1(29,7)=T1681+T1689+T108*y(55)*T1720-y(59)*T1731-(T100*y(13)*T108*T128*params(5)*y(54)*T1586-T100*T108*T128*params(5)*y(54)*y(13)*T1586)/(T100*y(13)*T100*y(13))+(T100*params(3)*y(13)*T108*T128*params(5)*y(54)*T1586-T100*T108*T128*params(5)*y(54)*params(3)*y(13)*T1586)/(T100*params(3)*y(13)*T100*params(3)*y(13))-(T100*T227*T108*T221*T128*params(29)*params(5)*y(60)*T1586-T227*T100*T108*T221*T128*params(29)*params(5)*y(60)*T1586)/(T100*T100);
  g1(29,8)=T108*y(55)*T1933;
  g1(29,10)=(-(y(59)*T2033));
  g1(29,12)=T2127+T2134+T108*y(55)*T447-y(59)*T2168-exp((-y(19)))*y(68)*(-T128)-T108*exp((-y(36)))*y(13)*y(65)-T100*(T108*T128*params(5)*y(54)+T108*params(5)*y(54)*(-T128))/(T100*y(13))+T100*(T108*T128*params(5)*y(54)+T108*params(5)*y(54)*(-T128))/(T100*params(3)*y(13))-T227*T100*(T108*T221*T128*params(29)*params(5)*y(60)+T108*T221*params(29)*params(5)*y(60)*(-T128))/T100;
  g1(29,13)=T2340+T2345+(-(y(59)*T2394))-T108*y(65)*exp((-y(36)))-(-(T100*T100*T108*T128*params(5)*y(54)))/(T100*y(13)*T100*y(13))+(-(params(3)*T100*T100*T108*T128*params(5)*y(54)))/(T100*params(3)*y(13)*T100*params(3)*y(13))-T100*T108*T221*T128*params(29)*params(5)*y(60)*T2322/T100;
  g1(29,14)=T325-y(59)*T460;
  g1(29,15)=T314-T227*T100*T108*T221*T128*params(29)*params(5)*y(60)/T100;
  g1(29,19)=(-(T128*y(68)*(-exp((-y(19))))));
  g1(29,36)=(-(T108*y(13)*y(65)*(-exp((-y(36))))));
  g1(29,41)=(-(y(59)*T3720));
  g1(29,50)=(-params(3));
  g1(29,54)=T3859;
  g1(29,55)=T108*T447;
  g1(29,59)=T100*T108*T132*T128*params(5)*params(29)/(T141*params(3)*T100)-T461;
  g1(29,60)=T3928;
  g1(29,65)=(-(T108*y(13)*exp((-y(36)))));
  g1(29,68)=(-(T128*exp((-y(19)))));
  g1(30,12)=T108*exp((-y(36)))*y(13)*y(65);
  g1(30,13)=T108*y(65)*exp((-y(36)));
  g1(30,36)=T108*y(13)*y(65)*(-exp((-y(36))));
  g1(30,50)=1;
  g1(30,65)=T108*y(13)*exp((-y(36)));
  g1(31,7)=(-(y(59)*T1757));
  g1(31,10)=T68*y(63)-y(59)*T2048-T68*y(60)*(1+params(35)*exp(y(42)))/params(27)-T68*y(64)*params(7)*exp(y(40))-(T518+T68*params(30)*exp(y(17))*T68*getPowerDeriv(T68,params(25),1))/T282;
  g1(31,12)=(-(y(59)*T497));
  g1(31,17)=(-(T518/T282));
  g1(31,40)=(-(T68*y(64)*params(7)*exp(y(40))));
  g1(31,41)=(-(y(59)*T3732))-(-(T518*exp(y(41))*getPowerDeriv(exp(y(41)),params(25),1)))/(T282*T282);
  g1(31,42)=(-(T68*y(60)*params(35)*exp(y(42))/params(27)));
  g1(31,59)=(-T497);
  g1(31,60)=(-(T68*(1+params(35)*exp(y(42)))/params(27)));
  g1(31,63)=T68;
  g1(31,64)=(-(T68*params(7)*exp(y(40))));
  g1(32,21)=T78*y(69)-y(71)*T2653+T531*T78*params(12)*y(78)*params(47)*params(48)+T78*params(12)*y(78)*params(47)*params(48)*T2637-T2663+T2669-(T553*y(27)*(T531*T527*T78*T425*params(12)*params(13)*y(66)+T527*T78*T425*params(12)*params(13)*y(66)*T2637)-T531*T527*T78*T425*params(12)*params(13)*y(66)*y(27)*T2646)/(T553*y(27)*T553*y(27))+(T621*(T553*T527*T78*T425*params(12)*params(13)*y(66)+T527*T78*T425*params(12)*params(13)*y(66)*T2646)-T553*T527*T78*T425*params(12)*params(13)*y(66)*params(3)*y(27)*T78*getPowerDeriv(T78,1+params(12),1))/(T621*T621)-(T553*T637*(T531*T633+T633*T2637)-T531*T633*T637*T2646)/(T553*T553)+(T643*T637*(T553*T633+T633*T2646)-T637*T553*T633*T2703)/(T643*T643)+(T559*T643*(T553*T527*T549*T78*T425*params(28)*params(12)*y(71)*params(13)+T527*T549*T78*T425*params(28)*params(12)*y(71)*params(13)*T2646)-T553*T527*T549*T78*T425*params(28)*params(12)*y(71)*params(13)*T559*T2703)/(T559*T643*T559*T643);
  g1(32,22)=T2964;
  g1(32,23)=(-T3019);
  g1(32,24)=(-(y(71)*T3072));
  g1(32,26)=T605+(-(y(71)*T3135))-T531*(T527*T78*T425*params(12)*params(13)*y(66)+T527*T78*params(12)*params(13)*y(66)*(-T425))/(T553*y(27))+T553*(T527*T78*T425*params(12)*params(13)*y(66)+T527*T78*params(12)*params(13)*y(66)*(-T425))/T621-T637*T531*(T633+T527*T631*T78*params(28)*params(12)*params(13)*y(72)*(-T425))/T553+T637*T553*(T633+T527*T631*T78*params(28)*params(12)*params(13)*y(72)*(-T425))/T643+T553*(T527*T549*T78*T425*params(28)*params(12)*y(71)*params(13)+T527*T549*T78*params(28)*params(12)*y(71)*params(13)*(-T425))/(T559*T643);
  g1(32,27)=(-(y(71)*T3358))-(-(T553*T531*T527*T78*T425*params(12)*params(13)*y(66)))/(T553*y(27)*T553*y(27))+(-(T553*T527*T78*T425*params(12)*params(13)*y(66)*T643))/(T621*T621)-T531*T633*T3370/T553+T553*T633*T3370/T643+(-(T553*T527*T549*T78*T425*params(28)*params(12)*y(71)*params(13)*T643*T3354))/(T559*T643*T559*T643);
  g1(32,28)=T655+(-(y(71)*T561));
  g1(32,29)=T637*T553*T633/T643+(-(T531*T633*T637/T553));
  g1(32,44)=(-(y(71)*(1+params(26))*T91*T78*params(12)*params(36)*T527*T531*T3778/params(26)));
  g1(32,66)=T3967;
  g1(32,67)=T3982;
  g1(32,68)=(-T3990);
  g1(32,69)=T78;
  g1(32,71)=T4007;
  g1(32,72)=T4031;
  g1(32,78)=T531*T78*params(12)*params(47)*params(48);
  g1(33,21)=(-T2669);
  g1(33,22)=(-y(75))*exp(y(22))-(T675*(exp(y(22))*y(69)*T661*T666+exp(y(22))*y(69)*T661*exp(y(22))*getPowerDeriv(exp(y(22)),T664-1,1))+exp(y(22))*y(69)*T661*T666*T2973)-T2964;
  g1(33,23)=(-(exp(y(22))*y(69)*T661*T666*T3024));
  g1(33,26)=(-T605);
  g1(33,67)=(-T3982);
  g1(33,69)=(-(T675*T666*exp(y(22))*T661));
  g1(33,75)=(-exp(y(22)));
  g1(34,47)=(-1);
  g1(34,77)=1;
  g1(35,31)=exp(y(31))*y(74);
  g1(35,51)=(-params(3));
  g1(35,74)=exp(y(31));
  g1(36,27)=(-((-(params(28)*y(74)*exp(y(37))*T3354))/(T559*T559)));
  g1(36,37)=(-(params(28)*y(74)*exp(y(37))/T559));
  g1(36,51)=1;
  g1(36,74)=(-(params(28)*exp(y(37))/T559));
  g1(37,25)=y(76)*exp(y(25))-y(75)*exp(y(25));
  g1(37,75)=(-exp(y(25)));
  g1(37,76)=exp(y(25));
  g1(38,21)=(-T2727);
  g1(38,26)=(-T3177);
  g1(38,27)=(-T3388);
  g1(38,28)=T549*y(70)*exp((-y(29)));
  g1(38,29)=y(72)*T631+T549*y(70)*(-exp((-y(29))))-T717;
  g1(38,70)=T549*exp((-y(29)));
  g1(38,72)=T4037;
  g1(39,21)=(-T2735);
  g1(39,26)=(-T3184);
  g1(39,27)=(-T3393);
  g1(39,28)=y(71)*T549-T549*y(70)*exp((-y(29)))-T728;
  g1(39,29)=(-(T549*y(70)*(-exp((-y(29))))));
  g1(39,70)=(-(T549*exp((-y(29)))));
  g1(39,71)=T549-T553*T527*T549*T425*params(13)*params(28)/(T559*params(3)*T553);
  g1(40,21)=T2663;
  g1(40,22)=(-(exp(y(23))*y(69)*T670*T733*T2973));
  g1(40,23)=T3019-(exp(y(23))*y(69)*T670*T733*T3024+T675*(exp(y(23))*y(69)*T670*T733+exp(y(23))*y(69)*T670*exp(y(23))*getPowerDeriv(exp(y(23)),T664-1,1)))-y(63)*exp(y(23))/params(33);
  g1(40,63)=(-(exp(y(23))/params(33)));
  g1(40,68)=T3990;
  g1(40,69)=(-(T675*T733*T670*exp(y(23))));
  g1(41,21)=(T760*T527*T425*params(13)*y(66)*T2646-T553*T527*T425*params(13)*y(66)*T2738)/(T760*T760)-(T783*(T635-1)*T527*T631*T425*params(28)*y(72)*params(13)*params(39)*T2646-T553*T527*T631*T425*params(28)*y(72)*params(13)*params(39)*(T635-1)*T556^T635*T2738)/(T783*T783)-(T769*T553*params(3)*T745*(1+params(26))*(1+params(24))*T527*T549*T425*params(28)*y(71)*params(13)*params(39)*T2646-(1+params(26))*(1+params(24))*T553*T527*T549*T425*params(28)*y(71)*params(13)*params(39)*T769*params(3)*T745*T2646)/(T769*T553*params(3)*T745*T769*T553*params(3)*T745);
  g1(41,26)=(-(T527*y(77)*exp((-y(39)))))+T553*(T527*T425*params(13)*y(66)+T527*params(13)*y(66)*(-T425))/T760-(T635-1)*T553*(T527*T631*T425*params(28)*y(72)*params(13)*params(39)+T527*T631*params(28)*y(72)*params(13)*params(39)*(-T425))/T783-(1+params(26))*(1+params(24))*T553*(T527*T549*T425*params(28)*y(71)*params(13)*params(39)+T527*T549*params(28)*y(71)*params(13)*params(39)*(-T425))/(T769*T553*params(3)*T745);
  g1(41,27)=(-(params(28)*params(39)*y(73)*(T748*params(26)*2*y(27)+T745*T3352*getPowerDeriv(T556,T747,1))))/(T749*T749)+(-(T553*T527*T425*params(13)*y(66)*T553*params(3)*2*y(27)))/(T760*T760)-(-((1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)*y(74)*(T769*params(26)*2*y(27)+T745*T3352*getPowerDeriv(T556,1+T558,1))))/(T745*T769*T745*T769)-(-(T553*T527*T631*T425*params(28)*y(72)*params(13)*params(39)*(T635-1)*T3426))/(T783*T783)-(-((1+params(26))*(1+params(24))*T553*T527*T549*T425*params(28)*y(71)*params(13)*params(39)*T3435))/(T769*T553*params(3)*T745*T769*T553*params(3)*T745);
  g1(41,28)=(-T797);
  g1(41,29)=(-T784);
  g1(41,37)=(-T771);
  g1(41,39)=(-(T527*y(77)*(-exp((-y(39))))));
  g1(41,66)=T553*T527*T425*params(13)/T760;
  g1(41,71)=T4018;
  g1(41,72)=T4043;
  g1(41,73)=params(28)*params(39)/T749;
  g1(41,74)=T4061;
  g1(41,77)=(-(T527*exp((-y(39)))));
  g1(42,30)=T807*(y(70)*T801*T805+y(70)*T801*T3585)+(y(73)*T801*(params(28)-1)*T813-y(73)*T801*(params(28)-1)*params(26)*T801*getPowerDeriv(T801,T747,1))/(T813*T813)-((params(28)-1)*(1+params(26))*(1+params(24))*y(74)*T801*T821-(params(28)-1)*(1+params(26))*(1+params(24))*y(74)*T801*params(26)*T801*getPowerDeriv(T801,1+T558,1))/(T821*T821);
  g1(42,70)=T807*T801*T805;
  g1(42,73)=T801*(params(28)-1)/T813;
  g1(42,74)=(-((params(28)-1)*(1+params(26))*(1+params(24))*T801/T821));
  g1(43,32)=(-((-(y(66)*2*(1+y(32))))/(T829*T829)));
  g1(43,52)=(-params(3));
  g1(43,66)=(-(1/T829));
  g1(44,52)=1;
  g1(45,19)=(-(y(56)*T425*exp(y(19))));
  g1(45,21)=T2727+T2735+T527*y(67)*T2765-y(71)*T2776-(T553*y(27)*T527*T425*params(13)*y(66)*T2646-T553*T527*T425*params(13)*y(66)*y(27)*T2646)/(T553*y(27)*T553*y(27))+(T553*params(3)*y(27)*T527*T425*params(13)*y(66)*T2646-T553*T527*T425*params(13)*y(66)*params(3)*y(27)*T2646)/(T553*params(3)*y(27)*T553*params(3)*y(27))-(T553*T637*T527*T631*T425*params(28)*params(13)*y(72)*T2646-T637*T553*T527*T631*T425*params(28)*params(13)*y(72)*T2646)/(T553*T553);
  g1(45,22)=T527*y(67)*T2981;
  g1(45,24)=(-(y(71)*T3078));
  g1(45,26)=T3177+T3184+T527*y(67)*T835-y(71)*T3216-exp(y(19))*y(56)*(-T425)-T527*exp((-y(39)))*y(27)*y(77)-T553*(T527*T425*params(13)*y(66)+T527*params(13)*y(66)*(-T425))/(T553*y(27))+T553*(T527*T425*params(13)*y(66)+T527*params(13)*y(66)*(-T425))/(T553*params(3)*y(27))-T637*T553*(T527*T631*T425*params(28)*params(13)*y(72)+T527*T631*params(28)*params(13)*y(72)*(-T425))/T553;
  g1(45,27)=T3388+T3393+(-(y(71)*T3442))-T527*y(77)*exp((-y(39)))-(-(T553*T553*T527*T425*params(13)*y(66)))/(T553*y(27)*T553*y(27))+(-(params(3)*T553*T553*T527*T425*params(13)*y(66)))/(T553*params(3)*y(27)*T553*params(3)*y(27))-T553*T527*T631*T425*params(28)*params(13)*y(72)*T3370/T553;
  g1(45,28)=T728-y(71)*T848;
  g1(45,29)=T717-T637*T553*T527*T631*T425*params(28)*params(13)*y(72)/T553;
  g1(45,39)=(-(T527*y(27)*y(77)*(-exp((-y(39))))));
  g1(45,44)=(-(y(71)*T3786));
  g1(45,53)=(-params(3));
  g1(45,56)=(-(T425*exp(y(19))));
  g1(45,66)=T3977;
  g1(45,67)=T527*T835;
  g1(45,71)=T553*T527*T549*T425*params(13)*params(28)/(T559*params(3)*T553)-T849;
  g1(45,72)=T4046;
  g1(45,77)=(-(T527*y(27)*exp((-y(39)))));
  g1(46,26)=T527*exp((-y(39)))*y(27)*y(77);
  g1(46,27)=T527*y(77)*exp((-y(39)));
  g1(46,39)=T527*y(27)*y(77)*(-exp((-y(39))));
  g1(46,53)=1;
  g1(46,77)=T527*y(27)*exp((-y(39)));
  g1(47,21)=(-(y(71)*T2802));
  g1(47,24)=T91*y(75)-y(71)*T3093-T91*y(72)*(1+params(40)*exp(y(45)))/params(26)-T91*y(76)*params(15)*exp(y(43));
  g1(47,26)=(-(y(71)*T885));
  g1(47,43)=(-(T91*y(76)*params(15)*exp(y(43))));
  g1(47,44)=(-(y(71)*T3798));
  g1(47,45)=(-(T91*y(72)*params(40)*exp(y(45))/params(26)));
  g1(47,71)=(-T885);
  g1(47,72)=(-(T91*(1+params(40)*exp(y(45)))/params(26)));
  g1(47,75)=T91;
  g1(47,76)=(-(T91*params(15)*exp(y(43))));
  g1(48,46)=1;
  g1(49,7)=T55*y(90)-y(92)*T1608-T1764-(T112*T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)*y(111)+T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)*y(111)*T1594)+T1771-(T100*y(13)*(T112*T108*T55*T128*params(4)*params(5)*y(87)+T108*T55*T128*params(4)*params(5)*y(87)*T1594)-T112*T108*T55*T128*params(4)*params(5)*y(87)*y(13)*T1586)/(T100*y(13)*T100*y(13))+(T211*(T100*T108*T55*T128*params(4)*params(5)*y(87)+T108*T55*T128*params(4)*params(5)*y(87)*T1586)-T100*T108*T55*T128*params(4)*params(5)*y(87)*params(3)*y(13)*T55*getPowerDeriv(T55,1+params(4),1))/(T211*T211)-(T100*T227*(T112*T955+T955*T1594)-T227*T112*T955*T1586)/(T100*T100)+(T233*T227*(T100*T955+T955*T1586)-T227*T100*T955*T1657)/(T233*T233)+(T141*T233*(T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)+T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)*T1586)-T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)*T141*T1657)/(T141*T233*T141*T233);
  g1(49,8)=T1941;
  g1(49,9)=(-T1993);
  g1(49,10)=(-(y(92)*T2024));
  g1(49,12)=T935+(-(y(92)*T2085))-T112*(T108*T55*T128*params(4)*params(5)*y(87)+T108*T55*params(4)*params(5)*y(87)*(-T128))/(T100*y(13))+T100*(T108*T55*T128*params(4)*params(5)*y(87)+T108*T55*params(4)*params(5)*y(87)*(-T128))/T211-T227*T112*(T955+T108*T221*T55*params(29)*params(4)*params(5)*y(93)*(-T128))/T100+T227*T100*(T955+T108*T221*T55*params(29)*params(4)*params(5)*y(93)*(-T128))/T233+T100*(T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)+T108*T132*T55*params(29)*params(4)*params(5)*y(92)*(-T128))/(T141*T233);
  g1(49,13)=(-(y(92)*T2310))-(-(T100*T112*T108*T55*T128*params(4)*params(5)*y(87)))/(T100*y(13)*T100*y(13))+(-(T233*T100*T108*T55*T128*params(4)*params(5)*y(87)))/(T211*T211)-T112*T955*T2322/T100+T100*T955*T2322/T233+(-(T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)*T233*T2306))/(T141*T233*T141*T233);
  g1(49,14)=T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)/(T141*T233)+(-(T143*y(92)));
  g1(49,15)=T227*T100*T955/T233+(-(T227*T112*T955/T100));
  g1(49,19)=(-(T112*T55*params(4)*params(51)*params(50)*params(49)*y(111)*(-exp((-y(19))))));
  g1(49,41)=(-(y(92)*(1+params(27))*T68*T55*params(4)*params(30)*T108*T112*T3704/params(27)));
  g1(49,87)=T3849;
  g1(49,88)=T3864;
  g1(49,89)=(-T3870);
  g1(49,90)=T55;
  g1(49,92)=T3889;
  g1(49,93)=T3913;
  g1(49,111)=(-(T112*T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)));
  g1(50,7)=(-T1771);
  g1(50,8)=exp(y(8))*(-y(96))-(T257*exp(y(8))*T252*y(90)*T1925+T266*(T257*exp(y(8))*T252*y(90)+exp(y(8))*T252*y(90)*exp(y(8))*getPowerDeriv(exp(y(8)),T255-1,1)))-T1941;
  g1(50,9)=(-(T257*exp(y(8))*T252*y(90)*T1976));
  g1(50,12)=(-T935);
  g1(50,88)=(-T3864);
  g1(50,90)=(-(T266*T257*exp(y(8))*T252));
  g1(50,96)=(-exp(y(8)));
  g1(51,79)=(-1);
  g1(51,98)=1;
  g1(52,17)=exp(y(17))*y(95);
  g1(52,81)=(-params(3));
  g1(52,95)=exp(y(17));
  g1(53,13)=(-((-(exp(y(34))*params(29)*y(95)*T2306))/(T141*T141)));
  g1(53,34)=(-(exp(y(34))*params(29)*y(95)/T141));
  g1(53,81)=1;
  g1(53,95)=(-(params(29)*exp(y(34))/T141));
  g1(54,11)=exp(y(11))*y(97)-exp(y(11))*y(96);
  g1(54,96)=(-exp(y(11)));
  g1(54,97)=exp(y(11));
  g1(55,7)=(-T1816);
  g1(55,12)=(-T2223);
  g1(55,13)=(-T2435);
  g1(55,14)=T132*exp((-y(15)))*y(91);
  g1(55,15)=T221*y(93)+T132*y(91)*(-exp((-y(15))))-T1016;
  g1(55,91)=T132*exp((-y(15)));
  g1(55,93)=T3919;
  g1(56,7)=(-T1822);
  g1(56,12)=(-T2230);
  g1(56,13)=(-T2439);
  g1(56,14)=T132*y(92)-T132*exp((-y(15)))*y(91)-T1027;
  g1(56,15)=(-(T132*y(91)*(-exp((-y(15))))));
  g1(56,91)=(-(T132*exp((-y(15)))));
  g1(56,92)=T132-T100*T108*T132*T128*params(5)*params(29)/(T141*params(3)*T100);
  g1(57,7)=T1764;
  g1(57,8)=(-(T330*exp(y(9))*T261*y(90)*T1925));
  g1(57,9)=T1993-(T330*exp(y(9))*T261*y(90)*T1976+T266*(T330*exp(y(9))*T261*y(90)+exp(y(9))*T261*y(90)*exp(y(9))*getPowerDeriv(exp(y(9)),T255-1,1)))-exp(y(9))*params(33)*y(108);
  g1(57,89)=T3870;
  g1(57,90)=(-(T266*T330*T261*exp(y(9))));
  g1(57,108)=(-(exp(y(9))*params(33)));
  g1(58,7)=(T359*T108*T128*params(5)*y(87)*T1586-T100*T108*T128*params(5)*y(87)*T1692)/(T359*T359)-(T382*(T225-1)*T108*T221*T128*params(29)*params(5)*params(34)*y(93)*T1586-(T225-1)*T100*T108*T221*T128*params(29)*params(5)*params(34)*y(93)*T138^T225*T1692)/(T382*T382)-(T368*T100*params(3)*T344*(1+params(27))*(1+params(25))*T108*T132*T128*params(29)*params(5)*params(34)*y(92)*T1586-(1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*params(5)*params(34)*y(92)*T368*params(3)*T344*T1586)/(T368*T100*params(3)*T344*T368*T100*params(3)*T344);
  g1(58,12)=(-(T108*exp((-y(36)))*y(98)))+T100*(T108*T128*params(5)*y(87)+T108*params(5)*y(87)*(-T128))/T359-(T225-1)*T100*(T108*T221*T128*params(29)*params(5)*params(34)*y(93)+T108*T221*params(29)*params(5)*params(34)*y(93)*(-T128))/T382-(1+params(27))*(1+params(25))*T100*(T108*T132*T128*params(29)*params(5)*params(34)*y(92)+T108*T132*params(29)*params(5)*params(34)*y(92)*(-T128))/(T368*T100*params(3)*T344);
  g1(58,13)=(-(params(29)*params(34)*y(94)*(T347*params(27)*2*y(13)+T344*T2304*getPowerDeriv(T138,T346,1))))/(T348*T348)+(-(T100*T108*T128*params(5)*y(87)*T100*params(3)*2*y(13)))/(T359*T359)-(-((1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)*y(95)*(T368*params(27)*2*y(13)+T344*T2304*getPowerDeriv(T138,1+T140,1))))/(T344*T368*T344*T368)-(-((T225-1)*T100*T108*T221*T128*params(29)*params(5)*params(34)*y(93)*T2378))/(T382*T382)-(-((1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*params(5)*params(34)*y(92)*T2387))/(T368*T100*params(3)*T344*T368*T100*params(3)*T344);
  g1(58,14)=(-T1076);
  g1(58,15)=(-T1066);
  g1(58,34)=(-T1057);
  g1(58,36)=(-(T108*y(98)*(-exp((-y(36))))));
  g1(58,87)=T100*T108*params(5)*T128/T359;
  g1(58,92)=T3900;
  g1(58,93)=T3925;
  g1(58,94)=params(29)*params(34)/T348;
  g1(58,95)=T3943;
  g1(58,98)=(-(T108*exp((-y(36)))));
  g1(59,16)=T406*(T404*T400*y(91)+T400*y(91)*T2537)+(T412*(params(29)-1)*T400*y(94)-(params(29)-1)*T400*y(94)*params(27)*T400*getPowerDeriv(T400,T346,1))/(T412*T412)-(T420*(params(29)-1)*(1+params(27))*(1+params(25))*T400*y(95)-(params(29)-1)*(1+params(27))*(1+params(25))*T400*y(95)*params(27)*T400*getPowerDeriv(T400,1+T140,1))/(T420*T420);
  g1(59,91)=T406*T400*T404;
  g1(59,94)=T400*(params(29)-1)/T412;
  g1(59,95)=(-((params(29)-1)*(1+params(27))*(1+params(25))*T400/T420));
  g1(60,7)=exp((-y(19)))*params(51)*params(50)*params(49)*y(111)*T1586;
  g1(60,12)=(-(exp((-y(19)))*y(101)*(-T128)));
  g1(60,19)=exp(y(19))*T425*y(89)-T128*y(101)*(-exp((-y(19))))+T100*params(51)*params(50)*params(49)*y(111)*(-exp((-y(19))));
  g1(60,26)=exp(y(19))*y(89)*(-T425);
  g1(60,89)=T425*exp(y(19));
  g1(60,101)=(-(T128*exp((-y(19)))));
  g1(60,111)=T100*exp((-y(19)))*params(51)*params(50)*params(49);
  g1(61,18)=(-((-(y(87)*2*(1+y(18))))/(T441*T441)));
  g1(61,82)=(-params(3));
  g1(61,87)=(-(1/T441));
  g1(62,82)=1;
  g1(63,7)=T1816+T1822+T108*y(88)*T1720-y(92)*T1731-(T100*y(13)*T108*T128*params(5)*y(87)*T1586-T100*T108*T128*params(5)*y(87)*y(13)*T1586)/(T100*y(13)*T100*y(13))+(T100*params(3)*y(13)*T108*T128*params(5)*y(87)*T1586-T100*T108*T128*params(5)*y(87)*params(3)*y(13)*T1586)/(T100*params(3)*y(13)*T100*params(3)*y(13))-(T100*T227*T108*T221*T128*params(29)*params(5)*y(93)*T1586-T227*T100*T108*T221*T128*params(29)*params(5)*y(93)*T1586)/(T100*T100);
  g1(63,8)=T108*y(88)*T1933;
  g1(63,10)=(-(y(92)*T2033));
  g1(63,12)=T2223+T2230+T447*T108*y(88)-y(92)*T2168-exp((-y(19)))*y(101)*(-T128)-T108*exp((-y(36)))*y(13)*y(98)-T100*(T108*T128*params(5)*y(87)+T108*params(5)*y(87)*(-T128))/(T100*y(13))+T100*(T108*T128*params(5)*y(87)+T108*params(5)*y(87)*(-T128))/(T100*params(3)*y(13))-T227*T100*(T108*T221*T128*params(29)*params(5)*y(93)+T108*T221*params(29)*params(5)*y(93)*(-T128))/T100;
  g1(63,13)=T2435+T2439+(-(y(92)*T2394))-T108*exp((-y(36)))*y(98)-(-(T100*T100*T108*T128*params(5)*y(87)))/(T100*y(13)*T100*y(13))+(-(params(3)*T100*T100*T108*T128*params(5)*y(87)))/(T100*params(3)*y(13)*T100*params(3)*y(13))-T100*T108*T221*T128*params(29)*params(5)*y(93)*T2322/T100;
  g1(63,14)=T1027-T460*y(92);
  g1(63,15)=T1016-T227*T100*T108*T221*T128*params(29)*params(5)*y(93)/T100;
  g1(63,19)=(-(T128*y(101)*(-exp((-y(19))))));
  g1(63,36)=(-(T108*y(13)*y(98)*(-exp((-y(36))))));
  g1(63,41)=(-(y(92)*T3720));
  g1(63,83)=(-params(3));
  g1(63,87)=T3859;
  g1(63,88)=T108*T447;
  g1(63,92)=T100*T108*T132*T128*params(5)*params(29)/(T141*params(3)*T100)-T461;
  g1(63,93)=T3928;
  g1(63,98)=(-(T108*y(13)*exp((-y(36)))));
  g1(63,101)=(-(T128*exp((-y(19)))));
  g1(64,12)=T108*exp((-y(36)))*y(13)*y(98);
  g1(64,13)=T108*exp((-y(36)))*y(98);
  g1(64,36)=T108*y(13)*y(98)*(-exp((-y(36))));
  g1(64,83)=1;
  g1(64,98)=T108*y(13)*exp((-y(36)));
  g1(65,7)=(-(y(92)*T1757));
  g1(65,10)=T68*y(96)-y(92)*T2048-(1+params(35)*exp(y(42)))*T68*y(93)/params(27)-T68*exp(y(40))*params(7)*y(97);
  g1(65,12)=(-(T497*y(92)));
  g1(65,40)=(-(T68*exp(y(40))*params(7)*y(97)));
  g1(65,41)=(-(y(92)*T3732));
  g1(65,42)=(-(params(35)*exp(y(42))*T68*y(93)/params(27)));
  g1(65,92)=(-T497);
  g1(65,93)=(-(T68*(1+params(35)*exp(y(42)))/params(27)));
  g1(65,96)=T68;
  g1(65,97)=(-(T68*params(7)*exp(y(40))));
  g1(66,21)=T78*y(102)+(T78*T553-T78*T2646)/(T553*T553)-y(104)*T2653+T531*T78*y(111)*params(12)*params(47)*params(48)+T78*y(111)*params(12)*params(47)*params(48)*T2637-T2817+T2821-(T553*y(27)*(T531*T527*T78*T425*params(12)*params(13)*y(99)+T527*T78*T425*params(12)*params(13)*y(99)*T2637)-T531*T527*T78*T425*params(12)*params(13)*y(99)*y(27)*T2646)/(T553*y(27)*T553*y(27))+(T621*(T553*T527*T78*T425*params(12)*params(13)*y(99)+T527*T78*T425*params(12)*params(13)*y(99)*T2646)-T553*T527*T78*T425*params(12)*params(13)*y(99)*params(3)*y(27)*T78*getPowerDeriv(T78,1+params(12),1))/(T621*T621)-(T553*T637*(T531*T1192+T1192*T2637)-T637*T531*T1192*T2646)/(T553*T553)+(T643*T637*(T553*T1192+T1192*T2646)-T637*T553*T1192*T2703)/(T643*T643)+(T559*T643*(T553*T527*T549*T78*T425*params(28)*params(12)*params(13)*y(104)+T527*T549*T78*T425*params(28)*params(12)*params(13)*y(104)*T2646)-T553*T527*T549*T78*T425*params(28)*params(12)*params(13)*y(104)*T559*T2703)/(T559*T643*T559*T643);
  g1(66,22)=T2989;
  g1(66,23)=(-T3041);
  g1(66,24)=(-(y(104)*T3072));
  g1(66,26)=T1173+(-(y(104)*T3135))-T531*(T527*T78*T425*params(12)*params(13)*y(99)+T527*T78*params(12)*params(13)*y(99)*(-T425))/(T553*y(27))+T553*(T527*T78*T425*params(12)*params(13)*y(99)+T527*T78*params(12)*params(13)*y(99)*(-T425))/T621-T637*T531*(T1192+T527*T631*T78*params(28)*params(12)*params(13)*y(105)*(-T425))/T553+T637*T553*(T1192+T527*T631*T78*params(28)*params(12)*params(13)*y(105)*(-T425))/T643+T553*(T527*T549*T78*T425*params(28)*params(12)*params(13)*y(104)+T527*T549*T78*params(28)*params(12)*params(13)*y(104)*(-T425))/(T559*T643);
  g1(66,27)=(-(y(104)*T3358))-(-(T553*T531*T527*T78*T425*params(12)*params(13)*y(99)))/(T553*y(27)*T553*y(27))+(-(T643*T553*T527*T78*T425*params(12)*params(13)*y(99)))/(T621*T621)-T531*T1192*T3370/T553+T553*T1192*T3370/T643+(-(T553*T527*T549*T78*T425*params(28)*params(12)*params(13)*y(104)*T643*T3354))/(T559*T643*T559*T643);
  g1(66,28)=T553*T527*T549*T78*T425*params(28)*params(12)*params(13)*y(104)/(T559*T643)+(-(T561*y(104)));
  g1(66,29)=T637*T553*T1192/T643+(-(T637*T531*T1192/T553));
  g1(66,44)=(-(y(104)*(1+params(26))*T91*T78*params(12)*params(36)*T527*T531*T3778/params(26)));
  g1(66,99)=T3967;
  g1(66,100)=T3982;
  g1(66,101)=(-T3990);
  g1(66,102)=T78;
  g1(66,104)=T4007;
  g1(66,105)=T4031;
  g1(66,111)=T531*T78*params(12)*params(47)*params(48);
  g1(67,21)=(-T2821);
  g1(67,22)=exp(y(22))*(-y(108))-(T666*exp(y(22))*T661*y(102)*T2973+T675*(T666*exp(y(22))*T661*y(102)+exp(y(22))*T661*y(102)*exp(y(22))*getPowerDeriv(exp(y(22)),T664-1,1)))-T2989;
  g1(67,23)=(-(T666*exp(y(22))*T661*y(102)*T3024));
  g1(67,26)=(-T1173);
  g1(67,100)=(-T3982);
  g1(67,102)=(-(T675*T666*exp(y(22))*T661));
  g1(67,108)=(-exp(y(22)));
  g1(68,80)=(-1);
  g1(68,110)=1;
  g1(69,24)=(-(params(36)*exp(y(31))*T91*getPowerDeriv(T91,1+params(24),1)/T1232));
  g1(69,31)=exp(y(31))*y(107)-T1233;
  g1(69,44)=(-((-(T93*params(36)*exp(y(31))*(1+params(24))*exp(y(44))*getPowerDeriv(exp(y(44)),params(24),1)))/(T1232*T1232)));
  g1(69,84)=(-params(3));
  g1(69,107)=exp(y(31));
  g1(70,27)=(-((-(exp(y(37))*params(28)*y(107)*T3354))/(T559*T559)));
  g1(70,37)=(-(exp(y(37))*params(28)*y(107)/T559));
  g1(70,84)=1;
  g1(70,107)=(-(params(28)*exp(y(37))/T559));
  g1(71,25)=exp(y(25))*y(109)-exp(y(25))*y(108);
  g1(71,108)=(-exp(y(25)));
  g1(71,109)=exp(y(25));
  g1(72,21)=(-T2866);
  g1(72,26)=(-T3273);
  g1(72,27)=(-T3483);
  g1(72,28)=T549*exp((-y(29)))*y(103);
  g1(72,29)=T631*y(105)+T549*y(103)*(-exp((-y(29))))-T1258;
  g1(72,103)=T549*exp((-y(29)));
  g1(72,105)=T4037;
  g1(73,21)=(-T2872);
  g1(73,26)=(-T3280);
  g1(73,27)=(-T3487);
  g1(73,28)=T549*y(104)-T549*exp((-y(29)))*y(103)-T1269;
  g1(73,29)=(-(T549*y(103)*(-exp((-y(29))))));
  g1(73,103)=(-(T549*exp((-y(29)))));
  g1(73,104)=T549-T553*T527*T549*T425*params(13)*params(28)/(T559*params(3)*T553);
  g1(74,21)=T2817;
  g1(74,22)=(-(T733*exp(y(23))*T670*y(102)*T2973));
  g1(74,23)=T3041-(T733*exp(y(23))*T670*y(102)*T3024+T675*(T733*exp(y(23))*T670*y(102)+exp(y(23))*T670*y(102)*exp(y(23))*getPowerDeriv(exp(y(23)),T664-1,1)))-exp(y(23))*y(96)/params(33);
  g1(74,96)=(-(exp(y(23))/params(33)));
  g1(74,101)=T3990;
  g1(74,102)=(-(T675*T733*T670*exp(y(23))));
  g1(75,21)=(T760*T527*T425*params(13)*y(99)*T2646-T553*T527*T425*params(13)*y(99)*T2738)/(T760*T760)-(T783*(T635-1)*T527*T631*T425*params(28)*params(13)*params(39)*y(105)*T2646-(T635-1)*T553*T527*T631*T425*params(28)*params(13)*params(39)*y(105)*T556^T635*T2738)/(T783*T783)-(T769*T553*params(3)*T745*(1+params(26))*(1+params(24))*T527*T549*T425*params(28)*params(13)*params(39)*y(104)*T2646-(1+params(26))*(1+params(24))*T553*T527*T549*T425*params(28)*params(13)*params(39)*y(104)*T769*params(3)*T745*T2646)/(T769*T553*params(3)*T745*T769*T553*params(3)*T745);
  g1(75,26)=(-(T527*exp((-y(39)))*y(110)))+T553*(T527*T425*params(13)*y(99)+T527*params(13)*y(99)*(-T425))/T760-(T635-1)*T553*(T527*T631*T425*params(28)*params(13)*params(39)*y(105)+T527*T631*params(28)*params(13)*params(39)*y(105)*(-T425))/T783-(1+params(26))*(1+params(24))*T553*(T527*T549*T425*params(28)*params(13)*params(39)*y(104)+T527*T549*params(28)*params(13)*params(39)*y(104)*(-T425))/(T769*T553*params(3)*T745);
  g1(75,27)=(-(params(28)*params(39)*y(106)*(T748*params(26)*2*y(27)+T745*T3352*getPowerDeriv(T556,T747,1))))/(T749*T749)+(-(T553*T527*T425*params(13)*y(99)*T553*params(3)*2*y(27)))/(T760*T760)-(-((1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)*y(107)*(T769*params(26)*2*y(27)+T745*T3352*getPowerDeriv(T556,1+T558,1))))/(T745*T769*T745*T769)-(-((T635-1)*T553*T527*T631*T425*params(28)*params(13)*params(39)*y(105)*T3426))/(T783*T783)-(-((1+params(26))*(1+params(24))*T553*T527*T549*T425*params(28)*params(13)*params(39)*y(104)*T3435))/(T769*T553*params(3)*T745*T769*T553*params(3)*T745);
  g1(75,28)=(-T1318);
  g1(75,29)=(-T1308);
  g1(75,37)=(-T1299);
  g1(75,39)=(-(T527*y(110)*(-exp((-y(39))))));
  g1(75,99)=T553*T527*T425*params(13)/T760;
  g1(75,104)=T4018;
  g1(75,105)=T4043;
  g1(75,106)=params(28)*params(39)/T749;
  g1(75,107)=T4061;
  g1(75,110)=(-(T527*exp((-y(39)))));
  g1(76,30)=T807*(T805*T801*y(103)+T801*y(103)*T3585)+(T813*(params(28)-1)*T801*y(106)-(params(28)-1)*T801*y(106)*params(26)*T801*getPowerDeriv(T801,T747,1))/(T813*T813)-(T821*(params(28)-1)*(1+params(26))*(1+params(24))*T801*y(107)-(params(28)-1)*(1+params(26))*(1+params(24))*T801*y(107)*params(26)*T801*getPowerDeriv(T801,1+T558,1))/(T821*T821);
  g1(76,103)=T807*T801*T805;
  g1(76,106)=T801*(params(28)-1)/T813;
  g1(76,107)=(-((params(28)-1)*(1+params(26))*(1+params(24))*T801/T821));
  g1(77,32)=(-((-(y(99)*2*(1+y(32))))/(T829*T829)));
  g1(77,85)=(-params(3));
  g1(77,99)=(-(1/T829));
  g1(78,85)=1;
  g1(79,19)=(-(exp(y(19))*T425*y(89)));
  g1(79,21)=T2866+T2872+T527*y(100)*T2765-y(104)*T2776-(T553*y(27)*T527*T425*params(13)*y(99)*T2646-T553*T527*T425*params(13)*y(99)*y(27)*T2646)/(T553*y(27)*T553*y(27))+(T553*params(3)*y(27)*T527*T425*params(13)*y(99)*T2646-T553*T527*T425*params(13)*y(99)*params(3)*y(27)*T2646)/(T553*params(3)*y(27)*T553*params(3)*y(27))-(T553*T637*T527*T631*T425*params(28)*params(13)*y(105)*T2646-T637*T553*T527*T631*T425*params(28)*params(13)*y(105)*T2646)/(T553*T553);
  g1(79,22)=T527*y(100)*T2981;
  g1(79,24)=(-(y(104)*T3078));
  g1(79,26)=T3273+T3280+T835*T527*y(100)-y(104)*T3216-exp(y(19))*y(89)*(-T425)-T527*exp((-y(39)))*y(27)*y(110)-T553*(T527*T425*params(13)*y(99)+T527*params(13)*y(99)*(-T425))/(T553*y(27))+T553*(T527*T425*params(13)*y(99)+T527*params(13)*y(99)*(-T425))/(T553*params(3)*y(27))-T637*T553*(T527*T631*T425*params(28)*params(13)*y(105)+T527*T631*params(28)*params(13)*y(105)*(-T425))/T553;
  g1(79,27)=T3483+T3487+(-(y(104)*T3442))-T527*exp((-y(39)))*y(110)-(-(T553*T553*T527*T425*params(13)*y(99)))/(T553*y(27)*T553*y(27))+(-(params(3)*T553*T553*T527*T425*params(13)*y(99)))/(T553*params(3)*y(27)*T553*params(3)*y(27))-T553*T527*T631*T425*params(28)*params(13)*y(105)*T3370/T553;
  g1(79,28)=T1269-T848*y(104);
  g1(79,29)=T1258-T637*T553*T527*T631*T425*params(28)*params(13)*y(105)/T553;
  g1(79,39)=(-(T527*y(27)*y(110)*(-exp((-y(39))))));
  g1(79,44)=(-(y(104)*T3786));
  g1(79,86)=(-params(3));
  g1(79,89)=(-(T425*exp(y(19))));
  g1(79,99)=T3977;
  g1(79,100)=T527*T835;
  g1(79,104)=T553*T527*T549*T425*params(13)*params(28)/(T559*params(3)*T553)-T849;
  g1(79,105)=T4046;
  g1(79,110)=(-(T527*y(27)*exp((-y(39)))));
  g1(80,26)=T527*exp((-y(39)))*y(27)*y(110);
  g1(80,27)=T527*exp((-y(39)))*y(110);
  g1(80,39)=T527*y(27)*y(110)*(-exp((-y(39))));
  g1(80,86)=1;
  g1(80,110)=T527*y(27)*exp((-y(39)));
  g1(81,21)=(-(y(104)*T2802));
  g1(81,24)=T91*y(108)-y(104)*T3093-(1+params(40)*exp(y(45)))*T91*y(105)/params(26)-T91*exp(y(43))*params(15)*y(109)-(T1378+T91*params(36)*exp(y(31))*T91*getPowerDeriv(T91,params(24),1))/T1231;
  g1(81,26)=(-(T885*y(104)));
  g1(81,31)=(-T1379);
  g1(81,43)=(-(T91*exp(y(43))*params(15)*y(109)));
  g1(81,44)=(-(y(104)*T3798))-(-(T1378*exp(y(44))*getPowerDeriv(exp(y(44)),params(24),1)))/(T1231*T1231);
  g1(81,45)=(-(params(40)*exp(y(45))*T91*y(105)/params(26)));
  g1(81,104)=(-T885);
  g1(81,105)=(-(T91*(1+params(40)*exp(y(45)))/params(26)));
  g1(81,108)=T91;
  g1(81,109)=(-(T91*params(15)*exp(y(43))));
  g1(82,80)=1;
  g1(83,7)=(-((T1386*params(5)*T1869-params(5)*T1386*T1869)/(T1386*T1386)/y(13)));
  g1(83,12)=(-((T1386*params(5)*T2274-params(5)*T1386*T2274)/(T1386*T1386)/y(13)));
  g1(83,13)=(-((-(params(5)*T1386/T1386))/(y(13)*y(13))));
  g1(83,18)=(-1)/((1+y(18))*(1+y(18)));
  g1(84,7)=T108*T1392*getPowerDeriv(T1392,T160,1);
  g1(84,8)=T108*getPowerDeriv(T1392,T160,1)*(-(exp(y(8))*T55*params(31)))/(exp(y(8))*exp(y(8)));
  g1(84,12)=T108*T1392^T160;
  g1(85,7)=(-(T1398*getPowerDeriv(T1398,T160,1)));
  g1(85,9)=(-(getPowerDeriv(T1398,T160,1)*(-(exp(y(9))*T55*params(32)))/(exp(y(9))*exp(y(9)))));
  g1(85,19)=exp(y(19))/T527;
  g1(85,26)=(-(exp(y(19))*T527))/(T527*T527);
  g1(86,7)=T55;
  g1(86,8)=(-(T252*exp(y(8))*getPowerDeriv(exp(y(8)),T255,1)*getPowerDeriv(T265,1+params(6),1)));
  g1(86,9)=(-(getPowerDeriv(T265,1+params(6),1)*T261*exp(y(9))*getPowerDeriv(exp(y(9)),T255,1)));
  g1(87,14)=(-(T132/T221));
  g1(87,15)=(-((-(T132*T221))/(T221*T221)));
  g1(87,16)=T400*getPowerDeriv(T400,1+params(25)*T225,1);
  g1(88,7)=(-(T68*(-(T1411*T1869))/(T1386*T1386)+T132*T1419*(T1386*params(5)*params(29)*T1869-params(5)*params(29)*T1386*T1869)/(T1386*T1386)));
  g1(88,10)=(-(T68*T1411/T1386+T68*params(30)*T225*T68/exp(y(41))*T2067/T1386));
  g1(88,12)=(-(T68*(-(T1411*T2274))/(T1386*T1386)+T132*T1419*(T1386*params(5)*params(29)*T2274-params(5)*params(29)*T1386*T2274)/(T1386*T1386)));
  g1(88,13)=(-(T132*T1415*T2304*getPowerDeriv(T138,T1418,1)));
  g1(88,14)=T132-T132*T1415*T1419;
  g1(88,41)=(-(T68*params(30)*T225*T2067*(-(exp(y(41))*T68))/(exp(y(41))*exp(y(41)))/T1386));
  g1(89,7)=(-(T221*T227*(T1386*params(5)*params(29)*T1869-params(5)*params(29)*T1386*T1869)/(T1386*T1386)));
  g1(89,10)=(-(T68*(1+params(35)*exp(y(42)))/params(27)));
  g1(89,12)=(-(T221*T227*(T1386*params(5)*params(29)*T2274-params(5)*params(29)*T1386*T2274)/(T1386*T1386)));
  g1(89,13)=(-(T221*T1415*T2322));
  g1(89,15)=T221-T221*T227*T1415;
  g1(89,42)=(-(T68*params(35)*exp(y(42))/params(27)));
  g1(90,13)=params(29)*T2304*getPowerDeriv(T138,T1431,1);
  g1(90,16)=(1-params(29))*T400*getPowerDeriv(T400,T1431,1);
  g1(91,13)=(-(exp(y(34))*params(29)*T2304*getPowerDeriv(T138,T1418,1)));
  g1(91,16)=(-((1-params(29))*T400*getPowerDeriv(T400,T1418,1)));
  g1(91,17)=exp(y(17));
  g1(91,34)=(-(exp(y(34))*params(29)*T1419));
  g1(92,8)=(-exp(y(8)));
  g1(92,10)=T68;
  g1(92,11)=(-exp(y(11)));
  g1(92,23)=(-(exp(y(23))*1/params(33)));
  g1(93,10)=(-(exp(y(40))*T68*params(7)));
  g1(93,11)=exp(y(11));
  g1(93,40)=(-(exp(y(40))*T68*params(7)));
  g1(94,12)=(-(y(13)*T108/exp(y(36))));
  g1(94,13)=(-(T108/exp(y(36))));
  g1(94,20)=1;
  g1(94,36)=(-(y(13)*(-(T108*exp(y(36))))/(exp(y(36))*exp(y(36)))));
  g1(95,21)=(-((T1459*params(13)*T2918-params(13)*T1459*T2918)/(T1459*T1459)/y(27)));
  g1(95,26)=(-((T1459*params(13)*T3325-params(13)*T1459*T3325)/(T1459*T1459)/y(27)));
  g1(95,27)=(-((-(params(13)*T1459/T1459))/(y(27)*y(27))));
  g1(95,32)=(-1)/((1+y(32))*(1+y(32)));
  g1(96,21)=T527*T1465*getPowerDeriv(T1465,T585,1);
  g1(96,22)=T527*getPowerDeriv(T1465,T585,1)*(-(exp(y(22))*T78*params(37)))/(exp(y(22))*exp(y(22)));
  g1(96,26)=T527*T1465^T585;
  g1(97,12)=(-(T108*1/exp(y(19))))/(T108*T108);
  g1(97,19)=(-exp(y(19)))/(exp(y(19))*exp(y(19)))/T108;
  g1(97,21)=(-(T1472*getPowerDeriv(T1472,T585,1)));
  g1(97,23)=(-(getPowerDeriv(T1472,T585,1)*(-(exp(y(23))*T78*params(38)))/(exp(y(23))*exp(y(23)))));
  g1(98,21)=T78;
  g1(98,22)=(-(T661*exp(y(22))*getPowerDeriv(exp(y(22)),T664,1)*getPowerDeriv(T674,1+params(14),1)));
  g1(98,23)=(-(getPowerDeriv(T674,1+params(14),1)*T670*exp(y(23))*getPowerDeriv(exp(y(23)),T664,1)));
  g1(99,28)=(-(T549/T631));
  g1(99,29)=(-((-(T549*T631))/(T631*T631)));
  g1(99,30)=T801*getPowerDeriv(T801,1+params(24)*T635,1);
  g1(100,21)=(-(T91*(-(T1485*T2918))/(T1459*T1459)+T549*T1493*(T1459*params(13)*params(28)*T2918-params(13)*params(28)*T1459*T2918)/(T1459*T1459)));
  g1(100,24)=(-(T91*T1485/T1459+T91*params(36)*T635*T91/exp(y(44))*T3115/T1459));
  g1(100,26)=(-(T91*(-(T1485*T3325))/(T1459*T1459)+T549*T1493*(T1459*params(13)*params(28)*T3325-params(13)*params(28)*T1459*T3325)/(T1459*T1459)));
  g1(100,27)=(-(T549*T1489*T3352*getPowerDeriv(T556,T1492,1)));
  g1(100,28)=T549-T549*T1489*T1493;
  g1(100,44)=(-(T91*params(36)*T635*T3115*(-(exp(y(44))*T91))/(exp(y(44))*exp(y(44)))/T1459));
  g1(101,21)=(-(T631*T637*(T1459*params(13)*params(28)*T2918-params(13)*params(28)*T1459*T2918)/(T1459*T1459)));
  g1(101,24)=(-(T91*(1+params(40)*exp(y(45)))/params(26)));
  g1(101,26)=(-(T631*T637*(T1459*params(13)*params(28)*T3325-params(13)*params(28)*T1459*T3325)/(T1459*T1459)));
  g1(101,27)=(-(T631*T1489*T3370));
  g1(101,29)=T631-T631*T637*T1489;
  g1(101,45)=(-(T91*params(40)*exp(y(45))/params(26)));
  g1(102,27)=params(28)*T3352*getPowerDeriv(T556,T1505,1);
  g1(102,30)=(1-params(28))*T801*getPowerDeriv(T801,T1505,1);
  g1(103,27)=(-(exp(y(37))*params(28)*T3352*getPowerDeriv(T556,T1492,1)));
  g1(103,30)=(-((1-params(28))*T801*getPowerDeriv(T801,T1492,1)));
  g1(103,31)=exp(y(31));
  g1(103,37)=(-(exp(y(37))*params(28)*T1493));
  g1(104,9)=(-(exp(y(9))*params(33)));
  g1(104,22)=(-exp(y(22)));
  g1(104,24)=T91;
  g1(104,25)=(-exp(y(25)));
  g1(105,24)=(-(exp(y(43))*T91*params(15)));
  g1(105,25)=exp(y(25));
  g1(105,43)=(-(exp(y(43))*T91*params(15)));
  g1(106,26)=(-(y(27)*T527/exp(y(39))));
  g1(106,27)=(-(T527/exp(y(39))));
  g1(106,33)=1;
  g1(106,39)=(-(y(27)*(-(T527*exp(y(39))))/(exp(y(39))*exp(y(39)))));
  g1(107,7)=(-(params(51)*(-(params(50)*params(49)/exp(y(19))*T55*getPowerDeriv(T55,(-params(4)),1)))/(T1385*T1385)));
  g1(107,19)=(-(params(51)*params(50)*(-(params(49)*exp(y(19))))/(exp(y(19))*exp(y(19)))/T1385));
  g1(107,21)=params(48)*(-(params(47)*T78*getPowerDeriv(T78,(-params(12)),1)))/(T1458*T1458);
  g1(108,40)=1-params(8);
  g1(109,41)=1-params(10);
  g1(110,42)=1-params(22);
  g1(111,43)=1-params(16);
  g1(112,44)=1-params(18);
  g1(113,45)=1-params(20);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],113,12769);
end
end
