function [optys,check] = BBCDLmodelcomp_nash_c1dcore_c2dcore_steadystate(junk,ys)
% TEMPLATE_FOR_NASH_STEADYSTATE.M: This file will be copied when a new
% _NASH.mod file is created, with BBCDLmodelcomp_nash_c1dcore_c2dcore being replaced by
% the new .mod filename in all instances.

global M_ params paramlist param_switch sensitivity_switch paramfile_name
check = 0;

% set parameters -- replace with outfilename
BBCDLmodelcomp_nash_c1dcore_c2dcore_paramfile

% export parameters
nparams = size(M_.param_names,1);
for icount = 1:nparams
    eval(['M_.params(icount) = ',M_.param_names(icount,:),';'])
end

% this calls a program that will be created with the _NASH.mod file which
% will 'guess' the steady-state values for the endogenous variables. the
% program will be a copy of the original _steadystate.m file; therefore,
% all original endogenous variables will have their original steady-state
% values, and the Lagrangian multipliers will be set to 0 for now.
[ys] = guess_BBCDLmodelcomp_nash_c1dcore_c2dcore_steadystate('');

% Solve for the steady-state from this initial guess.
nexog = M_.exo_nbr;
exog = zeros(nexog,1);
algo = char('active-set', 'trust-region-reflective', 'interior-point', 'interior-point-convex', 'levenberg-marquardt', 'trust-region-dogleg', 'lm-line-search','sqp');
options = optimset('Display','Iter','Jacobian','on','MaxFunEvals',1e4,'MaxIter',1e4,'TolFun',1e-9,'TolX',1e-9,'Algorithm',algo(5,:));
optys=fsolve(@(ys) BBCDLmodelcomp_nash_c1dcore_c2dcore_static(ys,exog,M_.params),ys,options);
