function [residual, g1, g2] = BBCDLmodelcomp_nash_c1pid_c2pid_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                    columns: equations in order of declaration
%                                                    rows: variables in declaration order
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: equations in order of declaration
%                                                       rows: variables in declaration order
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 113, 1);

%
% Model equations
%

T55 = exp(y(7));
T68 = exp(y(10));
T70 = T68^(1+params(25));
T74 = params(30)*exp(y(41))^(-params(25))*T70/(1+params(25))*exp(y(17));
T78 = exp(y(21));
T91 = exp(y(24));
T93 = T91^(1+params(24));
T97 = params(36)*exp(y(44))^(-params(24))*T93/(1+params(24))*exp(y(31));
T100 = T55^params(4);
T108 = exp(y(12));
T112 = T55^(params(4)-1);
T117 = (T68*exp((-y(41))))^params(25);
T122 = T68*T55*params(4)*params(30)*T108*T112*T117*(1+params(27))/params(27);
T128 = exp((-y(12)));
T132 = exp(y(14));
T137 = params(34)/y(13);
T139 = (1+params(25))*(1+params(27))/params(27);
T140 = T137^T139;
T142 = T112*T108*T55*params(4)*params(5)*params(29)*T128*T132/(T100*T140);
T143 = T122+T142;
T159 = params(6)/(1+params(6));
T161 = (T55*params(32)*exp((-y(9))))^(T159-1);
T163 = T55*params(32)*y(56)*params(6)*exp((-y(9)))*T161/(1+params(6));
T192 = (T55*params(31)*exp((-y(8))))^(T159-1);
T194 = T108*T55*params(6)*params(31)*y(55)*exp((-y(8)))*T192/(1+params(6));
T210 = params(3)*y(13)*T55^(1+params(4));
T220 = exp(y(15));
T222 = T108*T55*T128*params(29)*params(4)*params(5)*y(60)*T220;
T224 = (1+params(27))/params(27);
T226 = T137^(1-T224);
T232 = params(3)*T55^(1+params(4));
T244 = T100*T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)/(T140*T232);
T251 = params(31)^T159;
T254 = 1/(1+params(6));
T256 = exp(y(8))^(T254-1);
T260 = params(32)^T159;
T264 = T251*exp(y(8))^T254+T260*exp(y(9))^T254;
T265 = T264^params(6);
T279 = exp(y(41))^params(25);
T280 = (1+params(25))*T279;
T281 = T70*params(30)*exp(y(17))/T280;
T311 = T226*T100*T108*T220*T128*params(29)*params(5)*y(60)/(params(3)*T100);
T322 = T100*T108*T132*T128*params(29)*y(59)*params(5)/(T140*params(3)*T100);
T327 = exp(y(9))^(T254-1);
T341 = params(27)*y(13)^2;
T343 = 1+1/params(27);
T344 = T137^T343;
T345 = T341*T344;
T358 = T100*params(3)*y(13)^2;
T367 = T137^(1+T139);
T369 = (1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)*y(62)/(T341*T367);
T381 = T358*T137^T224;
T382 = T100*T108*T220*T128*params(29)*y(60)*params(5)*params(34)*(T224-1)/T381;
T395 = (1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*y(59)*params(5)*params(34)/(T367*T100*params(3)*T341);
T399 = exp(y(16));
T403 = T399^(params(25)*(1+params(27))/params(27));
T405 = 1+params(25)*(1+params(27))/params(27);
T411 = params(27)*T399^T343;
T419 = params(27)*T399^(1+T139);
T424 = exp((-y(26)));
T440 = (1+y(18))^2;
T446 = (T55*params(31)*exp((-y(8))))^T159;
T453 = (1+params(27))*T117*T100*T68*params(30)*T108/params(27);
T459 = T100*T108*T132*T128*params(5)*params(29)/(T100*T140);
T460 = T453+T459;
T492 = (T68*exp((-y(41))))^(params(25)-1);
T496 = T453+(1+params(27))*T100*T108*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*T492/params(27);
T517 = T68*params(30)*exp(y(17))*T68^params(25);
T526 = exp(y(26));
T530 = T78^(params(12)-1);
T535 = (T91*exp((-y(44))))^params(24);
T540 = T91*T78*params(12)*params(36)*T526*T530*T535*(1+params(26))/params(26);
T548 = exp(y(28));
T552 = T78^params(12);
T554 = params(39)/y(27);
T556 = (1+params(24))*(1+params(26))/params(26);
T557 = T554^T556;
T559 = T530*T526*T78*T424*params(12)*params(13)*params(28)*T548/(T552*T557);
T560 = T540+T559;
T583 = params(14)/(1+params(14));
T585 = (T78*params(38)*exp((-y(23))))^(T583-1);
T587 = T78*y(68)*params(38)*params(14)*exp((-y(23)))*T585/(1+params(14));
T601 = (T78*params(37)*exp((-y(22))))^(T583-1);
T603 = T526*T78*params(14)*params(37)*y(67)*exp((-y(22)))*T601/(1+params(14));
T619 = params(3)*y(27)*T78^(1+params(12));
T629 = exp(y(29));
T631 = T526*T78*T424*params(28)*params(12)*params(13)*y(72)*T629;
T633 = (1+params(26))/params(26);
T635 = T554^(1-T633);
T641 = params(3)*T78^(1+params(12));
T653 = T552*T526*T548*T78*T424*params(28)*params(12)*y(71)*params(13)/(T557*T641);
T659 = params(37)^T583;
T662 = 1/(1+params(14));
T664 = exp(y(22))^(T662-1);
T668 = params(38)^T583;
T672 = T659*exp(y(22))^T662+T668*exp(y(23))^T662;
T673 = T672^params(14);
T713 = T635*T552*T526*T629*T424*params(28)*params(13)*y(72)/(params(3)*T552);
T724 = T552*T526*T548*T424*params(28)*y(71)*params(13)/(T557*params(3)*T552);
T729 = exp(y(23))^(T662-1);
T741 = params(26)*y(27)^2;
T743 = 1+1/params(26);
T744 = T554^T743;
T745 = T741*T744;
T758 = T552*params(3)*y(27)^2;
T767 = T554^(1+T556);
T769 = (1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)*y(74)/(T741*T767);
T781 = T758*T554^T633;
T782 = T552*T526*T629*T424*params(28)*y(72)*params(13)*params(39)*(T633-1)/T781;
T795 = (1+params(26))*(1+params(24))*T552*T526*T548*T424*params(28)*y(71)*params(13)*params(39)/(T767*T552*params(3)*T741);
T799 = exp(y(30));
T803 = T799^(params(24)*(1+params(26))/params(26));
T805 = 1+params(24)*(1+params(26))/params(26);
T811 = params(26)*T799^T743;
T819 = params(26)*T799^(1+T556);
T827 = (1+y(32))^2;
T833 = (T78*params(37)*exp((-y(22))))^T583;
T840 = (1+params(26))*T535*T552*T91*params(36)*T526/params(26);
T846 = T552*T526*T548*T424*params(13)*params(28)/(T552*T557);
T847 = T840+T846;
T879 = (T91*exp((-y(44))))^(params(24)-1);
T883 = T840+(1+params(26))*T552*T526*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*T879/params(26);
T933 = T192*T108*T55*exp((-y(8)))*params(6)*params(31)*y(88)/(1+params(6));
T953 = T108*T220*T55*T128*params(29)*params(4)*params(5)*y(93);
T1012 = T226*T100*T108*T220*T128*params(29)*params(5)*y(93)/(params(3)*T100);
T1023 = T100*T108*T132*T128*params(29)*params(5)*y(92)/(T140*params(3)*T100);
T1055 = (1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)*y(95)/(T341*T367);
T1064 = (T224-1)*T100*T108*T220*T128*params(29)*params(5)*params(34)*y(93)/T381;
T1074 = (1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*params(5)*params(34)*y(92)/(T367*T100*params(3)*T341);
T1171 = T601*T526*T78*exp((-y(22)))*params(14)*params(37)*y(100)/(1+params(14));
T1190 = T526*T629*T78*T424*params(28)*params(12)*params(13)*y(105);
T1227 = exp(y(44))^params(24);
T1228 = (1+params(24))*T1227;
T1229 = T93*params(36)*exp(y(31))/T1228;
T1254 = T635*T552*T526*T629*T424*params(28)*params(13)*y(105)/(params(3)*T552);
T1265 = T552*T526*T548*T424*params(28)*params(13)*y(104)/(T557*params(3)*T552);
T1297 = (1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)*y(107)/(T741*T767);
T1306 = (T633-1)*T552*T526*T629*T424*params(28)*params(13)*params(39)*y(105)/T781;
T1316 = (1+params(26))*(1+params(24))*T552*T526*T548*T424*params(28)*params(13)*params(39)*y(104)/(T767*T552*params(3)*T741);
T1376 = T91*params(36)*exp(y(31))*T91^params(24);
T1377 = T1376/T1227;
T1383 = T55^(-params(4));
T1384 = T1383/T108;
T1390 = T55*params(31)/exp(y(8));
T1396 = T55*params(32)/exp(y(9));
T1409 = params(30)*T224*(T68/exp(y(41)))^params(25);
T1413 = params(5)*params(29)*T1384/T1384;
T1416 = (1+params(25))*(-(1+params(27)))/params(27);
T1417 = T137^T1416;
T1429 = (-1)/params(27);
T1457 = T78^(-params(12));
T1458 = T1457/T526;
T1464 = T78*params(37)/exp(y(22));
T1471 = T78*params(38)/exp(y(23));
T1484 = params(36)*T633*(T91/exp(y(44)))^params(24);
T1488 = params(13)*params(28)*T1458/T1458;
T1491 = (1+params(24))*(-(1+params(26)))/params(26);
T1492 = T554^T1491;
T1504 = (-1)/params(26);
T1586 = T55*getPowerDeriv(T55,params(4),1);
T1594 = T55*getPowerDeriv(T55,params(4)-1,1);
T1608 = (1+params(27))*T117*(T68*T55*params(4)*params(30)*T108*T112+T68*T55*params(4)*params(30)*T108*T1594)/params(27)+(T100*T140*(T112*T108*T55*params(4)*params(5)*params(29)*T128*T132+T108*T55*params(4)*params(5)*params(29)*T128*T132*T1594)-T112*T108*T55*params(4)*params(5)*params(29)*T128*T132*T140*T1586)/(T100*T140*T100*T140);
T1612 = T55*params(32)*exp((-y(9)))*getPowerDeriv(T55*params(32)*exp((-y(9))),T159-1,1);
T1615 = (T55*params(32)*y(56)*params(6)*exp((-y(9)))*T161+T55*params(32)*y(56)*params(6)*exp((-y(9)))*T1612)/(1+params(6));
T1621 = T55*params(31)*exp((-y(8)))*getPowerDeriv(T55*params(31)*exp((-y(8))),T159-1,1);
T1624 = (T108*T55*params(6)*params(31)*y(55)*exp((-y(8)))*T192+T108*T55*params(6)*params(31)*y(55)*exp((-y(8)))*T1621)/(1+params(6));
T1657 = params(3)*T55*getPowerDeriv(T55,1+params(4),1);
T1681 = (params(3)*T100*T226*T108*T220*T128*params(29)*params(5)*y(60)*T1586-T226*T100*T108*T220*T128*params(29)*params(5)*y(60)*params(3)*T1586)/(params(3)*T100*params(3)*T100);
T1689 = (T140*params(3)*T100*T108*T132*T128*params(29)*y(59)*params(5)*T1586-T100*T108*T132*T128*params(29)*y(59)*params(5)*T140*params(3)*T1586)/(T140*params(3)*T100*T140*params(3)*T100);
T1692 = params(3)*y(13)^2*T1586;
T1720 = T55*params(31)*exp((-y(8)))*getPowerDeriv(T55*params(31)*exp((-y(8))),T159,1);
T1731 = (1+params(27))*T117*T68*params(30)*T108*T1586/params(27)+(T100*T140*T108*T132*T128*params(5)*params(29)*T1586-T100*T108*T132*T128*params(5)*params(29)*T140*T1586)/(T100*T140*T100*T140);
T1757 = (1+params(27))*T117*T68*params(30)*T108*T1586/params(27)+(1+params(27))*T492*T108*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*T1586/params(27);
T1764 = (T161*T55*exp((-y(9)))*params(32)*params(6)*y(89)+T55*exp((-y(9)))*params(32)*params(6)*y(89)*T1612)/(1+params(6));
T1771 = (T192*T108*T55*exp((-y(8)))*params(6)*params(31)*y(88)+T108*T55*exp((-y(8)))*params(6)*params(31)*y(88)*T1621)/(1+params(6));
T1816 = (params(3)*T100*T226*T108*T220*T128*params(29)*params(5)*y(93)*T1586-T226*T100*T108*T220*T128*params(29)*params(5)*y(93)*params(3)*T1586)/(params(3)*T100*params(3)*T100);
T1822 = (T140*params(3)*T100*T108*T132*T128*params(29)*params(5)*y(92)*T1586-T100*T108*T132*T128*params(29)*params(5)*y(92)*T140*params(3)*T1586)/(T140*params(3)*T100*T140*params(3)*T100);
T1869 = T55*getPowerDeriv(T55,(-params(4)),1)/T108;
T1912 = getPowerDeriv(T55*params(31)*exp((-y(8))),T159-1,1)*T55*params(31)*(-exp((-y(8))));
T1916 = (T192*T108*T55*params(6)*params(31)*y(55)*(-exp((-y(8))))+T108*T55*params(6)*params(31)*y(55)*exp((-y(8)))*T1912)/(1+params(6));
T1925 = T251*exp(y(8))*getPowerDeriv(exp(y(8)),T254,1)*getPowerDeriv(T264,params(6),1);
T1933 = getPowerDeriv(T55*params(31)*exp((-y(8))),T159,1)*T55*params(31)*(-exp((-y(8))));
T1941 = (T108*T55*exp((-y(8)))*params(6)*params(31)*y(88)*T1912+T192*T108*T55*params(6)*params(31)*y(88)*(-exp((-y(8)))))/(1+params(6));
T1967 = getPowerDeriv(T55*params(32)*exp((-y(9))),T159-1,1)*T55*params(32)*(-exp((-y(9))));
T1971 = (T161*T55*params(32)*y(56)*params(6)*(-exp((-y(9))))+T55*params(32)*y(56)*params(6)*exp((-y(9)))*T1967)/(1+params(6));
T1976 = getPowerDeriv(T264,params(6),1)*T260*exp(y(9))*getPowerDeriv(exp(y(9)),T254,1);
T1993 = (T55*exp((-y(9)))*params(32)*params(6)*y(89)*T1967+T161*T55*params(32)*params(6)*y(89)*(-exp((-y(9)))))/(1+params(6));
T2020 = T68*exp((-y(41)))*getPowerDeriv(T68*exp((-y(41))),params(25),1);
T2024 = (1+params(27))*(T68*T55*params(4)*params(30)*T108*T112*T117+T68*T55*params(4)*params(30)*T108*T112*T2020)/params(27);
T2033 = (1+params(27))*(T117*T100*T68*params(30)*T108+T100*T68*params(30)*T108*T2020)/params(27);
T2048 = T2033+(1+params(27))*(T492*T100*T108*exp((-y(41)))*params(30)*params(25)*2*exp(2*y(10))+T100*T108*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*T68*exp((-y(41)))*getPowerDeriv(T68*exp((-y(41))),params(25)-1,1))/params(27);
T2067 = getPowerDeriv(T68/exp(y(41)),params(25),1);
T2085 = T122+T112*(T108*T55*params(4)*params(5)*params(29)*T128*T132+T108*T132*T55*params(4)*params(5)*params(29)*(-T128))/(T100*T140);
T2127 = T226*T100*(T108*T220*T128*params(29)*params(5)*y(60)+T108*T220*params(29)*params(5)*y(60)*(-T128))/(params(3)*T100);
T2134 = T100*(T108*T132*T128*params(29)*y(59)*params(5)+T108*T132*params(29)*y(59)*params(5)*(-T128))/(T140*params(3)*T100);
T2168 = T453+T100*(T108*T132*T128*params(5)*params(29)+T108*T132*params(5)*params(29)*(-T128))/(T100*T140);
T2223 = T226*T100*(T108*T220*T128*params(29)*params(5)*y(93)+T108*T220*params(29)*params(5)*y(93)*(-T128))/(params(3)*T100);
T2230 = T100*(T108*T132*T128*params(29)*params(5)*y(92)+T108*T132*params(29)*params(5)*y(92)*(-T128))/(T140*params(3)*T100);
T2274 = (-(T108*T1383))/(T108*T108);
T2304 = (-params(34))/(y(13)*y(13));
T2306 = T2304*getPowerDeriv(T137,T139,1);
T2310 = (-(T112*T108*T55*params(4)*params(5)*params(29)*T128*T132*T100*T2306))/(T100*T140*T100*T140);
T2322 = T2304*getPowerDeriv(T137,1-T224,1);
T2340 = T100*T108*T220*T128*params(29)*params(5)*y(60)*T2322/(params(3)*T100);
T2345 = (-(T100*T108*T132*T128*params(29)*y(59)*params(5)*params(3)*T100*T2306))/(T140*params(3)*T100*T140*params(3)*T100);
T2378 = T137^T224*T100*params(3)*2*y(13)+T358*T2304*getPowerDeriv(T137,T224,1);
T2387 = T100*params(3)*T341*T2304*getPowerDeriv(T137,1+T139,1)+T367*T100*params(3)*params(27)*2*y(13);
T2394 = (-(T100*T108*T132*T128*params(5)*params(29)*T100*T2306))/(T100*T140*T100*T140);
T2435 = T100*T108*T220*T128*params(29)*params(5)*y(93)*T2322/(params(3)*T100);
T2439 = (-(T100*T108*T132*T128*params(29)*params(5)*y(92)*params(3)*T100*T2306))/(T140*params(3)*T100*T140*params(3)*T100);
T2537 = T399*getPowerDeriv(T399,params(25)*(1+params(27))/params(27),1);
T2637 = T78*getPowerDeriv(T78,params(12)-1,1);
T2646 = T78*getPowerDeriv(T78,params(12),1);
T2653 = (1+params(26))*T535*(T91*T78*params(12)*params(36)*T526*T530+T91*T78*params(12)*params(36)*T526*T2637)/params(26)+(T552*T557*(T530*T526*T78*T424*params(12)*params(13)*params(28)*T548+T526*T78*T424*params(12)*params(13)*params(28)*T548*T2637)-T530*T526*T78*T424*params(12)*params(13)*params(28)*T548*T557*T2646)/(T552*T557*T552*T557);
T2660 = T78*params(38)*exp((-y(23)))*getPowerDeriv(T78*params(38)*exp((-y(23))),T583-1,1);
T2663 = (T78*y(68)*params(38)*params(14)*exp((-y(23)))*T585+T78*y(68)*params(38)*params(14)*exp((-y(23)))*T2660)/(1+params(14));
T2666 = T78*params(37)*exp((-y(22)))*getPowerDeriv(T78*params(37)*exp((-y(22))),T583-1,1);
T2669 = (T526*T78*params(14)*params(37)*y(67)*exp((-y(22)))*T601+T526*T78*params(14)*params(37)*y(67)*exp((-y(22)))*T2666)/(1+params(14));
T2703 = params(3)*T78*getPowerDeriv(T78,1+params(12),1);
T2727 = (params(3)*T552*T635*T526*T629*T424*params(28)*params(13)*y(72)*T2646-T635*T552*T526*T629*T424*params(28)*params(13)*y(72)*params(3)*T2646)/(params(3)*T552*params(3)*T552);
T2735 = (T557*params(3)*T552*T526*T548*T424*params(28)*y(71)*params(13)*T2646-T552*T526*T548*T424*params(28)*y(71)*params(13)*T557*params(3)*T2646)/(T557*params(3)*T552*T557*params(3)*T552);
T2738 = params(3)*y(27)^2*T2646;
T2765 = T78*params(37)*exp((-y(22)))*getPowerDeriv(T78*params(37)*exp((-y(22))),T583,1);
T2776 = (1+params(26))*T535*T91*params(36)*T526*T2646/params(26)+(T552*T557*T526*T548*T424*params(13)*params(28)*T2646-T552*T526*T548*T424*params(13)*params(28)*T557*T2646)/(T552*T557*T552*T557);
T2802 = (1+params(26))*T535*T91*params(36)*T526*T2646/params(26)+(1+params(26))*T879*T526*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*T2646/params(26);
T2817 = (T585*T78*exp((-y(23)))*y(101)*params(38)*params(14)+T78*exp((-y(23)))*y(101)*params(38)*params(14)*T2660)/(1+params(14));
T2821 = (T601*T526*T78*exp((-y(22)))*params(14)*params(37)*y(100)+T526*T78*exp((-y(22)))*params(14)*params(37)*y(100)*T2666)/(1+params(14));
T2866 = (params(3)*T552*T635*T526*T629*T424*params(28)*params(13)*y(105)*T2646-T635*T552*T526*T629*T424*params(28)*params(13)*y(105)*params(3)*T2646)/(params(3)*T552*params(3)*T552);
T2872 = (T557*params(3)*T552*T526*T548*T424*params(28)*params(13)*y(104)*T2646-T552*T526*T548*T424*params(28)*params(13)*y(104)*T557*params(3)*T2646)/(T557*params(3)*T552*T557*params(3)*T552);
T2918 = T78*getPowerDeriv(T78,(-params(12)),1)/T526;
T2960 = getPowerDeriv(T78*params(37)*exp((-y(22))),T583-1,1)*T78*params(37)*(-exp((-y(22))));
T2964 = (T601*T526*T78*params(14)*params(37)*y(67)*(-exp((-y(22))))+T526*T78*params(14)*params(37)*y(67)*exp((-y(22)))*T2960)/(1+params(14));
T2973 = T659*exp(y(22))*getPowerDeriv(exp(y(22)),T662,1)*getPowerDeriv(T672,params(14),1);
T2981 = getPowerDeriv(T78*params(37)*exp((-y(22))),T583,1)*T78*params(37)*(-exp((-y(22))));
T2989 = (T526*T78*exp((-y(22)))*params(14)*params(37)*y(100)*T2960+T601*T526*T78*params(14)*params(37)*y(100)*(-exp((-y(22)))))/(1+params(14));
T3015 = getPowerDeriv(T78*params(38)*exp((-y(23))),T583-1,1)*T78*params(38)*(-exp((-y(23))));
T3019 = (T585*T78*y(68)*params(38)*params(14)*(-exp((-y(23))))+T78*y(68)*params(38)*params(14)*exp((-y(23)))*T3015)/(1+params(14));
T3024 = getPowerDeriv(T672,params(14),1)*T668*exp(y(23))*getPowerDeriv(exp(y(23)),T662,1);
T3041 = (T78*exp((-y(23)))*y(101)*params(38)*params(14)*T3015+T585*T78*y(101)*params(38)*params(14)*(-exp((-y(23)))))/(1+params(14));
T3068 = T91*exp((-y(44)))*getPowerDeriv(T91*exp((-y(44))),params(24),1);
T3072 = (1+params(26))*(T91*T78*params(12)*params(36)*T526*T530*T535+T91*T78*params(12)*params(36)*T526*T530*T3068)/params(26);
T3078 = (1+params(26))*(T535*T552*T91*params(36)*T526+T552*T91*params(36)*T526*T3068)/params(26);
T3093 = T3078+(1+params(26))*(T879*T552*T526*exp((-y(44)))*params(36)*params(24)*2*exp(2*y(24))+T552*T526*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*T91*exp((-y(44)))*getPowerDeriv(T91*exp((-y(44))),params(24)-1,1))/params(26);
T3115 = getPowerDeriv(T91/exp(y(44)),params(24),1);
T3135 = T540+T530*(T526*T78*T424*params(12)*params(13)*params(28)*T548+T526*T548*T78*params(12)*params(13)*params(28)*(-T424))/(T552*T557);
T3177 = T635*T552*(T526*T629*T424*params(28)*params(13)*y(72)+T526*T629*params(28)*params(13)*y(72)*(-T424))/(params(3)*T552);
T3184 = T552*(T526*T548*T424*params(28)*y(71)*params(13)+T526*T548*params(28)*y(71)*params(13)*(-T424))/(T557*params(3)*T552);
T3216 = T840+T552*(T526*T548*T424*params(13)*params(28)+T526*T548*params(13)*params(28)*(-T424))/(T552*T557);
T3273 = T635*T552*(T526*T629*T424*params(28)*params(13)*y(105)+T526*T629*params(28)*params(13)*y(105)*(-T424))/(params(3)*T552);
T3280 = T552*(T526*T548*T424*params(28)*params(13)*y(104)+T526*T548*params(28)*params(13)*y(104)*(-T424))/(T557*params(3)*T552);
T3325 = (-(T526*T1457))/(T526*T526);
T3352 = (-params(39))/(y(27)*y(27));
T3354 = T3352*getPowerDeriv(T554,T556,1);
T3358 = (-(T530*T526*T78*T424*params(12)*params(13)*params(28)*T548*T552*T3354))/(T552*T557*T552*T557);
T3370 = T3352*getPowerDeriv(T554,1-T633,1);
T3388 = T552*T526*T629*T424*params(28)*params(13)*y(72)*T3370/(params(3)*T552);
T3393 = (-(T552*T526*T548*T424*params(28)*y(71)*params(13)*params(3)*T552*T3354))/(T557*params(3)*T552*T557*params(3)*T552);
T3426 = T554^T633*T552*params(3)*2*y(27)+T758*T3352*getPowerDeriv(T554,T633,1);
T3435 = T552*params(3)*T741*T3352*getPowerDeriv(T554,1+T556,1)+T767*T552*params(3)*params(26)*2*y(27);
T3442 = (-(T552*T526*T548*T424*params(13)*params(28)*T552*T3354))/(T552*T557*T552*T557);
T3483 = T552*T526*T629*T424*params(28)*params(13)*y(105)*T3370/(params(3)*T552);
T3487 = (-(T552*T526*T548*T424*params(28)*params(13)*y(104)*params(3)*T552*T3354))/(T557*params(3)*T552*T557*params(3)*T552);
T3585 = T799*getPowerDeriv(T799,params(24)*(1+params(26))/params(26),1);
T3704 = getPowerDeriv(T68*exp((-y(41))),params(25),1)*T68*(-exp((-y(41))));
T3720 = (1+params(27))*T100*T68*params(30)*T108*T3704/params(27);
T3732 = T3720+(1+params(27))*(T492*T100*T108*params(30)*params(25)*exp(2*y(10))*(-exp((-y(41))))+T100*T108*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*getPowerDeriv(T68*exp((-y(41))),params(25)-1,1)*T68*(-exp((-y(41)))))/params(27);
T3778 = getPowerDeriv(T91*exp((-y(44))),params(24),1)*T91*(-exp((-y(44))));
T3786 = (1+params(26))*T552*T91*params(36)*T526*T3778/params(26);
T3798 = T3786+(1+params(26))*(T879*T552*T526*params(36)*params(24)*exp(2*y(24))*(-exp((-y(44))))+T552*T526*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*getPowerDeriv(T91*exp((-y(44))),params(24)-1,1)*T91*(-exp((-y(44)))))/params(26);
T3849 = (-(T112*T108*T55*params(4)*params(5)*T128/(y(13)*T100)))+T100*T108*T55*params(4)*params(5)*T128/T210;
T3859 = (-(T100*T108*params(5)*T128/(y(13)*T100)))+T100*T108*params(5)*T128/(T100*params(3)*y(13));
T3864 = T192*T108*T55*exp((-y(8)))*params(6)*params(31)/(1+params(6));
T3870 = T161*T55*exp((-y(9)))*params(32)*params(6)/(1+params(6));
T3889 = (-T143)+T100*T108*T55*params(4)*params(5)*params(29)*T128*T132/(T140*T232);
T3900 = (-((1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*params(5)*params(34)/(T367*T100*params(3)*T341)));
T3913 = (-(T226*T112*T108*T55*params(4)*params(5)*params(29)*T128*T220/T100))+T226*T100*T108*T55*params(4)*params(5)*params(29)*T128*T220/T232;
T3919 = T220-T226*T100*T108*T220*T128*params(5)*params(29)/(params(3)*T100);
T3925 = (-((T224-1)*T100*T108*T220*T128*params(29)*params(5)*params(34)/T381));
T3928 = T226*T100*T108*T220*T128*params(5)*params(29)/(params(3)*T100)-T226*T100*T108*T220*T128*params(5)*params(29)/T100;
T3943 = (-((1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)/(T341*T367)));
T3967 = (-(T530*T526*T78*T424*params(12)*params(13)/(y(27)*T552)))+T552*T526*T78*T424*params(12)*params(13)/T619;
T3977 = (-(T552*T526*T424*params(13)/(y(27)*T552)))+T552*T526*T424*params(13)/(T552*params(3)*y(27));
T3982 = T601*T526*T78*exp((-y(22)))*params(14)*params(37)/(1+params(14));
T3990 = T585*T78*exp((-y(23)))*params(38)*params(14)/(1+params(14));
T4007 = (-T560)+T526*T78*T424*params(12)*params(13)*params(28)*T548*T552/(T557*T641);
T4018 = (-((1+params(26))*(1+params(24))*T552*T526*T548*T424*params(28)*params(13)*params(39)/(T767*T552*params(3)*T741)));
T4031 = (-(T635*T530*T526*T78*T424*params(12)*params(13)*params(28)*T629/T552))+T635*T552*T526*T78*T424*params(12)*params(13)*params(28)*T629/T641;
T4037 = T629-T635*T552*T526*T629*T424*params(13)*params(28)/(params(3)*T552);
T4043 = (-((T633-1)*T552*T526*T629*T424*params(28)*params(13)*params(39)/T781));
T4046 = T635*T552*T526*T629*T424*params(13)*params(28)/(params(3)*T552)-T635*T552*T526*T629*T424*params(13)*params(28)/T552;
T4061 = (-((1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)/(T741*T767)));
lhs =y(112);
rhs =params(1)*y(5)+params(2)*y(6);
residual(1)= lhs-rhs;
lhs =y(113);
rhs =y(112)+y(113)*params(3);
residual(2)= lhs-rhs;
lhs =y(1);
rhs =y(5)+params(3)*y(1);
residual(3)= lhs-rhs;
lhs =y(2);
rhs =y(6)+params(3)*y(2);
residual(4)= lhs-rhs;
lhs =y(3);
rhs =y(13);
residual(5)= lhs-rhs;
lhs =y(4);
rhs =y(27);
residual(6)= lhs-rhs;
lhs =y(34);
rhs =y(17);
residual(7)= lhs-rhs;
lhs =y(35);
rhs =y(18);
residual(8)= lhs-rhs;
lhs =y(36);
rhs =y(12);
residual(9)= lhs-rhs;
lhs =y(37);
rhs =y(31);
residual(10)= lhs-rhs;
lhs =y(38);
rhs =y(32);
residual(11)= lhs-rhs;
lhs =y(39);
rhs =y(26);
residual(12)= lhs-rhs;
lhs =y(5);
rhs =T55^(1-params(4))/(1-params(4))-T74;
residual(13)= lhs-rhs;
lhs =y(6);
rhs =T78^(1-params(12))/(1-params(12))-T97;
residual(14)= lhs-rhs;
residual(15) = T55/T100+T55*y(57)-y(59)*T143-T163-T112*T55*params(4)*params(50)*y(78)*params(49)*params(51)*exp((-y(19)))+T194-T112*T108*T55*T128*params(4)*params(5)*y(54)/(y(13)*T100)+T100*T108*T55*T128*params(4)*params(5)*y(54)/T210-T112*T222*T226/T100+T226*T100*T222/T232+T244;
residual(16) = (-y(63))*exp(y(8))-exp(y(8))*y(57)*T251*T256*T265-T194;
residual(17) = y(65);
residual(18) = exp(y(17))*y(62)-params(3)*y(48)-T281;
residual(19) = y(48)-params(29)*y(62)*exp(y(34))/T140;
residual(20) = y(64)*exp(y(11))-y(63)*exp(y(11));
residual(21) = y(60)*T220+T132*y(58)*exp((-y(15)))-T311;
residual(22) = y(59)*T132-T132*y(58)*exp((-y(15)))-T322;
residual(23) = T163-T265*exp(y(9))*y(57)*T260*T327-exp(y(9))*y(75)*params(33);
residual(24) = params(29)*params(34)*y(61)/T345-T108*y(65)*exp((-y(36)))-y(46)+T100*T108*T128*params(5)*y(54)/T358-T369-T382-T395;
residual(25) = y(58)*T399*T403*T405+y(61)*T399*(params(29)-1)/T411-(params(29)-1)*(1+params(27))*(1+params(25))*y(62)*T399/T419;
residual(26) = y(56)*T424*exp(y(19))-T128*exp((-y(19)))*y(68)+T100*params(50)*y(78)*params(49)*params(51)*exp((-y(19)));
residual(27) = params(3)*(-y(49))-y(54)/T440;
residual(28) = y(49);
residual(29) = T311+T322+T108*y(55)*T446-y(59)*T460-T128*exp((-y(19)))*y(68)-params(3)*y(50)-T108*exp((-y(36)))*y(13)*y(65)-T100*T108*T128*params(5)*y(54)/(y(13)*T100)+T100*T108*T128*params(5)*y(54)/(T100*params(3)*y(13))-T226*T100*T108*T220*T128*params(29)*params(5)*y(60)/T100;
residual(30) = y(50)+T108*exp((-y(36)))*y(13)*y(65);
residual(31) = T68*y(63)-y(59)*T496-T68*y(60)*(1+params(35)*exp(y(42)))/params(27)-T68*y(64)*params(7)*exp(y(40))-T517/T279;
residual(32) = T78*y(69)-y(71)*T560+T530*T78*params(12)*y(78)*params(47)*params(48)-T587+T603-T530*T526*T78*T424*params(12)*params(13)*y(66)/(y(27)*T552)+T552*T526*T78*T424*params(12)*params(13)*y(66)/T619-T530*T631*T635/T552+T635*T552*T631/T641+T653;
residual(33) = (-y(75))*exp(y(22))-exp(y(22))*y(69)*T659*T664*T673-T603;
residual(34) = y(77);
residual(35) = exp(y(31))*y(74)-params(3)*y(51);
residual(36) = y(51)-params(28)*y(74)*exp(y(37))/T557;
residual(37) = y(76)*exp(y(25))-y(75)*exp(y(25));
residual(38) = y(72)*T629+T548*y(70)*exp((-y(29)))-T713;
residual(39) = y(71)*T548-T548*y(70)*exp((-y(29)))-T724;
residual(40) = T587-T673*exp(y(23))*y(69)*T668*T729-y(63)*exp(y(23))/params(33);
residual(41) = params(28)*params(39)*y(73)/T745-T526*y(77)*exp((-y(39)))-y(47)+T552*T526*T424*params(13)*y(66)/T758-T769-T782-T795;
residual(42) = y(70)*T799*T803*T805+y(73)*T799*(params(28)-1)/T811-(params(28)-1)*(1+params(26))*(1+params(24))*y(74)*T799/T819;
residual(43) = params(3)*(-y(52))-y(66)/T827;
residual(44) = y(52);
residual(45) = T713+T724+T526*y(67)*T833-y(71)*T847-params(3)*y(53)-y(56)*T424*exp(y(19))-T526*exp((-y(39)))*y(27)*y(77)-T552*T526*T424*params(13)*y(66)/(y(27)*T552)+T552*T526*T424*params(13)*y(66)/(T552*params(3)*y(27))-T635*T552*T526*T629*T424*params(28)*params(13)*y(72)/T552;
residual(46) = y(53)+T526*exp((-y(39)))*y(27)*y(77);
residual(47) = T91*y(75)-y(71)*T883-T91*y(72)*(1+params(40)*exp(y(45)))/params(26)-T91*y(76)*params(15)*exp(y(43));
residual(48) = y(46);
residual(49) = T55*y(90)-T143*y(92)-T161*T55*exp((-y(9)))*params(32)*params(6)*y(89)/(1+params(6))-T112*T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)*y(111)+T933-T112*T108*T55*T128*params(4)*params(5)*y(87)/(y(13)*T100)+T100*T108*T55*T128*params(4)*params(5)*y(87)/T210-T226*T112*T953/T100+T226*T100*T953/T232+T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)/(T140*T232);
residual(50) = exp(y(8))*(-y(96))-T265*T256*exp(y(8))*T251*y(90)-T933;
residual(51) = y(98);
residual(52) = exp(y(17))*y(95)-params(3)*y(81);
residual(53) = y(81)-exp(y(34))*params(29)*y(95)/T140;
residual(54) = exp(y(11))*y(97)-exp(y(11))*y(96);
residual(55) = T220*y(93)+T132*exp((-y(15)))*y(91)-T1012;
residual(56) = T132*y(92)-T132*exp((-y(15)))*y(91)-T1023;
residual(57) = T161*T55*exp((-y(9)))*params(32)*params(6)*y(89)/(1+params(6))-T265*T327*exp(y(9))*T260*y(90)-exp(y(9))*params(33)*y(108);
residual(58) = params(29)*params(34)*y(94)/T345-T108*exp((-y(36)))*y(98)-y(79)+T100*T108*T128*params(5)*y(87)/T358-T1055-T1064-T1074;
residual(59) = T405*T403*T399*y(91)+(params(29)-1)*T399*y(94)/T411-(params(29)-1)*(1+params(27))*(1+params(25))*T399*y(95)/T419;
residual(60) = exp(y(19))*T424*y(89)-T128*exp((-y(19)))*y(101)+T100*exp((-y(19)))*params(51)*params(50)*params(49)*y(111);
residual(61) = params(3)*(-y(82))-y(87)/T440;
residual(62) = y(82);
residual(63) = T1012+T1023+T446*T108*y(88)-T460*y(92)-T128*exp((-y(19)))*y(101)-params(3)*y(83)-T108*exp((-y(36)))*y(13)*y(98)-T100*T108*T128*params(5)*y(87)/(y(13)*T100)+T100*T108*T128*params(5)*y(87)/(T100*params(3)*y(13))-T226*T100*T108*T220*T128*params(29)*params(5)*y(93)/T100;
residual(64) = y(83)+T108*exp((-y(36)))*y(13)*y(98);
residual(65) = T68*y(96)-T496*y(92)-(1+params(35)*exp(y(42)))*T68*y(93)/params(27)-T68*exp(y(40))*params(7)*y(97);
residual(66) = T78/T552+T78*y(102)-T560*y(104)+T530*T78*y(111)*params(12)*params(47)*params(48)-T585*T78*exp((-y(23)))*y(101)*params(38)*params(14)/(1+params(14))+T1171-T530*T526*T78*T424*params(12)*params(13)*y(99)/(y(27)*T552)+T552*T526*T78*T424*params(12)*params(13)*y(99)/T619-T635*T530*T1190/T552+T635*T552*T1190/T641+T552*T526*T548*T78*T424*params(28)*params(12)*params(13)*y(104)/(T557*T641);
residual(67) = exp(y(22))*(-y(108))-T673*T664*exp(y(22))*T659*y(102)-T1171;
residual(68) = y(110);
residual(69) = exp(y(31))*y(107)-params(3)*y(84)-T1229;
residual(70) = y(84)-exp(y(37))*params(28)*y(107)/T557;
residual(71) = exp(y(25))*y(109)-exp(y(25))*y(108);
residual(72) = T629*y(105)+T548*exp((-y(29)))*y(103)-T1254;
residual(73) = T548*y(104)-T548*exp((-y(29)))*y(103)-T1265;
residual(74) = T585*T78*exp((-y(23)))*y(101)*params(38)*params(14)/(1+params(14))-T673*T729*exp(y(23))*T668*y(102)-exp(y(23))*y(96)/params(33);
residual(75) = params(28)*params(39)*y(106)/T745-T526*exp((-y(39)))*y(110)-y(80)+T552*T526*T424*params(13)*y(99)/T758-T1297-T1306-T1316;
residual(76) = T805*T803*T799*y(103)+(params(28)-1)*T799*y(106)/T811-(params(28)-1)*(1+params(26))*(1+params(24))*T799*y(107)/T819;
residual(77) = params(3)*(-y(85))-y(99)/T827;
residual(78) = y(85);
residual(79) = T1254+T1265+T833*T526*y(100)-T847*y(104)-params(3)*y(86)-exp(y(19))*T424*y(89)-T526*exp((-y(39)))*y(27)*y(110)-T552*T526*T424*params(13)*y(99)/(y(27)*T552)+T552*T526*T424*params(13)*y(99)/(T552*params(3)*y(27))-T635*T552*T526*T629*T424*params(28)*params(13)*y(105)/T552;
residual(80) = y(86)+T526*exp((-y(39)))*y(27)*y(110);
residual(81) = T91*y(108)-T883*y(104)-(1+params(40)*exp(y(45)))*T91*y(105)/params(26)-T91*exp(y(43))*params(15)*y(109)-T1377;
residual(82) = y(80);
lhs =1/(1+y(18));
rhs =params(5)*T1384/T1384/y(13);
residual(83)= lhs-rhs;
lhs =T108*T1390^T159;
rhs =1;
residual(84)= lhs-rhs;
lhs =exp(y(19))/T526;
rhs =T1396^T159;
residual(85)= lhs-rhs;
lhs =T55;
rhs =T264^(1+params(6));
residual(86)= lhs-rhs;
lhs =T399^(1+params(25)*T224);
rhs =T132/T220;
residual(87)= lhs-rhs;
lhs =T132;
rhs =T68*T1409/T1384+T132*T1413*T1417;
residual(88)= lhs-rhs;
lhs =T220;
rhs =T68*(1+params(35)*exp(y(42)))/params(27)+T220*T226*T1413;
residual(89)= lhs-rhs;
lhs =(1-params(29))*T399^T1429+params(29)*T137^T1429;
rhs =1;
residual(90)= lhs-rhs;
lhs =exp(y(17));
rhs =(1-params(29))*T399^T1416+exp(y(34))*params(29)*T1417;
residual(91)= lhs-rhs;
lhs =T68;
rhs =exp(y(8))+exp(y(11))+exp(y(23))*1/params(33);
residual(92)= lhs-rhs;
lhs =exp(y(11));
rhs =exp(y(40))*T68*params(7);
residual(93)= lhs-rhs;
lhs =y(20);
rhs =y(13)*T108/exp(y(36));
residual(94)= lhs-rhs;
lhs =1/(1+y(32));
rhs =params(13)*T1458/T1458/y(27);
residual(95)= lhs-rhs;
lhs =T526*T1464^T583;
rhs =1;
residual(96)= lhs-rhs;
lhs =1/exp(y(19))/T108;
rhs =T1471^T583;
residual(97)= lhs-rhs;
lhs =T78;
rhs =T672^(1+params(14));
residual(98)= lhs-rhs;
lhs =T799^(1+params(24)*T633);
rhs =T548/T629;
residual(99)= lhs-rhs;
lhs =T548;
rhs =T91*T1484/T1458+T548*T1488*T1492;
residual(100)= lhs-rhs;
lhs =T629;
rhs =T91*(1+params(40)*exp(y(45)))/params(26)+T629*T635*T1488;
residual(101)= lhs-rhs;
lhs =(1-params(28))*T799^T1504+params(28)*T554^T1504;
rhs =1;
residual(102)= lhs-rhs;
lhs =exp(y(31));
rhs =(1-params(28))*T799^T1491+exp(y(37))*params(28)*T1492;
residual(103)= lhs-rhs;
lhs =T91;
rhs =exp(y(22))+exp(y(25))+exp(y(9))*params(33);
residual(104)= lhs-rhs;
lhs =exp(y(25));
rhs =exp(y(43))*T91*params(15);
residual(105)= lhs-rhs;
lhs =y(33);
rhs =y(27)*T526/exp(y(39));
residual(106)= lhs-rhs;
lhs =params(48)*params(47)/T1457;
rhs =params(51)*params(50)*params(49)/exp(y(19))/T1383;
residual(107)= lhs-rhs;
lhs =y(40);
rhs =y(40)*params(8)+params(9)*x(1);
residual(108)= lhs-rhs;
lhs =y(41);
rhs =y(41)*params(10)+params(11)*x(2);
residual(109)= lhs-rhs;
lhs =y(42);
rhs =y(42)*params(22)+params(23)*x(6);
residual(110)= lhs-rhs;
lhs =y(43);
rhs =y(43)*params(16)+params(17)*x(3);
residual(111)= lhs-rhs;
lhs =y(44);
rhs =y(44)*params(18)+params(19)*x(4);
residual(112)= lhs-rhs;
lhs =y(45);
rhs =y(45)*params(20)+params(21)*x(5);
residual(113)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(113, 113);

  %
  % Jacobian matrix
  %

  g1(1,5)=(-params(1));
  g1(1,6)=(-params(2));
  g1(1,112)=1;
  g1(2,112)=(-1);
  g1(2,113)=1-params(3);
  g1(3,1)=1-params(3);
  g1(3,5)=(-1);
  g1(4,2)=1-params(3);
  g1(4,6)=(-1);
  g1(5,3)=1;
  g1(5,13)=(-1);
  g1(6,4)=1;
  g1(6,27)=(-1);
  g1(7,17)=(-1);
  g1(7,34)=1;
  g1(8,18)=(-1);
  g1(8,35)=1;
  g1(9,12)=(-1);
  g1(9,36)=1;
  g1(10,31)=(-1);
  g1(10,37)=1;
  g1(11,32)=(-1);
  g1(11,38)=1;
  g1(12,26)=(-1);
  g1(12,39)=1;
  g1(13,5)=1;
  g1(13,7)=(-(T55*getPowerDeriv(T55,1-params(4),1)/(1-params(4))));
  g1(13,10)=exp(y(17))*params(30)*exp(y(41))^(-params(25))*T68*getPowerDeriv(T68,1+params(25),1)/(1+params(25));
  g1(13,17)=T74;
  g1(13,41)=exp(y(17))*T70*params(30)*exp(y(41))*getPowerDeriv(exp(y(41)),(-params(25)),1)/(1+params(25));
  g1(14,6)=1;
  g1(14,21)=(-(T78*getPowerDeriv(T78,1-params(12),1)/(1-params(12))));
  g1(14,24)=exp(y(31))*params(36)*exp(y(44))^(-params(24))*T91*getPowerDeriv(T91,1+params(24),1)/(1+params(24));
  g1(14,31)=T97;
  g1(14,44)=exp(y(31))*T93*params(36)*exp(y(44))*getPowerDeriv(exp(y(44)),(-params(24)),1)/(1+params(24));
  g1(15,7)=T55*y(57)+(T55*T100-T55*T1586)/(T100*T100)-y(59)*T1608-T1615-(T112*T55*params(4)*params(50)*y(78)*params(49)*params(51)*exp((-y(19)))+T55*params(4)*params(50)*y(78)*params(49)*params(51)*exp((-y(19)))*T1594)+T1624-(y(13)*T100*(T112*T108*T55*T128*params(4)*params(5)*y(54)+T108*T55*T128*params(4)*params(5)*y(54)*T1594)-T112*T108*T55*T128*params(4)*params(5)*y(54)*y(13)*T1586)/(y(13)*T100*y(13)*T100)+(T210*(T100*T108*T55*T128*params(4)*params(5)*y(54)+T108*T55*T128*params(4)*params(5)*y(54)*T1586)-T100*T108*T55*T128*params(4)*params(5)*y(54)*params(3)*y(13)*T55*getPowerDeriv(T55,1+params(4),1))/(T210*T210)-(T100*T226*(T112*T222+T222*T1594)-T112*T222*T226*T1586)/(T100*T100)+(T232*T226*(T100*T222+T222*T1586)-T226*T100*T222*T1657)/(T232*T232)+(T140*T232*(T100*T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)+T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)*T1586)-T100*T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)*T140*T1657)/(T140*T232*T140*T232);
  g1(15,8)=T1916;
  g1(15,9)=(-T1971);
  g1(15,10)=(-(y(59)*T2024));
  g1(15,12)=T194+(-(y(59)*T2085))-T112*(T108*T55*T128*params(4)*params(5)*y(54)+T108*T55*params(4)*params(5)*y(54)*(-T128))/(y(13)*T100)+T100*(T108*T55*T128*params(4)*params(5)*y(54)+T108*T55*params(4)*params(5)*y(54)*(-T128))/T210-T226*T112*(T222+T108*T220*T55*params(29)*params(4)*params(5)*y(60)*(-T128))/T100+T226*T100*(T222+T108*T220*T55*params(29)*params(4)*params(5)*y(60)*(-T128))/T232+T100*(T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)+T108*T132*T55*params(29)*params(4)*y(59)*params(5)*(-T128))/(T140*T232);
  g1(15,13)=(-(y(59)*T2310))-(-(T100*T112*T108*T55*T128*params(4)*params(5)*y(54)))/(y(13)*T100*y(13)*T100)+(-(T100*T108*T55*T128*params(4)*params(5)*y(54)*T232))/(T210*T210)-T112*T222*T2322/T100+T100*T222*T2322/T232+(-(T100*T108*T132*T55*T128*params(29)*params(4)*y(59)*params(5)*T232*T2306))/(T140*T232*T140*T232);
  g1(15,14)=T244+(-(y(59)*T142));
  g1(15,15)=T226*T100*T222/T232+(-(T112*T222*T226/T100));
  g1(15,19)=(-(T112*T55*params(4)*params(50)*y(78)*params(49)*params(51)*(-exp((-y(19))))));
  g1(15,41)=(-(y(59)*(1+params(27))*T68*T55*params(4)*params(30)*T108*T112*T3704/params(27)));
  g1(15,54)=T3849;
  g1(15,55)=T3864;
  g1(15,56)=(-T3870);
  g1(15,57)=T55;
  g1(15,59)=T3889;
  g1(15,60)=T3913;
  g1(15,78)=(-(T112*T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)));
  g1(16,7)=(-T1624);
  g1(16,8)=(-y(63))*exp(y(8))-(T265*(exp(y(8))*y(57)*T251*T256+exp(y(8))*y(57)*T251*exp(y(8))*getPowerDeriv(exp(y(8)),T254-1,1))+exp(y(8))*y(57)*T251*T256*T1925)-T1916;
  g1(16,9)=(-(exp(y(8))*y(57)*T251*T256*T1976));
  g1(16,12)=(-T194);
  g1(16,55)=(-T3864);
  g1(16,57)=(-(T265*T256*exp(y(8))*T251));
  g1(16,63)=(-exp(y(8)));
  g1(17,65)=1;
  g1(18,10)=(-(params(30)*exp(y(17))*T68*getPowerDeriv(T68,1+params(25),1)/T280));
  g1(18,17)=exp(y(17))*y(62)-T281;
  g1(18,41)=(-((-(T70*params(30)*exp(y(17))*(1+params(25))*exp(y(41))*getPowerDeriv(exp(y(41)),params(25),1)))/(T280*T280)));
  g1(18,48)=(-params(3));
  g1(18,62)=exp(y(17));
  g1(19,13)=(-((-(params(29)*y(62)*exp(y(34))*T2306))/(T140*T140)));
  g1(19,34)=(-(params(29)*y(62)*exp(y(34))/T140));
  g1(19,48)=1;
  g1(19,62)=(-(params(29)*exp(y(34))/T140));
  g1(20,11)=y(64)*exp(y(11))-y(63)*exp(y(11));
  g1(20,63)=(-exp(y(11)));
  g1(20,64)=exp(y(11));
  g1(21,7)=(-T1681);
  g1(21,12)=(-T2127);
  g1(21,13)=(-T2340);
  g1(21,14)=T132*y(58)*exp((-y(15)));
  g1(21,15)=y(60)*T220+T132*y(58)*(-exp((-y(15))))-T311;
  g1(21,58)=T132*exp((-y(15)));
  g1(21,60)=T3919;
  g1(22,7)=(-T1689);
  g1(22,12)=(-T2134);
  g1(22,13)=(-T2345);
  g1(22,14)=y(59)*T132-T132*y(58)*exp((-y(15)))-T322;
  g1(22,15)=(-(T132*y(58)*(-exp((-y(15))))));
  g1(22,58)=(-(T132*exp((-y(15)))));
  g1(22,59)=T132-T100*T108*T132*T128*params(5)*params(29)/(T140*params(3)*T100);
  g1(23,7)=T1615;
  g1(23,8)=(-(exp(y(9))*y(57)*T260*T327*T1925));
  g1(23,9)=T1971-(exp(y(9))*y(57)*T260*T327*T1976+T265*(exp(y(9))*y(57)*T260*T327+exp(y(9))*y(57)*T260*exp(y(9))*getPowerDeriv(exp(y(9)),T254-1,1)))-exp(y(9))*y(75)*params(33);
  g1(23,56)=T3870;
  g1(23,57)=(-(T265*T327*T260*exp(y(9))));
  g1(23,75)=(-(exp(y(9))*params(33)));
  g1(24,7)=(T358*T108*T128*params(5)*y(54)*T1586-T100*T108*T128*params(5)*y(54)*T1692)/(T358*T358)-(T381*(T224-1)*T108*T220*T128*params(29)*y(60)*params(5)*params(34)*T1586-T100*T108*T220*T128*params(29)*y(60)*params(5)*params(34)*(T224-1)*T137^T224*T1692)/(T381*T381)-(T367*T100*params(3)*T341*(1+params(27))*(1+params(25))*T108*T132*T128*params(29)*y(59)*params(5)*params(34)*T1586-(1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*y(59)*params(5)*params(34)*T367*params(3)*T341*T1586)/(T367*T100*params(3)*T341*T367*T100*params(3)*T341);
  g1(24,12)=(-(T108*y(65)*exp((-y(36)))))+T100*(T108*T128*params(5)*y(54)+T108*params(5)*y(54)*(-T128))/T358-(T224-1)*T100*(T108*T220*T128*params(29)*y(60)*params(5)*params(34)+T108*T220*params(29)*y(60)*params(5)*params(34)*(-T128))/T381-(1+params(27))*(1+params(25))*T100*(T108*T132*T128*params(29)*y(59)*params(5)*params(34)+T108*T132*params(29)*y(59)*params(5)*params(34)*(-T128))/(T367*T100*params(3)*T341);
  g1(24,13)=(-(params(29)*params(34)*y(61)*(T344*params(27)*2*y(13)+T341*T2304*getPowerDeriv(T137,T343,1))))/(T345*T345)+(-(T100*T108*T128*params(5)*y(54)*T100*params(3)*2*y(13)))/(T358*T358)-(-((1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)*y(62)*(T367*params(27)*2*y(13)+T341*T2304*getPowerDeriv(T137,1+T139,1))))/(T341*T367*T341*T367)-(-(T100*T108*T220*T128*params(29)*y(60)*params(5)*params(34)*(T224-1)*T2378))/(T381*T381)-(-((1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*y(59)*params(5)*params(34)*T2387))/(T367*T100*params(3)*T341*T367*T100*params(3)*T341);
  g1(24,14)=(-T395);
  g1(24,15)=(-T382);
  g1(24,34)=(-T369);
  g1(24,36)=(-(T108*y(65)*(-exp((-y(36))))));
  g1(24,46)=(-1);
  g1(24,54)=T100*T108*params(5)*T128/T358;
  g1(24,59)=T3900;
  g1(24,60)=T3925;
  g1(24,61)=params(29)*params(34)/T345;
  g1(24,62)=T3943;
  g1(24,65)=(-(T108*exp((-y(36)))));
  g1(25,16)=T405*(y(58)*T399*T403+y(58)*T399*T2537)+(y(61)*T399*(params(29)-1)*T411-y(61)*T399*(params(29)-1)*params(27)*T399*getPowerDeriv(T399,T343,1))/(T411*T411)-((params(29)-1)*(1+params(27))*(1+params(25))*y(62)*T399*T419-(params(29)-1)*(1+params(27))*(1+params(25))*y(62)*T399*params(27)*T399*getPowerDeriv(T399,1+T139,1))/(T419*T419);
  g1(25,58)=T405*T399*T403;
  g1(25,61)=T399*(params(29)-1)/T411;
  g1(25,62)=(-((params(29)-1)*(1+params(27))*(1+params(25))*T399/T419));
  g1(26,7)=params(50)*y(78)*params(49)*params(51)*exp((-y(19)))*T1586;
  g1(26,12)=(-(exp((-y(19)))*y(68)*(-T128)));
  g1(26,19)=y(56)*T424*exp(y(19))-T128*y(68)*(-exp((-y(19))))+T100*params(50)*y(78)*params(49)*params(51)*(-exp((-y(19))));
  g1(26,26)=exp(y(19))*y(56)*(-T424);
  g1(26,56)=T424*exp(y(19));
  g1(26,68)=(-(T128*exp((-y(19)))));
  g1(26,78)=T100*exp((-y(19)))*params(51)*params(50)*params(49);
  g1(27,18)=(-((-(y(54)*2*(1+y(18))))/(T440*T440)));
  g1(27,49)=(-params(3));
  g1(27,54)=(-(1/T440));
  g1(28,49)=1;
  g1(29,7)=T1681+T1689+T108*y(55)*T1720-y(59)*T1731-(y(13)*T100*T108*T128*params(5)*y(54)*T1586-T100*T108*T128*params(5)*y(54)*y(13)*T1586)/(y(13)*T100*y(13)*T100)+(T100*params(3)*y(13)*T108*T128*params(5)*y(54)*T1586-T100*T108*T128*params(5)*y(54)*params(3)*y(13)*T1586)/(T100*params(3)*y(13)*T100*params(3)*y(13))-(T100*T226*T108*T220*T128*params(29)*params(5)*y(60)*T1586-T226*T100*T108*T220*T128*params(29)*params(5)*y(60)*T1586)/(T100*T100);
  g1(29,8)=T108*y(55)*T1933;
  g1(29,10)=(-(y(59)*T2033));
  g1(29,12)=T2127+T2134+T108*y(55)*T446-y(59)*T2168-exp((-y(19)))*y(68)*(-T128)-T108*exp((-y(36)))*y(13)*y(65)-T100*(T108*T128*params(5)*y(54)+T108*params(5)*y(54)*(-T128))/(y(13)*T100)+T100*(T108*T128*params(5)*y(54)+T108*params(5)*y(54)*(-T128))/(T100*params(3)*y(13))-T226*T100*(T108*T220*T128*params(29)*params(5)*y(60)+T108*T220*params(29)*params(5)*y(60)*(-T128))/T100;
  g1(29,13)=T2340+T2345+(-(y(59)*T2394))-T108*y(65)*exp((-y(36)))-(-(T100*T100*T108*T128*params(5)*y(54)))/(y(13)*T100*y(13)*T100)+(-(params(3)*T100*T100*T108*T128*params(5)*y(54)))/(T100*params(3)*y(13)*T100*params(3)*y(13))-T100*T108*T220*T128*params(29)*params(5)*y(60)*T2322/T100;
  g1(29,14)=T322-y(59)*T459;
  g1(29,15)=T311-T226*T100*T108*T220*T128*params(29)*params(5)*y(60)/T100;
  g1(29,19)=(-(T128*y(68)*(-exp((-y(19))))));
  g1(29,36)=(-(T108*y(13)*y(65)*(-exp((-y(36))))));
  g1(29,41)=(-(y(59)*T3720));
  g1(29,50)=(-params(3));
  g1(29,54)=T3859;
  g1(29,55)=T108*T446;
  g1(29,59)=T100*T108*T132*T128*params(5)*params(29)/(T140*params(3)*T100)-T460;
  g1(29,60)=T3928;
  g1(29,65)=(-(T108*y(13)*exp((-y(36)))));
  g1(29,68)=(-(T128*exp((-y(19)))));
  g1(30,12)=T108*exp((-y(36)))*y(13)*y(65);
  g1(30,13)=T108*y(65)*exp((-y(36)));
  g1(30,36)=T108*y(13)*y(65)*(-exp((-y(36))));
  g1(30,50)=1;
  g1(30,65)=T108*y(13)*exp((-y(36)));
  g1(31,7)=(-(y(59)*T1757));
  g1(31,10)=T68*y(63)-y(59)*T2048-T68*y(60)*(1+params(35)*exp(y(42)))/params(27)-T68*y(64)*params(7)*exp(y(40))-(T517+T68*params(30)*exp(y(17))*T68*getPowerDeriv(T68,params(25),1))/T279;
  g1(31,12)=(-(y(59)*T496));
  g1(31,17)=(-(T517/T279));
  g1(31,40)=(-(T68*y(64)*params(7)*exp(y(40))));
  g1(31,41)=(-(y(59)*T3732))-(-(T517*exp(y(41))*getPowerDeriv(exp(y(41)),params(25),1)))/(T279*T279);
  g1(31,42)=(-(T68*y(60)*params(35)*exp(y(42))/params(27)));
  g1(31,59)=(-T496);
  g1(31,60)=(-(T68*(1+params(35)*exp(y(42)))/params(27)));
  g1(31,63)=T68;
  g1(31,64)=(-(T68*params(7)*exp(y(40))));
  g1(32,21)=T78*y(69)-y(71)*T2653+T530*T78*params(12)*y(78)*params(47)*params(48)+T78*params(12)*y(78)*params(47)*params(48)*T2637-T2663+T2669-(y(27)*T552*(T530*T526*T78*T424*params(12)*params(13)*y(66)+T526*T78*T424*params(12)*params(13)*y(66)*T2637)-T530*T526*T78*T424*params(12)*params(13)*y(66)*y(27)*T2646)/(y(27)*T552*y(27)*T552)+(T619*(T552*T526*T78*T424*params(12)*params(13)*y(66)+T526*T78*T424*params(12)*params(13)*y(66)*T2646)-T552*T526*T78*T424*params(12)*params(13)*y(66)*params(3)*y(27)*T78*getPowerDeriv(T78,1+params(12),1))/(T619*T619)-(T552*T635*(T530*T631+T631*T2637)-T530*T631*T635*T2646)/(T552*T552)+(T641*T635*(T552*T631+T631*T2646)-T635*T552*T631*T2703)/(T641*T641)+(T557*T641*(T552*T526*T548*T78*T424*params(28)*params(12)*y(71)*params(13)+T526*T548*T78*T424*params(28)*params(12)*y(71)*params(13)*T2646)-T552*T526*T548*T78*T424*params(28)*params(12)*y(71)*params(13)*T557*T2703)/(T557*T641*T557*T641);
  g1(32,22)=T2964;
  g1(32,23)=(-T3019);
  g1(32,24)=(-(y(71)*T3072));
  g1(32,26)=T603+(-(y(71)*T3135))-T530*(T526*T78*T424*params(12)*params(13)*y(66)+T526*T78*params(12)*params(13)*y(66)*(-T424))/(y(27)*T552)+T552*(T526*T78*T424*params(12)*params(13)*y(66)+T526*T78*params(12)*params(13)*y(66)*(-T424))/T619-T635*T530*(T631+T526*T629*T78*params(28)*params(12)*params(13)*y(72)*(-T424))/T552+T635*T552*(T631+T526*T629*T78*params(28)*params(12)*params(13)*y(72)*(-T424))/T641+T552*(T526*T548*T78*T424*params(28)*params(12)*y(71)*params(13)+T526*T548*T78*params(28)*params(12)*y(71)*params(13)*(-T424))/(T557*T641);
  g1(32,27)=(-(y(71)*T3358))-(-(T552*T530*T526*T78*T424*params(12)*params(13)*y(66)))/(y(27)*T552*y(27)*T552)+(-(T552*T526*T78*T424*params(12)*params(13)*y(66)*T641))/(T619*T619)-T530*T631*T3370/T552+T552*T631*T3370/T641+(-(T552*T526*T548*T78*T424*params(28)*params(12)*y(71)*params(13)*T641*T3354))/(T557*T641*T557*T641);
  g1(32,28)=T653+(-(y(71)*T559));
  g1(32,29)=T635*T552*T631/T641+(-(T530*T631*T635/T552));
  g1(32,44)=(-(y(71)*(1+params(26))*T91*T78*params(12)*params(36)*T526*T530*T3778/params(26)));
  g1(32,66)=T3967;
  g1(32,67)=T3982;
  g1(32,68)=(-T3990);
  g1(32,69)=T78;
  g1(32,71)=T4007;
  g1(32,72)=T4031;
  g1(32,78)=T530*T78*params(12)*params(47)*params(48);
  g1(33,21)=(-T2669);
  g1(33,22)=(-y(75))*exp(y(22))-(T673*(exp(y(22))*y(69)*T659*T664+exp(y(22))*y(69)*T659*exp(y(22))*getPowerDeriv(exp(y(22)),T662-1,1))+exp(y(22))*y(69)*T659*T664*T2973)-T2964;
  g1(33,23)=(-(exp(y(22))*y(69)*T659*T664*T3024));
  g1(33,26)=(-T603);
  g1(33,67)=(-T3982);
  g1(33,69)=(-(T673*T664*exp(y(22))*T659));
  g1(33,75)=(-exp(y(22)));
  g1(34,77)=1;
  g1(35,31)=exp(y(31))*y(74);
  g1(35,51)=(-params(3));
  g1(35,74)=exp(y(31));
  g1(36,27)=(-((-(params(28)*y(74)*exp(y(37))*T3354))/(T557*T557)));
  g1(36,37)=(-(params(28)*y(74)*exp(y(37))/T557));
  g1(36,51)=1;
  g1(36,74)=(-(params(28)*exp(y(37))/T557));
  g1(37,25)=y(76)*exp(y(25))-y(75)*exp(y(25));
  g1(37,75)=(-exp(y(25)));
  g1(37,76)=exp(y(25));
  g1(38,21)=(-T2727);
  g1(38,26)=(-T3177);
  g1(38,27)=(-T3388);
  g1(38,28)=T548*y(70)*exp((-y(29)));
  g1(38,29)=y(72)*T629+T548*y(70)*(-exp((-y(29))))-T713;
  g1(38,70)=T548*exp((-y(29)));
  g1(38,72)=T4037;
  g1(39,21)=(-T2735);
  g1(39,26)=(-T3184);
  g1(39,27)=(-T3393);
  g1(39,28)=y(71)*T548-T548*y(70)*exp((-y(29)))-T724;
  g1(39,29)=(-(T548*y(70)*(-exp((-y(29))))));
  g1(39,70)=(-(T548*exp((-y(29)))));
  g1(39,71)=T548-T552*T526*T548*T424*params(13)*params(28)/(T557*params(3)*T552);
  g1(40,21)=T2663;
  g1(40,22)=(-(exp(y(23))*y(69)*T668*T729*T2973));
  g1(40,23)=T3019-(exp(y(23))*y(69)*T668*T729*T3024+T673*(exp(y(23))*y(69)*T668*T729+exp(y(23))*y(69)*T668*exp(y(23))*getPowerDeriv(exp(y(23)),T662-1,1)))-y(63)*exp(y(23))/params(33);
  g1(40,63)=(-(exp(y(23))/params(33)));
  g1(40,68)=T3990;
  g1(40,69)=(-(T673*T729*T668*exp(y(23))));
  g1(41,21)=(T758*T526*T424*params(13)*y(66)*T2646-T552*T526*T424*params(13)*y(66)*T2738)/(T758*T758)-(T781*(T633-1)*T526*T629*T424*params(28)*y(72)*params(13)*params(39)*T2646-T552*T526*T629*T424*params(28)*y(72)*params(13)*params(39)*(T633-1)*T554^T633*T2738)/(T781*T781)-(T767*T552*params(3)*T741*(1+params(26))*(1+params(24))*T526*T548*T424*params(28)*y(71)*params(13)*params(39)*T2646-(1+params(26))*(1+params(24))*T552*T526*T548*T424*params(28)*y(71)*params(13)*params(39)*T767*params(3)*T741*T2646)/(T767*T552*params(3)*T741*T767*T552*params(3)*T741);
  g1(41,26)=(-(T526*y(77)*exp((-y(39)))))+T552*(T526*T424*params(13)*y(66)+T526*params(13)*y(66)*(-T424))/T758-(T633-1)*T552*(T526*T629*T424*params(28)*y(72)*params(13)*params(39)+T526*T629*params(28)*y(72)*params(13)*params(39)*(-T424))/T781-(1+params(26))*(1+params(24))*T552*(T526*T548*T424*params(28)*y(71)*params(13)*params(39)+T526*T548*params(28)*y(71)*params(13)*params(39)*(-T424))/(T767*T552*params(3)*T741);
  g1(41,27)=(-(params(28)*params(39)*y(73)*(T744*params(26)*2*y(27)+T741*T3352*getPowerDeriv(T554,T743,1))))/(T745*T745)+(-(T552*T526*T424*params(13)*y(66)*T552*params(3)*2*y(27)))/(T758*T758)-(-((1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)*y(74)*(T767*params(26)*2*y(27)+T741*T3352*getPowerDeriv(T554,1+T556,1))))/(T741*T767*T741*T767)-(-(T552*T526*T629*T424*params(28)*y(72)*params(13)*params(39)*(T633-1)*T3426))/(T781*T781)-(-((1+params(26))*(1+params(24))*T552*T526*T548*T424*params(28)*y(71)*params(13)*params(39)*T3435))/(T767*T552*params(3)*T741*T767*T552*params(3)*T741);
  g1(41,28)=(-T795);
  g1(41,29)=(-T782);
  g1(41,37)=(-T769);
  g1(41,39)=(-(T526*y(77)*(-exp((-y(39))))));
  g1(41,47)=(-1);
  g1(41,66)=T552*T526*T424*params(13)/T758;
  g1(41,71)=T4018;
  g1(41,72)=T4043;
  g1(41,73)=params(28)*params(39)/T745;
  g1(41,74)=T4061;
  g1(41,77)=(-(T526*exp((-y(39)))));
  g1(42,30)=T805*(y(70)*T799*T803+y(70)*T799*T3585)+(y(73)*T799*(params(28)-1)*T811-y(73)*T799*(params(28)-1)*params(26)*T799*getPowerDeriv(T799,T743,1))/(T811*T811)-((params(28)-1)*(1+params(26))*(1+params(24))*y(74)*T799*T819-(params(28)-1)*(1+params(26))*(1+params(24))*y(74)*T799*params(26)*T799*getPowerDeriv(T799,1+T556,1))/(T819*T819);
  g1(42,70)=T805*T799*T803;
  g1(42,73)=T799*(params(28)-1)/T811;
  g1(42,74)=(-((params(28)-1)*(1+params(26))*(1+params(24))*T799/T819));
  g1(43,32)=(-((-(y(66)*2*(1+y(32))))/(T827*T827)));
  g1(43,52)=(-params(3));
  g1(43,66)=(-(1/T827));
  g1(44,52)=1;
  g1(45,19)=(-(y(56)*T424*exp(y(19))));
  g1(45,21)=T2727+T2735+T526*y(67)*T2765-y(71)*T2776-(y(27)*T552*T526*T424*params(13)*y(66)*T2646-T552*T526*T424*params(13)*y(66)*y(27)*T2646)/(y(27)*T552*y(27)*T552)+(T552*params(3)*y(27)*T526*T424*params(13)*y(66)*T2646-T552*T526*T424*params(13)*y(66)*params(3)*y(27)*T2646)/(T552*params(3)*y(27)*T552*params(3)*y(27))-(T552*T635*T526*T629*T424*params(28)*params(13)*y(72)*T2646-T635*T552*T526*T629*T424*params(28)*params(13)*y(72)*T2646)/(T552*T552);
  g1(45,22)=T526*y(67)*T2981;
  g1(45,24)=(-(y(71)*T3078));
  g1(45,26)=T3177+T3184+T526*y(67)*T833-y(71)*T3216-exp(y(19))*y(56)*(-T424)-T526*exp((-y(39)))*y(27)*y(77)-T552*(T526*T424*params(13)*y(66)+T526*params(13)*y(66)*(-T424))/(y(27)*T552)+T552*(T526*T424*params(13)*y(66)+T526*params(13)*y(66)*(-T424))/(T552*params(3)*y(27))-T635*T552*(T526*T629*T424*params(28)*params(13)*y(72)+T526*T629*params(28)*params(13)*y(72)*(-T424))/T552;
  g1(45,27)=T3388+T3393+(-(y(71)*T3442))-T526*y(77)*exp((-y(39)))-(-(T552*T552*T526*T424*params(13)*y(66)))/(y(27)*T552*y(27)*T552)+(-(params(3)*T552*T552*T526*T424*params(13)*y(66)))/(T552*params(3)*y(27)*T552*params(3)*y(27))-T552*T526*T629*T424*params(28)*params(13)*y(72)*T3370/T552;
  g1(45,28)=T724-y(71)*T846;
  g1(45,29)=T713-T635*T552*T526*T629*T424*params(28)*params(13)*y(72)/T552;
  g1(45,39)=(-(T526*y(27)*y(77)*(-exp((-y(39))))));
  g1(45,44)=(-(y(71)*T3786));
  g1(45,53)=(-params(3));
  g1(45,56)=(-(T424*exp(y(19))));
  g1(45,66)=T3977;
  g1(45,67)=T526*T833;
  g1(45,71)=T552*T526*T548*T424*params(13)*params(28)/(T557*params(3)*T552)-T847;
  g1(45,72)=T4046;
  g1(45,77)=(-(T526*y(27)*exp((-y(39)))));
  g1(46,26)=T526*exp((-y(39)))*y(27)*y(77);
  g1(46,27)=T526*y(77)*exp((-y(39)));
  g1(46,39)=T526*y(27)*y(77)*(-exp((-y(39))));
  g1(46,53)=1;
  g1(46,77)=T526*y(27)*exp((-y(39)));
  g1(47,21)=(-(y(71)*T2802));
  g1(47,24)=T91*y(75)-y(71)*T3093-T91*y(72)*(1+params(40)*exp(y(45)))/params(26)-T91*y(76)*params(15)*exp(y(43));
  g1(47,26)=(-(y(71)*T883));
  g1(47,43)=(-(T91*y(76)*params(15)*exp(y(43))));
  g1(47,44)=(-(y(71)*T3798));
  g1(47,45)=(-(T91*y(72)*params(40)*exp(y(45))/params(26)));
  g1(47,71)=(-T883);
  g1(47,72)=(-(T91*(1+params(40)*exp(y(45)))/params(26)));
  g1(47,75)=T91;
  g1(47,76)=(-(T91*params(15)*exp(y(43))));
  g1(48,46)=1;
  g1(49,7)=T55*y(90)-y(92)*T1608-T1764-(T112*T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)*y(111)+T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)*y(111)*T1594)+T1771-(y(13)*T100*(T112*T108*T55*T128*params(4)*params(5)*y(87)+T108*T55*T128*params(4)*params(5)*y(87)*T1594)-T112*T108*T55*T128*params(4)*params(5)*y(87)*y(13)*T1586)/(y(13)*T100*y(13)*T100)+(T210*(T100*T108*T55*T128*params(4)*params(5)*y(87)+T108*T55*T128*params(4)*params(5)*y(87)*T1586)-T100*T108*T55*T128*params(4)*params(5)*y(87)*params(3)*y(13)*T55*getPowerDeriv(T55,1+params(4),1))/(T210*T210)-(T100*T226*(T112*T953+T953*T1594)-T226*T112*T953*T1586)/(T100*T100)+(T232*T226*(T100*T953+T953*T1586)-T226*T100*T953*T1657)/(T232*T232)+(T140*T232*(T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)+T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)*T1586)-T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)*T140*T1657)/(T140*T232*T140*T232);
  g1(49,8)=T1941;
  g1(49,9)=(-T1993);
  g1(49,10)=(-(y(92)*T2024));
  g1(49,12)=T933+(-(y(92)*T2085))-T112*(T108*T55*T128*params(4)*params(5)*y(87)+T108*T55*params(4)*params(5)*y(87)*(-T128))/(y(13)*T100)+T100*(T108*T55*T128*params(4)*params(5)*y(87)+T108*T55*params(4)*params(5)*y(87)*(-T128))/T210-T226*T112*(T953+T108*T220*T55*params(29)*params(4)*params(5)*y(93)*(-T128))/T100+T226*T100*(T953+T108*T220*T55*params(29)*params(4)*params(5)*y(93)*(-T128))/T232+T100*(T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)+T108*T132*T55*params(29)*params(4)*params(5)*y(92)*(-T128))/(T140*T232);
  g1(49,13)=(-(y(92)*T2310))-(-(T100*T112*T108*T55*T128*params(4)*params(5)*y(87)))/(y(13)*T100*y(13)*T100)+(-(T232*T100*T108*T55*T128*params(4)*params(5)*y(87)))/(T210*T210)-T112*T953*T2322/T100+T100*T953*T2322/T232+(-(T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)*T232*T2306))/(T140*T232*T140*T232);
  g1(49,14)=T100*T108*T132*T55*T128*params(29)*params(4)*params(5)*y(92)/(T140*T232)+(-(T142*y(92)));
  g1(49,15)=T226*T100*T953/T232+(-(T226*T112*T953/T100));
  g1(49,19)=(-(T112*T55*params(4)*params(51)*params(50)*params(49)*y(111)*(-exp((-y(19))))));
  g1(49,41)=(-(y(92)*(1+params(27))*T68*T55*params(4)*params(30)*T108*T112*T3704/params(27)));
  g1(49,87)=T3849;
  g1(49,88)=T3864;
  g1(49,89)=(-T3870);
  g1(49,90)=T55;
  g1(49,92)=T3889;
  g1(49,93)=T3913;
  g1(49,111)=(-(T112*T55*exp((-y(19)))*params(4)*params(51)*params(50)*params(49)));
  g1(50,7)=(-T1771);
  g1(50,8)=exp(y(8))*(-y(96))-(T256*exp(y(8))*T251*y(90)*T1925+T265*(T256*exp(y(8))*T251*y(90)+exp(y(8))*T251*y(90)*exp(y(8))*getPowerDeriv(exp(y(8)),T254-1,1)))-T1941;
  g1(50,9)=(-(T256*exp(y(8))*T251*y(90)*T1976));
  g1(50,12)=(-T933);
  g1(50,88)=(-T3864);
  g1(50,90)=(-(T265*T256*exp(y(8))*T251));
  g1(50,96)=(-exp(y(8)));
  g1(51,98)=1;
  g1(52,17)=exp(y(17))*y(95);
  g1(52,81)=(-params(3));
  g1(52,95)=exp(y(17));
  g1(53,13)=(-((-(exp(y(34))*params(29)*y(95)*T2306))/(T140*T140)));
  g1(53,34)=(-(exp(y(34))*params(29)*y(95)/T140));
  g1(53,81)=1;
  g1(53,95)=(-(params(29)*exp(y(34))/T140));
  g1(54,11)=exp(y(11))*y(97)-exp(y(11))*y(96);
  g1(54,96)=(-exp(y(11)));
  g1(54,97)=exp(y(11));
  g1(55,7)=(-T1816);
  g1(55,12)=(-T2223);
  g1(55,13)=(-T2435);
  g1(55,14)=T132*exp((-y(15)))*y(91);
  g1(55,15)=T220*y(93)+T132*y(91)*(-exp((-y(15))))-T1012;
  g1(55,91)=T132*exp((-y(15)));
  g1(55,93)=T3919;
  g1(56,7)=(-T1822);
  g1(56,12)=(-T2230);
  g1(56,13)=(-T2439);
  g1(56,14)=T132*y(92)-T132*exp((-y(15)))*y(91)-T1023;
  g1(56,15)=(-(T132*y(91)*(-exp((-y(15))))));
  g1(56,91)=(-(T132*exp((-y(15)))));
  g1(56,92)=T132-T100*T108*T132*T128*params(5)*params(29)/(T140*params(3)*T100);
  g1(57,7)=T1764;
  g1(57,8)=(-(T327*exp(y(9))*T260*y(90)*T1925));
  g1(57,9)=T1993-(T327*exp(y(9))*T260*y(90)*T1976+T265*(T327*exp(y(9))*T260*y(90)+exp(y(9))*T260*y(90)*exp(y(9))*getPowerDeriv(exp(y(9)),T254-1,1)))-exp(y(9))*params(33)*y(108);
  g1(57,89)=T3870;
  g1(57,90)=(-(T265*T327*T260*exp(y(9))));
  g1(57,108)=(-(exp(y(9))*params(33)));
  g1(58,7)=(T358*T108*T128*params(5)*y(87)*T1586-T100*T108*T128*params(5)*y(87)*T1692)/(T358*T358)-(T381*(T224-1)*T108*T220*T128*params(29)*params(5)*params(34)*y(93)*T1586-(T224-1)*T100*T108*T220*T128*params(29)*params(5)*params(34)*y(93)*T137^T224*T1692)/(T381*T381)-(T367*T100*params(3)*T341*(1+params(27))*(1+params(25))*T108*T132*T128*params(29)*params(5)*params(34)*y(92)*T1586-(1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*params(5)*params(34)*y(92)*T367*params(3)*T341*T1586)/(T367*T100*params(3)*T341*T367*T100*params(3)*T341);
  g1(58,12)=(-(T108*exp((-y(36)))*y(98)))+T100*(T108*T128*params(5)*y(87)+T108*params(5)*y(87)*(-T128))/T358-(T224-1)*T100*(T108*T220*T128*params(29)*params(5)*params(34)*y(93)+T108*T220*params(29)*params(5)*params(34)*y(93)*(-T128))/T381-(1+params(27))*(1+params(25))*T100*(T108*T132*T128*params(29)*params(5)*params(34)*y(92)+T108*T132*params(29)*params(5)*params(34)*y(92)*(-T128))/(T367*T100*params(3)*T341);
  g1(58,13)=(-(params(29)*params(34)*y(94)*(T344*params(27)*2*y(13)+T341*T2304*getPowerDeriv(T137,T343,1))))/(T345*T345)+(-(T100*T108*T128*params(5)*y(87)*T100*params(3)*2*y(13)))/(T358*T358)-(-((1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)*y(95)*(T367*params(27)*2*y(13)+T341*T2304*getPowerDeriv(T137,1+T139,1))))/(T341*T367*T341*T367)-(-((T224-1)*T100*T108*T220*T128*params(29)*params(5)*params(34)*y(93)*T2378))/(T381*T381)-(-((1+params(27))*(1+params(25))*T100*T108*T132*T128*params(29)*params(5)*params(34)*y(92)*T2387))/(T367*T100*params(3)*T341*T367*T100*params(3)*T341);
  g1(58,14)=(-T1074);
  g1(58,15)=(-T1064);
  g1(58,34)=(-T1055);
  g1(58,36)=(-(T108*y(98)*(-exp((-y(36))))));
  g1(58,79)=(-1);
  g1(58,87)=T100*T108*params(5)*T128/T358;
  g1(58,92)=T3900;
  g1(58,93)=T3925;
  g1(58,94)=params(29)*params(34)/T345;
  g1(58,95)=T3943;
  g1(58,98)=(-(T108*exp((-y(36)))));
  g1(59,16)=T405*(T403*T399*y(91)+T399*y(91)*T2537)+(T411*(params(29)-1)*T399*y(94)-(params(29)-1)*T399*y(94)*params(27)*T399*getPowerDeriv(T399,T343,1))/(T411*T411)-(T419*(params(29)-1)*(1+params(27))*(1+params(25))*T399*y(95)-(params(29)-1)*(1+params(27))*(1+params(25))*T399*y(95)*params(27)*T399*getPowerDeriv(T399,1+T139,1))/(T419*T419);
  g1(59,91)=T405*T399*T403;
  g1(59,94)=T399*(params(29)-1)/T411;
  g1(59,95)=(-((params(29)-1)*(1+params(27))*(1+params(25))*T399/T419));
  g1(60,7)=exp((-y(19)))*params(51)*params(50)*params(49)*y(111)*T1586;
  g1(60,12)=(-(exp((-y(19)))*y(101)*(-T128)));
  g1(60,19)=exp(y(19))*T424*y(89)-T128*y(101)*(-exp((-y(19))))+T100*params(51)*params(50)*params(49)*y(111)*(-exp((-y(19))));
  g1(60,26)=exp(y(19))*y(89)*(-T424);
  g1(60,89)=T424*exp(y(19));
  g1(60,101)=(-(T128*exp((-y(19)))));
  g1(60,111)=T100*exp((-y(19)))*params(51)*params(50)*params(49);
  g1(61,18)=(-((-(y(87)*2*(1+y(18))))/(T440*T440)));
  g1(61,82)=(-params(3));
  g1(61,87)=(-(1/T440));
  g1(62,82)=1;
  g1(63,7)=T1816+T1822+T108*y(88)*T1720-y(92)*T1731-(y(13)*T100*T108*T128*params(5)*y(87)*T1586-T100*T108*T128*params(5)*y(87)*y(13)*T1586)/(y(13)*T100*y(13)*T100)+(T100*params(3)*y(13)*T108*T128*params(5)*y(87)*T1586-T100*T108*T128*params(5)*y(87)*params(3)*y(13)*T1586)/(T100*params(3)*y(13)*T100*params(3)*y(13))-(T100*T226*T108*T220*T128*params(29)*params(5)*y(93)*T1586-T226*T100*T108*T220*T128*params(29)*params(5)*y(93)*T1586)/(T100*T100);
  g1(63,8)=T108*y(88)*T1933;
  g1(63,10)=(-(y(92)*T2033));
  g1(63,12)=T2223+T2230+T446*T108*y(88)-y(92)*T2168-exp((-y(19)))*y(101)*(-T128)-T108*exp((-y(36)))*y(13)*y(98)-T100*(T108*T128*params(5)*y(87)+T108*params(5)*y(87)*(-T128))/(y(13)*T100)+T100*(T108*T128*params(5)*y(87)+T108*params(5)*y(87)*(-T128))/(T100*params(3)*y(13))-T226*T100*(T108*T220*T128*params(29)*params(5)*y(93)+T108*T220*params(29)*params(5)*y(93)*(-T128))/T100;
  g1(63,13)=T2435+T2439+(-(y(92)*T2394))-T108*exp((-y(36)))*y(98)-(-(T100*T100*T108*T128*params(5)*y(87)))/(y(13)*T100*y(13)*T100)+(-(params(3)*T100*T100*T108*T128*params(5)*y(87)))/(T100*params(3)*y(13)*T100*params(3)*y(13))-T100*T108*T220*T128*params(29)*params(5)*y(93)*T2322/T100;
  g1(63,14)=T1023-T459*y(92);
  g1(63,15)=T1012-T226*T100*T108*T220*T128*params(29)*params(5)*y(93)/T100;
  g1(63,19)=(-(T128*y(101)*(-exp((-y(19))))));
  g1(63,36)=(-(T108*y(13)*y(98)*(-exp((-y(36))))));
  g1(63,41)=(-(y(92)*T3720));
  g1(63,83)=(-params(3));
  g1(63,87)=T3859;
  g1(63,88)=T108*T446;
  g1(63,92)=T100*T108*T132*T128*params(5)*params(29)/(T140*params(3)*T100)-T460;
  g1(63,93)=T3928;
  g1(63,98)=(-(T108*y(13)*exp((-y(36)))));
  g1(63,101)=(-(T128*exp((-y(19)))));
  g1(64,12)=T108*exp((-y(36)))*y(13)*y(98);
  g1(64,13)=T108*exp((-y(36)))*y(98);
  g1(64,36)=T108*y(13)*y(98)*(-exp((-y(36))));
  g1(64,83)=1;
  g1(64,98)=T108*y(13)*exp((-y(36)));
  g1(65,7)=(-(y(92)*T1757));
  g1(65,10)=T68*y(96)-y(92)*T2048-(1+params(35)*exp(y(42)))*T68*y(93)/params(27)-T68*exp(y(40))*params(7)*y(97);
  g1(65,12)=(-(T496*y(92)));
  g1(65,40)=(-(T68*exp(y(40))*params(7)*y(97)));
  g1(65,41)=(-(y(92)*T3732));
  g1(65,42)=(-(params(35)*exp(y(42))*T68*y(93)/params(27)));
  g1(65,92)=(-T496);
  g1(65,93)=(-(T68*(1+params(35)*exp(y(42)))/params(27)));
  g1(65,96)=T68;
  g1(65,97)=(-(T68*params(7)*exp(y(40))));
  g1(66,21)=T78*y(102)+(T78*T552-T78*T2646)/(T552*T552)-y(104)*T2653+T530*T78*y(111)*params(12)*params(47)*params(48)+T78*y(111)*params(12)*params(47)*params(48)*T2637-T2817+T2821-(y(27)*T552*(T530*T526*T78*T424*params(12)*params(13)*y(99)+T526*T78*T424*params(12)*params(13)*y(99)*T2637)-T530*T526*T78*T424*params(12)*params(13)*y(99)*y(27)*T2646)/(y(27)*T552*y(27)*T552)+(T619*(T552*T526*T78*T424*params(12)*params(13)*y(99)+T526*T78*T424*params(12)*params(13)*y(99)*T2646)-T552*T526*T78*T424*params(12)*params(13)*y(99)*params(3)*y(27)*T78*getPowerDeriv(T78,1+params(12),1))/(T619*T619)-(T552*T635*(T530*T1190+T1190*T2637)-T635*T530*T1190*T2646)/(T552*T552)+(T641*T635*(T552*T1190+T1190*T2646)-T635*T552*T1190*T2703)/(T641*T641)+(T557*T641*(T552*T526*T548*T78*T424*params(28)*params(12)*params(13)*y(104)+T526*T548*T78*T424*params(28)*params(12)*params(13)*y(104)*T2646)-T552*T526*T548*T78*T424*params(28)*params(12)*params(13)*y(104)*T557*T2703)/(T557*T641*T557*T641);
  g1(66,22)=T2989;
  g1(66,23)=(-T3041);
  g1(66,24)=(-(y(104)*T3072));
  g1(66,26)=T1171+(-(y(104)*T3135))-T530*(T526*T78*T424*params(12)*params(13)*y(99)+T526*T78*params(12)*params(13)*y(99)*(-T424))/(y(27)*T552)+T552*(T526*T78*T424*params(12)*params(13)*y(99)+T526*T78*params(12)*params(13)*y(99)*(-T424))/T619-T635*T530*(T1190+T526*T629*T78*params(28)*params(12)*params(13)*y(105)*(-T424))/T552+T635*T552*(T1190+T526*T629*T78*params(28)*params(12)*params(13)*y(105)*(-T424))/T641+T552*(T526*T548*T78*T424*params(28)*params(12)*params(13)*y(104)+T526*T548*T78*params(28)*params(12)*params(13)*y(104)*(-T424))/(T557*T641);
  g1(66,27)=(-(y(104)*T3358))-(-(T552*T530*T526*T78*T424*params(12)*params(13)*y(99)))/(y(27)*T552*y(27)*T552)+(-(T641*T552*T526*T78*T424*params(12)*params(13)*y(99)))/(T619*T619)-T530*T1190*T3370/T552+T552*T1190*T3370/T641+(-(T552*T526*T548*T78*T424*params(28)*params(12)*params(13)*y(104)*T641*T3354))/(T557*T641*T557*T641);
  g1(66,28)=T552*T526*T548*T78*T424*params(28)*params(12)*params(13)*y(104)/(T557*T641)+(-(T559*y(104)));
  g1(66,29)=T635*T552*T1190/T641+(-(T635*T530*T1190/T552));
  g1(66,44)=(-(y(104)*(1+params(26))*T91*T78*params(12)*params(36)*T526*T530*T3778/params(26)));
  g1(66,99)=T3967;
  g1(66,100)=T3982;
  g1(66,101)=(-T3990);
  g1(66,102)=T78;
  g1(66,104)=T4007;
  g1(66,105)=T4031;
  g1(66,111)=T530*T78*params(12)*params(47)*params(48);
  g1(67,21)=(-T2821);
  g1(67,22)=exp(y(22))*(-y(108))-(T664*exp(y(22))*T659*y(102)*T2973+T673*(T664*exp(y(22))*T659*y(102)+exp(y(22))*T659*y(102)*exp(y(22))*getPowerDeriv(exp(y(22)),T662-1,1)))-T2989;
  g1(67,23)=(-(T664*exp(y(22))*T659*y(102)*T3024));
  g1(67,26)=(-T1171);
  g1(67,100)=(-T3982);
  g1(67,102)=(-(T673*T664*exp(y(22))*T659));
  g1(67,108)=(-exp(y(22)));
  g1(68,110)=1;
  g1(69,24)=(-(params(36)*exp(y(31))*T91*getPowerDeriv(T91,1+params(24),1)/T1228));
  g1(69,31)=exp(y(31))*y(107)-T1229;
  g1(69,44)=(-((-(T93*params(36)*exp(y(31))*(1+params(24))*exp(y(44))*getPowerDeriv(exp(y(44)),params(24),1)))/(T1228*T1228)));
  g1(69,84)=(-params(3));
  g1(69,107)=exp(y(31));
  g1(70,27)=(-((-(exp(y(37))*params(28)*y(107)*T3354))/(T557*T557)));
  g1(70,37)=(-(exp(y(37))*params(28)*y(107)/T557));
  g1(70,84)=1;
  g1(70,107)=(-(params(28)*exp(y(37))/T557));
  g1(71,25)=exp(y(25))*y(109)-exp(y(25))*y(108);
  g1(71,108)=(-exp(y(25)));
  g1(71,109)=exp(y(25));
  g1(72,21)=(-T2866);
  g1(72,26)=(-T3273);
  g1(72,27)=(-T3483);
  g1(72,28)=T548*exp((-y(29)))*y(103);
  g1(72,29)=T629*y(105)+T548*y(103)*(-exp((-y(29))))-T1254;
  g1(72,103)=T548*exp((-y(29)));
  g1(72,105)=T4037;
  g1(73,21)=(-T2872);
  g1(73,26)=(-T3280);
  g1(73,27)=(-T3487);
  g1(73,28)=T548*y(104)-T548*exp((-y(29)))*y(103)-T1265;
  g1(73,29)=(-(T548*y(103)*(-exp((-y(29))))));
  g1(73,103)=(-(T548*exp((-y(29)))));
  g1(73,104)=T548-T552*T526*T548*T424*params(13)*params(28)/(T557*params(3)*T552);
  g1(74,21)=T2817;
  g1(74,22)=(-(T729*exp(y(23))*T668*y(102)*T2973));
  g1(74,23)=T3041-(T729*exp(y(23))*T668*y(102)*T3024+T673*(T729*exp(y(23))*T668*y(102)+exp(y(23))*T668*y(102)*exp(y(23))*getPowerDeriv(exp(y(23)),T662-1,1)))-exp(y(23))*y(96)/params(33);
  g1(74,96)=(-(exp(y(23))/params(33)));
  g1(74,101)=T3990;
  g1(74,102)=(-(T673*T729*T668*exp(y(23))));
  g1(75,21)=(T758*T526*T424*params(13)*y(99)*T2646-T552*T526*T424*params(13)*y(99)*T2738)/(T758*T758)-(T781*(T633-1)*T526*T629*T424*params(28)*params(13)*params(39)*y(105)*T2646-(T633-1)*T552*T526*T629*T424*params(28)*params(13)*params(39)*y(105)*T554^T633*T2738)/(T781*T781)-(T767*T552*params(3)*T741*(1+params(26))*(1+params(24))*T526*T548*T424*params(28)*params(13)*params(39)*y(104)*T2646-(1+params(26))*(1+params(24))*T552*T526*T548*T424*params(28)*params(13)*params(39)*y(104)*T767*params(3)*T741*T2646)/(T767*T552*params(3)*T741*T767*T552*params(3)*T741);
  g1(75,26)=(-(T526*exp((-y(39)))*y(110)))+T552*(T526*T424*params(13)*y(99)+T526*params(13)*y(99)*(-T424))/T758-(T633-1)*T552*(T526*T629*T424*params(28)*params(13)*params(39)*y(105)+T526*T629*params(28)*params(13)*params(39)*y(105)*(-T424))/T781-(1+params(26))*(1+params(24))*T552*(T526*T548*T424*params(28)*params(13)*params(39)*y(104)+T526*T548*params(28)*params(13)*params(39)*y(104)*(-T424))/(T767*T552*params(3)*T741);
  g1(75,27)=(-(params(28)*params(39)*y(106)*(T744*params(26)*2*y(27)+T741*T3352*getPowerDeriv(T554,T743,1))))/(T745*T745)+(-(T552*T526*T424*params(13)*y(99)*T552*params(3)*2*y(27)))/(T758*T758)-(-((1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)*y(107)*(T767*params(26)*2*y(27)+T741*T3352*getPowerDeriv(T554,1+T556,1))))/(T741*T767*T741*T767)-(-((T633-1)*T552*T526*T629*T424*params(28)*params(13)*params(39)*y(105)*T3426))/(T781*T781)-(-((1+params(26))*(1+params(24))*T552*T526*T548*T424*params(28)*params(13)*params(39)*y(104)*T3435))/(T767*T552*params(3)*T741*T767*T552*params(3)*T741);
  g1(75,28)=(-T1316);
  g1(75,29)=(-T1306);
  g1(75,37)=(-T1297);
  g1(75,39)=(-(T526*y(110)*(-exp((-y(39))))));
  g1(75,80)=(-1);
  g1(75,99)=T552*T526*T424*params(13)/T758;
  g1(75,104)=T4018;
  g1(75,105)=T4043;
  g1(75,106)=params(28)*params(39)/T745;
  g1(75,107)=T4061;
  g1(75,110)=(-(T526*exp((-y(39)))));
  g1(76,30)=T805*(T803*T799*y(103)+T799*y(103)*T3585)+(T811*(params(28)-1)*T799*y(106)-(params(28)-1)*T799*y(106)*params(26)*T799*getPowerDeriv(T799,T743,1))/(T811*T811)-(T819*(params(28)-1)*(1+params(26))*(1+params(24))*T799*y(107)-(params(28)-1)*(1+params(26))*(1+params(24))*T799*y(107)*params(26)*T799*getPowerDeriv(T799,1+T556,1))/(T819*T819);
  g1(76,103)=T805*T799*T803;
  g1(76,106)=T799*(params(28)-1)/T811;
  g1(76,107)=(-((params(28)-1)*(1+params(26))*(1+params(24))*T799/T819));
  g1(77,32)=(-((-(y(99)*2*(1+y(32))))/(T827*T827)));
  g1(77,85)=(-params(3));
  g1(77,99)=(-(1/T827));
  g1(78,85)=1;
  g1(79,19)=(-(exp(y(19))*T424*y(89)));
  g1(79,21)=T2866+T2872+T526*y(100)*T2765-y(104)*T2776-(y(27)*T552*T526*T424*params(13)*y(99)*T2646-T552*T526*T424*params(13)*y(99)*y(27)*T2646)/(y(27)*T552*y(27)*T552)+(T552*params(3)*y(27)*T526*T424*params(13)*y(99)*T2646-T552*T526*T424*params(13)*y(99)*params(3)*y(27)*T2646)/(T552*params(3)*y(27)*T552*params(3)*y(27))-(T552*T635*T526*T629*T424*params(28)*params(13)*y(105)*T2646-T635*T552*T526*T629*T424*params(28)*params(13)*y(105)*T2646)/(T552*T552);
  g1(79,22)=T526*y(100)*T2981;
  g1(79,24)=(-(y(104)*T3078));
  g1(79,26)=T3273+T3280+T833*T526*y(100)-y(104)*T3216-exp(y(19))*y(89)*(-T424)-T526*exp((-y(39)))*y(27)*y(110)-T552*(T526*T424*params(13)*y(99)+T526*params(13)*y(99)*(-T424))/(y(27)*T552)+T552*(T526*T424*params(13)*y(99)+T526*params(13)*y(99)*(-T424))/(T552*params(3)*y(27))-T635*T552*(T526*T629*T424*params(28)*params(13)*y(105)+T526*T629*params(28)*params(13)*y(105)*(-T424))/T552;
  g1(79,27)=T3483+T3487+(-(y(104)*T3442))-T526*exp((-y(39)))*y(110)-(-(T552*T552*T526*T424*params(13)*y(99)))/(y(27)*T552*y(27)*T552)+(-(params(3)*T552*T552*T526*T424*params(13)*y(99)))/(T552*params(3)*y(27)*T552*params(3)*y(27))-T552*T526*T629*T424*params(28)*params(13)*y(105)*T3370/T552;
  g1(79,28)=T1265-T846*y(104);
  g1(79,29)=T1254-T635*T552*T526*T629*T424*params(28)*params(13)*y(105)/T552;
  g1(79,39)=(-(T526*y(27)*y(110)*(-exp((-y(39))))));
  g1(79,44)=(-(y(104)*T3786));
  g1(79,86)=(-params(3));
  g1(79,89)=(-(T424*exp(y(19))));
  g1(79,99)=T3977;
  g1(79,100)=T526*T833;
  g1(79,104)=T552*T526*T548*T424*params(13)*params(28)/(T557*params(3)*T552)-T847;
  g1(79,105)=T4046;
  g1(79,110)=(-(T526*y(27)*exp((-y(39)))));
  g1(80,26)=T526*exp((-y(39)))*y(27)*y(110);
  g1(80,27)=T526*exp((-y(39)))*y(110);
  g1(80,39)=T526*y(27)*y(110)*(-exp((-y(39))));
  g1(80,86)=1;
  g1(80,110)=T526*y(27)*exp((-y(39)));
  g1(81,21)=(-(y(104)*T2802));
  g1(81,24)=T91*y(108)-y(104)*T3093-(1+params(40)*exp(y(45)))*T91*y(105)/params(26)-T91*exp(y(43))*params(15)*y(109)-(T1376+T91*params(36)*exp(y(31))*T91*getPowerDeriv(T91,params(24),1))/T1227;
  g1(81,26)=(-(T883*y(104)));
  g1(81,31)=(-T1377);
  g1(81,43)=(-(T91*exp(y(43))*params(15)*y(109)));
  g1(81,44)=(-(y(104)*T3798))-(-(T1376*exp(y(44))*getPowerDeriv(exp(y(44)),params(24),1)))/(T1227*T1227);
  g1(81,45)=(-(params(40)*exp(y(45))*T91*y(105)/params(26)));
  g1(81,104)=(-T883);
  g1(81,105)=(-(T91*(1+params(40)*exp(y(45)))/params(26)));
  g1(81,108)=T91;
  g1(81,109)=(-(T91*params(15)*exp(y(43))));
  g1(82,80)=1;
  g1(83,7)=(-((T1384*params(5)*T1869-params(5)*T1384*T1869)/(T1384*T1384)/y(13)));
  g1(83,12)=(-((T1384*params(5)*T2274-params(5)*T1384*T2274)/(T1384*T1384)/y(13)));
  g1(83,13)=(-((-(params(5)*T1384/T1384))/(y(13)*y(13))));
  g1(83,18)=(-1)/((1+y(18))*(1+y(18)));
  g1(84,7)=T108*T1390*getPowerDeriv(T1390,T159,1);
  g1(84,8)=T108*getPowerDeriv(T1390,T159,1)*(-(exp(y(8))*T55*params(31)))/(exp(y(8))*exp(y(8)));
  g1(84,12)=T108*T1390^T159;
  g1(85,7)=(-(T1396*getPowerDeriv(T1396,T159,1)));
  g1(85,9)=(-(getPowerDeriv(T1396,T159,1)*(-(exp(y(9))*T55*params(32)))/(exp(y(9))*exp(y(9)))));
  g1(85,19)=exp(y(19))/T526;
  g1(85,26)=(-(exp(y(19))*T526))/(T526*T526);
  g1(86,7)=T55;
  g1(86,8)=(-(T251*exp(y(8))*getPowerDeriv(exp(y(8)),T254,1)*getPowerDeriv(T264,1+params(6),1)));
  g1(86,9)=(-(getPowerDeriv(T264,1+params(6),1)*T260*exp(y(9))*getPowerDeriv(exp(y(9)),T254,1)));
  g1(87,14)=(-(T132/T220));
  g1(87,15)=(-((-(T132*T220))/(T220*T220)));
  g1(87,16)=T399*getPowerDeriv(T399,1+params(25)*T224,1);
  g1(88,7)=(-(T68*(-(T1409*T1869))/(T1384*T1384)+T132*T1417*(T1384*params(5)*params(29)*T1869-params(5)*params(29)*T1384*T1869)/(T1384*T1384)));
  g1(88,10)=(-(T68*T1409/T1384+T68*params(30)*T224*T68/exp(y(41))*T2067/T1384));
  g1(88,12)=(-(T68*(-(T1409*T2274))/(T1384*T1384)+T132*T1417*(T1384*params(5)*params(29)*T2274-params(5)*params(29)*T1384*T2274)/(T1384*T1384)));
  g1(88,13)=(-(T132*T1413*T2304*getPowerDeriv(T137,T1416,1)));
  g1(88,14)=T132-T132*T1413*T1417;
  g1(88,41)=(-(T68*params(30)*T224*T2067*(-(exp(y(41))*T68))/(exp(y(41))*exp(y(41)))/T1384));
  g1(89,7)=(-(T220*T226*(T1384*params(5)*params(29)*T1869-params(5)*params(29)*T1384*T1869)/(T1384*T1384)));
  g1(89,10)=(-(T68*(1+params(35)*exp(y(42)))/params(27)));
  g1(89,12)=(-(T220*T226*(T1384*params(5)*params(29)*T2274-params(5)*params(29)*T1384*T2274)/(T1384*T1384)));
  g1(89,13)=(-(T220*T1413*T2322));
  g1(89,15)=T220-T220*T226*T1413;
  g1(89,42)=(-(T68*params(35)*exp(y(42))/params(27)));
  g1(90,13)=params(29)*T2304*getPowerDeriv(T137,T1429,1);
  g1(90,16)=(1-params(29))*T399*getPowerDeriv(T399,T1429,1);
  g1(91,13)=(-(exp(y(34))*params(29)*T2304*getPowerDeriv(T137,T1416,1)));
  g1(91,16)=(-((1-params(29))*T399*getPowerDeriv(T399,T1416,1)));
  g1(91,17)=exp(y(17));
  g1(91,34)=(-(exp(y(34))*params(29)*T1417));
  g1(92,8)=(-exp(y(8)));
  g1(92,10)=T68;
  g1(92,11)=(-exp(y(11)));
  g1(92,23)=(-(exp(y(23))*1/params(33)));
  g1(93,10)=(-(exp(y(40))*T68*params(7)));
  g1(93,11)=exp(y(11));
  g1(93,40)=(-(exp(y(40))*T68*params(7)));
  g1(94,12)=(-(y(13)*T108/exp(y(36))));
  g1(94,13)=(-(T108/exp(y(36))));
  g1(94,20)=1;
  g1(94,36)=(-(y(13)*(-(T108*exp(y(36))))/(exp(y(36))*exp(y(36)))));
  g1(95,21)=(-((T1458*params(13)*T2918-params(13)*T1458*T2918)/(T1458*T1458)/y(27)));
  g1(95,26)=(-((T1458*params(13)*T3325-params(13)*T1458*T3325)/(T1458*T1458)/y(27)));
  g1(95,27)=(-((-(params(13)*T1458/T1458))/(y(27)*y(27))));
  g1(95,32)=(-1)/((1+y(32))*(1+y(32)));
  g1(96,21)=T526*T1464*getPowerDeriv(T1464,T583,1);
  g1(96,22)=T526*getPowerDeriv(T1464,T583,1)*(-(exp(y(22))*T78*params(37)))/(exp(y(22))*exp(y(22)));
  g1(96,26)=T526*T1464^T583;
  g1(97,12)=(-(T108*1/exp(y(19))))/(T108*T108);
  g1(97,19)=(-exp(y(19)))/(exp(y(19))*exp(y(19)))/T108;
  g1(97,21)=(-(T1471*getPowerDeriv(T1471,T583,1)));
  g1(97,23)=(-(getPowerDeriv(T1471,T583,1)*(-(exp(y(23))*T78*params(38)))/(exp(y(23))*exp(y(23)))));
  g1(98,21)=T78;
  g1(98,22)=(-(T659*exp(y(22))*getPowerDeriv(exp(y(22)),T662,1)*getPowerDeriv(T672,1+params(14),1)));
  g1(98,23)=(-(getPowerDeriv(T672,1+params(14),1)*T668*exp(y(23))*getPowerDeriv(exp(y(23)),T662,1)));
  g1(99,28)=(-(T548/T629));
  g1(99,29)=(-((-(T548*T629))/(T629*T629)));
  g1(99,30)=T799*getPowerDeriv(T799,1+params(24)*T633,1);
  g1(100,21)=(-(T91*(-(T1484*T2918))/(T1458*T1458)+T548*T1492*(T1458*params(13)*params(28)*T2918-params(13)*params(28)*T1458*T2918)/(T1458*T1458)));
  g1(100,24)=(-(T91*T1484/T1458+T91*params(36)*T633*T91/exp(y(44))*T3115/T1458));
  g1(100,26)=(-(T91*(-(T1484*T3325))/(T1458*T1458)+T548*T1492*(T1458*params(13)*params(28)*T3325-params(13)*params(28)*T1458*T3325)/(T1458*T1458)));
  g1(100,27)=(-(T548*T1488*T3352*getPowerDeriv(T554,T1491,1)));
  g1(100,28)=T548-T548*T1488*T1492;
  g1(100,44)=(-(T91*params(36)*T633*T3115*(-(exp(y(44))*T91))/(exp(y(44))*exp(y(44)))/T1458));
  g1(101,21)=(-(T629*T635*(T1458*params(13)*params(28)*T2918-params(13)*params(28)*T1458*T2918)/(T1458*T1458)));
  g1(101,24)=(-(T91*(1+params(40)*exp(y(45)))/params(26)));
  g1(101,26)=(-(T629*T635*(T1458*params(13)*params(28)*T3325-params(13)*params(28)*T1458*T3325)/(T1458*T1458)));
  g1(101,27)=(-(T629*T1488*T3370));
  g1(101,29)=T629-T629*T635*T1488;
  g1(101,45)=(-(T91*params(40)*exp(y(45))/params(26)));
  g1(102,27)=params(28)*T3352*getPowerDeriv(T554,T1504,1);
  g1(102,30)=(1-params(28))*T799*getPowerDeriv(T799,T1504,1);
  g1(103,27)=(-(exp(y(37))*params(28)*T3352*getPowerDeriv(T554,T1491,1)));
  g1(103,30)=(-((1-params(28))*T799*getPowerDeriv(T799,T1491,1)));
  g1(103,31)=exp(y(31));
  g1(103,37)=(-(exp(y(37))*params(28)*T1492));
  g1(104,9)=(-(exp(y(9))*params(33)));
  g1(104,22)=(-exp(y(22)));
  g1(104,24)=T91;
  g1(104,25)=(-exp(y(25)));
  g1(105,24)=(-(exp(y(43))*T91*params(15)));
  g1(105,25)=exp(y(25));
  g1(105,43)=(-(exp(y(43))*T91*params(15)));
  g1(106,26)=(-(y(27)*T526/exp(y(39))));
  g1(106,27)=(-(T526/exp(y(39))));
  g1(106,33)=1;
  g1(106,39)=(-(y(27)*(-(T526*exp(y(39))))/(exp(y(39))*exp(y(39)))));
  g1(107,7)=(-(params(51)*(-(params(50)*params(49)/exp(y(19))*T55*getPowerDeriv(T55,(-params(4)),1)))/(T1383*T1383)));
  g1(107,19)=(-(params(51)*params(50)*(-(params(49)*exp(y(19))))/(exp(y(19))*exp(y(19)))/T1383));
  g1(107,21)=params(48)*(-(params(47)*T78*getPowerDeriv(T78,(-params(12)),1)))/(T1457*T1457);
  g1(108,40)=1-params(8);
  g1(109,41)=1-params(10);
  g1(110,42)=1-params(22);
  g1(111,43)=1-params(16);
  g1(112,44)=1-params(18);
  g1(113,45)=1-params(20);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],113,12769);
end
end
