function [residual, g1, g2] = BBCDLmodelcomp_ramsey_c1pid_c2pid_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                    columns: equations in order of declaration
%                                                    rows: variables in declaration order
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: equations in order of declaration
%                                                       rows: variables in declaration order
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 82, 1);

%
% Model equations
%

T55 = exp(y(7));
T68 = exp(y(10));
T70 = T68^(1+params(25));
T74 = params(30)*exp(y(41))^(-params(25))*T70/(1+params(25))*exp(y(17));
T78 = exp(y(21));
T91 = exp(y(24));
T93 = T91^(1+params(24));
T97 = params(36)*exp(y(44))^(-params(24))*T93/(1+params(24))*exp(y(31));
T105 = exp(y(12));
T109 = T55^(params(4)-1);
T114 = (T68*exp((-y(41))))^params(25);
T119 = T68*T55*params(4)*params(30)*T105*T109*T114*(1+params(27))/params(27);
T125 = exp((-y(12)));
T129 = exp(y(14));
T131 = T105*T55*params(4)*params(5)*params(29)*T125*T129;
T132 = T109*T131;
T133 = T55^params(4);
T135 = params(34)/y(13);
T137 = (1+params(25))*(1+params(27))/params(27);
T138 = T135^T137;
T161 = params(6)/(1+params(6));
T163 = (T55*params(32)*exp((-y(9))))^(T161-1);
T164 = T55*params(32)*params(6)*y(58)*exp((-y(9)))*T163;
T165 = T164/(1+params(6));
T194 = (T55*params(31)*exp((-y(8))))^(T161-1);
T195 = T105*T55*params(6)*params(31)*y(57)*exp((-y(8)))*T194;
T196 = T195/(1+params(6));
T211 = params(3)*y(13)*T55^(1+params(4));
T221 = T105*T55*T125*params(4)*params(5)*params(29)*y(62)*exp(y(15));
T223 = (1+params(27))/params(27);
T225 = T135^(1-T223);
T231 = params(3)*T55^(1+params(4));
T239 = T133*T105*T129*T55*T125*y(61)*params(4)*params(5)*params(29);
T248 = params(31)^T161;
T251 = 1/(1+params(6));
T254 = exp(y(8))*y(59)*T248*exp(y(8))^(T251-1);
T257 = params(32)^T161;
T261 = T248*exp(y(8))^T251+T257*exp(y(9))^T251;
T262 = T261^params(6);
T277 = exp(y(41))^params(25);
T278 = (1+params(25))*T277;
T279 = T70*exp(y(17))*params(30)*y(54)/T278;
T310 = T225*T133*T105*exp(y(15))*T125*y(62)*params(5)*params(29)/(params(3)*T133);
T321 = T133*T105*T129*T125*y(61)*params(5)*params(29)/(T138*params(3)*T133);
T327 = exp(y(9))*y(59)*T257*exp(y(9))^(T251-1);
T340 = params(27)*y(13)^2;
T342 = 1+1/params(27);
T343 = T135^T342;
T358 = T133*params(3)*y(13)^2;
T366 = T135^(1+T137);
T368 = (1+params(27))*(1+params(25))*exp(y(34))*y(64)*params(29)*params(34)/(T340*T366);
T380 = T358*T135^T223;
T381 = T133*T105*exp(y(15))*T125*y(62)*params(29)*params(5)*params(34)*(T223-1)/T380;
T389 = (1+params(27))*(1+params(25))*T133*T105*T129*T125*y(61)*params(29)*params(5)*params(34);
T397 = exp(y(16));
T401 = T397^(params(25)*(1+params(27))/params(27));
T402 = y(60)*T397*T401;
T403 = 1+params(25)*(1+params(27))/params(27);
T409 = params(27)*T397^T342;
T417 = params(27)*T397^(1+T137);
T422 = exp((-y(26)));
T439 = (1+y(18))^2;
T452 = (1+params(27))*T114*T133*T68*params(30)*T105/params(27);
T490 = (T68*exp((-y(41))))^(params(25)-1);
T494 = T452+(1+params(27))*T133*T105*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*T490/params(27);
T495 = y(61)*T494;
T515 = T68*exp(y(17))*params(30)*y(54)*T68^params(25);
T524 = exp(y(26));
T528 = T78^(params(12)-1);
T533 = (T91*exp((-y(44))))^params(24);
T538 = T91*T78*params(12)*params(36)*T524*T528*T533*(1+params(26))/params(26);
T546 = exp(y(28));
T548 = T524*T78*T422*params(12)*params(13)*params(28)*T546;
T549 = T528*T548;
T550 = T78^params(12);
T552 = params(39)/y(27);
T554 = (1+params(24))*(1+params(26))/params(26);
T555 = T552^T554;
T585 = params(14)/(1+params(14));
T587 = (T78*params(38)*exp((-y(23))))^(T585-1);
T588 = T78*y(70)*params(38)*params(14)*exp((-y(23)))*T587;
T589 = T588/(1+params(14));
T603 = (T78*params(37)*exp((-y(22))))^(T585-1);
T604 = T524*T78*params(14)*params(37)*y(69)*exp((-y(22)))*T603;
T605 = T604/(1+params(14));
T620 = params(3)*y(27)*T78^(1+params(12));
T630 = T524*T78*T422*params(12)*params(13)*params(28)*y(74)*exp(y(29));
T632 = (1+params(26))/params(26);
T634 = T552^(1-T632);
T640 = params(3)*T78^(1+params(12));
T648 = T550*T524*T546*T78*T422*y(73)*params(12)*params(13)*params(28);
T656 = params(37)^T585;
T659 = 1/(1+params(14));
T662 = exp(y(22))*y(71)*T656*exp(y(22))^(T659-1);
T665 = params(38)^T585;
T669 = T656*exp(y(22))^T659+T665*exp(y(23))^T659;
T670 = T669^params(14);
T685 = exp(y(44))^params(24);
T686 = (1+params(24))*T685;
T687 = T93*exp(y(31))*params(36)*y(55)/T686;
T718 = T634*T550*T524*exp(y(29))*T422*y(74)*params(13)*params(28)/(params(3)*T550);
T729 = T550*T524*T546*T422*y(73)*params(13)*params(28)/(T555*params(3)*T550);
T735 = exp(y(23))*y(71)*T665*exp(y(23))^(T659-1);
T746 = params(26)*y(27)^2;
T748 = 1+1/params(26);
T749 = T552^T748;
T764 = T550*params(3)*y(27)^2;
T772 = T552^(1+T554);
T774 = (1+params(26))*(1+params(24))*exp(y(37))*y(76)*params(28)*params(39)/(T746*T772);
T786 = T764*T552^T632;
T787 = T550*T524*exp(y(29))*T422*y(74)*params(28)*params(13)*params(39)*(T632-1)/T786;
T795 = (1+params(26))*(1+params(24))*T550*T524*T546*T422*y(73)*params(28)*params(13)*params(39);
T803 = exp(y(30));
T807 = T803^(params(24)*(1+params(26))/params(26));
T808 = y(72)*T803*T807;
T809 = 1+params(24)*(1+params(26))/params(26);
T815 = params(26)*T803^T748;
T823 = params(26)*T803^(1+T554);
T831 = (1+y(32))^2;
T844 = (1+params(26))*T533*T550*T91*params(36)*T524/params(26);
T882 = (T91*exp((-y(44))))^(params(24)-1);
T886 = T844+(1+params(26))*T550*T524*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*T882/params(26);
T887 = y(73)*T886;
T907 = T91*exp(y(31))*params(36)*y(55)*T91^params(24);
T919 = T55^(-params(4));
T920 = T919/T105;
T926 = T55*params(31)/exp(y(8));
T932 = T55*params(32)/exp(y(9));
T945 = params(30)*T223*(T68/exp(y(41)))^params(25);
T949 = params(5)*params(29)*T920/T920;
T952 = (1+params(25))*(-(1+params(27)))/params(27);
T953 = T135^T952;
T965 = (-1)/params(27);
T993 = T78^(-params(12));
T994 = T993/T524;
T1000 = T78*params(37)/exp(y(22));
T1007 = T78*params(38)/exp(y(23));
T1020 = params(36)*T632*(T91/exp(y(44)))^params(24);
T1024 = params(13)*params(28)*T994/T994;
T1027 = (1+params(24))*(-(1+params(26)))/params(26);
T1028 = T552^T1027;
T1040 = (-1)/params(26);
T1122 = T55*getPowerDeriv(T55,params(4)-1,1);
T1131 = T55*getPowerDeriv(T55,params(4),1);
T1151 = (T164+T55*params(32)*params(6)*y(58)*exp((-y(9)))*T55*params(32)*exp((-y(9)))*getPowerDeriv(T55*params(32)*exp((-y(9))),T161-1,1))/(1+params(6));
T1160 = (T195+T105*T55*params(6)*params(31)*y(57)*exp((-y(8)))*T55*params(31)*exp((-y(8)))*getPowerDeriv(T55*params(31)*exp((-y(8))),T161-1,1))/(1+params(6));
T1217 = (params(3)*T133*T225*T105*exp(y(15))*T125*y(62)*params(5)*params(29)*T1131-T225*T133*T105*exp(y(15))*T125*y(62)*params(5)*params(29)*params(3)*T1131)/(params(3)*T133*params(3)*T133);
T1225 = (T138*params(3)*T133*T105*T129*T125*y(61)*params(5)*params(29)*T1131-T133*T105*T129*T125*y(61)*params(5)*params(29)*T138*params(3)*T1131)/(T138*params(3)*T133*T138*params(3)*T133);
T1298 = T55*getPowerDeriv(T55,(-params(4)),1)/T105;
T1345 = (T194*T105*T55*params(6)*params(31)*y(57)*(-exp((-y(8))))+T105*T55*params(6)*params(31)*y(57)*exp((-y(8)))*getPowerDeriv(T55*params(31)*exp((-y(8))),T161-1,1)*T55*params(31)*(-exp((-y(8)))))/(1+params(6));
T1354 = T248*exp(y(8))*getPowerDeriv(exp(y(8)),T251,1)*getPowerDeriv(T261,params(6),1);
T1383 = (T163*T55*params(32)*params(6)*y(58)*(-exp((-y(9))))+T55*params(32)*params(6)*y(58)*exp((-y(9)))*getPowerDeriv(T55*params(32)*exp((-y(9))),T161-1,1)*T55*params(32)*(-exp((-y(9)))))/(1+params(6));
T1388 = getPowerDeriv(T261,params(6),1)*T257*exp(y(9))*getPowerDeriv(exp(y(9)),T251,1);
T1416 = T68*exp((-y(41)))*getPowerDeriv(T68*exp((-y(41))),params(25),1);
T1428 = (1+params(27))*(T114*T133*T68*params(30)*T105+T133*T68*params(30)*T105*T1416)/params(27);
T1454 = getPowerDeriv(T68/exp(y(41)),params(25),1);
T1514 = T225*T133*(T105*exp(y(15))*T125*y(62)*params(5)*params(29)+T105*exp(y(15))*y(62)*params(5)*params(29)*(-T125))/(params(3)*T133);
T1521 = T133*(T105*T129*T125*y(61)*params(5)*params(29)+T105*T129*y(61)*params(5)*params(29)*(-T125))/(T138*params(3)*T133);
T1572 = (-(T105*T919))/(T105*T105);
T1602 = (-params(34))/(y(13)*y(13));
T1604 = T1602*getPowerDeriv(T135,T137,1);
T1620 = T1602*getPowerDeriv(T135,1-T223,1);
T1638 = T133*T105*exp(y(15))*T125*y(62)*params(5)*params(29)*T1620/(params(3)*T133);
T1643 = (-(T133*T105*T129*T125*y(61)*params(5)*params(29)*params(3)*T133*T1604))/(T138*params(3)*T133*T138*params(3)*T133);
T1823 = T78*getPowerDeriv(T78,params(12)-1,1);
T1832 = T78*getPowerDeriv(T78,params(12),1);
T1855 = (T588+T78*y(70)*params(38)*params(14)*exp((-y(23)))*T78*params(38)*exp((-y(23)))*getPowerDeriv(T78*params(38)*exp((-y(23))),T585-1,1))/(1+params(14));
T1861 = (T604+T524*T78*params(14)*params(37)*y(69)*exp((-y(22)))*T78*params(37)*exp((-y(22)))*getPowerDeriv(T78*params(37)*exp((-y(22))),T585-1,1))/(1+params(14));
T1918 = (params(3)*T550*T634*T524*exp(y(29))*T422*y(74)*params(13)*params(28)*T1832-T634*T550*T524*exp(y(29))*T422*y(74)*params(13)*params(28)*params(3)*T1832)/(params(3)*T550*params(3)*T550);
T1926 = (T555*params(3)*T550*T524*T546*T422*y(73)*params(13)*params(28)*T1832-T550*T524*T546*T422*y(73)*params(13)*params(28)*T555*params(3)*T1832)/(T555*params(3)*T550*T555*params(3)*T550);
T1998 = T78*getPowerDeriv(T78,(-params(12)),1)/T524;
T2044 = (T603*T524*T78*params(14)*params(37)*y(69)*(-exp((-y(22))))+T524*T78*params(14)*params(37)*y(69)*exp((-y(22)))*getPowerDeriv(T78*params(37)*exp((-y(22))),T585-1,1)*T78*params(37)*(-exp((-y(22)))))/(1+params(14));
T2053 = T656*exp(y(22))*getPowerDeriv(exp(y(22)),T659,1)*getPowerDeriv(T669,params(14),1);
T2082 = (T587*T78*y(70)*params(38)*params(14)*(-exp((-y(23))))+T78*y(70)*params(38)*params(14)*exp((-y(23)))*getPowerDeriv(T78*params(38)*exp((-y(23))),T585-1,1)*T78*params(38)*(-exp((-y(23)))))/(1+params(14));
T2087 = getPowerDeriv(T669,params(14),1)*T665*exp(y(23))*getPowerDeriv(exp(y(23)),T659,1);
T2115 = T91*exp((-y(44)))*getPowerDeriv(T91*exp((-y(44))),params(24),1);
T2127 = (1+params(26))*(T533*T550*T91*params(36)*T524+T550*T91*params(36)*T524*T2115)/params(26);
T2153 = getPowerDeriv(T91/exp(y(44)),params(24),1);
T2215 = T634*T550*(T524*exp(y(29))*T422*y(74)*params(13)*params(28)+T524*exp(y(29))*y(74)*params(13)*params(28)*(-T422))/(params(3)*T550);
T2222 = T550*(T524*T546*T422*y(73)*params(13)*params(28)+T524*T546*y(73)*params(13)*params(28)*(-T422))/(T555*params(3)*T550);
T2274 = (-(T524*T993))/(T524*T524);
T2301 = (-params(39))/(y(27)*y(27));
T2303 = T2301*getPowerDeriv(T552,T554,1);
T2319 = T2301*getPowerDeriv(T552,1-T632,1);
T2337 = T550*T524*exp(y(29))*T422*y(74)*params(13)*params(28)*T2319/(params(3)*T550);
T2342 = (-(T550*T524*T546*T422*y(73)*params(13)*params(28)*params(3)*T550*T2303))/(T555*params(3)*T550*T555*params(3)*T550);
T2536 = getPowerDeriv(T68*exp((-y(41))),params(25),1)*T68*(-exp((-y(41))));
T2599 = getPowerDeriv(T91*exp((-y(44))),params(24),1)*T91*(-exp((-y(44))));
lhs =y(1);
rhs =params(1)*y(5)+params(2)*y(6);
residual(1)= lhs-rhs;
lhs =y(2);
rhs =y(1)+y(2)*params(3);
residual(2)= lhs-rhs;
lhs =y(81);
rhs =y(5)+params(3)*y(81);
residual(3)= lhs-rhs;
lhs =y(82);
rhs =y(6)+params(3)*y(82);
residual(4)= lhs-rhs;
lhs =y(3);
rhs =y(13);
residual(5)= lhs-rhs;
lhs =y(4);
rhs =y(27);
residual(6)= lhs-rhs;
lhs =y(34);
rhs =y(17);
residual(7)= lhs-rhs;
lhs =y(35);
rhs =y(18);
residual(8)= lhs-rhs;
lhs =y(36);
rhs =y(12);
residual(9)= lhs-rhs;
lhs =y(37);
rhs =y(31);
residual(10)= lhs-rhs;
lhs =y(38);
rhs =y(32);
residual(11)= lhs-rhs;
lhs =y(39);
rhs =y(26);
residual(12)= lhs-rhs;
lhs =y(5);
rhs =T55^(1-params(4))/(1-params(4))-T74;
residual(13)= lhs-rhs;
lhs =y(6);
rhs =T78^(1-params(12))/(1-params(12))-T97;
residual(14)= lhs-rhs;
residual(15) = T55*y(59)-y(61)*(T119+T132/(T133*T138))-T55*y(54)/T133-T165-T109*T55*params(4)*params(50)*params(49)*params(51)*y(80)*exp((-y(19)))+T196-T109*T105*T55*T125*params(4)*params(5)*y(56)/(y(13)*T133)+T133*T105*T55*T125*params(4)*params(5)*y(56)/T211-T109*T221*T225/T133+T225*T133*T221/T231+T239/(T138*T231);
residual(16) = (-y(65))*exp(y(8))-T254*T262-T196;
residual(17) = y(67);
residual(18) = exp(y(17))*y(64)-params(3)*y(48)+T279;
residual(19) = y(48)-params(29)*y(64)*exp(y(34))/T138;
residual(20) = y(66)*exp(y(11))-y(65)*exp(y(11));
residual(21) = y(62)*exp(y(15))+T129*y(60)*exp((-y(15)))-T310;
residual(22) = y(61)*T129-T129*y(60)*exp((-y(15)))-T321;
residual(23) = T165-T262*T327-exp(y(9))*params(33)*y(77);
residual(24) = params(29)*params(34)*y(63)/(T340*T343)-T105*y(67)*exp((-y(36)))-y(46)+T133*T105*T125*params(5)*y(56)/T358-T368-T381-T389/(T366*T133*params(3)*T340);
residual(25) = T402*T403+y(63)*T397*(params(29)-1)/T409-(params(29)-1)*(1+params(27))*(1+params(25))*y(64)*T397/T417;
residual(26) = y(58)*T422*exp(y(19))-T125*exp((-y(19)))*y(70)+T133*exp((-y(19)))*params(50)*params(49)*params(51)*y(80);
residual(27) = params(3)*(-y(49))-y(56)/T439;
residual(28) = y(49);
residual(29) = T310+T321+T105*y(57)*(T55*params(31)*exp((-y(8))))^T161-y(61)*(T452+T133*T105*T129*T125*params(5)*params(29)/(T133*T138))-T125*exp((-y(19)))*y(70)-params(3)*y(50)-T105*exp((-y(36)))*y(13)*y(67)-T133*T105*T125*params(5)*y(56)/(y(13)*T133)+T133*T105*T125*params(5)*y(56)/(T133*params(3)*y(13))-T225*T133*T105*exp(y(15))*T125*y(62)*params(5)*params(29)/T133;
residual(30) = y(50)+T105*exp((-y(36)))*y(13)*y(67);
residual(31) = T68*y(65)-T495-T68*y(62)*(1+params(35)*exp(y(42)))/params(27)-T68*y(66)*params(7)*exp(y(40))+T515/T277;
residual(32) = T78*y(71)-y(73)*(T538+T549/(T550*T555))-T78*y(55)/T550+T528*T78*y(80)*params(12)*params(47)*params(48)-T589+T605-T528*T524*T78*T422*params(12)*params(13)*y(68)/(y(27)*T550)+T550*T524*T78*T422*params(12)*params(13)*y(68)/T620-T528*T630*T634/T550+T634*T550*T630/T640+T648/(T555*T640);
residual(33) = (-y(77))*exp(y(22))-T662*T670-T605;
residual(34) = y(79);
residual(35) = exp(y(31))*y(76)-params(3)*y(51)+T687;
residual(36) = y(51)-params(28)*y(76)*exp(y(37))/T555;
residual(37) = y(78)*exp(y(25))-y(77)*exp(y(25));
residual(38) = y(74)*exp(y(29))+T546*y(72)*exp((-y(29)))-T718;
residual(39) = y(73)*T546-T546*y(72)*exp((-y(29)))-T729;
residual(40) = T589-T670*T735-y(65)*exp(y(23))/params(33);
residual(41) = params(28)*params(39)*y(75)/(T746*T749)-T524*y(79)*exp((-y(39)))-y(47)+T550*T524*T422*params(13)*y(68)/T764-T774-T787-T795/(T772*T550*params(3)*T746);
residual(42) = T808*T809+y(75)*T803*(params(28)-1)/T815-(params(28)-1)*(1+params(26))*(1+params(24))*y(76)*T803/T823;
residual(43) = params(3)*(-y(52))-y(68)/T831;
residual(44) = y(52);
residual(45) = T718+T729+T524*y(69)*(T78*params(37)*exp((-y(22))))^T585-y(73)*(T844+T550*T524*T546*T422*params(13)*params(28)/(T550*T555))-params(3)*y(53)-y(58)*T422*exp(y(19))-T524*exp((-y(39)))*y(27)*y(79)-T550*T524*T422*params(13)*y(68)/(y(27)*T550)+T550*T524*T422*params(13)*y(68)/(T550*params(3)*y(27))-T634*T550*T524*exp(y(29))*T422*y(74)*params(13)*params(28)/T550;
residual(46) = y(53)+T524*exp((-y(39)))*y(27)*y(79);
residual(47) = T91*y(77)-T887-T91*y(74)*(1+params(40)*exp(y(45)))/params(26)-T91*y(78)*params(15)*exp(y(43))+T907/T685;
residual(48) = y(46);
residual(49) = y(47);
residual(50) = params(1)+y(54);
residual(51) = params(2)+y(55);
lhs =1/(1+y(18));
rhs =params(5)*T920/T920/y(13);
residual(52)= lhs-rhs;
lhs =T105*T926^T161;
rhs =1;
residual(53)= lhs-rhs;
lhs =exp(y(19))/T524;
rhs =T932^T161;
residual(54)= lhs-rhs;
lhs =T55;
rhs =T261^(1+params(6));
residual(55)= lhs-rhs;
lhs =T397^(1+params(25)*T223);
rhs =T129/exp(y(15));
residual(56)= lhs-rhs;
lhs =T129;
rhs =T68*T945/T920+T129*T949*T953;
residual(57)= lhs-rhs;
lhs =exp(y(15));
rhs =T68*(1+params(35)*exp(y(42)))/params(27)+exp(y(15))*T225*T949;
residual(58)= lhs-rhs;
lhs =(1-params(29))*T397^T965+params(29)*T135^T965;
rhs =1;
residual(59)= lhs-rhs;
lhs =exp(y(17));
rhs =(1-params(29))*T397^T952+exp(y(34))*params(29)*T953;
residual(60)= lhs-rhs;
lhs =T68;
rhs =exp(y(8))+exp(y(11))+exp(y(23))*1/params(33);
residual(61)= lhs-rhs;
lhs =exp(y(11));
rhs =exp(y(40))*T68*params(7);
residual(62)= lhs-rhs;
lhs =y(20);
rhs =y(13)*T105/exp(y(36));
residual(63)= lhs-rhs;
lhs =1/(1+y(32));
rhs =params(13)*T994/T994/y(27);
residual(64)= lhs-rhs;
lhs =T524*T1000^T585;
rhs =1;
residual(65)= lhs-rhs;
lhs =1/exp(y(19))/T105;
rhs =T1007^T585;
residual(66)= lhs-rhs;
lhs =T78;
rhs =T669^(1+params(14));
residual(67)= lhs-rhs;
lhs =T803^(1+params(24)*T632);
rhs =T546/exp(y(29));
residual(68)= lhs-rhs;
lhs =T546;
rhs =T91*T1020/T994+T546*T1024*T1028;
residual(69)= lhs-rhs;
lhs =exp(y(29));
rhs =T91*(1+params(40)*exp(y(45)))/params(26)+exp(y(29))*T634*T1024;
residual(70)= lhs-rhs;
lhs =(1-params(28))*T803^T1040+params(28)*T552^T1040;
rhs =1;
residual(71)= lhs-rhs;
lhs =exp(y(31));
rhs =(1-params(28))*T803^T1027+exp(y(37))*params(28)*T1028;
residual(72)= lhs-rhs;
lhs =T91;
rhs =exp(y(22))+exp(y(25))+exp(y(9))*params(33);
residual(73)= lhs-rhs;
lhs =exp(y(25));
rhs =exp(y(43))*T91*params(15);
residual(74)= lhs-rhs;
lhs =y(33);
rhs =y(27)*T524/exp(y(39));
residual(75)= lhs-rhs;
lhs =params(48)*params(47)/T993;
rhs =params(51)*params(50)*params(49)/exp(y(19))/T919;
residual(76)= lhs-rhs;
lhs =y(40);
rhs =y(40)*params(8)+params(9)*x(1);
residual(77)= lhs-rhs;
lhs =y(41);
rhs =y(41)*params(10)+params(11)*x(2);
residual(78)= lhs-rhs;
lhs =y(42);
rhs =y(42)*params(22)+params(23)*x(6);
residual(79)= lhs-rhs;
lhs =y(43);
rhs =y(43)*params(16)+params(17)*x(3);
residual(80)= lhs-rhs;
lhs =y(44);
rhs =y(44)*params(18)+params(19)*x(4);
residual(81)= lhs-rhs;
lhs =y(45);
rhs =y(45)*params(20)+params(21)*x(5);
residual(82)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(82, 82);

  %
  % Jacobian matrix
  %

  g1(1,1)=1;
  g1(1,5)=(-params(1));
  g1(1,6)=(-params(2));
  g1(2,1)=(-1);
  g1(2,2)=1-params(3);
  g1(3,5)=(-1);
  g1(3,81)=1-params(3);
  g1(4,6)=(-1);
  g1(4,82)=1-params(3);
  g1(5,3)=1;
  g1(5,13)=(-1);
  g1(6,4)=1;
  g1(6,27)=(-1);
  g1(7,17)=(-1);
  g1(7,34)=1;
  g1(8,18)=(-1);
  g1(8,35)=1;
  g1(9,12)=(-1);
  g1(9,36)=1;
  g1(10,31)=(-1);
  g1(10,37)=1;
  g1(11,32)=(-1);
  g1(11,38)=1;
  g1(12,26)=(-1);
  g1(12,39)=1;
  g1(13,5)=1;
  g1(13,7)=(-(T55*getPowerDeriv(T55,1-params(4),1)/(1-params(4))));
  g1(13,10)=exp(y(17))*params(30)*exp(y(41))^(-params(25))*T68*getPowerDeriv(T68,1+params(25),1)/(1+params(25));
  g1(13,17)=T74;
  g1(13,41)=exp(y(17))*T70*params(30)*exp(y(41))*getPowerDeriv(exp(y(41)),(-params(25)),1)/(1+params(25));
  g1(14,6)=1;
  g1(14,21)=(-(T78*getPowerDeriv(T78,1-params(12),1)/(1-params(12))));
  g1(14,24)=exp(y(31))*params(36)*exp(y(44))^(-params(24))*T91*getPowerDeriv(T91,1+params(24),1)/(1+params(24));
  g1(14,31)=T97;
  g1(14,44)=exp(y(31))*T93*params(36)*exp(y(44))*getPowerDeriv(exp(y(44)),(-params(24)),1)/(1+params(24));
  g1(15,7)=T55*y(59)-y(61)*((1+params(27))*T114*(T68*T55*params(4)*params(30)*T105*T109+T68*T55*params(4)*params(30)*T105*T1122)/params(27)+(T133*T138*(T132+T131*T1122)-T132*T138*T1131)/(T133*T138*T133*T138))-(T133*T55*y(54)-T55*y(54)*T1131)/(T133*T133)-T1151-(T109*T55*params(4)*params(50)*params(49)*params(51)*y(80)*exp((-y(19)))+T55*params(4)*params(50)*params(49)*params(51)*y(80)*exp((-y(19)))*T1122)+T1160-(y(13)*T133*(T109*T105*T55*T125*params(4)*params(5)*y(56)+T105*T55*T125*params(4)*params(5)*y(56)*T1122)-T109*T105*T55*T125*params(4)*params(5)*y(56)*y(13)*T1131)/(y(13)*T133*y(13)*T133)+(T211*(T133*T105*T55*T125*params(4)*params(5)*y(56)+T105*T55*T125*params(4)*params(5)*y(56)*T1131)-T133*T105*T55*T125*params(4)*params(5)*y(56)*params(3)*y(13)*T55*getPowerDeriv(T55,1+params(4),1))/(T211*T211)-(T133*T225*(T109*T221+T221*T1122)-T109*T221*T225*T1131)/(T133*T133)+(T231*T225*(T133*T221+T221*T1131)-T225*T133*T221*params(3)*T55*getPowerDeriv(T55,1+params(4),1))/(T231*T231)+(T138*T231*(T239+T105*T129*T55*T125*y(61)*params(4)*params(5)*params(29)*T1131)-T239*T138*params(3)*T55*getPowerDeriv(T55,1+params(4),1))/(T138*T231*T138*T231);
  g1(15,8)=T1345;
  g1(15,9)=(-T1383);
  g1(15,10)=(-(y(61)*(1+params(27))*(T68*T55*params(4)*params(30)*T105*T109*T114+T68*T55*params(4)*params(30)*T105*T109*T1416)/params(27)));
  g1(15,12)=T196+(-(y(61)*(T119+T109*(T131+T105*T129*T55*params(4)*params(5)*params(29)*(-T125))/(T133*T138))))-T109*(T105*T55*T125*params(4)*params(5)*y(56)+T105*T55*params(4)*params(5)*y(56)*(-T125))/(y(13)*T133)+T133*(T105*T55*T125*params(4)*params(5)*y(56)+T105*T55*params(4)*params(5)*y(56)*(-T125))/T211-T225*T109*(T221+T105*exp(y(15))*T55*params(4)*params(5)*params(29)*y(62)*(-T125))/T133+T225*T133*(T221+T105*exp(y(15))*T55*params(4)*params(5)*params(29)*y(62)*(-T125))/T231+T133*(T105*T129*T55*T125*y(61)*params(4)*params(5)*params(29)+T105*T129*T55*y(61)*params(4)*params(5)*params(29)*(-T125))/(T138*T231);
  g1(15,13)=(-(y(61)*(-(T132*T133*T1604))/(T133*T138*T133*T138)))-(-(T133*T109*T105*T55*T125*params(4)*params(5)*y(56)))/(y(13)*T133*y(13)*T133)+(-(T133*T105*T55*T125*params(4)*params(5)*y(56)*T231))/(T211*T211)-T109*T221*T1620/T133+T133*T221*T1620/T231+(-(T239*T231*T1604))/(T138*T231*T138*T231);
  g1(15,14)=T239/(T138*T231)+(-(y(61)*T132/(T133*T138)));
  g1(15,15)=T225*T133*T221/T231+(-(T109*T221*T225/T133));
  g1(15,19)=(-(T109*T55*params(4)*params(50)*params(49)*params(51)*y(80)*(-exp((-y(19))))));
  g1(15,41)=(-(y(61)*(1+params(27))*T68*T55*params(4)*params(30)*T105*T109*T2536/params(27)));
  g1(15,54)=(-(T55/T133));
  g1(15,56)=(-(T109*T105*T55*params(4)*params(5)*T125/(y(13)*T133)))+T133*T105*T55*params(4)*params(5)*T125/T211;
  g1(15,57)=T194*T105*T55*params(6)*params(31)*exp((-y(8)))/(1+params(6));
  g1(15,58)=(-(T163*T55*params(32)*params(6)*exp((-y(9)))/(1+params(6))));
  g1(15,59)=T55;
  g1(15,61)=(-(T119+T132/(T133*T138)))+T131*T133/(T138*T231);
  g1(15,62)=(-(T225*T109*T105*T55*params(4)*params(5)*params(29)*T125*exp(y(15))/T133))+T225*T133*T105*T55*params(4)*params(5)*params(29)*T125*exp(y(15))/T231;
  g1(15,80)=(-(T109*T55*params(4)*params(50)*params(49)*params(51)*exp((-y(19)))));
  g1(16,7)=(-T1160);
  g1(16,8)=(-y(65))*exp(y(8))-(T262*(T254+exp(y(8))*y(59)*T248*exp(y(8))*getPowerDeriv(exp(y(8)),T251-1,1))+T254*T1354)-T1345;
  g1(16,9)=(-(T254*T1388));
  g1(16,12)=(-T196);
  g1(16,57)=(-(T194*T105*T55*params(6)*params(31)*exp((-y(8)))/(1+params(6))));
  g1(16,59)=(-(T262*exp(y(8))^(T251-1)*exp(y(8))*T248));
  g1(16,65)=(-exp(y(8)));
  g1(17,67)=1;
  g1(18,10)=exp(y(17))*params(30)*y(54)*T68*getPowerDeriv(T68,1+params(25),1)/T278;
  g1(18,17)=exp(y(17))*y(64)+T279;
  g1(18,41)=(-(T70*exp(y(17))*params(30)*y(54)*(1+params(25))*exp(y(41))*getPowerDeriv(exp(y(41)),params(25),1)))/(T278*T278);
  g1(18,48)=(-params(3));
  g1(18,54)=T70*params(30)*exp(y(17))/T278;
  g1(18,64)=exp(y(17));
  g1(19,13)=(-((-(params(29)*y(64)*exp(y(34))*T1604))/(T138*T138)));
  g1(19,34)=(-(params(29)*y(64)*exp(y(34))/T138));
  g1(19,48)=1;
  g1(19,64)=(-(params(29)*exp(y(34))/T138));
  g1(20,11)=y(66)*exp(y(11))-y(65)*exp(y(11));
  g1(20,65)=(-exp(y(11)));
  g1(20,66)=exp(y(11));
  g1(21,7)=(-T1217);
  g1(21,12)=(-T1514);
  g1(21,13)=(-T1638);
  g1(21,14)=T129*y(60)*exp((-y(15)));
  g1(21,15)=y(62)*exp(y(15))+T129*y(60)*(-exp((-y(15))))-T310;
  g1(21,60)=T129*exp((-y(15)));
  g1(21,62)=exp(y(15))-T225*T133*T105*exp(y(15))*T125*params(5)*params(29)/(params(3)*T133);
  g1(22,7)=(-T1225);
  g1(22,12)=(-T1521);
  g1(22,13)=(-T1643);
  g1(22,14)=y(61)*T129-T129*y(60)*exp((-y(15)))-T321;
  g1(22,15)=(-(T129*y(60)*(-exp((-y(15))))));
  g1(22,60)=(-(T129*exp((-y(15)))));
  g1(22,61)=T129-T133*T105*T129*T125*params(5)*params(29)/(T138*params(3)*T133);
  g1(23,7)=T1151;
  g1(23,8)=(-(T327*T1354));
  g1(23,9)=T1383-(T327*T1388+T262*(T327+exp(y(9))*y(59)*T257*exp(y(9))*getPowerDeriv(exp(y(9)),T251-1,1)))-exp(y(9))*params(33)*y(77);
  g1(23,58)=T163*T55*params(32)*params(6)*exp((-y(9)))/(1+params(6));
  g1(23,59)=(-(T262*exp(y(9))^(T251-1)*T257*exp(y(9))));
  g1(23,77)=(-(exp(y(9))*params(33)));
  g1(24,7)=(T358*T105*T125*params(5)*y(56)*T1131-T133*T105*T125*params(5)*y(56)*params(3)*y(13)^2*T1131)/(T358*T358)-(T380*(T223-1)*T105*exp(y(15))*T125*y(62)*params(29)*params(5)*params(34)*T1131-T133*T105*exp(y(15))*T125*y(62)*params(29)*params(5)*params(34)*(T223-1)*T135^T223*params(3)*y(13)^2*T1131)/(T380*T380)-(T366*T133*params(3)*T340*(1+params(27))*(1+params(25))*T105*T129*T125*y(61)*params(29)*params(5)*params(34)*T1131-T389*T366*params(3)*T340*T1131)/(T366*T133*params(3)*T340*T366*T133*params(3)*T340);
  g1(24,12)=(-(T105*y(67)*exp((-y(36)))))+T133*(T105*T125*params(5)*y(56)+T105*params(5)*y(56)*(-T125))/T358-(T223-1)*T133*(T105*exp(y(15))*T125*y(62)*params(29)*params(5)*params(34)+T105*exp(y(15))*y(62)*params(29)*params(5)*params(34)*(-T125))/T380-(1+params(27))*(1+params(25))*T133*(T105*T129*T125*y(61)*params(29)*params(5)*params(34)+T105*T129*y(61)*params(29)*params(5)*params(34)*(-T125))/(T366*T133*params(3)*T340);
  g1(24,13)=(-(params(29)*params(34)*y(63)*(T343*params(27)*2*y(13)+T340*T1602*getPowerDeriv(T135,T342,1))))/(T340*T343*T340*T343)+(-(T133*T105*T125*params(5)*y(56)*T133*params(3)*2*y(13)))/(T358*T358)-(-((1+params(27))*(1+params(25))*exp(y(34))*y(64)*params(29)*params(34)*(T366*params(27)*2*y(13)+T340*T1602*getPowerDeriv(T135,1+T137,1))))/(T340*T366*T340*T366)-(-(T133*T105*exp(y(15))*T125*y(62)*params(29)*params(5)*params(34)*(T223-1)*(T135^T223*T133*params(3)*2*y(13)+T358*T1602*getPowerDeriv(T135,T223,1))))/(T380*T380)-(-(T389*(T133*params(3)*T340*T1602*getPowerDeriv(T135,1+T137,1)+T366*T133*params(3)*params(27)*2*y(13))))/(T366*T133*params(3)*T340*T366*T133*params(3)*T340);
  g1(24,14)=(-(T389/(T366*T133*params(3)*T340)));
  g1(24,15)=(-T381);
  g1(24,34)=(-T368);
  g1(24,36)=(-(T105*y(67)*(-exp((-y(36))))));
  g1(24,46)=(-1);
  g1(24,56)=T133*T105*params(5)*T125/T358;
  g1(24,61)=(-((1+params(27))*(1+params(25))*T133*T105*T129*T125*params(29)*params(5)*params(34)/(T366*T133*params(3)*T340)));
  g1(24,62)=(-((T223-1)*T133*T105*exp(y(15))*T125*params(29)*params(5)*params(34)/T380));
  g1(24,63)=params(29)*params(34)/(T340*T343);
  g1(24,64)=(-((1+params(27))*(1+params(25))*exp(y(34))*params(29)*params(34)/(T340*T366)));
  g1(24,67)=(-(T105*exp((-y(36)))));
  g1(25,16)=T403*(T402+y(60)*T397*T397*getPowerDeriv(T397,params(25)*(1+params(27))/params(27),1))+(y(63)*T397*(params(29)-1)*T409-y(63)*T397*(params(29)-1)*params(27)*T397*getPowerDeriv(T397,T342,1))/(T409*T409)-((params(29)-1)*(1+params(27))*(1+params(25))*y(64)*T397*T417-(params(29)-1)*(1+params(27))*(1+params(25))*y(64)*T397*params(27)*T397*getPowerDeriv(T397,1+T137,1))/(T417*T417);
  g1(25,60)=T403*T397*T401;
  g1(25,63)=T397*(params(29)-1)/T409;
  g1(25,64)=(-((params(29)-1)*(1+params(27))*(1+params(25))*T397/T417));
  g1(26,7)=exp((-y(19)))*params(50)*params(49)*params(51)*y(80)*T1131;
  g1(26,12)=(-(exp((-y(19)))*y(70)*(-T125)));
  g1(26,19)=y(58)*T422*exp(y(19))-T125*y(70)*(-exp((-y(19))))+T133*params(50)*params(49)*params(51)*y(80)*(-exp((-y(19))));
  g1(26,26)=exp(y(19))*y(58)*(-T422);
  g1(26,58)=T422*exp(y(19));
  g1(26,70)=(-(T125*exp((-y(19)))));
  g1(26,80)=T133*params(50)*params(49)*params(51)*exp((-y(19)));
  g1(27,18)=(-((-(y(56)*2*(1+y(18))))/(T439*T439)));
  g1(27,49)=(-params(3));
  g1(27,56)=(-(1/T439));
  g1(28,49)=1;
  g1(29,7)=T1217+T1225+T105*y(57)*T55*params(31)*exp((-y(8)))*getPowerDeriv(T55*params(31)*exp((-y(8))),T161,1)-y(61)*((1+params(27))*T114*T68*params(30)*T105*T1131/params(27)+(T133*T138*T105*T129*T125*params(5)*params(29)*T1131-T133*T105*T129*T125*params(5)*params(29)*T138*T1131)/(T133*T138*T133*T138))-(y(13)*T133*T105*T125*params(5)*y(56)*T1131-T133*T105*T125*params(5)*y(56)*y(13)*T1131)/(y(13)*T133*y(13)*T133)+(T133*params(3)*y(13)*T105*T125*params(5)*y(56)*T1131-T133*T105*T125*params(5)*y(56)*params(3)*y(13)*T1131)/(T133*params(3)*y(13)*T133*params(3)*y(13))-(T133*T225*T105*exp(y(15))*T125*y(62)*params(5)*params(29)*T1131-T225*T133*T105*exp(y(15))*T125*y(62)*params(5)*params(29)*T1131)/(T133*T133);
  g1(29,8)=T105*y(57)*getPowerDeriv(T55*params(31)*exp((-y(8))),T161,1)*T55*params(31)*(-exp((-y(8))));
  g1(29,10)=(-(y(61)*T1428));
  g1(29,12)=T1514+T1521+T105*y(57)*(T55*params(31)*exp((-y(8))))^T161-y(61)*(T452+T133*(T105*T129*T125*params(5)*params(29)+T105*T129*params(5)*params(29)*(-T125))/(T133*T138))-exp((-y(19)))*y(70)*(-T125)-T105*exp((-y(36)))*y(13)*y(67)-T133*(T105*T125*params(5)*y(56)+T105*params(5)*y(56)*(-T125))/(y(13)*T133)+T133*(T105*T125*params(5)*y(56)+T105*params(5)*y(56)*(-T125))/(T133*params(3)*y(13))-T225*T133*(T105*exp(y(15))*T125*y(62)*params(5)*params(29)+T105*exp(y(15))*y(62)*params(5)*params(29)*(-T125))/T133;
  g1(29,13)=T1638+T1643+(-(y(61)*(-(T133*T105*T129*T125*params(5)*params(29)*T133*T1604))/(T133*T138*T133*T138)))-T105*y(67)*exp((-y(36)))-(-(T133*T133*T105*T125*params(5)*y(56)))/(y(13)*T133*y(13)*T133)+(-(params(3)*T133*T133*T105*T125*params(5)*y(56)))/(T133*params(3)*y(13)*T133*params(3)*y(13))-T133*T105*exp(y(15))*T125*y(62)*params(5)*params(29)*T1620/T133;
  g1(29,14)=T321-y(61)*T133*T105*T129*T125*params(5)*params(29)/(T133*T138);
  g1(29,15)=T310-T225*T133*T105*exp(y(15))*T125*y(62)*params(5)*params(29)/T133;
  g1(29,19)=(-(T125*y(70)*(-exp((-y(19))))));
  g1(29,36)=(-(T105*y(13)*y(67)*(-exp((-y(36))))));
  g1(29,41)=(-(y(61)*(1+params(27))*T133*T68*params(30)*T105*T2536/params(27)));
  g1(29,50)=(-params(3));
  g1(29,56)=(-(T133*T105*params(5)*T125/(y(13)*T133)))+T133*T105*params(5)*T125/(T133*params(3)*y(13));
  g1(29,57)=T105*(T55*params(31)*exp((-y(8))))^T161;
  g1(29,61)=T133*T105*T129*T125*params(5)*params(29)/(T138*params(3)*T133)-(T452+T133*T105*T129*T125*params(5)*params(29)/(T133*T138));
  g1(29,62)=T225*T133*T105*exp(y(15))*T125*params(5)*params(29)/(params(3)*T133)-T225*T133*T105*exp(y(15))*T125*params(5)*params(29)/T133;
  g1(29,67)=(-(T105*y(13)*exp((-y(36)))));
  g1(29,70)=(-(T125*exp((-y(19)))));
  g1(30,12)=T105*exp((-y(36)))*y(13)*y(67);
  g1(30,13)=T105*y(67)*exp((-y(36)));
  g1(30,36)=T105*y(13)*y(67)*(-exp((-y(36))));
  g1(30,50)=1;
  g1(30,67)=T105*y(13)*exp((-y(36)));
  g1(31,7)=(-(y(61)*((1+params(27))*T114*T68*params(30)*T105*T1131/params(27)+(1+params(27))*T490*T105*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*T1131/params(27))));
  g1(31,10)=T68*y(65)-y(61)*(T1428+(1+params(27))*(T490*T133*T105*exp((-y(41)))*params(30)*params(25)*2*exp(2*y(10))+T133*T105*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*T68*exp((-y(41)))*getPowerDeriv(T68*exp((-y(41))),params(25)-1,1))/params(27))-T68*y(62)*(1+params(35)*exp(y(42)))/params(27)-T68*y(66)*params(7)*exp(y(40))+(T515+T68*exp(y(17))*params(30)*y(54)*T68*getPowerDeriv(T68,params(25),1))/T277;
  g1(31,12)=(-T495);
  g1(31,17)=T515/T277;
  g1(31,40)=(-(T68*y(66)*params(7)*exp(y(40))));
  g1(31,41)=(-(y(61)*((1+params(27))*T133*T68*params(30)*T105*T2536/params(27)+(1+params(27))*(T490*T133*T105*params(30)*params(25)*exp(2*y(10))*(-exp((-y(41))))+T133*T105*exp((-y(41)))*params(30)*params(25)*exp(2*y(10))*getPowerDeriv(T68*exp((-y(41))),params(25)-1,1)*T68*(-exp((-y(41)))))/params(27))))+(-(T515*exp(y(41))*getPowerDeriv(exp(y(41)),params(25),1)))/(T277*T277);
  g1(31,42)=(-(T68*y(62)*params(35)*exp(y(42))/params(27)));
  g1(31,54)=T68^params(25)*T68*params(30)*exp(y(17))/T277;
  g1(31,61)=(-T494);
  g1(31,62)=(-(T68*(1+params(35)*exp(y(42)))/params(27)));
  g1(31,65)=T68;
  g1(31,66)=(-(T68*params(7)*exp(y(40))));
  g1(32,21)=T78*y(71)-y(73)*((1+params(26))*T533*(T91*T78*params(12)*params(36)*T524*T528+T91*T78*params(12)*params(36)*T524*T1823)/params(26)+(T550*T555*(T549+T548*T1823)-T549*T555*T1832)/(T550*T555*T550*T555))-(T550*T78*y(55)-T78*y(55)*T1832)/(T550*T550)+T528*T78*y(80)*params(12)*params(47)*params(48)+T78*y(80)*params(12)*params(47)*params(48)*T1823-T1855+T1861-(y(27)*T550*(T528*T524*T78*T422*params(12)*params(13)*y(68)+T524*T78*T422*params(12)*params(13)*y(68)*T1823)-T528*T524*T78*T422*params(12)*params(13)*y(68)*y(27)*T1832)/(y(27)*T550*y(27)*T550)+(T620*(T550*T524*T78*T422*params(12)*params(13)*y(68)+T524*T78*T422*params(12)*params(13)*y(68)*T1832)-T550*T524*T78*T422*params(12)*params(13)*y(68)*params(3)*y(27)*T78*getPowerDeriv(T78,1+params(12),1))/(T620*T620)-(T550*T634*(T528*T630+T630*T1823)-T528*T630*T634*T1832)/(T550*T550)+(T640*T634*(T550*T630+T630*T1832)-T634*T550*T630*params(3)*T78*getPowerDeriv(T78,1+params(12),1))/(T640*T640)+(T555*T640*(T648+T524*T546*T78*T422*y(73)*params(12)*params(13)*params(28)*T1832)-T648*T555*params(3)*T78*getPowerDeriv(T78,1+params(12),1))/(T555*T640*T555*T640);
  g1(32,22)=T2044;
  g1(32,23)=(-T2082);
  g1(32,24)=(-(y(73)*(1+params(26))*(T91*T78*params(12)*params(36)*T524*T528*T533+T91*T78*params(12)*params(36)*T524*T528*T2115)/params(26)));
  g1(32,26)=T605+(-(y(73)*(T538+T528*(T548+T524*T546*T78*params(12)*params(13)*params(28)*(-T422))/(T550*T555))))-T528*(T524*T78*T422*params(12)*params(13)*y(68)+T524*T78*params(12)*params(13)*y(68)*(-T422))/(y(27)*T550)+T550*(T524*T78*T422*params(12)*params(13)*y(68)+T524*T78*params(12)*params(13)*y(68)*(-T422))/T620-T634*T528*(T630+T524*exp(y(29))*T78*params(12)*params(13)*params(28)*y(74)*(-T422))/T550+T634*T550*(T630+T524*exp(y(29))*T78*params(12)*params(13)*params(28)*y(74)*(-T422))/T640+T550*(T524*T546*T78*T422*y(73)*params(12)*params(13)*params(28)+T524*T546*T78*y(73)*params(12)*params(13)*params(28)*(-T422))/(T555*T640);
  g1(32,27)=(-(y(73)*(-(T549*T550*T2303))/(T550*T555*T550*T555)))-(-(T550*T528*T524*T78*T422*params(12)*params(13)*y(68)))/(y(27)*T550*y(27)*T550)+(-(T550*T524*T78*T422*params(12)*params(13)*y(68)*T640))/(T620*T620)-T528*T630*T2319/T550+T550*T630*T2319/T640+(-(T648*T640*T2303))/(T555*T640*T555*T640);
  g1(32,28)=T648/(T555*T640)+(-(y(73)*T549/(T550*T555)));
  g1(32,29)=T634*T550*T630/T640+(-(T528*T630*T634/T550));
  g1(32,44)=(-(y(73)*(1+params(26))*T91*T78*params(12)*params(36)*T524*T528*T2599/params(26)));
  g1(32,55)=(-(T78/T550));
  g1(32,68)=(-(T528*T524*T78*T422*params(12)*params(13)/(y(27)*T550)))+T550*T524*T78*T422*params(12)*params(13)/T620;
  g1(32,69)=T603*T524*T78*params(14)*params(37)*exp((-y(22)))/(1+params(14));
  g1(32,70)=(-(T587*T78*params(38)*params(14)*exp((-y(23)))/(1+params(14))));
  g1(32,71)=T78;
  g1(32,73)=(-(T538+T549/(T550*T555)))+T548*T550/(T555*T640);
  g1(32,74)=(-(T634*T528*T524*T78*T422*params(12)*params(13)*params(28)*exp(y(29))/T550))+T634*T550*T524*T78*T422*params(12)*params(13)*params(28)*exp(y(29))/T640;
  g1(32,80)=T528*T78*params(12)*params(47)*params(48);
  g1(33,21)=(-T1861);
  g1(33,22)=(-y(77))*exp(y(22))-(T670*(T662+exp(y(22))*y(71)*T656*exp(y(22))*getPowerDeriv(exp(y(22)),T659-1,1))+T662*T2053)-T2044;
  g1(33,23)=(-(T662*T2087));
  g1(33,26)=(-T605);
  g1(33,69)=(-(T603*T524*T78*params(14)*params(37)*exp((-y(22)))/(1+params(14))));
  g1(33,71)=(-(T670*exp(y(22))^(T659-1)*exp(y(22))*T656));
  g1(33,77)=(-exp(y(22)));
  g1(34,79)=1;
  g1(35,24)=exp(y(31))*params(36)*y(55)*T91*getPowerDeriv(T91,1+params(24),1)/T686;
  g1(35,31)=exp(y(31))*y(76)+T687;
  g1(35,44)=(-(T93*exp(y(31))*params(36)*y(55)*(1+params(24))*exp(y(44))*getPowerDeriv(exp(y(44)),params(24),1)))/(T686*T686);
  g1(35,51)=(-params(3));
  g1(35,55)=T93*params(36)*exp(y(31))/T686;
  g1(35,76)=exp(y(31));
  g1(36,27)=(-((-(params(28)*y(76)*exp(y(37))*T2303))/(T555*T555)));
  g1(36,37)=(-(params(28)*y(76)*exp(y(37))/T555));
  g1(36,51)=1;
  g1(36,76)=(-(params(28)*exp(y(37))/T555));
  g1(37,25)=y(78)*exp(y(25))-y(77)*exp(y(25));
  g1(37,77)=(-exp(y(25)));
  g1(37,78)=exp(y(25));
  g1(38,21)=(-T1918);
  g1(38,26)=(-T2215);
  g1(38,27)=(-T2337);
  g1(38,28)=T546*y(72)*exp((-y(29)));
  g1(38,29)=y(74)*exp(y(29))+T546*y(72)*(-exp((-y(29))))-T718;
  g1(38,72)=T546*exp((-y(29)));
  g1(38,74)=exp(y(29))-T634*T550*T524*exp(y(29))*T422*params(13)*params(28)/(params(3)*T550);
  g1(39,21)=(-T1926);
  g1(39,26)=(-T2222);
  g1(39,27)=(-T2342);
  g1(39,28)=y(73)*T546-T546*y(72)*exp((-y(29)))-T729;
  g1(39,29)=(-(T546*y(72)*(-exp((-y(29))))));
  g1(39,72)=(-(T546*exp((-y(29)))));
  g1(39,73)=T546-T550*T524*T546*T422*params(13)*params(28)/(T555*params(3)*T550);
  g1(40,21)=T1855;
  g1(40,22)=(-(T735*T2053));
  g1(40,23)=T2082-(T735*T2087+T670*(T735+exp(y(23))*y(71)*T665*exp(y(23))*getPowerDeriv(exp(y(23)),T659-1,1)))-y(65)*exp(y(23))/params(33);
  g1(40,65)=(-(exp(y(23))/params(33)));
  g1(40,70)=T587*T78*params(38)*params(14)*exp((-y(23)))/(1+params(14));
  g1(40,71)=(-(T670*exp(y(23))^(T659-1)*T665*exp(y(23))));
  g1(41,21)=(T764*T524*T422*params(13)*y(68)*T1832-T550*T524*T422*params(13)*y(68)*params(3)*y(27)^2*T1832)/(T764*T764)-(T786*(T632-1)*T524*exp(y(29))*T422*y(74)*params(28)*params(13)*params(39)*T1832-T550*T524*exp(y(29))*T422*y(74)*params(28)*params(13)*params(39)*(T632-1)*T552^T632*params(3)*y(27)^2*T1832)/(T786*T786)-(T772*T550*params(3)*T746*(1+params(26))*(1+params(24))*T524*T546*T422*y(73)*params(28)*params(13)*params(39)*T1832-T795*T772*params(3)*T746*T1832)/(T772*T550*params(3)*T746*T772*T550*params(3)*T746);
  g1(41,26)=(-(T524*y(79)*exp((-y(39)))))+T550*(T524*T422*params(13)*y(68)+T524*params(13)*y(68)*(-T422))/T764-(T632-1)*T550*(T524*exp(y(29))*T422*y(74)*params(28)*params(13)*params(39)+T524*exp(y(29))*y(74)*params(28)*params(13)*params(39)*(-T422))/T786-(1+params(26))*(1+params(24))*T550*(T524*T546*T422*y(73)*params(28)*params(13)*params(39)+T524*T546*y(73)*params(28)*params(13)*params(39)*(-T422))/(T772*T550*params(3)*T746);
  g1(41,27)=(-(params(28)*params(39)*y(75)*(T749*params(26)*2*y(27)+T746*T2301*getPowerDeriv(T552,T748,1))))/(T746*T749*T746*T749)+(-(T550*T524*T422*params(13)*y(68)*T550*params(3)*2*y(27)))/(T764*T764)-(-((1+params(26))*(1+params(24))*exp(y(37))*y(76)*params(28)*params(39)*(T772*params(26)*2*y(27)+T746*T2301*getPowerDeriv(T552,1+T554,1))))/(T746*T772*T746*T772)-(-(T550*T524*exp(y(29))*T422*y(74)*params(28)*params(13)*params(39)*(T632-1)*(T552^T632*T550*params(3)*2*y(27)+T764*T2301*getPowerDeriv(T552,T632,1))))/(T786*T786)-(-(T795*(T550*params(3)*T746*T2301*getPowerDeriv(T552,1+T554,1)+T772*T550*params(3)*params(26)*2*y(27))))/(T772*T550*params(3)*T746*T772*T550*params(3)*T746);
  g1(41,28)=(-(T795/(T772*T550*params(3)*T746)));
  g1(41,29)=(-T787);
  g1(41,37)=(-T774);
  g1(41,39)=(-(T524*y(79)*(-exp((-y(39))))));
  g1(41,47)=(-1);
  g1(41,68)=T550*T524*T422*params(13)/T764;
  g1(41,73)=(-((1+params(26))*(1+params(24))*T550*T524*T546*T422*params(28)*params(13)*params(39)/(T772*T550*params(3)*T746)));
  g1(41,74)=(-((T632-1)*T550*T524*exp(y(29))*T422*params(28)*params(13)*params(39)/T786));
  g1(41,75)=params(28)*params(39)/(T746*T749);
  g1(41,76)=(-((1+params(26))*(1+params(24))*exp(y(37))*params(28)*params(39)/(T746*T772)));
  g1(41,79)=(-(T524*exp((-y(39)))));
  g1(42,30)=T809*(T808+y(72)*T803*T803*getPowerDeriv(T803,params(24)*(1+params(26))/params(26),1))+(y(75)*T803*(params(28)-1)*T815-y(75)*T803*(params(28)-1)*params(26)*T803*getPowerDeriv(T803,T748,1))/(T815*T815)-((params(28)-1)*(1+params(26))*(1+params(24))*y(76)*T803*T823-(params(28)-1)*(1+params(26))*(1+params(24))*y(76)*T803*params(26)*T803*getPowerDeriv(T803,1+T554,1))/(T823*T823);
  g1(42,72)=T809*T803*T807;
  g1(42,75)=T803*(params(28)-1)/T815;
  g1(42,76)=(-((params(28)-1)*(1+params(26))*(1+params(24))*T803/T823));
  g1(43,32)=(-((-(y(68)*2*(1+y(32))))/(T831*T831)));
  g1(43,52)=(-params(3));
  g1(43,68)=(-(1/T831));
  g1(44,52)=1;
  g1(45,19)=(-(y(58)*T422*exp(y(19))));
  g1(45,21)=T1918+T1926+T524*y(69)*T78*params(37)*exp((-y(22)))*getPowerDeriv(T78*params(37)*exp((-y(22))),T585,1)-y(73)*((1+params(26))*T533*T91*params(36)*T524*T1832/params(26)+(T550*T555*T524*T546*T422*params(13)*params(28)*T1832-T550*T524*T546*T422*params(13)*params(28)*T555*T1832)/(T550*T555*T550*T555))-(y(27)*T550*T524*T422*params(13)*y(68)*T1832-T550*T524*T422*params(13)*y(68)*y(27)*T1832)/(y(27)*T550*y(27)*T550)+(T550*params(3)*y(27)*T524*T422*params(13)*y(68)*T1832-T550*T524*T422*params(13)*y(68)*params(3)*y(27)*T1832)/(T550*params(3)*y(27)*T550*params(3)*y(27))-(T550*T634*T524*exp(y(29))*T422*y(74)*params(13)*params(28)*T1832-T634*T550*T524*exp(y(29))*T422*y(74)*params(13)*params(28)*T1832)/(T550*T550);
  g1(45,22)=T524*y(69)*getPowerDeriv(T78*params(37)*exp((-y(22))),T585,1)*T78*params(37)*(-exp((-y(22))));
  g1(45,24)=(-(y(73)*T2127));
  g1(45,26)=T2215+T2222+T524*y(69)*(T78*params(37)*exp((-y(22))))^T585-y(73)*(T844+T550*(T524*T546*T422*params(13)*params(28)+T524*T546*params(13)*params(28)*(-T422))/(T550*T555))-exp(y(19))*y(58)*(-T422)-T524*exp((-y(39)))*y(27)*y(79)-T550*(T524*T422*params(13)*y(68)+T524*params(13)*y(68)*(-T422))/(y(27)*T550)+T550*(T524*T422*params(13)*y(68)+T524*params(13)*y(68)*(-T422))/(T550*params(3)*y(27))-T634*T550*(T524*exp(y(29))*T422*y(74)*params(13)*params(28)+T524*exp(y(29))*y(74)*params(13)*params(28)*(-T422))/T550;
  g1(45,27)=T2337+T2342+(-(y(73)*(-(T550*T524*T546*T422*params(13)*params(28)*T550*T2303))/(T550*T555*T550*T555)))-T524*y(79)*exp((-y(39)))-(-(T550*T550*T524*T422*params(13)*y(68)))/(y(27)*T550*y(27)*T550)+(-(params(3)*T550*T550*T524*T422*params(13)*y(68)))/(T550*params(3)*y(27)*T550*params(3)*y(27))-T550*T524*exp(y(29))*T422*y(74)*params(13)*params(28)*T2319/T550;
  g1(45,28)=T729-y(73)*T550*T524*T546*T422*params(13)*params(28)/(T550*T555);
  g1(45,29)=T718-T634*T550*T524*exp(y(29))*T422*y(74)*params(13)*params(28)/T550;
  g1(45,39)=(-(T524*y(27)*y(79)*(-exp((-y(39))))));
  g1(45,44)=(-(y(73)*(1+params(26))*T550*T91*params(36)*T524*T2599/params(26)));
  g1(45,53)=(-params(3));
  g1(45,58)=(-(T422*exp(y(19))));
  g1(45,68)=(-(T550*T524*T422*params(13)/(y(27)*T550)))+T550*T524*T422*params(13)/(T550*params(3)*y(27));
  g1(45,69)=T524*(T78*params(37)*exp((-y(22))))^T585;
  g1(45,73)=T550*T524*T546*T422*params(13)*params(28)/(T555*params(3)*T550)-(T844+T550*T524*T546*T422*params(13)*params(28)/(T550*T555));
  g1(45,74)=T634*T550*T524*exp(y(29))*T422*params(13)*params(28)/(params(3)*T550)-T634*T550*T524*exp(y(29))*T422*params(13)*params(28)/T550;
  g1(45,79)=(-(T524*y(27)*exp((-y(39)))));
  g1(46,26)=T524*exp((-y(39)))*y(27)*y(79);
  g1(46,27)=T524*y(79)*exp((-y(39)));
  g1(46,39)=T524*y(27)*y(79)*(-exp((-y(39))));
  g1(46,53)=1;
  g1(46,79)=T524*y(27)*exp((-y(39)));
  g1(47,21)=(-(y(73)*((1+params(26))*T533*T91*params(36)*T524*T1832/params(26)+(1+params(26))*T882*T524*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*T1832/params(26))));
  g1(47,24)=T91*y(77)-y(73)*(T2127+(1+params(26))*(T882*T550*T524*exp((-y(44)))*params(36)*params(24)*2*exp(2*y(24))+T550*T524*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*T91*exp((-y(44)))*getPowerDeriv(T91*exp((-y(44))),params(24)-1,1))/params(26))-T91*y(74)*(1+params(40)*exp(y(45)))/params(26)-T91*y(78)*params(15)*exp(y(43))+(T907+T91*exp(y(31))*params(36)*y(55)*T91*getPowerDeriv(T91,params(24),1))/T685;
  g1(47,26)=(-T887);
  g1(47,31)=T907/T685;
  g1(47,43)=(-(T91*y(78)*params(15)*exp(y(43))));
  g1(47,44)=(-(y(73)*((1+params(26))*T550*T91*params(36)*T524*T2599/params(26)+(1+params(26))*(T882*T550*T524*params(36)*params(24)*exp(2*y(24))*(-exp((-y(44))))+T550*T524*exp((-y(44)))*params(36)*params(24)*exp(2*y(24))*getPowerDeriv(T91*exp((-y(44))),params(24)-1,1)*T91*(-exp((-y(44)))))/params(26))))+(-(T907*exp(y(44))*getPowerDeriv(exp(y(44)),params(24),1)))/(T685*T685);
  g1(47,45)=(-(T91*y(74)*params(40)*exp(y(45))/params(26)));
  g1(47,55)=T91^params(24)*T91*params(36)*exp(y(31))/T685;
  g1(47,73)=(-T886);
  g1(47,74)=(-(T91*(1+params(40)*exp(y(45)))/params(26)));
  g1(47,77)=T91;
  g1(47,78)=(-(T91*params(15)*exp(y(43))));
  g1(48,46)=1;
  g1(49,47)=1;
  g1(50,54)=1;
  g1(51,55)=1;
  g1(52,7)=(-((T920*params(5)*T1298-params(5)*T920*T1298)/(T920*T920)/y(13)));
  g1(52,12)=(-((T920*params(5)*T1572-params(5)*T920*T1572)/(T920*T920)/y(13)));
  g1(52,13)=(-((-(params(5)*T920/T920))/(y(13)*y(13))));
  g1(52,18)=(-1)/((1+y(18))*(1+y(18)));
  g1(53,7)=T105*T926*getPowerDeriv(T926,T161,1);
  g1(53,8)=T105*getPowerDeriv(T926,T161,1)*(-(exp(y(8))*T55*params(31)))/(exp(y(8))*exp(y(8)));
  g1(53,12)=T105*T926^T161;
  g1(54,7)=(-(T932*getPowerDeriv(T932,T161,1)));
  g1(54,9)=(-(getPowerDeriv(T932,T161,1)*(-(exp(y(9))*T55*params(32)))/(exp(y(9))*exp(y(9)))));
  g1(54,19)=exp(y(19))/T524;
  g1(54,26)=(-(exp(y(19))*T524))/(T524*T524);
  g1(55,7)=T55;
  g1(55,8)=(-(T248*exp(y(8))*getPowerDeriv(exp(y(8)),T251,1)*getPowerDeriv(T261,1+params(6),1)));
  g1(55,9)=(-(getPowerDeriv(T261,1+params(6),1)*T257*exp(y(9))*getPowerDeriv(exp(y(9)),T251,1)));
  g1(56,14)=(-(T129/exp(y(15))));
  g1(56,15)=(-((-(T129*exp(y(15))))/(exp(y(15))*exp(y(15)))));
  g1(56,16)=T397*getPowerDeriv(T397,1+params(25)*T223,1);
  g1(57,7)=(-(T68*(-(T945*T1298))/(T920*T920)+T129*T953*(T920*params(5)*params(29)*T1298-params(5)*params(29)*T920*T1298)/(T920*T920)));
  g1(57,10)=(-(T68*T945/T920+T68*params(30)*T223*T68/exp(y(41))*T1454/T920));
  g1(57,12)=(-(T68*(-(T945*T1572))/(T920*T920)+T129*T953*(T920*params(5)*params(29)*T1572-params(5)*params(29)*T920*T1572)/(T920*T920)));
  g1(57,13)=(-(T129*T949*T1602*getPowerDeriv(T135,T952,1)));
  g1(57,14)=T129-T129*T949*T953;
  g1(57,41)=(-(T68*params(30)*T223*T1454*(-(exp(y(41))*T68))/(exp(y(41))*exp(y(41)))/T920));
  g1(58,7)=(-(exp(y(15))*T225*(T920*params(5)*params(29)*T1298-params(5)*params(29)*T920*T1298)/(T920*T920)));
  g1(58,10)=(-(T68*(1+params(35)*exp(y(42)))/params(27)));
  g1(58,12)=(-(exp(y(15))*T225*(T920*params(5)*params(29)*T1572-params(5)*params(29)*T920*T1572)/(T920*T920)));
  g1(58,13)=(-(exp(y(15))*T949*T1620));
  g1(58,15)=exp(y(15))-exp(y(15))*T225*T949;
  g1(58,42)=(-(T68*params(35)*exp(y(42))/params(27)));
  g1(59,13)=params(29)*T1602*getPowerDeriv(T135,T965,1);
  g1(59,16)=(1-params(29))*T397*getPowerDeriv(T397,T965,1);
  g1(60,13)=(-(exp(y(34))*params(29)*T1602*getPowerDeriv(T135,T952,1)));
  g1(60,16)=(-((1-params(29))*T397*getPowerDeriv(T397,T952,1)));
  g1(60,17)=exp(y(17));
  g1(60,34)=(-(exp(y(34))*params(29)*T953));
  g1(61,8)=(-exp(y(8)));
  g1(61,10)=T68;
  g1(61,11)=(-exp(y(11)));
  g1(61,23)=(-(exp(y(23))*1/params(33)));
  g1(62,10)=(-(exp(y(40))*T68*params(7)));
  g1(62,11)=exp(y(11));
  g1(62,40)=(-(exp(y(40))*T68*params(7)));
  g1(63,12)=(-(y(13)*T105/exp(y(36))));
  g1(63,13)=(-(T105/exp(y(36))));
  g1(63,20)=1;
  g1(63,36)=(-(y(13)*(-(T105*exp(y(36))))/(exp(y(36))*exp(y(36)))));
  g1(64,21)=(-((T994*params(13)*T1998-params(13)*T994*T1998)/(T994*T994)/y(27)));
  g1(64,26)=(-((T994*params(13)*T2274-params(13)*T994*T2274)/(T994*T994)/y(27)));
  g1(64,27)=(-((-(params(13)*T994/T994))/(y(27)*y(27))));
  g1(64,32)=(-1)/((1+y(32))*(1+y(32)));
  g1(65,21)=T524*T1000*getPowerDeriv(T1000,T585,1);
  g1(65,22)=T524*getPowerDeriv(T1000,T585,1)*(-(exp(y(22))*T78*params(37)))/(exp(y(22))*exp(y(22)));
  g1(65,26)=T524*T1000^T585;
  g1(66,12)=(-(T105*1/exp(y(19))))/(T105*T105);
  g1(66,19)=(-exp(y(19)))/(exp(y(19))*exp(y(19)))/T105;
  g1(66,21)=(-(T1007*getPowerDeriv(T1007,T585,1)));
  g1(66,23)=(-(getPowerDeriv(T1007,T585,1)*(-(exp(y(23))*T78*params(38)))/(exp(y(23))*exp(y(23)))));
  g1(67,21)=T78;
  g1(67,22)=(-(T656*exp(y(22))*getPowerDeriv(exp(y(22)),T659,1)*getPowerDeriv(T669,1+params(14),1)));
  g1(67,23)=(-(getPowerDeriv(T669,1+params(14),1)*T665*exp(y(23))*getPowerDeriv(exp(y(23)),T659,1)));
  g1(68,28)=(-(T546/exp(y(29))));
  g1(68,29)=(-((-(T546*exp(y(29))))/(exp(y(29))*exp(y(29)))));
  g1(68,30)=T803*getPowerDeriv(T803,1+params(24)*T632,1);
  g1(69,21)=(-(T91*(-(T1020*T1998))/(T994*T994)+T546*T1028*(T994*params(13)*params(28)*T1998-params(13)*params(28)*T994*T1998)/(T994*T994)));
  g1(69,24)=(-(T91*T1020/T994+T91*params(36)*T632*T91/exp(y(44))*T2153/T994));
  g1(69,26)=(-(T91*(-(T1020*T2274))/(T994*T994)+T546*T1028*(T994*params(13)*params(28)*T2274-params(13)*params(28)*T994*T2274)/(T994*T994)));
  g1(69,27)=(-(T546*T1024*T2301*getPowerDeriv(T552,T1027,1)));
  g1(69,28)=T546-T546*T1024*T1028;
  g1(69,44)=(-(T91*params(36)*T632*T2153*(-(exp(y(44))*T91))/(exp(y(44))*exp(y(44)))/T994));
  g1(70,21)=(-(exp(y(29))*T634*(T994*params(13)*params(28)*T1998-params(13)*params(28)*T994*T1998)/(T994*T994)));
  g1(70,24)=(-(T91*(1+params(40)*exp(y(45)))/params(26)));
  g1(70,26)=(-(exp(y(29))*T634*(T994*params(13)*params(28)*T2274-params(13)*params(28)*T994*T2274)/(T994*T994)));
  g1(70,27)=(-(exp(y(29))*T1024*T2319));
  g1(70,29)=exp(y(29))-exp(y(29))*T634*T1024;
  g1(70,45)=(-(T91*params(40)*exp(y(45))/params(26)));
  g1(71,27)=params(28)*T2301*getPowerDeriv(T552,T1040,1);
  g1(71,30)=(1-params(28))*T803*getPowerDeriv(T803,T1040,1);
  g1(72,27)=(-(exp(y(37))*params(28)*T2301*getPowerDeriv(T552,T1027,1)));
  g1(72,30)=(-((1-params(28))*T803*getPowerDeriv(T803,T1027,1)));
  g1(72,31)=exp(y(31));
  g1(72,37)=(-(exp(y(37))*params(28)*T1028));
  g1(73,9)=(-(exp(y(9))*params(33)));
  g1(73,22)=(-exp(y(22)));
  g1(73,24)=T91;
  g1(73,25)=(-exp(y(25)));
  g1(74,24)=(-(exp(y(43))*T91*params(15)));
  g1(74,25)=exp(y(25));
  g1(74,43)=(-(exp(y(43))*T91*params(15)));
  g1(75,26)=(-(y(27)*T524/exp(y(39))));
  g1(75,27)=(-(T524/exp(y(39))));
  g1(75,33)=1;
  g1(75,39)=(-(y(27)*(-(T524*exp(y(39))))/(exp(y(39))*exp(y(39)))));
  g1(76,7)=(-(params(51)*(-(params(50)*params(49)/exp(y(19))*T55*getPowerDeriv(T55,(-params(4)),1)))/(T919*T919)));
  g1(76,19)=(-(params(51)*params(50)*(-(params(49)*exp(y(19))))/(exp(y(19))*exp(y(19)))/T919));
  g1(76,21)=params(48)*(-(params(47)*T78*getPowerDeriv(T78,(-params(12)),1)))/(T993*T993);
  g1(77,40)=1-params(8);
  g1(78,41)=1-params(10);
  g1(79,42)=1-params(22);
  g1(80,43)=1-params(16);
  g1(81,44)=1-params(18);
  g1(82,45)=1-params(20);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],82,6724);
end
end
