function [residual, g1, g2] = BBCDLmodelcomp_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                     columns: variables in declaration order
%                                                     rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 35, 1);

%
% Model equations
%

T30 = params(27)*exp(y(31))^(-params(22))*exp(y(6))^(1+params(22))/(1+params(22))*exp(y(13));
T55 = params(33)*exp(y(34))^(-params(21))*exp(y(20))^(1+params(21))/(1+params(21))*exp(y(27));
T64 = ((1+y(14))/(1+params(38)))^params(40);
T67 = y(9)/params(31);
T69 = T67^params(41);
T86 = ((1+y(28))/(1+params(39)))^params(42);
T89 = y(23)/params(36);
T91 = T89^params(43);
T105 = exp(y(3))^(-params(1));
T108 = T105/exp(y(8));
T117 = exp(y(3))*params(28)/exp(y(4));
T120 = params(3)/(1+params(3));
T133 = exp(y(3))*params(29)/exp(y(5));
T137 = 1/(1+params(3));
T143 = params(28)^T120*exp(y(4))^T137+params(29)^T120*exp(y(5))^T137;
T161 = exp(y(6))/exp(y(31));
T163 = params(27)*(1+params(24))/params(24)*T161^params(22);
T169 = T108*params(2)*params(26)/T108;
T170 = params(31)/y(9);
T173 = (1+params(22))*(-(1+params(24)))/params(24);
T174 = T170^T173;
T187 = T170^(1-(1+params(24))/params(24));
T193 = (-1)/params(24);
T227 = exp(y(17))^(-params(9));
T228 = T227/exp(y(22));
T237 = exp(y(17))*params(34)/exp(y(18));
T240 = params(11)/(1+params(11));
T248 = exp(y(17))*params(35)/exp(y(19));
T252 = 1/(1+params(11));
T258 = params(34)^T240*exp(y(18))^T252+params(35)^T240*exp(y(19))^T252;
T276 = exp(y(20))/exp(y(34));
T278 = params(33)*(1+params(23))/params(23)*T276^params(21);
T284 = T228*params(10)*params(25)/T228;
T285 = params(36)/y(23);
T288 = (1+params(21))*(-(1+params(23)))/params(23);
T289 = T285^T288;
T302 = T285^(1-(1+params(23))/params(23));
T308 = (-1)/params(23);
T395 = exp(y(3))*getPowerDeriv(exp(y(3)),(-params(1)),1)/exp(y(8));
T476 = (-(T105*exp(y(8))))/(exp(y(8))*exp(y(8)));
T522 = (-params(31))/(y(9)*y(9))*getPowerDeriv(T170,T173,1);
T582 = exp(y(17))*getPowerDeriv(exp(y(17)),(-params(9)),1)/exp(y(22));
T665 = (-(exp(y(22))*T227))/(exp(y(22))*exp(y(22)));
T708 = (-params(36))/(y(23)*y(23))*getPowerDeriv(T285,T288,1);
lhs =y(1);
rhs =exp(y(3))^(1-params(1))/(1-params(1))-T30;
residual(1)= lhs-rhs;
lhs =y(2);
rhs =exp(y(17))^(1-params(9))/(1-params(9))-T55;
residual(2)= lhs-rhs;
lhs =y(14);
rhs =(1+params(38))*T64*(T67*T69)^(1-params(40))*(1+x(7))-1;
residual(3)= lhs-rhs;
lhs =y(28);
rhs =(1+params(39))*T86*(T89*T91)^(1-params(42))*(1+x(8))-1;
residual(4)= lhs-rhs;
lhs =1/(1+y(14));
rhs =params(2)*T108/T108/y(9);
residual(5)= lhs-rhs;
lhs =exp(y(8))*T117^T120;
rhs =1;
residual(6)= lhs-rhs;
lhs =exp(y(15))/exp(y(22));
rhs =T133^T120;
residual(7)= lhs-rhs;
lhs =exp(y(3));
rhs =T143^(1+params(3));
residual(8)= lhs-rhs;
lhs =exp(y(12))^(1+params(22)*(1+params(24))/params(24));
rhs =exp(y(10))/exp(y(11));
residual(9)= lhs-rhs;
lhs =exp(y(10));
rhs =exp(y(6))*T163/T108+exp(y(10))*T169*T174;
residual(10)= lhs-rhs;
lhs =exp(y(11));
rhs =exp(y(6))*(1+params(32)*exp(y(32)))/params(24)+exp(y(11))*T169*T187;
residual(11)= lhs-rhs;
lhs =(1-params(26))*exp(y(12))^T193+params(26)*T170^T193;
rhs =1;
residual(12)= lhs-rhs;
lhs =exp(y(13));
rhs =(1-params(26))*exp(y(12))^T173+exp(y(13))*params(26)*T174;
residual(13)= lhs-rhs;
lhs =exp(y(6));
rhs =exp(y(4))+exp(y(7))+1/params(30)*exp(y(19));
residual(14)= lhs-rhs;
lhs =exp(y(7));
rhs =exp(y(6))*params(4)*exp(y(30));
residual(15)= lhs-rhs;
lhs =y(16);
rhs =y(9);
residual(16)= lhs-rhs;
lhs =1/(1+y(28));
rhs =params(10)*T228/T228/y(23);
residual(17)= lhs-rhs;
lhs =exp(y(22))*T237^T240;
rhs =1;
residual(18)= lhs-rhs;
lhs =1/exp(y(15))/exp(y(8));
rhs =T248^T240;
residual(19)= lhs-rhs;
lhs =exp(y(17));
rhs =T258^(1+params(11));
residual(20)= lhs-rhs;
lhs =exp(y(26))^(1+params(21)*(1+params(23))/params(23));
rhs =exp(y(24))/exp(y(25));
residual(21)= lhs-rhs;
lhs =exp(y(24));
rhs =exp(y(20))*T278/T228+exp(y(24))*T284*T289;
residual(22)= lhs-rhs;
lhs =exp(y(25));
rhs =exp(y(20))*(1+params(37)*exp(y(35)))/params(23)+exp(y(25))*T284*T302;
residual(23)= lhs-rhs;
lhs =(1-params(25))*exp(y(26))^T308+params(25)*T285^T308;
rhs =1;
residual(24)= lhs-rhs;
lhs =exp(y(27));
rhs =(1-params(25))*exp(y(26))^T288+exp(y(27))*params(25)*T289;
residual(25)= lhs-rhs;
lhs =exp(y(20));
rhs =exp(y(18))+exp(y(21))+exp(y(5))*params(30);
residual(26)= lhs-rhs;
lhs =exp(y(21));
rhs =exp(y(20))*params(12)*exp(y(33));
residual(27)= lhs-rhs;
lhs =y(29);
rhs =y(23);
residual(28)= lhs-rhs;
lhs =params(44)/T227*params(45);
rhs =params(46)/exp(y(15))*params(47)/T105*params(48);
residual(29)= lhs-rhs;
lhs =y(30);
rhs =y(30)*params(5)+params(6)*x(1);
residual(30)= lhs-rhs;
lhs =y(31);
rhs =y(31)*params(7)+params(8)*x(2);
residual(31)= lhs-rhs;
lhs =y(32);
rhs =y(32)*params(19)+params(20)*x(6);
residual(32)= lhs-rhs;
lhs =y(33);
rhs =y(33)*params(13)+params(14)*x(3);
residual(33)= lhs-rhs;
lhs =y(34);
rhs =y(34)*params(15)+params(16)*x(4);
residual(34)= lhs-rhs;
lhs =y(35);
rhs =y(35)*params(17)+params(18)*x(5);
residual(35)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(35, 35);

  %
  % Jacobian matrix
  %

  g1(1,1)=1;
  g1(1,3)=(-(exp(y(3))*getPowerDeriv(exp(y(3)),1-params(1),1)/(1-params(1))));
  g1(1,6)=exp(y(13))*params(27)*exp(y(31))^(-params(22))*exp(y(6))*getPowerDeriv(exp(y(6)),1+params(22),1)/(1+params(22));
  g1(1,13)=T30;
  g1(1,31)=exp(y(13))*exp(y(6))^(1+params(22))*params(27)*exp(y(31))*getPowerDeriv(exp(y(31)),(-params(22)),1)/(1+params(22));
  g1(2,2)=1;
  g1(2,17)=(-(exp(y(17))*getPowerDeriv(exp(y(17)),1-params(9),1)/(1-params(9))));
  g1(2,20)=exp(y(27))*params(33)*exp(y(34))^(-params(21))*exp(y(20))*getPowerDeriv(exp(y(20)),1+params(21),1)/(1+params(21));
  g1(2,27)=T55;
  g1(2,34)=exp(y(27))*exp(y(20))^(1+params(21))*params(33)*exp(y(34))*getPowerDeriv(exp(y(34)),(-params(21)),1)/(1+params(21));
  g1(3,9)=(-((1+x(7))*(1+params(38))*T64*(T69*1/params(31)+T67*1/params(31)*getPowerDeriv(T67,params(41),1))*getPowerDeriv(T67*T69,1-params(40),1)));
  g1(3,14)=1-(1+x(7))*(1+params(38))*(T67*T69)^(1-params(40))*1/(1+params(38))*getPowerDeriv((1+y(14))/(1+params(38)),params(40),1);
  g1(4,23)=(-((1+x(8))*(1+params(39))*T86*(T91*1/params(36)+T89*1/params(36)*getPowerDeriv(T89,params(43),1))*getPowerDeriv(T89*T91,1-params(42),1)));
  g1(4,28)=1-(1+x(8))*(1+params(39))*(T89*T91)^(1-params(42))*1/(1+params(39))*getPowerDeriv((1+y(28))/(1+params(39)),params(42),1);
  g1(5,3)=(-((T108*params(2)*T395-params(2)*T108*T395)/(T108*T108)/y(9)));
  g1(5,8)=(-((T108*params(2)*T476-params(2)*T108*T476)/(T108*T108)/y(9)));
  g1(5,9)=(-((-(params(2)*T108/T108))/(y(9)*y(9))));
  g1(5,14)=(-1)/((1+y(14))*(1+y(14)));
  g1(6,3)=exp(y(8))*T117*getPowerDeriv(T117,T120,1);
  g1(6,4)=exp(y(8))*getPowerDeriv(T117,T120,1)*(-(exp(y(3))*params(28)*exp(y(4))))/(exp(y(4))*exp(y(4)));
  g1(6,8)=exp(y(8))*T117^T120;
  g1(7,3)=(-(T133*getPowerDeriv(T133,T120,1)));
  g1(7,5)=(-(getPowerDeriv(T133,T120,1)*(-(exp(y(3))*params(29)*exp(y(5))))/(exp(y(5))*exp(y(5)))));
  g1(7,15)=exp(y(15))/exp(y(22));
  g1(7,22)=(-(exp(y(15))*exp(y(22))))/(exp(y(22))*exp(y(22)));
  g1(8,3)=exp(y(3));
  g1(8,4)=(-(params(28)^T120*exp(y(4))*getPowerDeriv(exp(y(4)),T137,1)*getPowerDeriv(T143,1+params(3),1)));
  g1(8,5)=(-(getPowerDeriv(T143,1+params(3),1)*params(29)^T120*exp(y(5))*getPowerDeriv(exp(y(5)),T137,1)));
  g1(9,10)=(-(exp(y(10))/exp(y(11))));
  g1(9,11)=(-((-(exp(y(10))*exp(y(11))))/(exp(y(11))*exp(y(11)))));
  g1(9,12)=exp(y(12))*getPowerDeriv(exp(y(12)),1+params(22)*(1+params(24))/params(24),1);
  g1(10,3)=(-(exp(y(6))*(-(T163*T395))/(T108*T108)+exp(y(10))*T174*(T108*params(2)*params(26)*T395-T108*params(2)*params(26)*T395)/(T108*T108)));
  g1(10,6)=(-(exp(y(6))*T163/T108+exp(y(6))*params(27)*(1+params(24))/params(24)*T161*getPowerDeriv(T161,params(22),1)/T108));
  g1(10,8)=(-(exp(y(6))*(-(T163*T476))/(T108*T108)+exp(y(10))*T174*(T108*params(2)*params(26)*T476-T108*params(2)*params(26)*T476)/(T108*T108)));
  g1(10,9)=(-(exp(y(10))*T169*T522));
  g1(10,10)=exp(y(10))-exp(y(10))*T169*T174;
  g1(10,31)=(-(exp(y(6))*params(27)*(1+params(24))/params(24)*getPowerDeriv(T161,params(22),1)*(-(exp(y(31))*exp(y(6))))/(exp(y(31))*exp(y(31)))/T108));
  g1(11,3)=(-(exp(y(11))*T187*(T108*params(2)*params(26)*T395-T108*params(2)*params(26)*T395)/(T108*T108)));
  g1(11,6)=(-(exp(y(6))*(1+params(32)*exp(y(32)))/params(24)));
  g1(11,8)=(-(exp(y(11))*T187*(T108*params(2)*params(26)*T476-T108*params(2)*params(26)*T476)/(T108*T108)));
  g1(11,9)=(-(exp(y(11))*T169*(-params(31))/(y(9)*y(9))*getPowerDeriv(T170,1-(1+params(24))/params(24),1)));
  g1(11,11)=exp(y(11))-exp(y(11))*T169*T187;
  g1(11,32)=(-(exp(y(6))*params(32)*exp(y(32))/params(24)));
  g1(12,9)=params(26)*(-params(31))/(y(9)*y(9))*getPowerDeriv(T170,T193,1);
  g1(12,12)=(1-params(26))*exp(y(12))*getPowerDeriv(exp(y(12)),T193,1);
  g1(13,9)=(-(exp(y(13))*params(26)*T522));
  g1(13,12)=(-((1-params(26))*exp(y(12))*getPowerDeriv(exp(y(12)),T173,1)));
  g1(13,13)=exp(y(13))-exp(y(13))*params(26)*T174;
  g1(14,4)=(-exp(y(4)));
  g1(14,6)=exp(y(6));
  g1(14,7)=(-exp(y(7)));
  g1(14,19)=(-(1/params(30)*exp(y(19))));
  g1(15,6)=(-(exp(y(6))*params(4)*exp(y(30))));
  g1(15,7)=exp(y(7));
  g1(15,30)=(-(exp(y(6))*params(4)*exp(y(30))));
  g1(16,9)=(-1);
  g1(16,16)=1;
  g1(17,17)=(-((T228*params(10)*T582-params(10)*T228*T582)/(T228*T228)/y(23)));
  g1(17,22)=(-((T228*params(10)*T665-params(10)*T228*T665)/(T228*T228)/y(23)));
  g1(17,23)=(-((-(params(10)*T228/T228))/(y(23)*y(23))));
  g1(17,28)=(-1)/((1+y(28))*(1+y(28)));
  g1(18,17)=exp(y(22))*T237*getPowerDeriv(T237,T240,1);
  g1(18,18)=exp(y(22))*getPowerDeriv(T237,T240,1)*(-(exp(y(17))*params(34)*exp(y(18))))/(exp(y(18))*exp(y(18)));
  g1(18,22)=exp(y(22))*T237^T240;
  g1(19,8)=(-(exp(y(8))*1/exp(y(15))))/(exp(y(8))*exp(y(8)));
  g1(19,15)=(-exp(y(15)))/(exp(y(15))*exp(y(15)))/exp(y(8));
  g1(19,17)=(-(T248*getPowerDeriv(T248,T240,1)));
  g1(19,19)=(-(getPowerDeriv(T248,T240,1)*(-(exp(y(19))*exp(y(17))*params(35)))/(exp(y(19))*exp(y(19)))));
  g1(20,17)=exp(y(17));
  g1(20,18)=(-(params(34)^T240*exp(y(18))*getPowerDeriv(exp(y(18)),T252,1)*getPowerDeriv(T258,1+params(11),1)));
  g1(20,19)=(-(getPowerDeriv(T258,1+params(11),1)*params(35)^T240*exp(y(19))*getPowerDeriv(exp(y(19)),T252,1)));
  g1(21,24)=(-(exp(y(24))/exp(y(25))));
  g1(21,25)=(-((-(exp(y(24))*exp(y(25))))/(exp(y(25))*exp(y(25)))));
  g1(21,26)=exp(y(26))*getPowerDeriv(exp(y(26)),1+params(21)*(1+params(23))/params(23),1);
  g1(22,17)=(-(exp(y(20))*(-(T278*T582))/(T228*T228)+exp(y(24))*T289*(T228*params(10)*params(25)*T582-T228*params(10)*params(25)*T582)/(T228*T228)));
  g1(22,20)=(-(exp(y(20))*T278/T228+exp(y(20))*params(33)*(1+params(23))/params(23)*T276*getPowerDeriv(T276,params(21),1)/T228));
  g1(22,22)=(-(exp(y(20))*(-(T278*T665))/(T228*T228)+exp(y(24))*T289*(T228*params(10)*params(25)*T665-T228*params(10)*params(25)*T665)/(T228*T228)));
  g1(22,23)=(-(exp(y(24))*T284*T708));
  g1(22,24)=exp(y(24))-exp(y(24))*T284*T289;
  g1(22,34)=(-(exp(y(20))*params(33)*(1+params(23))/params(23)*getPowerDeriv(T276,params(21),1)*(-(exp(y(34))*exp(y(20))))/(exp(y(34))*exp(y(34)))/T228));
  g1(23,17)=(-(exp(y(25))*T302*(T228*params(10)*params(25)*T582-T228*params(10)*params(25)*T582)/(T228*T228)));
  g1(23,20)=(-(exp(y(20))*(1+params(37)*exp(y(35)))/params(23)));
  g1(23,22)=(-(exp(y(25))*T302*(T228*params(10)*params(25)*T665-T228*params(10)*params(25)*T665)/(T228*T228)));
  g1(23,23)=(-(exp(y(25))*T284*(-params(36))/(y(23)*y(23))*getPowerDeriv(T285,1-(1+params(23))/params(23),1)));
  g1(23,25)=exp(y(25))-exp(y(25))*T284*T302;
  g1(23,35)=(-(exp(y(20))*params(37)*exp(y(35))/params(23)));
  g1(24,23)=params(25)*(-params(36))/(y(23)*y(23))*getPowerDeriv(T285,T308,1);
  g1(24,26)=(1-params(25))*exp(y(26))*getPowerDeriv(exp(y(26)),T308,1);
  g1(25,23)=(-(exp(y(27))*params(25)*T708));
  g1(25,26)=(-((1-params(25))*exp(y(26))*getPowerDeriv(exp(y(26)),T288,1)));
  g1(25,27)=exp(y(27))-exp(y(27))*params(25)*T289;
  g1(26,5)=(-(exp(y(5))*params(30)));
  g1(26,18)=(-exp(y(18)));
  g1(26,20)=exp(y(20));
  g1(26,21)=(-exp(y(21)));
  g1(27,20)=(-(exp(y(20))*params(12)*exp(y(33))));
  g1(27,21)=exp(y(21));
  g1(27,33)=(-(exp(y(20))*params(12)*exp(y(33))));
  g1(28,23)=(-1);
  g1(28,29)=1;
  g1(29,3)=(-(params(48)*(-(params(46)/exp(y(15))*params(47)*exp(y(3))*getPowerDeriv(exp(y(3)),(-params(1)),1)))/(T105*T105)));
  g1(29,15)=(-(params(48)*params(47)*(-(exp(y(15))*params(46)))/(exp(y(15))*exp(y(15)))/T105));
  g1(29,17)=params(45)*(-(params(44)*exp(y(17))*getPowerDeriv(exp(y(17)),(-params(9)),1)))/(T227*T227);
  g1(30,30)=1-params(5);
  g1(31,31)=1-params(7);
  g1(32,32)=1-params(19);
  g1(33,33)=1-params(13);
  g1(34,34)=1-params(15);
  g1(35,35)=1-params(17);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],35,1225);
end
end
