% home country
c1beta  = 1/1.01;       
c1sigma = 2;     
c1chi   = 0.5;    
c1less  = 1;       
c1sharegy = 0.000001;     
c1omegac = 0.85;
c1omegamc = 1-c1omegac;
c1telast = 2;        
c1rhoc   = 1/(c1telast-1);
c1nup = 1/9;
c1taup   = c1nup;
c1xip    = 0.75;            


% foreign country
c2beta  = c1beta;       
c2sigma = c1sigma;     
c2chi   = c1chi ;    
c2less  = c1less;       
c2sharegy = c1sharegy;
c2omegac = c1omegac;
c2omegamc = 1-c2omegac;
c2telast = c1telast;        
c2rhoc   = 1/(c2telast-1);
c2nup = c1nup;
c2taup   = c2nup;
c2xip    = c1xip;     

% relative country size
c1relc2  = 1;


%% Steady state
c1pistar = 1;    
c2pistar = c1pistar;    

%home country
c1l  = c1less;
c1y  = c1less; 
c1c  = (1-c1sharegy)*c1y;
c1cd = c1omegac*c1c;
c1mc = (1-c1omegac)*c1c;
c1g  = c1sharegy*c1y;
c1lambdaq = c1c^(-c1sigma);
c1rpcpd = 1;
c1dpd   = 0;
c1dcore = c1pistar;
c1chi0   = c1lambdaq/c1y^c1chi*(1+c1taup)/(1+c1nup);
c1hp = (1+c1nup)/c1nup*c1chi0*(c1y)^c1chi/c1lambdaq*c1y/(1-c1xip*c1beta);
c1gp = (1+c1taup)/c1nup*(c1y)/(1-c1xip*c1beta);
c1pstar  = 1;
c1pid    = c1pistar;
c1deltad = 1;
c1rn     = (c1pistar)/c1beta-1;


%foreign country 
c2l  = c2less;
c2y  = c2less; 
c2c  = (1-c2sharegy)*c2y;
c2cd = c2omegac*c2c;
c2mc = (1-c2omegac)*c2c;
c2g  = c2sharegy*c2y;
c2lambdaq = c2c^(-c2sigma);
c2rpcpd = 1;
c2dpd   = 0;
c2dcore = c2pistar;
c2chi0   = c2lambdaq/c2y^c2chi*(1+c2taup)/(1+c2nup);
c2hp = (1+c2nup)/c2nup*c2chi0*(c2y)^c2chi/c2lambdaq*(c2y)/(1-c2xip*c2beta);
c2gp = (1+c2taup)/c2nup*(c2y)/(1-c2xip*c2beta);
c2pstar  = 1;
c2pid    = c2pistar;
c2deltad = 1;
c2rn     = c2pistar/c2beta-1;
c1rer    = 1;

%shocks
c1shockgy   = 0;
c1z         = 0;
c1taupvar   = 0;
c2shockgy   = 0;
c2z         = 0;
c2taupvar   = 0;

Util1 = (c1c)^(1-c1sigma)/(1-c1sigma)...
        -c1chi0/(1+c1chi)*(c1y)^(1+c1chi);
    
Util2 = (c2c)^(1-c2sigma)/(1-c2sigma)...
        -c2chi0/(1+c2chi)*(c2y)^(1+c2chi);


%% Policy rule
c1gamrn = 0; 
c1gamdpc = 100000000000.5; 
c2gamrn = c1gamrn;
c2gamdpc = c1gamdpc;

%% Shocks
%technology
c1rhoz = 0.95;   
c1sigmaz =  0.008;       
c2rhoz = c1rhoz;   
c2sigmaz = c1sigmaz;       

%government spending
c1rhogy = 0.99;            
c1sigmagy = 0;  
c2rhogy = c1rhogy;            
c2sigmagy = c1sigmagy;  

%price mark up
c1rhotaupvar = 0;     
c1sigmataupvarerr = -0.1;   
c2rhotaupvar = c1rhotaupvar;     
c2sigmataupvarerr = c1sigmataupvarerr;  


%% assign steady state values

Util1ss = Util1;
Util2ss = Util2;
c1lambdaqss = c1lambdaq;
c1css = c1c;
c1cdss = c1cd;
c1mcss = c1mc;
c1yss = c1y;
c1gss = c1g;
c1rpcpdss = c1rpcpd;
c1dcoress = c1dcore;
c1hpss = c1hp;
c1gpss = c1gp;
c1pstarss = c1pstar;
c1pidss = c1pid;
c1deltadss = c1deltad;
c1rnss = c1rn;

c2lambdaqss = c2lambdaq;
c2css = c2c;
c2cdss = c2cd;
c2mcss = c2mc;
c2yss = c2y;
c2gss = c2g;
c2rpcpdss = c2rpcpd;
c2dcoress = c2dcore;
c2hpss = c2hp;
c2gpss = c2gp;
c2pstarss = c2pstar;
c2pidss = c2pid;
c2deltadss = c2deltad;
c2rnss = c2rn;

c1rerss = c1rer;

c1shockgyss = c1shockgy; 
c1zss = c1z;
c1taupvarss = c1taupvar;
c2shockgyss = c2shockgy;
c2zss = c2z;
c2taupvarss = c2taupvar;