%% GKfigure1.m produces Figures 4

clear all
setpathdynare4

stem = 'rbcb_monprud';

nobias_ramsey_modnam = [stem,'_nobias_ramsey_infl_bt'];
ramsey_modnam = [stem,'_ramsey_infl_bt'];
nash_modnam = [stem,'_nash_infl_bt'];

modnam1 = nobias_ramsey_modnam;
modnam2 = ramsey_modnam;
modnam3 = nash_modnam;
nummod = 3;

% solve models using dynare
for counter = 1:nummod      
    eval(['dynare ',eval(['modnam',num2str(counter)]),' noclearall'])
    eval(['M',num2str(counter),'_ = M_;'])
    eval(['oo',num2str(counter),'_ = oo_;'])
    eval(['ys',num2str(counter),'= oo_.dr.ys;'])
    eval(['nvars',num2str(counter),'= size(M_.endo_names,1);'])
    eval(['nshocks',num2str(counter),'= size(M_.exo_names,1);'])
end

% generate model IRFs
nperiods = 10;

titlelist = char('Investment', 'Consumption ',...
                 'Price of Capital','Output',...
                 'Spread of Loan Rate \newline over Deposit Rate (AR)','Policy Interest Rate (AR)',...
                 'Inflation (AR)', 'Bank Transfer');
             
pc = 'Percent Dev. from SS';
ppt = 'PPt. Dev. from SS';

ylabels = char(pc, pc,...
               pc, pc,...
               ppt, ppt,...
               ppt, pc);


%set shock
shocknamevector = char('errz');       
shocknamevectortex = char('Technology Shock z_t');  

for shockcounter =1:size(shocknamevector,1)
    shockname = deblank(shocknamevector(shockcounter,:));
    shocksize = -0.01;
    
    for counter = 1:nummod
        nshocks = eval(['nshocks',num2str(counter)]);
        shocks  = zeros(1,nshocks);
        shocks(1,strmatch(shockname,eval(['M',num2str(counter),'_.exo_names']),'exact')) = shocksize;
        eval(['shocks',num2str(counter),'= shocks;']);
    end
    
    for counter = 1:nummod
        eval(['M_ = M',num2str(counter),'_;'])
        eval(['oo_ = oo',num2str(counter),'_;'])
        eval(['nvars = nvars',num2str(counter),';'])
        eval(['shocks = shocks',num2str(counter),';'])
        order = 1;
        [zdata] = makeirfsecondorder(M_,oo_,nperiods,shocks,order);
        endo_names_reordered = M_.endo_names(oo_.dr.order_var,:);
        for indxi = 1:nvars
            eval([deblank(M_.endo_names(indxi,:)),'_ss_',num2str(counter),'_',num2str(shockcounter),'= zdata.',deblank(M_.endo_names(indxi,:)),'_ss;']);
            eval([deblank(endo_names_reordered(indxi,:)),'_irf_',num2str(counter),'_',num2str(shockcounter),'= zdata.',deblank(endo_names_reordered(indxi,:)),'_irf;']);
        end
    end
    
    eval(['line_nobias_ramsey',num2str(shockcounter),...
           ' = 100*[in_irf_1_',num2str(shockcounter),'/in_ss_1_',num2str(shockcounter)...
           ', c_irf_1_',num2str(shockcounter),'/c_ss_1_',num2str(shockcounter)...
           ', q_irf_1_',num2str(shockcounter),...
           ', y_irf_1_',num2str(shockcounter),'/y_ss_1_',num2str(shockcounter)...           
           ', 4*spread_irf_1_',num2str(shockcounter),...
           ', 4*rmon_irf_1_',num2str(shockcounter),...
           ', 4*infl_irf_1_',num2str(shockcounter),...           
           ', bt_irf_1_',num2str(shockcounter),'];']);

    eval(['line_ramsey',num2str(shockcounter),...
           ' = 100*[in_irf_2_',num2str(shockcounter),'/in_ss_2_',num2str(shockcounter)...
           ', c_irf_2_',num2str(shockcounter),'/c_ss_2_',num2str(shockcounter)...
           ', q_irf_2_',num2str(shockcounter),...
           ', y_irf_2_',num2str(shockcounter),'/y_ss_2_',num2str(shockcounter)...           
           ', 4*spread_irf_2_',num2str(shockcounter),...
           ', 4*rmon_irf_2_',num2str(shockcounter),...
           ', 4*infl_irf_2_',num2str(shockcounter),...           
           ', bt_irf_2_',num2str(shockcounter),'];']);
       
    eval(['line_nash',num2str(shockcounter),...
           ' = 100*[in_irf_3_',num2str(shockcounter),'/in_ss_3_',num2str(shockcounter)...
           ', c_irf_3_',num2str(shockcounter),'/c_ss_3_',num2str(shockcounter)...
           ', q_irf_3_',num2str(shockcounter),...
           ', y_irf_3_',num2str(shockcounter),'/y_ss_3_',num2str(shockcounter)...           
           ', 4*spread_irf_3_',num2str(shockcounter),...
           ', 4*rmon_irf_3_',num2str(shockcounter),...
           ', 4*infl_irf_3_',num2str(shockcounter),...           
           ', bt_irf_3_',num2str(shockcounter),'];']);       
       
end;

for shockcounter = 1:size(shocknamevector,1)
    shockname = deblank(shocknamevectortex(shockcounter,:));
    
    legendlist = cellstr(char('Cooperation, no bias',...
                              'Cooperation, biased objectives',...
                              'Open-loop Nash'));
                  
    figtitle = [''];

    eval(['figurehandle_shock',num2str(shockcounter),...
        ' = makechart(titlelist,legendlist,figtitle,ylabels,',...
        'line_nobias_ramsey',num2str(shockcounter),',',...
        'line_ramsey',num2str(shockcounter),',',...
        'line_nash',num2str(shockcounter),...
        ');']);
    
%     printpref
% 
%     directory = pwd;
%     cd ../..
%     directory1 = cd;
%     cd(directory);
% 
%     print('-dpsc',[directory1,'/paper/figurespaper/GKfigure1']); 
end;








