%% GKfigure2.m produces Figures 5

clear all
setpathdynare4;

global overwrite_param_names overwrite

stem = 'rbcb_monprud';

nobias_ramsey_modnam = [stem,'_nobias_ramsey_infl_bt'];
ramsey_modnam = [stem,'_ramsey_infl_bt'];
nash_modnam = [stem,'_nash_infl_bt'];

modnam1 = nobias_ramsey_modnam;
modnam2 = ramsey_modnam;
modnam3 = nash_modnam;
nummod = 3;

%% Create or load results

load_results = 0; 
if load_results == 1    
   load welfare_resultsnew
else
    my_cb_range   = [0 1 2];
    my_mpr_range = [0 0.1 0.2 0.3 0.4 0.45 0.5 0.55 0.6];
    tau2to1 = zeros(length(my_cb_range),length(my_mpr_range));
    
    for counter = 1
        eval(['dynare ',eval(['modnam',num2str(counter)]),' noclearall'])
        eval(['M',num2str(counter),'_ = M_;'])
        eval(['oo',num2str(counter),'_ = oo_;'])            
    end        
  
    my_cb_index = 0;
    for my_cb_loop  = my_cb_range
        my_cb_index = my_cb_index+1;
        my_mpr_index = 0;
        for my_mpr_loop = my_mpr_range
            my_mpr_index = my_mpr_index+1;
                   
            mu_cb   = my_cb_loop;
            mu_mpr = my_mpr_loop;

            overwrite_param_names = char('mu_cb','mu_mpr');
            overwrite = [mu_cb;mu_mpr];
            for counter = 2:3
                eval(['dynare ',eval(['modnam',num2str(counter)]),' noclearall'])
                eval(['M',num2str(counter),'_ = M_;'])
                eval(['oo',num2str(counter),'_ = oo_;'])                        
            end        

            eval([modnam2,'_paramfile']);

            Welfmod1 = oo1_.mean(strmatch('Welf',M1_.endo_names,'exact'));           
            Welfmod2 = oo2_.mean(strmatch('Welf_nobias',M2_.endo_names,'exact'));
            Welfmod3 = oo3_.mean(strmatch('Welf_nobias',M3_.endo_names,'exact'));

            tau2to1(my_cb_index,my_mpr_index) = exp((1-betap)*(Welfmod1-Welfmod2))-1
            tau3to1(my_cb_index,my_mpr_index) = exp((1-betap)*(Welfmod1-Welfmod3))-1
        end
    end
    save welfare_resultsnew tau2to1 tau3to1 my_cb_range my_mpr_range
end

%% Plotting results
close all
figurehandle = figure;

subplot(2,1,1)
spline_range = 0:0.02:my_mpr_range(end)
spline_tau = spline(my_mpr_range,tau2to1(1,:),spline_range);
plot(spline_range,spline_tau*100,'b-','linewidth',2); hold on
spline_tau = spline(my_mpr_range,tau2to1(2,:),spline_range);
plot(spline_range,spline_tau*100,'r--','linewidth',2)
xlim([0 spline_range(end)])
xlabel('Bias on Spread Stabilization, \mu_{mpr}')
ylabel('Percent of Consumption')
title('Welfare Cost of Stabilization Biases with Cooperative Policies')

subplot(2,1,2)
spline_range = 0:0.02:my_mpr_range(end)
spline_tau = spline(my_mpr_range,tau3to1(1,:),spline_range);
plot(spline_range,spline_tau*100,'b-','linewidth',2); hold on
spline_tau = spline(my_mpr_range,tau3to1(2,:),spline_range);
plot(spline_range,spline_tau*100,'r--','linewidth',2)
xlim([0 spline_range(end)])
xlabel('Bias on Spread Stabilization, \mu_{mpr}')
ylabel('Percent of Consumption')
title('Welfare Cost of Stabilization Biases with Open-loop Nash Policies')

legend('No Bias on Infl. Stabilization \mu_{cb} = 0','Bias on Infl. Stabilization \mu_{cb} = 1','location','NorthWest')

% printpref
% 
% directory = pwd;
% cd ../..
% directory1 = cd;
% cd(directory);
% 
% print('-dpsc',[directory1,'/paper/figurespaper/GKfigure2']); 

