%%%%%%%%%%%%%%%%%%%%%%%
% Parameters in 
% standard RBC model
%%%%%%%%%%%%%%%%%%%%%%%

% preferences
betap    = 0.99;   % discount factor
gammap   = 0.6;    % consumption habits
chip     = 1;      % labor supply elasticity
l_ss     = 1/2;    % steady state labor supply
omegagyp = 0.0;    % share of gov. spending in output

% production
alphap   = 0.3;    % share of capital in production
deltap   = 0.025;  % capital depreciation rate
psip     = 1;      % investment adjustment cost

% technology shock
rhozp     = 0.95;
sigmazp   = 1; 

% shock to marginal utility of consumption
rhocprefp = 0.7;
sigmacprefp = 1;

% policy preferences
mu_cb     = 1;
mu_mpr   = 0.5;


%%%%%%%%%%%%%%%%%%%%%%%
% Additional 
% parameters in NKM
% with capital and 
% Rotemberg contracts
%%%%%%%%%%%%%%%%%%%%%%%

% features of the Phillips Curve
nup     = 1/10;     % determines elasticity of substitution between varieties
taup    = nup;      % steady state subsidy to producers
xip     = 0.75;     % determine average contract duration under Calvo contracts
%kappap = (1-betap*xip)*(1-xip)/xip; 
phip    = (1+nup)/nup/taup/((1-betap*xip)*(1-xip)/xip);
                    % mapping Calvo parameter into Rotemberg adjustment
                    % costs
indexp  = 0.5;      % indexation parameter
infl_ss = 1;        % steady state inflation

% monetary policy rule
rs_rslp = 0.7;     % weight on past interst rate 
rs_inflp = 3;      % weight on inflation
rs_yp =0;          % weight on output gap


%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Additional 
% parameters in model
% with financial frictions
%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% to replicate RBCA set s2n to a large number
% and blife to 1

% features of the financial accelerator mechanism
spreadp = 0; % loan spread 
s2n = 4;     % ratio of savings to networth
blife = 20;  % helps ensure stability when turning on 
thetap = (blife-1)/blife;  
             % probability of bank exit

% policy reaction function financial regulator             
bt_btlp = 0.7;     % lagged response to the transfer instrument
bt_sp = 1;                            

% shock to transfer bt
rhobtp   = 0.9;        
sigmabtp = 1;        

% shock to lambda
rholambdap   = 0; 
sigmalambdap = 1; 

% shock to discount factor
rhobetavarp   = 0.9;
sigmabetavarp = 1;


