function [residual, g1, g2] = rbcb_monprud_nash_infl_bt_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                    columns: equations in order of declaration
%                                                    rows: variables in declaration order
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: equations in order of declaration
%                                                       rows: variables in declaration order
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 132, 1);

%
% Model equations
%

T88 = log(y(19)-y(34)*params(5)+y(50))-params(6)*y(10)^(1+params(7))/(1+params(7));
T127 = params(12)-y(14);
T130 = 1+y(11)-y(15)*(y(11)-y(8))/T127;
T132 = params(3)*y(9);
T145 = T127*params(3)*y(15)*y(9);
T156 = 1+y(11)-y(35)*(y(11)-y(8))/(y(48)-y(45));
T163 = (y(19)+y(50)-y(34)*params(5))^2;
T167 = y(49)*params(5)^2;
T170 = (y(19)+y(50)-y(19)*params(5))^2;
T172 = 1/T163+T167/T170;
T202 = params(3)*(1+y(23));
T210 = y(32)-1;
T218 = T210*(y(11)-y(8))*y(14)*params(13)*y(9)*y(15)*params(8);
T219 = T127*y(15)*y(9);
T223 = T130*T210*T127*y(14)*params(13)*y(9)*y(15)*params(8);
T226 = T127*y(9)*y(15)^2;
T228 = T218/T219+T223/T226;
T235 = T210*(y(11)-y(8))*params(13)*y(9)*y(15)*params(8)/(y(9)*T127)-1;
T271 = y(17)/y(36)-1;
T279 = params(10)*T271^2/2+T271*y(17)*params(10)/y(36)-1;
T287 = y(17)^2;
T292 = y(17)^3;
T299 = y(9)*y(17)^4;
T301 = y(18)*y(17)*params(10)/T287+y(18)*params(10)*y(9)*y(49)*T292/T299;
T314 = y(18)*params(10)*y(9)*y(49)*T287/(y(9)*T292);
T326 = y(18)*params(10)*T287/T292;
T336 = y(36)^2;
T343 = y(24)^2;
T350 = y(24)*params(20)-params(51)*(params(20)-1);
T351 = T350^2;
T356 = y(24)/T350-1;
T359 = T343*params(16)/T351+params(16)*2*y(24)*T356/T350;
T374 = y(24)*params(16)/T351+params(16)*T356/T350;
T381 = T350^3;
T387 = params(16)*params(20)*y(24)^3/T381+T356*params(16)*T343*params(20)/T351;
T395 = params(16)*T343*params(20)/T381+T356*params(16)*y(24)*params(20)/T351;
T401 = y(37)*params(20)-params(51)*(params(20)-1);
T403 = y(24)/T401-1;
T418 = T401^2;
T437 = y(38)^(params(4)-1);
T440 = y(10)^(1-params(4));
T451 = y(18)*y(38)^2;
T460 = params(6)*y(10)^params(7);
T466 = y(10)^(params(7)-1);
T473 = y(10)^params(4);
T474 = (params(4)-1)*exp(y(47))*y(75)*y(38)^params(4)/T473;
T485 = y(9)^2;
T490 = (y(11)-y(8))*params(8)*y(9)*(params(13)-1)/T485-T223/(T127*y(15)*T485);
T500 = T130*T210*T127*y(14)*params(13)*y(15)*params(8);
T502 = (params(13)-1)*params(8)*(y(11)-y(8))/y(9)-T500/T219;
T561 = (1+params(19))/params(18)-y(28)*(1+params(18))/params(18);
T573 = y(18)^2;
T579 = y(18)*(params(9)-1)/T573-y(6)*y(28)*params(4)/(y(38)*T573);
T592 = (1+y(11))^2;
T593 = y(49)*T592;
T597 = y(15)/T127;
T598 = T597-1;
T603 = params(8)*y(9)*(params(13)-1)/y(9)+T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T598/T219;
T613 = y(35)/(y(48)-y(45))-1;
T625 = (1+y(23))^2;
T640 = T210*y(14)*params(13)*y(9)*y(15)*params(8);
T642 = params(8)*y(9)*(params(13)-1)/y(9)+T640/(y(9)*T127);
T676 = y(6)*y(26)-y(6)*(1+params(18))*(y(25)-1)/params(18);
T694 = T127^2;
T697 = T130*T210*T127*params(13)*y(9)*y(15)*params(8)/T219+T223/(y(15)*y(9)*T694);
T705 = T130*T640/T219+T218/(T127*y(9)*T127)-1;
T715 = (y(48)-y(14))^2;
T726 = (y(48)-y(45))^2;
T735 = y(7)^2;
T752 = y(6)^2;
T954 = (params(4)-1)*exp(y(47))*y(38)^params(4)*y(115)/T473;
T1189 = y(9)*params(8)*(1-params(13))/y(9);
T1193 = y(9)*params(8)*params(13)/y(9);
T1199 = (1-y(32))*T1193*(y(11)+1+y(15)*(y(8)-y(11))/T127);
T1207 = exp(y(47))*y(38)^params(4);
T1223 = y(28)*(1+params(18))/params(18)+(-(1+params(19)))/params(18);
T1225 = T1223*(1-y(25));
T1264 = 1-T271^2*params(10)/2;
T1382 = (-(y(28)*params(4)/(y(38)*y(18))));
T1417 = (-((-y(15))/T127));
T1425 = (-((-y(35))/(y(48)-y(45))));
T1432 = T210*(-(y(14)*params(13)*y(9)*y(15)*params(8)))/T219+T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T1417/T226;
T1454 = (params(13)-1)*(-(params(8)*y(9)))/T485-T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T1417/(T127*y(15)*T485);
T1461 = (params(13)-1)*(-params(8))/y(9)-T210*T127*y(14)*params(13)*y(15)*params(8)*T1417/T219;
T1475 = T210*T127*params(13)*y(9)*y(15)*params(8)*T1417/T219+T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T1417/(y(15)*y(9)*T694);
T1481 = T640*T1417/T219+T210*(-(y(14)*params(13)*y(9)*y(15)*params(8)))/(T127*y(9)*T127);
T1578 = (T219*T210*(y(11)-y(8))*y(14)*params(13)*y(15)*params(8)-T218*y(15)*T127)/(T219*T219)+(T226*T500-T223*T127*y(15)^2)/(T226*T226);
T1587 = (y(9)*T127*T210*(y(11)-y(8))*params(13)*y(15)*params(8)-T127*T210*(y(11)-y(8))*params(13)*y(9)*y(15)*params(8))/(y(9)*T127*y(9)*T127);
T1614 = (T299*y(18)*params(10)*y(49)*T292-y(18)*params(10)*y(9)*y(49)*T292*y(17)^4)/(T299*T299);
T1623 = (y(9)*T292*y(18)*params(10)*y(49)*T287-T292*y(18)*params(10)*y(9)*y(49)*T287)/(y(9)*T292*y(9)*T292);
T1647 = (T485*(params(13)-1)*params(8)*(y(11)-y(8))-(y(11)-y(8))*params(8)*y(9)*(params(13)-1)*2*y(9))/(T485*T485)-(T127*y(15)*T485*T500-T223*T127*y(15)*2*y(9))/(T127*y(15)*T485*T127*y(15)*T485);
T1655 = (-((params(13)-1)*params(8)*(y(11)-y(8))))/(y(9)*y(9))-(-(T500*y(15)*T127))/(T219*T219);
T1701 = (y(9)*params(8)*(params(13)-1)-params(8)*y(9)*(params(13)-1))/(y(9)*y(9))+(T219*T210*T127*y(14)*params(13)*y(15)*params(8)*T598-T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T598*y(15)*T127)/(T219*T219);
T1715 = (y(9)*params(8)*(params(13)-1)-params(8)*y(9)*(params(13)-1))/(y(9)*y(9))+(y(9)*T127*T210*y(14)*params(13)*y(15)*params(8)-T127*T640)/(y(9)*T127*y(9)*T127);
T1740 = (T219*T130*T210*T127*params(13)*y(15)*params(8)-T130*T210*T127*params(13)*y(9)*y(15)*params(8)*y(15)*T127)/(T219*T219)+(T500*y(15)*y(9)*T694-T223*y(15)*T694)/(y(15)*y(9)*T694*y(15)*y(9)*T694);
T1754 = (T219*T130*T210*y(14)*params(13)*y(15)*params(8)-T130*T640*y(15)*T127)/(T219*T219)+(T127*y(9)*T127*T210*(y(11)-y(8))*y(14)*params(13)*y(15)*params(8)-T218*T127*T127)/(T127*y(9)*T127*T127*y(9)*T127);
T1873 = params(6)*getPowerDeriv(y(10),1+params(7),1)/(1+params(7));
T1875 = getPowerDeriv(y(10),1-params(4),1);
T1902 = 1-T597;
T1908 = 1-y(35)/(y(48)-y(45));
T1913 = T640/T219+T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T1902/T226;
T1931 = params(8)*y(9)*(params(13)-1)/T485-T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T1902/(T127*y(15)*T485);
T1936 = params(8)*(params(13)-1)/y(9)-T210*T127*y(14)*params(13)*y(15)*params(8)*T1902/T219;
T1956 = T210*T127*params(13)*y(9)*y(15)*params(8)*T1902/T219+T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T1902/(y(15)*y(9)*T694);
T1962 = T640*T1902/T219+T640/(T127*y(9)*T127);
T2043 = (y(48)-y(14))*(y(48)-y(14));
T2047 = (-(y(15)*(y(11)-y(8))/(T127*T127)));
T2074 = T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T2047+T130*T210*(T127*params(13)*y(9)*y(15)*params(8)+(-(y(14)*params(13)*y(9)*y(15)*params(8))));
T2080 = (T219*T210*(y(11)-y(8))*params(13)*y(9)*y(15)*params(8)-T218*(-(y(15)*y(9))))/(T219*T219)+(T226*T2074-T223*(-(y(9)*y(15)^2)))/(T226*T226);
T2085 = (-(T210*(y(11)-y(8))*params(13)*y(9)*y(15)*params(8)*(-y(9))))/(y(9)*T127*y(9)*T127);
T2111 = (-((T127*y(15)*T485*T2074-T223*(-(y(15)*T485)))/(T127*y(15)*T485*T127*y(15)*T485)));
T2123 = (-((T219*(T210*T127*y(14)*params(13)*y(15)*params(8)*T2047+T130*T210*(T127*params(13)*y(15)*params(8)+(-(y(14)*params(13)*y(15)*params(8)))))-T500*(-(y(15)*y(9))))/(T219*T219)));
T2135 = y(15)/(T127*T127);
T2146 = (T219*T210*((-(y(14)*params(13)*y(9)*y(15)*params(8)*T598))+T127*(params(13)*y(9)*y(15)*params(8)*T598+y(14)*params(13)*y(9)*y(15)*params(8)*T2135))-T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T598*(-(y(15)*y(9))))/(T219*T219);
T2156 = (y(9)*T127*T210*params(13)*y(9)*y(15)*params(8)-T640*(-y(9)))/(y(9)*T127*y(9)*T127);
T2178 = (T219*(T210*T127*params(13)*y(9)*y(15)*params(8)*T2047+T130*T210*(-(params(13)*y(9)*y(15)*params(8))))-T130*T210*T127*params(13)*y(9)*y(15)*params(8)*(-(y(15)*y(9))))/(T219*T219)+(y(15)*y(9)*T694*T2074-T223*y(15)*y(9)*(-(2*T127)))/(y(15)*y(9)*T694*y(15)*y(9)*T694);
T2195 = (T219*(T640*T2047+T130*T210*params(13)*y(9)*y(15)*params(8))-T130*T640*(-(y(15)*y(9))))/(T219*T219)+(T210*(y(11)-y(8))*params(13)*y(9)*y(15)*params(8)*T127*y(9)*T127-T218*((-(y(9)*T127))+T127*(-y(9))))/(T127*y(9)*T127*T127*y(9)*T127);
T2311 = (-((y(11)-y(8))/T127));
T2337 = T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T2311+T130*T210*T127*y(14)*params(13)*params(8)*y(9);
T2345 = (T219*T210*(y(11)-y(8))*y(14)*params(13)*params(8)*y(9)-T218*y(9)*T127)/(T219*T219)+(T226*T2337-T223*T127*y(9)*2*y(15))/(T226*T226);
T2367 = (-((T127*y(15)*T485*T2337-T223*T127*T485)/(T127*y(15)*T485*T127*y(15)*T485)));
T2379 = (-((T219*(T210*T127*y(14)*params(13)*y(15)*params(8)*T2311+T130*T210*T127*y(14)*params(8)*params(13))-y(9)*T127*T500)/(T219*T219)));
T2391 = 1/T127;
T2400 = (T219*T210*T127*(T598*y(14)*params(13)*params(8)*y(9)+y(14)*params(13)*y(9)*y(15)*params(8)*T2391)-y(9)*T127*T210*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T598)/(T219*T219);
T2432 = (T219*(T210*T127*params(13)*y(9)*y(15)*params(8)*T2311+T130*T210*T127*params(13)*params(8)*y(9))-y(9)*T127*T130*T210*T127*params(13)*y(9)*y(15)*params(8))/(T219*T219)+(y(15)*y(9)*T694*T2337-T223*y(9)*T694)/(y(15)*y(9)*T694*y(15)*y(9)*T694);
T2443 = (T219*(T640*T2311+T130*T210*y(14)*params(13)*params(8)*y(9))-y(9)*T127*T130*T640)/(T219*T219)+T210*(y(11)-y(8))*y(14)*params(13)*params(8)*y(9)/(T127*y(9)*T127);
T2534 = 1/y(36);
T2543 = params(10)*T2534*2*T271/2+(y(17)*params(10)*T2534+params(10)*T271)/y(36);
T2561 = (T287*y(18)*params(10)-y(18)*y(17)*params(10)*2*y(17))/(T287*T287)+(T299*y(18)*params(10)*y(9)*y(49)*T287*3-y(18)*params(10)*y(9)*y(49)*T292*y(9)*T292*4)/(T299*T299);
T2572 = (y(9)*T292*y(18)*params(10)*y(9)*y(49)*2*y(17)-y(18)*params(10)*y(9)*y(49)*T287*y(9)*T287*3)/(y(9)*T292*y(9)*T292);
T2580 = (T292*y(18)*params(10)*2*y(17)-y(18)*params(10)*T287*T287*3)/(T292*T292);
T2612 = y(17)*params(10)/T287+params(10)*y(9)*y(49)*T292/T299;
T2637 = ((params(9)-1)*T573-y(18)*(params(9)-1)*2*y(18))/(T573*T573)-(-(y(6)*y(28)*params(4)*y(38)*2*y(18)))/(y(38)*T573*y(38)*T573);
T2684 = (-(1/(y(19)-y(34)*params(5)+y(50))));
T2696 = (-(2*(y(19)+y(50)-y(34)*params(5))))/(T163*T163)+(-(T167*(1-params(5))*2*(y(19)+y(50)-y(19)*params(5))))/(T170*T170);
T2699 = (-1)/((y(19)+y(50)-y(34)*params(5))*(y(19)+y(50)-y(34)*params(5)));
T2713 = (-((-params(5))/((y(19)+y(50)-y(34)*params(5))*(y(19)+y(50)-y(34)*params(5)))))-(-(params(5)*y(67)*2*(y(19)+y(50)-y(34)*params(5))))/(T163*T163);
T2723 = (-((-params(5))/((y(19)+y(50)-y(34)*params(5))*(y(19)+y(50)-y(34)*params(5)))))-(-(params(5)*y(107)*2*(y(19)+y(50)-y(34)*params(5))))/(T163*T163);
T2798 = (T350-y(24)*params(20))/(T350*T350);
T2806 = (T351*params(16)*2*y(24)-T343*params(16)*params(20)*2*T350)/(T351*T351)+(T350*(T356*2*params(16)+params(16)*2*y(24)*T2798)-params(20)*params(16)*2*y(24)*T356)/(T350*T350);
T2819 = (params(16)*T351-y(24)*params(16)*params(20)*2*T350)/(T351*T351)+(T350*params(16)*T2798-params(20)*params(16)*T356)/(T350*T350);
T2841 = (T381*params(16)*params(20)*3*T343-params(16)*params(20)*y(24)^3*params(20)*3*T351)/(T381*T381)+(T351*(params(16)*T343*params(20)*T2798+T356*params(16)*params(20)*2*y(24))-T356*params(16)*T343*params(20)*params(20)*2*T350)/(T351*T351);
T2856 = (T381*params(16)*params(20)*2*y(24)-params(16)*T343*params(20)*params(20)*3*T351)/(T381*T381)+(T351*(params(16)*y(24)*params(20)*T2798+T356*params(16)*params(20))-T356*params(16)*y(24)*params(20)*params(20)*2*T350)/(T351*T351);
T2859 = 1/T401;
T2914 = (y(24)*params(20)+params(51)*(1-params(20))-y(24)*params(20))/((y(24)*params(20)+params(51)*(1-params(20)))*(y(24)*params(20)+params(51)*(1-params(20))));
T3004 = (-(y(6)*params(4)/(y(38)*y(18))));
T3020 = (y(11)-y(8))*y(14)*params(13)*y(9)*y(15)*params(8)/T219+T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)/T226;
T3056 = T130*T127*params(13)*y(9)*y(15)*params(8)/T219+T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)/(y(15)*y(9)*T694);
T3062 = T130*y(14)*params(13)*y(9)*y(15)*params(8)/T219+(y(11)-y(8))*y(14)*params(13)*y(9)*y(15)*params(8)/(T127*y(9)*T127);
T3133 = (-((-(params(5)*(-params(5))))/((y(19)+y(50)-y(34)*params(5))*(y(19)+y(50)-y(34)*params(5)))));
T3147 = (-((y(11)-y(8))/(y(48)-y(45))));
T3170 = (-y(17))/(y(36)*y(36));
T3178 = params(10)*2*T271*T3170/2+(y(36)*y(17)*params(10)*T3170-T271*y(17)*params(10))/(y(36)*y(36));
T3201 = (-(y(24)*params(20)))/(T401*T401);
T3326 = (y(48)-y(45))*(y(48)-y(45));
T3328 = (-(y(35)*(y(11)-y(8))/T3326));
T3373 = (-((-(y(35)*(y(11)-y(8))))/T3326));
T3420 = params(5)^2/T170;
T3467 = (-(2*(y(19)+y(50)-y(34)*params(5))))/(T163*T163)+(-(T167*2*(y(19)+y(50)-y(19)*params(5))))/(T170*T170);
T3495 = 1/T132-y(9)/T485;
T3548 = (-(T130*T210*params(13)*y(9)*y(15)*params(8)/T485))+T130*T210*params(13)*y(15)*params(8)/T132;
T3566 = (params(4)-1)*T1207/T473;
T3593 = (1+params(19)-y(28))*y(26)-T561*(y(25)-1)+(1+params(19)-y(28))*y(27)/T202;
T3618 = 1/(params(3)*y(24)*y(9))-y(9)/(y(24)*T485);
lhs =y(131);
rhs =params(1)*y(30)+params(2)*y(31);
residual(1)= lhs-rhs;
lhs =y(132);
rhs =y(131)+y(132)*params(3);
residual(2)= lhs-rhs;
lhs =y(1);
rhs =y(30)+params(3)*y(1);
residual(3)= lhs-rhs;
lhs =y(2);
rhs =y(31)+params(3)*y(2);
residual(4)= lhs-rhs;
lhs =y(3);
rhs =y(24);
residual(5)= lhs-rhs;
lhs =y(4);
rhs =y(32);
residual(6)= lhs-rhs;
lhs =y(33);
rhs =y(32);
residual(7)= lhs-rhs;
lhs =y(34);
rhs =y(19);
residual(8)= lhs-rhs;
lhs =y(35);
rhs =y(15);
residual(9)= lhs-rhs;
lhs =y(36);
rhs =y(17);
residual(10)= lhs-rhs;
lhs =y(37);
rhs =y(24);
residual(11)= lhs-rhs;
lhs =y(38);
rhs =y(5);
residual(12)= lhs-rhs;
lhs =y(39);
rhs =y(10);
residual(13)= lhs-rhs;
lhs =y(40);
rhs =y(23);
residual(14)= lhs-rhs;
lhs =y(41);
rhs =y(18);
residual(15)= lhs-rhs;
lhs =y(42);
rhs =y(11);
residual(16)= lhs-rhs;
lhs =y(43);
rhs =y(13);
residual(17)= lhs-rhs;
lhs =y(44);
rhs =y(12);
residual(18)= lhs-rhs;
lhs =y(45);
rhs =y(14);
residual(19)= lhs-rhs;
lhs =y(46);
rhs =y(6);
residual(20)= lhs-rhs;
lhs =y(30);
rhs =T88-params(22)*(y(24)-params(51))^2;
residual(21)= lhs-rhs;
lhs =y(31);
rhs =T88-params(21)*(y(21)-params(17))^2;
residual(22)= lhs-rhs;
residual(23) = y(13)*y(15)*y(70)/(y(48)-y(14))-params(3)*y(53)-y(52)+y(15)*params(8)*y(73)*y(9)*params(13)*T130/T132+T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(72)/T145;
residual(24) = y(53)+params(13)*y(43)*y(71)*T156;
residual(25) = y(67)*T172-y(85)-params(3)*y(54)+1/(y(19)+y(50)-y(34)*params(5))-params(5)*y(67)*y(49)/(params(3)*T170);
residual(26) = y(54)-params(5)/(y(19)+y(50)-y(34)*params(5))-params(5)*y(67)/T163;
residual(27) = y(81)+y(6)*y(78)*(1+params(19)-y(28))/T202;
residual(28) = y(6)*y(78)*(1+params(19)-y(28))+y(80);
residual(29) = y(13)*y(70)*T210/(y(48)-y(14))-y(72)*T228-y(73)*T235-y(88)/T127-params(3)*y(55)+T130*T210*params(13)*params(8)*y(73)*y(9)/T132+T130*T210*T127*y(14)*params(13)*y(9)*params(8)*y(72)/T145;
residual(30) = y(55)-(y(11)-y(8))*params(13)*y(43)*y(71)*(y(33)-1)/(y(48)-y(45));
residual(31) = y(86)-y(85);
residual(32) = y(83)*T279-params(3)*y(56)-y(85)-y(84)*T301+y(84)*T314/params(3)+params(3)*y(84)*T326;
residual(33) = y(56)-T271*params(10)*y(83)*T287/T336;
residual(34) = y(83)-y(82);
residual(35) = y(81)*T359-params(3)*y(57)-y(51)-params(22)*(2*y(24)-2*params(51))-y(80)*T374-params(3)*y(81)*T387+params(3)*y(80)*T395-params(16)*y(79)*T403/T401-y(9)*y(89)/(params(3)*y(9)*T343);
residual(36) = y(57)+T403*params(16)*y(24)*params(20)*y(79)/T418;
residual(37) = y(51);
residual(38) = y(82)+y(74)-params(3)*y(58);
residual(39) = y(58)+y(82)*(params(9)-1)-params(4)*y(75)*T437*T440*exp(y(47))+y(6)*y(28)*params(4)*y(77)/T451;
residual(40) = y(76)-params(3)*y(59)-T460+params(6)*params(7)*y(68)*T466+T474;
residual(41) = y(88);
residual(42) = y(67)-y(68)*y(7)+y(72)*T490-y(72)*T502/params(3)+y(69)/T132-y(9)*y(69)/T485+y(89)/(params(3)*y(24)*y(9))-y(9)*y(89)/(y(24)*T485)-T130*y(15)*params(8)*y(73)*y(9)*params(13)*T210/T485+T130*T210*y(15)*params(8)*y(73)*params(13)/T132;
residual(43) = y(59);
residual(44) = y(71)-params(3)*y(63)-y(90)/y(6)+y(15)*y(70)*T210/(y(48)-y(14));
residual(45) = y(90);
residual(46) = y(63)+T156*(y(33)-1)*params(13)*y(71);
residual(47) = y(79)-y(6)*y(78)*T561;
residual(48) = y(12)*y(70)-(-y(84))-params(3)*y(61)-params(3)*y(77)*T579+(params(9)-1)*y(77)/y(18)-y(44)*y(71)*params(14);
residual(49) = y(61);
residual(50) = y(69)/T593-y(72)*T603-params(3)*y(62)-(y(33)-1)*params(13)*y(43)*params(3)*y(71)*T613-T210*y(15)*params(8)*y(73)*y(9)*params(13)*T598/y(9);
residual(51) = y(62)+y(87);
residual(52) = y(89)/(y(49)*T625)-params(3)*y(60)-(1+params(19)-y(28))*y(6)*y(78)*y(27)/T625;
residual(53) = y(60);
residual(54) = y(77)-y(87)+y(72)*T642/params(3)+(y(33)-1)*params(13)*y(43)*y(35)*y(71)/(y(48)-y(45))+T210*params(13)*y(9)*y(15)*y(15)*params(8)*y(73)/(T127*T132);
residual(55) = y(18)*y(70)-params(3)*y(64)-y(74);
residual(56) = (params(4)-1)*y(6)*y(76)/y(7)-y(78)*T676-y(6)*params(4)*y(77)/(y(38)*y(18))-y(6)*y(78)*y(27)/T202;
residual(57) = y(64)-y(18)*y(71)*params(14);
residual(58) = y(87);
residual(59) = y(72)*T697/params(3)-y(72)*T705-y(15)*y(88)/T694-params(3)*y(65)+y(13)*y(15)*y(70)*T210/T715-T210*(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)*y(73)/(y(9)*T694);
residual(60) = y(65)-(y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(35)*y(71)/T726;
residual(61) = y(9)*(-y(68))-(params(4)-1)*y(6)*y(28)*y(76)/T735;
residual(62) = y(85)+y(75)-params(3)*y(66)-y(86)*params(11)+y(78)*((1+params(19)-y(28))*y(26)-T561*(y(25)-1))+y(13)*y(90)/T752+(params(4)-1)*y(28)*y(76)/y(7)-y(28)*params(4)*y(77)/(y(38)*y(18))+(1+params(19)-y(28))*y(78)*y(27)/T202;
residual(63) = y(66);
residual(64) = y(13)*y(15)*y(110)/(y(48)-y(14))-params(3)*y(93)-y(92)+T130*params(13)*y(9)*y(15)*params(8)*y(113)/T132+T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(112)/T145;
residual(65) = y(93)+T156*params(13)*y(43)*y(111);
residual(66) = 1/(y(19)+y(50)-y(34)*params(5))+T172*y(107)-y(125)-params(3)*y(94)-params(5)*y(49)*y(107)/(params(3)*T170);
residual(67) = y(94)-params(5)/(y(19)+y(50)-y(34)*params(5))-params(5)*y(107)/T163;
residual(68) = y(121)+(1+params(19)-y(28))*y(6)*y(118)/T202;
residual(69) = (1+params(19)-y(28))*y(6)*y(118)+y(120);
residual(70) = T210*y(13)*y(110)/(y(48)-y(14))-T228*y(112)-T235*y(113)-y(128)/T127-params(3)*y(95)+T130*T210*params(13)*y(9)*params(8)*y(113)/T132+T130*T210*T127*y(14)*params(13)*y(9)*params(8)*y(112)/T145;
residual(71) = y(95)-(y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(111)/(y(48)-y(45));
residual(72) = y(126)-y(125);
residual(73) = T279*y(123)-params(3)*y(96)-y(125)-T301*y(124)+T314*y(124)/params(3)+T326*params(3)*y(124);
residual(74) = y(96)-T271*params(10)*T287*y(123)/T336;
residual(75) = y(123)-y(122);
residual(76) = T359*y(121)-params(3)*y(97)-y(91)-T374*y(120)-T387*params(3)*y(121)+T395*params(3)*y(120)-T403*params(16)*y(119)/T401-y(9)*y(129)/(params(3)*y(9)*T343);
residual(77) = y(97)+T403*params(16)*y(24)*params(20)*y(119)/T418;
residual(78) = y(92);
residual(79) = y(122)+y(114)-params(3)*y(98);
residual(80) = y(98)+(params(9)-1)*y(122)-exp(y(47))*T440*T437*params(4)*y(115)+y(6)*y(28)*params(4)*y(117)/T451;
residual(81) = y(116)-params(3)*y(99)-T460+T466*params(6)*params(7)*y(108)+T954;
residual(82) = y(128);
residual(83) = y(107)-y(7)*y(108)+T490*y(112)-T502*y(112)/params(3)+y(109)/T132-y(9)*y(109)/T485+y(129)/(params(3)*y(24)*y(9))-y(9)*y(129)/(y(24)*T485)-T130*T210*params(13)*y(9)*y(15)*params(8)*y(113)/T485+T130*T210*params(13)*y(15)*params(8)*y(113)/T132;
residual(84) = y(99);
residual(85) = y(111)-params(3)*y(103)-y(130)/y(6)+T210*y(15)*y(110)/(y(48)-y(14));
residual(86) = y(130);
residual(87) = y(103)+T156*(y(33)-1)*params(13)*y(111);
residual(88) = y(119)-T561*y(6)*y(118);
residual(89) = y(12)*y(110)-(-y(124))-params(3)*y(101)-T579*params(3)*y(117)+(params(9)-1)*y(117)/y(18)-y(44)*params(14)*y(111);
residual(90) = y(101);
residual(91) = y(109)/T593-T603*y(112)-params(3)*y(102)-(y(33)-1)*T613*params(13)*y(43)*params(3)*y(111)-T210*T598*params(13)*y(9)*y(15)*params(8)*y(113)/y(9);
residual(92) = y(102)+y(127);
residual(93) = y(129)/(y(49)*T625)-params(3)*y(100)-(1+params(19)-y(28))*y(6)*y(27)*y(118)/T625;
residual(94) = y(100);
residual(95) = y(117)-y(127)+T642*y(112)/params(3)+(y(33)-1)*params(13)*y(43)*y(35)*y(111)/(y(48)-y(45))+T210*params(13)*y(9)*y(15)*y(15)*params(8)*y(113)/(T127*T132);
residual(96) = y(18)*y(110)-params(3)*y(104)-y(114);
residual(97) = (params(4)-1)*y(6)*y(116)/y(7)-T676*y(118)-y(6)*params(4)*y(117)/(y(38)*y(18))-y(6)*y(27)*y(118)/T202;
residual(98) = y(104)-y(18)*params(14)*y(111);
residual(99) = y(127)-params(21)*(2*y(21)-2*params(17));
residual(100) = T697*y(112)/params(3)-T705*y(112)-y(15)*y(128)/T694-params(3)*y(105)+T210*y(13)*y(15)*y(110)/T715-T210*(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)*y(113)/(y(9)*T694);
residual(101) = y(105)-(y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(35)*y(111)/T726;
residual(102) = y(9)*(-y(108))-(params(4)-1)*y(6)*y(28)*y(116)/T735;
residual(103) = y(125)+y(115)-params(3)*y(106)-params(11)*y(126)+((1+params(19)-y(28))*y(26)-T561*(y(25)-1))*y(118)+y(13)*y(130)/T752+(params(4)-1)*y(28)*y(116)/y(7)-y(28)*params(4)*y(117)/(y(38)*y(18))+(1+params(19)-y(28))*y(27)*y(118)/T202;
residual(104) = y(106);
lhs =y(9);
rhs =1/(y(19)-y(34)*params(5)+y(50))-params(5)*y(49)/(y(50)+y(19)-y(19)*params(5));
residual(105)= lhs-rhs;
lhs =T460;
rhs =y(9)*y(7);
residual(106)= lhs-rhs;
lhs =1;
rhs =1/(y(49)*(1+y(11)));
residual(107)= lhs-rhs;
lhs =y(18)*y(12);
rhs =y(13)*y(15)/(y(48)-y(14))*(1-y(32));
residual(108)= lhs-rhs;
lhs =y(13);
rhs =y(43)*params(13)*(y(11)+1+y(35)*(y(8)-y(11))/(y(48)-y(45)))*(1-y(33))+y(44)*y(18)*params(14);
residual(109)= lhs-rhs;
lhs =y(14);
rhs =(y(8)-y(11))*T1189+y(14)*T1199;
residual(110)= lhs-rhs;
lhs =y(15);
rhs =1-params(13)+y(15)*T1199;
residual(111)= lhs-rhs;
lhs =y(5);
rhs =y(12);
residual(112)= lhs-rhs;
lhs =y(6);
rhs =T440*T1207;
residual(113)= lhs-rhs;
lhs =y(10);
rhs =y(6)*y(28)*(1-params(4))/y(7);
residual(114)= lhs-rhs;
lhs =1+y(8);
rhs =y(6)*y(28)*params(4)/(y(38)*y(18))+y(18)*(1-params(9))/y(18);
residual(115)= lhs-rhs;
lhs =0;
rhs =y(6)*T1225-y(26)*y(6)*(1+params(19)-y(28))-y(27)*y(6)*(1+params(19)-y(28))*1/(1+y(23));
residual(116)= lhs-rhs;
lhs =y(25);
rhs =params(16)/2*(y(24)/(y(37)*params(20)+params(51)*(1-params(20)))-1)^2;
residual(117)= lhs-rhs;
lhs =y(26);
rhs =y(24)*params(16)*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)/(y(24)*params(20)+params(51)*(1-params(20)));
residual(118)= lhs-rhs;
lhs =y(27);
rhs =T343*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)*(-params(16))/(y(24)*params(20)+params(51)*(1-params(20)));
residual(119)= lhs-rhs;
lhs =y(5);
rhs =y(16)+y(38)*(1-params(9));
residual(120)= lhs-rhs;
lhs =y(16);
rhs =y(17)*T1264;
residual(121)= lhs-rhs;
lhs =y(18);
rhs =1;
residual(122)= lhs-rhs;
lhs =y(6);
rhs =y(19)+y(17)+y(20);
residual(123)= lhs-rhs;
lhs =y(20);
rhs =y(6)*params(11);
residual(124)= lhs-rhs;
lhs =y(21);
rhs =y(8)-y(42);
residual(125)= lhs-rhs;
lhs =y(22);
rhs =T597;
residual(126)= lhs-rhs;
lhs =1/y(24);
rhs =1/(y(49)*(1+y(23)));
residual(127)= lhs-rhs;
lhs =y(29);
rhs =y(13)/y(6);
residual(128)= lhs-rhs;
lhs =y(48)-params(12);
rhs =(y(48)-params(12))*params(32)+params(33)*x(3);
residual(129)= lhs-rhs;
lhs =y(49)-params(8);
rhs =(y(49)-params(8))*params(36)+params(37)*x(5);
residual(130)= lhs-rhs;
lhs =y(50);
rhs =y(50)*params(38)+params(39)*x(6);
residual(131)= lhs-rhs;
lhs =y(47);
rhs =y(47)*params(30)+params(31)*x(1);
residual(132)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(132, 132);

  %
  % Jacobian matrix
  %

  g1(1,30)=(-params(1));
  g1(1,31)=(-params(2));
  g1(1,131)=1;
  g1(2,131)=(-1);
  g1(2,132)=1-params(3);
  g1(3,1)=1-params(3);
  g1(3,30)=(-1);
  g1(4,2)=1-params(3);
  g1(4,31)=(-1);
  g1(5,3)=1;
  g1(5,24)=(-1);
  g1(6,4)=1;
  g1(6,32)=(-1);
  g1(7,32)=(-1);
  g1(7,33)=1;
  g1(8,19)=(-1);
  g1(8,34)=1;
  g1(9,15)=(-1);
  g1(9,35)=1;
  g1(10,17)=(-1);
  g1(10,36)=1;
  g1(11,24)=(-1);
  g1(11,37)=1;
  g1(12,5)=(-1);
  g1(12,38)=1;
  g1(13,10)=(-1);
  g1(13,39)=1;
  g1(14,23)=(-1);
  g1(14,40)=1;
  g1(15,18)=(-1);
  g1(15,41)=1;
  g1(16,11)=(-1);
  g1(16,42)=1;
  g1(17,13)=(-1);
  g1(17,43)=1;
  g1(18,12)=(-1);
  g1(18,44)=1;
  g1(19,14)=(-1);
  g1(19,45)=1;
  g1(20,6)=(-1);
  g1(20,46)=1;
  g1(21,10)=T1873;
  g1(21,19)=T2684;
  g1(21,24)=params(22)*2*(y(24)-params(51));
  g1(21,30)=1;
  g1(21,34)=(-((-params(5))/(y(19)-y(34)*params(5)+y(50))));
  g1(21,50)=T2684;
  g1(22,10)=T1873;
  g1(22,19)=T2684;
  g1(22,21)=params(21)*2*(y(21)-params(17));
  g1(22,31)=1;
  g1(22,34)=(-((-params(5))/(y(19)-y(34)*params(5)+y(50))));
  g1(22,50)=T2684;
  g1(23,8)=y(15)*params(8)*y(73)*y(9)*params(13)*T1417/T132+T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(72)*T1417/T145;
  g1(23,9)=(T132*T130*y(15)*params(8)*y(73)*params(13)-params(3)*y(15)*params(8)*y(73)*y(9)*params(13)*T130)/(T132*T132)+(T145*T130*T127*y(14)*params(13)*y(15)*params(8)*y(72)-T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(72)*T127*params(3)*y(15))/(T145*T145);
  g1(23,11)=y(15)*params(8)*y(73)*y(9)*params(13)*T1902/T132+T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(72)*T1902/T145;
  g1(23,13)=y(15)*y(70)/(y(48)-y(14));
  g1(23,14)=y(13)*y(15)*y(70)/T2043+y(15)*params(8)*y(73)*y(9)*params(13)*T2047/T132+(T145*(T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(72)*T2047+T130*((-(y(14)*params(13)*y(9)*y(15)*params(8)*y(72)))+T127*params(13)*y(9)*y(15)*params(8)*y(72)))-T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(72)*(-(params(3)*y(15)*y(9))))/(T145*T145);
  g1(23,15)=y(13)*y(70)/(y(48)-y(14))+(T130*params(13)*params(8)*y(73)*y(9)+y(15)*params(8)*y(73)*y(9)*params(13)*T2311)/T132+(T145*(T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(72)*T2311+T130*T127*y(14)*params(13)*y(9)*params(8)*y(72))-T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(72)*T127*T132)/(T145*T145);
  g1(23,48)=(-(y(13)*y(15)*y(70)))/T2043;
  g1(23,52)=(-1);
  g1(23,53)=(-params(3));
  g1(23,70)=y(15)*y(13)/(y(48)-y(14));
  g1(23,72)=T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)/T145;
  g1(23,73)=T130*params(13)*y(9)*y(15)*params(8)/T132;
  g1(24,8)=params(13)*y(43)*y(71)*T1425;
  g1(24,11)=params(13)*y(43)*y(71)*T1908;
  g1(24,35)=params(13)*y(43)*y(71)*T3147;
  g1(24,43)=T156*params(13)*y(71);
  g1(24,45)=params(13)*y(43)*y(71)*T3328;
  g1(24,48)=params(13)*y(43)*y(71)*T3373;
  g1(24,53)=1;
  g1(24,71)=T156*y(43)*params(13);
  g1(25,19)=y(67)*T2696+T2699-(-(params(5)*y(67)*y(49)*params(3)*(1-params(5))*2*(y(19)+y(50)-y(19)*params(5))))/(params(3)*T170*params(3)*T170);
  g1(25,34)=y(67)*(-(2*(y(19)+y(50)-y(34)*params(5))*(-params(5))))/(T163*T163)+params(5)/((y(19)+y(50)-y(34)*params(5))*(y(19)+y(50)-y(34)*params(5)));
  g1(25,49)=y(67)*T3420-params(5)*y(67)/(params(3)*T170);
  g1(25,50)=T2699+y(67)*T3467-(-(params(5)*y(67)*y(49)*params(3)*2*(y(19)+y(50)-y(19)*params(5))))/(params(3)*T170*params(3)*T170);
  g1(25,54)=(-params(3));
  g1(25,67)=T172-params(5)*y(49)/(params(3)*T170);
  g1(25,85)=(-1);
  g1(26,19)=T2713;
  g1(26,34)=T3133-(-(params(5)*y(67)*2*(y(19)+y(50)-y(34)*params(5))*(-params(5))))/(T163*T163);
  g1(26,50)=T2713;
  g1(26,54)=1;
  g1(26,67)=(-(params(5)/T163));
  g1(27,6)=y(78)*(1+params(19)-y(28))/T202;
  g1(27,23)=(-(params(3)*y(6)*y(78)*(1+params(19)-y(28))))/(T202*T202);
  g1(27,28)=(-(y(6)*y(78)))/T202;
  g1(27,78)=y(6)*(1+params(19)-y(28))/T202;
  g1(27,81)=1;
  g1(28,6)=y(78)*(1+params(19)-y(28));
  g1(28,28)=(-(y(6)*y(78)));
  g1(28,78)=y(6)*(1+params(19)-y(28));
  g1(28,80)=1;
  g1(29,8)=(-(y(72)*T1432))-y(73)*T210*(-(params(13)*y(9)*y(15)*params(8)))/(y(9)*T127)+T210*params(13)*params(8)*y(73)*y(9)*T1417/T132+T210*T127*y(14)*params(13)*y(9)*params(8)*y(72)*T1417/T145;
  g1(29,9)=(-(y(72)*T1578))-y(73)*T1587+(T132*T130*T210*params(8)*y(73)*params(13)-params(3)*T130*T210*params(13)*params(8)*y(73)*y(9))/(T132*T132)+(T145*T130*T210*T127*y(14)*params(13)*params(8)*y(72)-T130*T210*T127*y(14)*params(13)*y(9)*params(8)*y(72)*T127*params(3)*y(15))/(T145*T145);
  g1(29,11)=(-(y(72)*T1913))-y(73)*T210*params(13)*y(9)*y(15)*params(8)/(y(9)*T127)+T210*params(13)*params(8)*y(73)*y(9)*T1902/T132+T210*T127*y(14)*params(13)*y(9)*params(8)*y(72)*T1902/T145;
  g1(29,13)=y(70)*T210/(y(48)-y(14));
  g1(29,14)=y(13)*y(70)*T210/T2043-y(72)*T2080-y(73)*T2085-y(88)/(T127*T127)+T210*params(13)*params(8)*y(73)*y(9)*T2047/T132+(T145*(T210*T127*y(14)*params(13)*y(9)*params(8)*y(72)*T2047+T130*T210*((-(y(14)*params(13)*y(9)*params(8)*y(72)))+T127*params(13)*y(9)*params(8)*y(72)))-T130*T210*T127*y(14)*params(13)*y(9)*params(8)*y(72)*(-(params(3)*y(15)*y(9))))/(T145*T145);
  g1(29,15)=(-(y(72)*T2345))-y(73)*T210*(y(11)-y(8))*params(13)*params(8)*y(9)/(y(9)*T127)+T210*params(13)*params(8)*y(73)*y(9)*T2311/T132+(T145*T210*T127*y(14)*params(13)*y(9)*params(8)*y(72)*T2311-T130*T210*T127*y(14)*params(13)*y(9)*params(8)*y(72)*T127*T132)/(T145*T145);
  g1(29,32)=y(13)*y(70)/(y(48)-y(14))-y(72)*T3020-y(73)*(y(11)-y(8))*params(13)*y(9)*y(15)*params(8)/(y(9)*T127)+T130*params(13)*params(8)*y(73)*y(9)/T132+T130*T127*y(14)*params(13)*y(9)*params(8)*y(72)/T145;
  g1(29,48)=(-(y(13)*y(70)*T210))/T2043;
  g1(29,55)=(-params(3));
  g1(29,70)=y(13)*T210/(y(48)-y(14));
  g1(29,72)=(-T228)+T130*T210*T127*y(14)*params(13)*params(8)*y(9)/T145;
  g1(29,73)=(-T235)+T130*T210*params(13)*params(8)*y(9)/T132;
  g1(29,88)=(-T2391);
  g1(30,8)=(-((y(33)-1)*(-(params(13)*y(43)*y(71)))/(y(48)-y(45))));
  g1(30,11)=(-(params(13)*y(43)*y(71)*(y(33)-1)/(y(48)-y(45))));
  g1(30,33)=(-((y(11)-y(8))*params(13)*y(43)*y(71)/(y(48)-y(45))));
  g1(30,43)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(71)/(y(48)-y(45))));
  g1(30,45)=(-((y(11)-y(8))*params(13)*y(43)*y(71)*(y(33)-1)/T3326));
  g1(30,48)=(-((-((y(11)-y(8))*params(13)*y(43)*y(71)*(y(33)-1)))/T3326));
  g1(30,55)=1;
  g1(30,71)=(-((y(33)-1)*(y(11)-y(8))*y(43)*params(13)/(y(48)-y(45))));
  g1(31,85)=(-1);
  g1(31,86)=1;
  g1(32,9)=(-(y(84)*T1614))+y(84)*T1623/params(3);
  g1(32,17)=y(83)*T2543-y(84)*T2561+y(84)*T2572/params(3)+params(3)*y(84)*T2580;
  g1(32,18)=(-(y(84)*T2612))+y(84)*params(10)*y(9)*y(49)*T287/(y(9)*T292)/params(3)+params(3)*y(84)*params(10)*T287/T292;
  g1(32,36)=y(83)*T3178;
  g1(32,49)=(-(y(84)*y(18)*params(10)*y(9)*T292/T299))+y(84)*y(18)*params(10)*y(9)*T287/(y(9)*T292)/params(3);
  g1(32,56)=(-params(3));
  g1(32,83)=T279;
  g1(32,84)=(-T301)+T314/params(3)+params(3)*T326;
  g1(32,85)=(-1);
  g1(33,17)=(-((params(10)*y(83)*T287*T2534+T271*params(10)*y(83)*2*y(17))/T336));
  g1(33,36)=(-((T336*params(10)*y(83)*T287*T3170-T271*params(10)*y(83)*T287*2*y(36))/(T336*T336)));
  g1(33,56)=1;
  g1(33,83)=(-(T271*params(10)*T287/T336));
  g1(34,82)=(-1);
  g1(34,83)=1;
  g1(35,9)=(-((y(89)*params(3)*y(9)*T343-y(9)*y(89)*params(3)*T343)/(params(3)*y(9)*T343*params(3)*y(9)*T343)));
  g1(35,24)=y(81)*T2806-2*params(22)-y(80)*T2819-params(3)*y(81)*T2841+params(3)*y(80)*T2856-params(16)*y(79)*T2859/T401-(-(y(9)*y(89)*params(3)*y(9)*2*y(24)))/(params(3)*y(9)*T343*params(3)*y(9)*T343);
  g1(35,37)=(-((T401*params(16)*y(79)*T3201-params(20)*params(16)*y(79)*T403)/(T401*T401)));
  g1(35,51)=(-1);
  g1(35,57)=(-params(3));
  g1(35,79)=(-(params(16)*T403/T401));
  g1(35,80)=(-T374)+params(3)*T395;
  g1(35,81)=T359-params(3)*T387;
  g1(35,89)=(-(y(9)/(params(3)*y(9)*T343)));
  g1(36,24)=(params(16)*y(24)*params(20)*y(79)*T2859+T403*params(16)*params(20)*y(79))/T418;
  g1(36,37)=(T418*params(16)*y(24)*params(20)*y(79)*T3201-T403*params(16)*y(24)*params(20)*y(79)*params(20)*2*T401)/(T418*T418);
  g1(36,57)=1;
  g1(36,79)=params(16)*y(24)*params(20)*T403/T418;
  g1(37,51)=1;
  g1(38,58)=(-params(3));
  g1(38,74)=1;
  g1(38,82)=1;
  g1(39,6)=y(28)*params(4)*y(77)/T451;
  g1(39,10)=(-(exp(y(47))*params(4)*y(75)*T437*T1875));
  g1(39,18)=(-(y(6)*y(28)*params(4)*y(77)*y(38)^2))/(T451*T451);
  g1(39,28)=y(6)*params(4)*y(77)/T451;
  g1(39,38)=(-(exp(y(47))*T440*params(4)*y(75)*getPowerDeriv(y(38),params(4)-1,1)))+(-(y(6)*y(28)*params(4)*y(77)*y(18)*2*y(38)))/(T451*T451);
  g1(39,47)=(-(params(4)*y(75)*T437*T440*exp(y(47))));
  g1(39,58)=1;
  g1(39,75)=(-(exp(y(47))*T440*params(4)*T437));
  g1(39,77)=y(6)*y(28)*params(4)/T451;
  g1(39,82)=params(9)-1;
  g1(40,10)=(-(params(6)*getPowerDeriv(y(10),params(7),1)))+params(6)*params(7)*y(68)*getPowerDeriv(y(10),params(7)-1,1)+(-((params(4)-1)*exp(y(47))*y(75)*y(38)^params(4)*getPowerDeriv(y(10),params(4),1)))/(T473*T473);
  g1(40,38)=(params(4)-1)*exp(y(47))*y(75)*getPowerDeriv(y(38),params(4),1)/T473;
  g1(40,47)=T474;
  g1(40,59)=(-params(3));
  g1(40,68)=T466*params(6)*params(7);
  g1(40,75)=T3566;
  g1(40,76)=1;
  g1(41,88)=1;
  g1(42,7)=(-y(68));
  g1(42,8)=y(72)*T1454-y(72)*T1461/params(3)-y(15)*params(8)*y(73)*y(9)*params(13)*T210*T1417/T485+T210*y(15)*params(8)*y(73)*params(13)*T1417/T132;
  g1(42,9)=y(72)*T1647-y(72)*T1655/params(3)+(-(params(3)*y(69)))/(T132*T132)-(T485*y(69)-y(9)*y(69)*2*y(9))/(T485*T485)+(-(y(89)*params(3)*y(24)))/(params(3)*y(24)*y(9)*params(3)*y(24)*y(9))-(y(89)*y(24)*T485-y(9)*y(89)*y(24)*2*y(9))/(y(24)*T485*y(24)*T485)-(T485*T130*T210*y(15)*params(8)*y(73)*params(13)-T130*y(15)*params(8)*y(73)*y(9)*params(13)*T210*2*y(9))/(T485*T485)+(-(params(3)*T130*T210*y(15)*params(8)*y(73)*params(13)))/(T132*T132);
  g1(42,11)=y(72)*T1931-y(72)*T1936/params(3)-y(15)*params(8)*y(73)*y(9)*params(13)*T210*T1902/T485+T210*y(15)*params(8)*y(73)*params(13)*T1902/T132;
  g1(42,14)=y(72)*T2111-y(72)*T2123/params(3)-y(15)*params(8)*y(73)*y(9)*params(13)*T210*T2047/T485+T210*y(15)*params(8)*y(73)*params(13)*T2047/T132;
  g1(42,15)=y(72)*T2367-y(72)*T2379/params(3)-(T130*T210*params(13)*params(8)*y(73)*y(9)+y(15)*params(8)*y(73)*y(9)*params(13)*T210*T2311)/T485+(T130*T210*params(8)*y(73)*params(13)+T210*y(15)*params(8)*y(73)*params(13)*T2311)/T132;
  g1(42,24)=(-(T132*y(89)))/(params(3)*y(24)*y(9)*params(3)*y(24)*y(9))-(-(y(9)*y(89)*T485))/(y(24)*T485*y(24)*T485);
  g1(42,32)=y(72)*(-(T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)/(T127*y(15)*T485)))-y(72)*(-(T130*T127*y(14)*params(13)*y(15)*params(8)/T219))/params(3)-y(15)*params(8)*y(73)*y(9)*params(13)*T130/T485+T130*y(15)*params(8)*y(73)*params(13)/T132;
  g1(42,67)=1;
  g1(42,68)=(-y(7));
  g1(42,69)=T3495;
  g1(42,72)=T490-T502/params(3);
  g1(42,73)=T3548;
  g1(42,89)=T3618;
  g1(43,59)=1;
  g1(44,6)=(-((-y(90))/(y(6)*y(6))));
  g1(44,14)=y(15)*y(70)*T210/T2043;
  g1(44,15)=y(70)*T210/(y(48)-y(14));
  g1(44,32)=y(15)*y(70)/(y(48)-y(14));
  g1(44,48)=(-(y(15)*y(70)*T210))/T2043;
  g1(44,63)=(-params(3));
  g1(44,70)=y(15)*T210/(y(48)-y(14));
  g1(44,71)=1;
  g1(44,90)=(-(1/y(6)));
  g1(45,90)=1;
  g1(46,8)=(y(33)-1)*params(13)*y(71)*T1425;
  g1(46,11)=(y(33)-1)*params(13)*y(71)*T1908;
  g1(46,33)=T156*params(13)*y(71);
  g1(46,35)=(y(33)-1)*params(13)*y(71)*T3147;
  g1(46,45)=(y(33)-1)*params(13)*y(71)*T3328;
  g1(46,48)=(y(33)-1)*params(13)*y(71)*T3373;
  g1(46,63)=1;
  g1(46,71)=T156*params(13)*(y(33)-1);
  g1(47,6)=(-(y(78)*T561));
  g1(47,28)=(-(y(6)*y(78)*(-((1+params(18))/params(18)))));
  g1(47,78)=(-(y(6)*T561));
  g1(47,79)=1;
  g1(48,6)=(-(params(3)*y(77)*(-(y(28)*params(4)/(y(38)*T573)))));
  g1(48,12)=y(70);
  g1(48,18)=(-(params(3)*y(77)*T2637))+(-((params(9)-1)*y(77)))/(y(18)*y(18));
  g1(48,28)=(-(params(3)*y(77)*(-(y(6)*params(4)/(y(38)*T573)))));
  g1(48,38)=(-(params(3)*y(77)*(-((-(T573*y(6)*y(28)*params(4)))/(y(38)*T573*y(38)*T573)))));
  g1(48,44)=(-(y(71)*params(14)));
  g1(48,61)=(-params(3));
  g1(48,70)=y(12);
  g1(48,71)=(-(y(44)*params(14)));
  g1(48,77)=(-(params(3)*T579))+(params(9)-1)/y(18);
  g1(48,84)=1;
  g1(49,61)=1;
  g1(50,9)=(-(y(72)*T1701))-(y(9)*T210*y(15)*params(8)*y(73)*params(13)*T598-T210*y(15)*params(8)*y(73)*y(9)*params(13)*T598)/(y(9)*y(9));
  g1(50,11)=(-(y(69)*y(49)*2*(1+y(11))))/(T593*T593);
  g1(50,14)=(-(y(72)*T2146))-T210*y(15)*params(8)*y(73)*y(9)*params(13)*T2135/y(9);
  g1(50,15)=(-(y(72)*T2400))-T210*(params(13)*params(8)*y(73)*y(9)*T598+y(15)*params(8)*y(73)*y(9)*params(13)*T2391)/y(9);
  g1(50,32)=(-(y(72)*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T598/T219))-y(15)*params(8)*y(73)*y(9)*params(13)*T598/y(9);
  g1(50,33)=(-(params(13)*y(43)*params(3)*y(71)*T613));
  g1(50,35)=(-((y(33)-1)*params(13)*y(43)*params(3)*y(71)*1/(y(48)-y(45))));
  g1(50,43)=(-((y(33)-1)*T613*params(13)*params(3)*y(71)));
  g1(50,45)=(-((y(33)-1)*params(13)*y(43)*params(3)*y(71)*y(35)/T3326));
  g1(50,48)=(-((y(33)-1)*params(13)*y(43)*params(3)*y(71)*(-y(35))/T3326));
  g1(50,49)=(-(y(69)*T592))/(T593*T593);
  g1(50,62)=(-params(3));
  g1(50,69)=1/T593;
  g1(50,71)=(-((y(33)-1)*T613*params(13)*params(3)*y(43)));
  g1(50,72)=(-T603);
  g1(50,73)=(-(T210*params(13)*y(9)*y(15)*params(8)*T598/y(9)));
  g1(51,62)=1;
  g1(51,87)=1;
  g1(52,6)=(-((1+params(19)-y(28))*y(78)*y(27)/T625));
  g1(52,23)=(-(y(89)*y(49)*2*(1+y(23))))/(y(49)*T625*y(49)*T625)-(-((1+params(19)-y(28))*y(6)*y(78)*y(27)*2*(1+y(23))))/(T625*T625);
  g1(52,27)=(-(y(6)*y(78)*(1+params(19)-y(28))/T625));
  g1(52,28)=(-((-(y(6)*y(78)*y(27)))/T625));
  g1(52,49)=(-(y(89)*T625))/(y(49)*T625*y(49)*T625);
  g1(52,60)=(-params(3));
  g1(52,78)=(-((1+params(19)-y(28))*y(6)*y(27)/T625));
  g1(52,89)=1/(y(49)*T625);
  g1(53,60)=1;
  g1(54,9)=y(72)*T1715/params(3)+(T127*T132*T210*params(13)*y(15)*y(15)*params(8)*y(73)-T210*params(13)*y(9)*y(15)*y(15)*params(8)*y(73)*params(3)*T127)/(T127*T132*T127*T132);
  g1(54,14)=y(72)*T2156/params(3)+(-(T210*params(13)*y(9)*y(15)*y(15)*params(8)*y(73)*(-T132)))/(T127*T132*T127*T132);
  g1(54,15)=y(72)*T210*y(14)*params(13)*params(8)*y(9)/(y(9)*T127)/params(3)+T210*params(13)*y(9)*(y(15)*params(8)*y(73)+y(15)*params(8)*y(73))/(T127*T132);
  g1(54,32)=y(72)*y(14)*params(13)*y(9)*y(15)*params(8)/(y(9)*T127)/params(3)+params(13)*y(9)*y(15)*y(15)*params(8)*y(73)/(T127*T132);
  g1(54,33)=params(13)*y(43)*y(35)*y(71)/(y(48)-y(45));
  g1(54,35)=params(13)*y(43)*y(71)*(y(33)-1)/(y(48)-y(45));
  g1(54,43)=(y(33)-1)*params(13)*y(35)*y(71)/(y(48)-y(45));
  g1(54,45)=(y(33)-1)*params(13)*y(43)*y(35)*y(71)/T3326;
  g1(54,48)=(-((y(33)-1)*params(13)*y(43)*y(35)*y(71)))/T3326;
  g1(54,71)=(y(33)-1)*params(13)*y(35)*y(43)/(y(48)-y(45));
  g1(54,72)=T642/params(3);
  g1(54,73)=T210*params(13)*y(9)*y(15)*y(15)*params(8)/(T127*T132);
  g1(54,77)=1;
  g1(54,87)=(-1);
  g1(55,18)=y(70);
  g1(55,64)=(-params(3));
  g1(55,70)=y(18);
  g1(55,74)=(-1);
  g1(56,6)=(params(4)-1)*y(76)/y(7)-y(78)*(y(26)-(1+params(18))*(y(25)-1)/params(18))-params(4)*y(77)/(y(38)*y(18))-y(78)*y(27)/T202;
  g1(56,7)=(-((params(4)-1)*y(6)*y(76)))/(y(7)*y(7));
  g1(56,18)=(-((-(y(38)*y(6)*params(4)*y(77)))/(y(38)*y(18)*y(38)*y(18))));
  g1(56,23)=(-((-(params(3)*y(6)*y(78)*y(27)))/(T202*T202)));
  g1(56,25)=(-(y(78)*(-(y(6)*(1+params(18))/params(18)))));
  g1(56,26)=(-(y(6)*y(78)));
  g1(56,27)=(-(y(6)*y(78)/T202));
  g1(56,38)=(-((-(y(18)*y(6)*params(4)*y(77)))/(y(38)*y(18)*y(38)*y(18))));
  g1(56,76)=y(6)*(params(4)-1)/y(7);
  g1(56,77)=T3004;
  g1(56,78)=(-T676)-y(6)*y(27)/T202;
  g1(57,18)=(-(y(71)*params(14)));
  g1(57,64)=1;
  g1(57,71)=(-(y(18)*params(14)));
  g1(58,87)=1;
  g1(59,8)=y(72)*T1475/params(3)-y(72)*T1481-T210*(-(params(13)*y(9)*y(15)*y(15)*params(8)*y(73)))/(y(9)*T694);
  g1(59,9)=y(72)*T1740/params(3)-y(72)*T1754-(y(9)*T694*T210*(y(11)-y(8))*params(13)*y(15)*y(15)*params(8)*y(73)-T694*T210*(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)*y(73))/(y(9)*T694*y(9)*T694);
  g1(59,11)=y(72)*T1956/params(3)-y(72)*T1962-T210*params(13)*y(9)*y(15)*y(15)*params(8)*y(73)/(y(9)*T694);
  g1(59,13)=y(15)*y(70)*T210/T715;
  g1(59,14)=y(72)*T2178/params(3)-y(72)*T2195-(-(y(15)*y(88)*(-(2*T127))))/(T694*T694)+(-(y(13)*y(15)*y(70)*T210*(-(2*(y(48)-y(14))))))/(T715*T715)-(-(T210*(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)*y(73)*y(9)*(-(2*T127))))/(y(9)*T694*y(9)*T694);
  g1(59,15)=y(72)*T2432/params(3)-y(72)*T2443-y(88)/T694+y(13)*y(70)*T210/T715-T210*(y(11)-y(8))*params(13)*y(9)*(y(15)*params(8)*y(73)+y(15)*params(8)*y(73))/(y(9)*T694);
  g1(59,32)=y(72)*T3056/params(3)-y(72)*T3062+y(13)*y(15)*y(70)/T715-(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)*y(73)/(y(9)*T694);
  g1(59,48)=(-(y(13)*y(15)*y(70)*T210*2*(y(48)-y(14))))/(T715*T715);
  g1(59,65)=(-params(3));
  g1(59,70)=T210*y(15)*y(13)/T715;
  g1(59,72)=T697/params(3)-T705;
  g1(59,73)=(-(T210*(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)/(y(9)*T694)));
  g1(59,88)=(-(y(15)/T694));
  g1(60,8)=(-((y(33)-1)*(-(params(13)*y(43)*y(35)*y(71)))/T726));
  g1(60,11)=(-((y(33)-1)*params(13)*y(43)*y(35)*y(71)/T726));
  g1(60,33)=(-((y(11)-y(8))*params(13)*y(43)*y(35)*y(71)/T726));
  g1(60,35)=(-((y(11)-y(8))*params(13)*y(43)*y(71)*(y(33)-1)/T726));
  g1(60,43)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(35)*y(71)/T726));
  g1(60,45)=(-((-((y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(35)*y(71)*(-(2*(y(48)-y(45))))))/(T726*T726)));
  g1(60,48)=(-((-((y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(35)*y(71)*2*(y(48)-y(45))))/(T726*T726)));
  g1(60,65)=1;
  g1(60,71)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(35)*y(43)/T726));
  g1(61,6)=(-((params(4)-1)*y(28)*y(76)/T735));
  g1(61,7)=(-((-((params(4)-1)*y(6)*y(28)*y(76)*2*y(7)))/(T735*T735)));
  g1(61,9)=(-y(68));
  g1(61,28)=(-((params(4)-1)*y(6)*y(76)/T735));
  g1(61,68)=(-y(9));
  g1(61,76)=(-((params(4)-1)*y(6)*y(28)/T735));
  g1(62,6)=(-(y(13)*y(90)*2*y(6)))/(T752*T752);
  g1(62,7)=(-((params(4)-1)*y(28)*y(76)))/(y(7)*y(7));
  g1(62,13)=y(90)/T752;
  g1(62,18)=(-((-(y(38)*y(28)*params(4)*y(77)))/(y(38)*y(18)*y(38)*y(18))));
  g1(62,23)=(-(params(3)*(1+params(19)-y(28))*y(78)*y(27)))/(T202*T202);
  g1(62,25)=y(78)*(-T561);
  g1(62,26)=y(78)*(1+params(19)-y(28));
  g1(62,27)=y(78)*(1+params(19)-y(28))/T202;
  g1(62,28)=(params(4)-1)*y(76)/y(7)+y(78)*((-y(26))-(y(25)-1)*(-((1+params(18))/params(18))))-params(4)*y(77)/(y(38)*y(18))+(-(y(78)*y(27)))/T202;
  g1(62,38)=(-((-(y(18)*y(28)*params(4)*y(77)))/(y(38)*y(18)*y(38)*y(18))));
  g1(62,66)=(-params(3));
  g1(62,75)=1;
  g1(62,76)=y(28)*(params(4)-1)/y(7);
  g1(62,77)=T1382;
  g1(62,78)=T3593;
  g1(62,85)=1;
  g1(62,86)=(-params(11));
  g1(62,90)=y(13)/T752;
  g1(63,66)=1;
  g1(64,8)=params(13)*y(9)*y(15)*params(8)*y(113)*T1417/T132+T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(112)*T1417/T145;
  g1(64,9)=(T132*T130*params(13)*y(15)*params(8)*y(113)-params(3)*T130*params(13)*y(9)*y(15)*params(8)*y(113))/(T132*T132)+(T145*T130*T127*y(14)*params(13)*y(15)*params(8)*y(112)-T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(112)*T127*params(3)*y(15))/(T145*T145);
  g1(64,11)=params(13)*y(9)*y(15)*params(8)*y(113)*T1902/T132+T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(112)*T1902/T145;
  g1(64,13)=y(15)*y(110)/(y(48)-y(14));
  g1(64,14)=y(13)*y(15)*y(110)/T2043+params(13)*y(9)*y(15)*params(8)*y(113)*T2047/T132+(T145*(T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(112)*T2047+T130*((-(y(14)*params(13)*y(9)*y(15)*params(8)*y(112)))+T127*params(13)*y(9)*y(15)*params(8)*y(112)))-T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(112)*(-(params(3)*y(15)*y(9))))/(T145*T145);
  g1(64,15)=y(13)*y(110)/(y(48)-y(14))+(params(13)*y(9)*y(15)*params(8)*y(113)*T2311+T130*params(13)*y(9)*params(8)*y(113))/T132+(T145*(T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(112)*T2311+T130*T127*y(14)*params(13)*y(9)*params(8)*y(112))-T127*T132*T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)*y(112))/(T145*T145);
  g1(64,48)=(-(y(13)*y(15)*y(110)))/T2043;
  g1(64,92)=(-1);
  g1(64,93)=(-params(3));
  g1(64,110)=y(15)*y(13)/(y(48)-y(14));
  g1(64,112)=T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)/T145;
  g1(64,113)=T130*params(13)*y(9)*y(15)*params(8)/T132;
  g1(65,8)=params(13)*y(43)*y(111)*T1425;
  g1(65,11)=params(13)*y(43)*y(111)*T1908;
  g1(65,35)=params(13)*y(43)*y(111)*T3147;
  g1(65,43)=T156*params(13)*y(111);
  g1(65,45)=params(13)*y(43)*y(111)*T3328;
  g1(65,48)=params(13)*y(43)*y(111)*T3373;
  g1(65,93)=1;
  g1(65,111)=T156*y(43)*params(13);
  g1(66,19)=T2699+y(107)*T2696-(-(params(5)*y(49)*y(107)*params(3)*(1-params(5))*2*(y(19)+y(50)-y(19)*params(5))))/(params(3)*T170*params(3)*T170);
  g1(66,34)=params(5)/((y(19)+y(50)-y(34)*params(5))*(y(19)+y(50)-y(34)*params(5)))+y(107)*(-(2*(y(19)+y(50)-y(34)*params(5))*(-params(5))))/(T163*T163);
  g1(66,49)=y(107)*T3420-params(5)*y(107)/(params(3)*T170);
  g1(66,50)=T2699+y(107)*T3467-(-(params(5)*y(49)*y(107)*params(3)*2*(y(19)+y(50)-y(19)*params(5))))/(params(3)*T170*params(3)*T170);
  g1(66,94)=(-params(3));
  g1(66,107)=T172-params(5)*y(49)/(params(3)*T170);
  g1(66,125)=(-1);
  g1(67,19)=T2723;
  g1(67,34)=T3133-(-(params(5)*y(107)*2*(y(19)+y(50)-y(34)*params(5))*(-params(5))))/(T163*T163);
  g1(67,50)=T2723;
  g1(67,94)=1;
  g1(67,107)=(-(params(5)/T163));
  g1(68,6)=(1+params(19)-y(28))*y(118)/T202;
  g1(68,23)=(-(params(3)*(1+params(19)-y(28))*y(6)*y(118)))/(T202*T202);
  g1(68,28)=(-(y(6)*y(118)))/T202;
  g1(68,118)=y(6)*(1+params(19)-y(28))/T202;
  g1(68,121)=1;
  g1(69,6)=(1+params(19)-y(28))*y(118);
  g1(69,28)=(-(y(6)*y(118)));
  g1(69,118)=y(6)*(1+params(19)-y(28));
  g1(69,120)=1;
  g1(70,8)=(-(y(112)*T1432))-y(113)*T210*(-(params(13)*y(9)*y(15)*params(8)))/(y(9)*T127)+T210*params(13)*y(9)*params(8)*y(113)*T1417/T132+T210*T127*y(14)*params(13)*y(9)*params(8)*y(112)*T1417/T145;
  g1(70,9)=(-(y(112)*T1578))-y(113)*T1587+(T132*T130*T210*params(13)*params(8)*y(113)-params(3)*T130*T210*params(13)*y(9)*params(8)*y(113))/(T132*T132)+(T145*T130*T210*T127*y(14)*params(13)*params(8)*y(112)-T130*T210*T127*y(14)*params(13)*y(9)*params(8)*y(112)*T127*params(3)*y(15))/(T145*T145);
  g1(70,11)=(-(y(112)*T1913))-y(113)*T210*params(13)*y(9)*y(15)*params(8)/(y(9)*T127)+T210*params(13)*y(9)*params(8)*y(113)*T1902/T132+T210*T127*y(14)*params(13)*y(9)*params(8)*y(112)*T1902/T145;
  g1(70,13)=T210*y(110)/(y(48)-y(14));
  g1(70,14)=T210*y(13)*y(110)/T2043-y(112)*T2080-y(113)*T2085-y(128)/(T127*T127)+T210*params(13)*y(9)*params(8)*y(113)*T2047/T132+(T145*(T210*T127*y(14)*params(13)*y(9)*params(8)*y(112)*T2047+T130*T210*((-(y(14)*params(13)*y(9)*params(8)*y(112)))+T127*params(13)*y(9)*params(8)*y(112)))-T130*T210*T127*y(14)*params(13)*y(9)*params(8)*y(112)*(-(params(3)*y(15)*y(9))))/(T145*T145);
  g1(70,15)=(-(y(112)*T2345))-y(113)*T210*(y(11)-y(8))*params(13)*params(8)*y(9)/(y(9)*T127)+T210*params(13)*y(9)*params(8)*y(113)*T2311/T132+(T145*T210*T127*y(14)*params(13)*y(9)*params(8)*y(112)*T2311-T127*T132*T130*T210*T127*y(14)*params(13)*y(9)*params(8)*y(112))/(T145*T145);
  g1(70,32)=y(13)*y(110)/(y(48)-y(14))-y(112)*T3020-y(113)*(y(11)-y(8))*params(13)*y(9)*y(15)*params(8)/(y(9)*T127)+T130*params(13)*y(9)*params(8)*y(113)/T132+T130*T127*y(14)*params(13)*y(9)*params(8)*y(112)/T145;
  g1(70,48)=(-(T210*y(13)*y(110)))/T2043;
  g1(70,95)=(-params(3));
  g1(70,110)=y(13)*T210/(y(48)-y(14));
  g1(70,112)=(-T228)+T130*T210*T127*y(14)*params(13)*params(8)*y(9)/T145;
  g1(70,113)=(-T235)+T130*T210*params(13)*params(8)*y(9)/T132;
  g1(70,128)=(-T2391);
  g1(71,8)=(-((y(33)-1)*(-(params(13)*y(43)*y(111)))/(y(48)-y(45))));
  g1(71,11)=(-((y(33)-1)*params(13)*y(43)*y(111)/(y(48)-y(45))));
  g1(71,33)=(-((y(11)-y(8))*params(13)*y(43)*y(111)/(y(48)-y(45))));
  g1(71,43)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(111)/(y(48)-y(45))));
  g1(71,45)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(111)/T3326));
  g1(71,48)=(-((-((y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(111)))/T3326));
  g1(71,95)=1;
  g1(71,111)=(-((y(33)-1)*(y(11)-y(8))*y(43)*params(13)/(y(48)-y(45))));
  g1(72,125)=(-1);
  g1(72,126)=1;
  g1(73,9)=(-(y(124)*T1614))+y(124)*T1623/params(3);
  g1(73,17)=y(123)*T2543-y(124)*T2561+y(124)*T2572/params(3)+params(3)*y(124)*T2580;
  g1(73,18)=(-(y(124)*T2612))+y(124)*params(10)*y(9)*y(49)*T287/(y(9)*T292)/params(3)+params(3)*y(124)*params(10)*T287/T292;
  g1(73,36)=y(123)*T3178;
  g1(73,49)=(-(y(124)*y(18)*params(10)*y(9)*T292/T299))+y(124)*y(18)*params(10)*y(9)*T287/(y(9)*T292)/params(3);
  g1(73,96)=(-params(3));
  g1(73,123)=T279;
  g1(73,124)=(-T301)+T314/params(3)+params(3)*T326;
  g1(73,125)=(-1);
  g1(74,17)=(-((params(10)*T287*y(123)*T2534+T271*params(10)*2*y(17)*y(123))/T336));
  g1(74,36)=(-((T336*params(10)*T287*y(123)*T3170-T271*params(10)*T287*y(123)*2*y(36))/(T336*T336)));
  g1(74,96)=1;
  g1(74,123)=(-(T271*params(10)*T287/T336));
  g1(75,122)=(-1);
  g1(75,123)=1;
  g1(76,9)=(-((params(3)*y(9)*T343*y(129)-y(9)*y(129)*params(3)*T343)/(params(3)*y(9)*T343*params(3)*y(9)*T343)));
  g1(76,24)=y(121)*T2806-y(120)*T2819-params(3)*y(121)*T2841+params(3)*y(120)*T2856-params(16)*y(119)*T2859/T401-(-(y(9)*y(129)*params(3)*y(9)*2*y(24)))/(params(3)*y(9)*T343*params(3)*y(9)*T343);
  g1(76,37)=(-((T401*params(16)*y(119)*T3201-params(20)*T403*params(16)*y(119))/(T401*T401)));
  g1(76,91)=(-1);
  g1(76,97)=(-params(3));
  g1(76,119)=(-(params(16)*T403/T401));
  g1(76,120)=(-T374)+params(3)*T395;
  g1(76,121)=T359-params(3)*T387;
  g1(76,129)=(-(y(9)/(params(3)*y(9)*T343)));
  g1(77,24)=(params(16)*y(24)*params(20)*y(119)*T2859+T403*params(16)*params(20)*y(119))/T418;
  g1(77,37)=(T418*params(16)*y(24)*params(20)*y(119)*T3201-T403*params(16)*y(24)*params(20)*y(119)*params(20)*2*T401)/(T418*T418);
  g1(77,97)=1;
  g1(77,119)=params(16)*y(24)*params(20)*T403/T418;
  g1(78,92)=1;
  g1(79,98)=(-params(3));
  g1(79,114)=1;
  g1(79,122)=1;
  g1(80,6)=y(28)*params(4)*y(117)/T451;
  g1(80,10)=(-(exp(y(47))*T437*params(4)*y(115)*T1875));
  g1(80,18)=(-(y(38)^2*y(6)*y(28)*params(4)*y(117)))/(T451*T451);
  g1(80,28)=y(6)*params(4)*y(117)/T451;
  g1(80,38)=(-(exp(y(47))*T440*params(4)*y(115)*getPowerDeriv(y(38),params(4)-1,1)))+(-(y(6)*y(28)*params(4)*y(117)*y(18)*2*y(38)))/(T451*T451);
  g1(80,47)=(-(exp(y(47))*T440*T437*params(4)*y(115)));
  g1(80,98)=1;
  g1(80,115)=(-(exp(y(47))*T440*params(4)*T437));
  g1(80,117)=y(6)*y(28)*params(4)/T451;
  g1(80,122)=params(9)-1;
  g1(81,10)=(-(params(6)*getPowerDeriv(y(10),params(7),1)))+params(6)*params(7)*y(108)*getPowerDeriv(y(10),params(7)-1,1)+(-((params(4)-1)*exp(y(47))*y(38)^params(4)*y(115)*getPowerDeriv(y(10),params(4),1)))/(T473*T473);
  g1(81,38)=(params(4)-1)*exp(y(47))*y(115)*getPowerDeriv(y(38),params(4),1)/T473;
  g1(81,47)=T954;
  g1(81,99)=(-params(3));
  g1(81,108)=T466*params(6)*params(7);
  g1(81,115)=T3566;
  g1(81,116)=1;
  g1(82,128)=1;
  g1(83,7)=(-y(108));
  g1(83,8)=y(112)*T1454-y(112)*T1461/params(3)-T210*params(13)*y(9)*y(15)*params(8)*y(113)*T1417/T485+T210*params(13)*y(15)*params(8)*y(113)*T1417/T132;
  g1(83,9)=y(112)*T1647-y(112)*T1655/params(3)+(-(params(3)*y(109)))/(T132*T132)-(T485*y(109)-y(9)*y(109)*2*y(9))/(T485*T485)+(-(y(129)*params(3)*y(24)))/(params(3)*y(24)*y(9)*params(3)*y(24)*y(9))-(y(24)*T485*y(129)-y(9)*y(129)*y(24)*2*y(9))/(y(24)*T485*y(24)*T485)-(T485*T130*T210*params(13)*y(15)*params(8)*y(113)-T130*T210*params(13)*y(9)*y(15)*params(8)*y(113)*2*y(9))/(T485*T485)+(-(params(3)*T130*T210*params(13)*y(15)*params(8)*y(113)))/(T132*T132);
  g1(83,11)=y(112)*T1931-y(112)*T1936/params(3)-T210*params(13)*y(9)*y(15)*params(8)*y(113)*T1902/T485+T210*params(13)*y(15)*params(8)*y(113)*T1902/T132;
  g1(83,14)=y(112)*T2111-y(112)*T2123/params(3)-T210*params(13)*y(9)*y(15)*params(8)*y(113)*T2047/T485+T210*params(13)*y(15)*params(8)*y(113)*T2047/T132;
  g1(83,15)=y(112)*T2367-y(112)*T2379/params(3)-(T130*T210*params(13)*y(9)*params(8)*y(113)+T210*params(13)*y(9)*y(15)*params(8)*y(113)*T2311)/T485+(T130*T210*params(13)*params(8)*y(113)+T210*params(13)*y(15)*params(8)*y(113)*T2311)/T132;
  g1(83,24)=(-(T132*y(129)))/(params(3)*y(24)*y(9)*params(3)*y(24)*y(9))-(-(T485*y(9)*y(129)))/(y(24)*T485*y(24)*T485);
  g1(83,32)=y(112)*(-(T130*T127*y(14)*params(13)*y(9)*y(15)*params(8)/(T127*y(15)*T485)))-y(112)*(-(T130*T127*y(14)*params(13)*y(15)*params(8)/T219))/params(3)-T130*params(13)*y(9)*y(15)*params(8)*y(113)/T485+T130*params(13)*y(15)*params(8)*y(113)/T132;
  g1(83,107)=1;
  g1(83,108)=(-y(7));
  g1(83,109)=T3495;
  g1(83,112)=T490-T502/params(3);
  g1(83,113)=T3548;
  g1(83,129)=T3618;
  g1(84,99)=1;
  g1(85,6)=(-((-y(130))/(y(6)*y(6))));
  g1(85,14)=T210*y(15)*y(110)/T2043;
  g1(85,15)=T210*y(110)/(y(48)-y(14));
  g1(85,32)=y(15)*y(110)/(y(48)-y(14));
  g1(85,48)=(-(T210*y(15)*y(110)))/T2043;
  g1(85,103)=(-params(3));
  g1(85,110)=y(15)*T210/(y(48)-y(14));
  g1(85,111)=1;
  g1(85,130)=(-(1/y(6)));
  g1(86,130)=1;
  g1(87,8)=(y(33)-1)*params(13)*y(111)*T1425;
  g1(87,11)=(y(33)-1)*params(13)*y(111)*T1908;
  g1(87,33)=T156*params(13)*y(111);
  g1(87,35)=(y(33)-1)*params(13)*y(111)*T3147;
  g1(87,45)=(y(33)-1)*params(13)*y(111)*T3328;
  g1(87,48)=(y(33)-1)*params(13)*y(111)*T3373;
  g1(87,103)=1;
  g1(87,111)=T156*params(13)*(y(33)-1);
  g1(88,6)=(-(T561*y(118)));
  g1(88,28)=(-(y(6)*y(118)*(-((1+params(18))/params(18)))));
  g1(88,118)=(-(y(6)*T561));
  g1(88,119)=1;
  g1(89,6)=(-(params(3)*y(117)*(-(y(28)*params(4)/(y(38)*T573)))));
  g1(89,12)=y(110);
  g1(89,18)=(-(params(3)*y(117)*T2637))+(-((params(9)-1)*y(117)))/(y(18)*y(18));
  g1(89,28)=(-(params(3)*y(117)*(-(y(6)*params(4)/(y(38)*T573)))));
  g1(89,38)=(-(params(3)*y(117)*(-((-(T573*y(6)*y(28)*params(4)))/(y(38)*T573*y(38)*T573)))));
  g1(89,44)=(-(params(14)*y(111)));
  g1(89,101)=(-params(3));
  g1(89,110)=y(12);
  g1(89,111)=(-(y(44)*params(14)));
  g1(89,117)=(-(params(3)*T579))+(params(9)-1)/y(18);
  g1(89,124)=1;
  g1(90,101)=1;
  g1(91,9)=(-(y(112)*T1701))-(y(9)*T210*T598*params(13)*y(15)*params(8)*y(113)-T210*T598*params(13)*y(9)*y(15)*params(8)*y(113))/(y(9)*y(9));
  g1(91,11)=(-(y(109)*y(49)*2*(1+y(11))))/(T593*T593);
  g1(91,14)=(-(y(112)*T2146))-T210*params(13)*y(9)*y(15)*params(8)*y(113)*T2135/y(9);
  g1(91,15)=(-(y(112)*T2400))-T210*(params(13)*y(9)*y(15)*params(8)*y(113)*T2391+T598*params(13)*y(9)*params(8)*y(113))/y(9);
  g1(91,32)=(-(y(112)*T127*y(14)*params(13)*y(9)*y(15)*params(8)*T598/T219))-T598*params(13)*y(9)*y(15)*params(8)*y(113)/y(9);
  g1(91,33)=(-(T613*params(13)*y(43)*params(3)*y(111)));
  g1(91,35)=(-((y(33)-1)*params(13)*y(43)*params(3)*y(111)*1/(y(48)-y(45))));
  g1(91,43)=(-((y(33)-1)*T613*params(13)*params(3)*y(111)));
  g1(91,45)=(-((y(33)-1)*params(13)*y(43)*params(3)*y(111)*y(35)/T3326));
  g1(91,48)=(-((y(33)-1)*params(13)*y(43)*params(3)*y(111)*(-y(35))/T3326));
  g1(91,49)=(-(T592*y(109)))/(T593*T593);
  g1(91,102)=(-params(3));
  g1(91,109)=1/T593;
  g1(91,111)=(-((y(33)-1)*T613*params(13)*params(3)*y(43)));
  g1(91,112)=(-T603);
  g1(91,113)=(-(T210*params(13)*y(9)*y(15)*params(8)*T598/y(9)));
  g1(92,102)=1;
  g1(92,127)=1;
  g1(93,6)=(-((1+params(19)-y(28))*y(27)*y(118)/T625));
  g1(93,23)=(-(y(129)*y(49)*2*(1+y(23))))/(y(49)*T625*y(49)*T625)-(-((1+params(19)-y(28))*y(6)*y(27)*y(118)*2*(1+y(23))))/(T625*T625);
  g1(93,27)=(-((1+params(19)-y(28))*y(6)*y(118)/T625));
  g1(93,28)=(-((-(y(6)*y(27)*y(118)))/T625));
  g1(93,49)=(-(T625*y(129)))/(y(49)*T625*y(49)*T625);
  g1(93,100)=(-params(3));
  g1(93,118)=(-((1+params(19)-y(28))*y(6)*y(27)/T625));
  g1(93,129)=1/(y(49)*T625);
  g1(94,100)=1;
  g1(95,9)=y(112)*T1715/params(3)+(T127*T132*T210*params(13)*y(15)*y(15)*params(8)*y(113)-T210*params(13)*y(9)*y(15)*y(15)*params(8)*y(113)*params(3)*T127)/(T127*T132*T127*T132);
  g1(95,14)=y(112)*T2156/params(3)+(-(T210*params(13)*y(9)*y(15)*y(15)*params(8)*y(113)*(-T132)))/(T127*T132*T127*T132);
  g1(95,15)=y(112)*T210*y(14)*params(13)*params(8)*y(9)/(y(9)*T127)/params(3)+T210*params(13)*y(9)*(y(15)*params(8)*y(113)+y(15)*params(8)*y(113))/(T127*T132);
  g1(95,32)=y(112)*y(14)*params(13)*y(9)*y(15)*params(8)/(y(9)*T127)/params(3)+params(13)*y(9)*y(15)*y(15)*params(8)*y(113)/(T127*T132);
  g1(95,33)=params(13)*y(43)*y(35)*y(111)/(y(48)-y(45));
  g1(95,35)=(y(33)-1)*params(13)*y(43)*y(111)/(y(48)-y(45));
  g1(95,43)=(y(33)-1)*params(13)*y(35)*y(111)/(y(48)-y(45));
  g1(95,45)=(y(33)-1)*params(13)*y(43)*y(35)*y(111)/T3326;
  g1(95,48)=(-((y(33)-1)*params(13)*y(43)*y(35)*y(111)))/T3326;
  g1(95,111)=(y(33)-1)*params(13)*y(35)*y(43)/(y(48)-y(45));
  g1(95,112)=T642/params(3);
  g1(95,113)=T210*params(13)*y(9)*y(15)*y(15)*params(8)/(T127*T132);
  g1(95,117)=1;
  g1(95,127)=(-1);
  g1(96,18)=y(110);
  g1(96,104)=(-params(3));
  g1(96,110)=y(18);
  g1(96,114)=(-1);
  g1(97,6)=(params(4)-1)*y(116)/y(7)-y(118)*(y(26)-(1+params(18))*(y(25)-1)/params(18))-params(4)*y(117)/(y(38)*y(18))-y(27)*y(118)/T202;
  g1(97,7)=(-((params(4)-1)*y(6)*y(116)))/(y(7)*y(7));
  g1(97,18)=(-((-(y(38)*y(6)*params(4)*y(117)))/(y(38)*y(18)*y(38)*y(18))));
  g1(97,23)=(-((-(params(3)*y(6)*y(27)*y(118)))/(T202*T202)));
  g1(97,25)=(-(y(118)*(-(y(6)*(1+params(18))/params(18)))));
  g1(97,26)=(-(y(6)*y(118)));
  g1(97,27)=(-(y(6)*y(118)/T202));
  g1(97,38)=(-((-(y(18)*y(6)*params(4)*y(117)))/(y(38)*y(18)*y(38)*y(18))));
  g1(97,116)=y(6)*(params(4)-1)/y(7);
  g1(97,117)=T3004;
  g1(97,118)=(-T676)-y(6)*y(27)/T202;
  g1(98,18)=(-(params(14)*y(111)));
  g1(98,104)=1;
  g1(98,111)=(-(y(18)*params(14)));
  g1(99,21)=(-(2*params(21)));
  g1(99,127)=1;
  g1(100,8)=y(112)*T1475/params(3)-y(112)*T1481-T210*(-(params(13)*y(9)*y(15)*y(15)*params(8)*y(113)))/(y(9)*T694);
  g1(100,9)=y(112)*T1740/params(3)-y(112)*T1754-(y(9)*T694*T210*(y(11)-y(8))*params(13)*y(15)*y(15)*params(8)*y(113)-T694*T210*(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)*y(113))/(y(9)*T694*y(9)*T694);
  g1(100,11)=y(112)*T1956/params(3)-y(112)*T1962-T210*params(13)*y(9)*y(15)*y(15)*params(8)*y(113)/(y(9)*T694);
  g1(100,13)=T210*y(15)*y(110)/T715;
  g1(100,14)=y(112)*T2178/params(3)-y(112)*T2195-(-(y(15)*y(128)*(-(2*T127))))/(T694*T694)+(-(T210*y(13)*y(15)*y(110)*(-(2*(y(48)-y(14))))))/(T715*T715)-(-(T210*(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)*y(113)*y(9)*(-(2*T127))))/(y(9)*T694*y(9)*T694);
  g1(100,15)=y(112)*T2432/params(3)-y(112)*T2443-y(128)/T694+T210*y(13)*y(110)/T715-T210*(y(11)-y(8))*params(13)*y(9)*(y(15)*params(8)*y(113)+y(15)*params(8)*y(113))/(y(9)*T694);
  g1(100,32)=y(112)*T3056/params(3)-y(112)*T3062+y(13)*y(15)*y(110)/T715-(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)*y(113)/(y(9)*T694);
  g1(100,48)=(-(T210*y(13)*y(15)*y(110)*2*(y(48)-y(14))))/(T715*T715);
  g1(100,105)=(-params(3));
  g1(100,110)=T210*y(15)*y(13)/T715;
  g1(100,112)=T697/params(3)-T705;
  g1(100,113)=(-(T210*(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)/(y(9)*T694)));
  g1(100,128)=(-(y(15)/T694));
  g1(101,8)=(-((y(33)-1)*(-(params(13)*y(43)*y(35)*y(111)))/T726));
  g1(101,11)=(-((y(33)-1)*params(13)*y(43)*y(35)*y(111)/T726));
  g1(101,33)=(-((y(11)-y(8))*params(13)*y(43)*y(35)*y(111)/T726));
  g1(101,35)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(111)/T726));
  g1(101,43)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(35)*y(111)/T726));
  g1(101,45)=(-((-((y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(35)*y(111)*(-(2*(y(48)-y(45))))))/(T726*T726)));
  g1(101,48)=(-((-((y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(35)*y(111)*2*(y(48)-y(45))))/(T726*T726)));
  g1(101,105)=1;
  g1(101,111)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(35)*y(43)/T726));
  g1(102,6)=(-((params(4)-1)*y(28)*y(116)/T735));
  g1(102,7)=(-((-((params(4)-1)*y(6)*y(28)*y(116)*2*y(7)))/(T735*T735)));
  g1(102,9)=(-y(108));
  g1(102,28)=(-((params(4)-1)*y(6)*y(116)/T735));
  g1(102,108)=(-y(9));
  g1(102,116)=(-((params(4)-1)*y(6)*y(28)/T735));
  g1(103,6)=(-(y(13)*y(130)*2*y(6)))/(T752*T752);
  g1(103,7)=(-((params(4)-1)*y(28)*y(116)))/(y(7)*y(7));
  g1(103,13)=y(130)/T752;
  g1(103,18)=(-((-(y(38)*y(28)*params(4)*y(117)))/(y(38)*y(18)*y(38)*y(18))));
  g1(103,23)=(-(params(3)*(1+params(19)-y(28))*y(27)*y(118)))/(T202*T202);
  g1(103,25)=y(118)*(-T561);
  g1(103,26)=(1+params(19)-y(28))*y(118);
  g1(103,27)=(1+params(19)-y(28))*y(118)/T202;
  g1(103,28)=(params(4)-1)*y(116)/y(7)+y(118)*((-y(26))-(y(25)-1)*(-((1+params(18))/params(18))))-params(4)*y(117)/(y(38)*y(18))+(-(y(27)*y(118)))/T202;
  g1(103,38)=(-((-(y(18)*y(28)*params(4)*y(117)))/(y(38)*y(18)*y(38)*y(18))));
  g1(103,106)=(-params(3));
  g1(103,115)=1;
  g1(103,116)=y(28)*(params(4)-1)/y(7);
  g1(103,117)=T1382;
  g1(103,118)=T3593;
  g1(103,125)=1;
  g1(103,126)=(-params(11));
  g1(103,130)=y(13)/T752;
  g1(104,106)=1;
  g1(105,9)=1;
  g1(105,19)=(-((-1)/((y(19)-y(34)*params(5)+y(50))*(y(19)-y(34)*params(5)+y(50)))-(-(params(5)*y(49)*(1-params(5))))/((y(50)+y(19)-y(19)*params(5))*(y(50)+y(19)-y(19)*params(5)))));
  g1(105,34)=(-(params(5)/((y(19)-y(34)*params(5)+y(50))*(y(19)-y(34)*params(5)+y(50)))));
  g1(105,49)=params(5)/(y(50)+y(19)-y(19)*params(5));
  g1(105,50)=(-((-1)/((y(19)-y(34)*params(5)+y(50))*(y(19)-y(34)*params(5)+y(50)))-(-(params(5)*y(49)))/((y(50)+y(19)-y(19)*params(5))*(y(50)+y(19)-y(19)*params(5)))));
  g1(106,7)=(-y(9));
  g1(106,9)=(-y(7));
  g1(106,10)=params(6)*getPowerDeriv(y(10),params(7),1);
  g1(107,11)=(-((-y(49))/(y(49)*(1+y(11))*y(49)*(1+y(11)))));
  g1(107,49)=(-((-(1+y(11)))/(y(49)*(1+y(11))*y(49)*(1+y(11)))));
  g1(108,12)=y(18);
  g1(108,13)=(-(y(15)/(y(48)-y(14))*(1-y(32))));
  g1(108,14)=(-((1-y(32))*y(13)*y(15)/T2043));
  g1(108,15)=(-((1-y(32))*y(13)*1/(y(48)-y(14))));
  g1(108,18)=y(12);
  g1(108,32)=y(13)*y(15)/(y(48)-y(14));
  g1(108,48)=(-((1-y(32))*y(13)*(-y(15))/T2043));
  g1(109,8)=(-((1-y(33))*y(43)*params(13)*y(35)/(y(48)-y(45))));
  g1(109,11)=(-((1-y(33))*y(43)*params(13)*(1+(-y(35))/(y(48)-y(45)))));
  g1(109,13)=1;
  g1(109,18)=(-(y(44)*params(14)));
  g1(109,33)=y(43)*params(13)*(y(11)+1+y(35)*(y(8)-y(11))/(y(48)-y(45)));
  g1(109,35)=(-((1-y(33))*y(43)*params(13)*(y(8)-y(11))/(y(48)-y(45))));
  g1(109,43)=(-(params(13)*(y(11)+1+y(35)*(y(8)-y(11))/(y(48)-y(45)))*(1-y(33))));
  g1(109,44)=(-(y(18)*params(14)));
  g1(109,45)=(-((1-y(33))*y(43)*params(13)*y(35)*(y(8)-y(11))/T3326));
  g1(109,48)=(-((1-y(33))*y(43)*params(13)*(-(y(35)*(y(8)-y(11))))/T3326));
  g1(110,8)=(-(T1189+y(14)*(1-y(32))*T597*T1193));
  g1(110,11)=(-((-T1189)+y(14)*(1-y(32))*T1193*(1+(-y(15))/T127)));
  g1(110,14)=1-(T1199+y(14)*(1-y(32))*T1193*y(15)*(y(8)-y(11))/(T127*T127));
  g1(110,15)=(-(y(14)*(1-y(32))*T1193*(y(8)-y(11))/T127));
  g1(110,32)=(-(y(14)*(-(T1193*(y(11)+1+y(15)*(y(8)-y(11))/T127)))));
  g1(111,8)=(-(y(15)*(1-y(32))*T597*T1193));
  g1(111,11)=(-(y(15)*(1-y(32))*T1193*(1+(-y(15))/T127)));
  g1(111,14)=(-(y(15)*(1-y(32))*T1193*y(15)*(y(8)-y(11))/(T127*T127)));
  g1(111,15)=1-(T1199+y(15)*(1-y(32))*T1193*(y(8)-y(11))/T127);
  g1(111,32)=(-(y(15)*(-(T1193*(y(11)+1+y(15)*(y(8)-y(11))/T127)))));
  g1(112,5)=1;
  g1(112,12)=(-1);
  g1(113,6)=1;
  g1(113,10)=(-(T1207*T1875));
  g1(113,38)=(-(T440*exp(y(47))*getPowerDeriv(y(38),params(4),1)));
  g1(113,47)=(-(T440*T1207));
  g1(114,6)=(-(y(28)*(1-params(4))/y(7)));
  g1(114,7)=(-((-(y(6)*y(28)*(1-params(4))))/(y(7)*y(7))));
  g1(114,10)=1;
  g1(114,28)=(-(y(6)*(1-params(4))/y(7)));
  g1(115,6)=T1382;
  g1(115,8)=1;
  g1(115,18)=(-((-(y(38)*y(6)*y(28)*params(4)))/(y(38)*y(18)*y(38)*y(18))));
  g1(115,28)=T3004;
  g1(115,38)=(-((-(y(18)*y(6)*y(28)*params(4)))/(y(38)*y(18)*y(38)*y(18))));
  g1(116,6)=(-(T1225-y(26)*(1+params(19)-y(28))-y(27)*(1+params(19)-y(28))*1/(1+y(23))));
  g1(116,23)=y(27)*y(6)*(1+params(19)-y(28))*(-1)/((1+y(23))*(1+y(23)));
  g1(116,25)=(-(y(6)*(-T1223)));
  g1(116,26)=y(6)*(1+params(19)-y(28));
  g1(116,27)=y(6)*(1+params(19)-y(28))*1/(1+y(23));
  g1(116,28)=(-(y(6)*(1-y(25))*(1+params(18))/params(18)-y(26)*(-y(6))-y(27)*y(6)*(-(1/(1+y(23))))));
  g1(117,24)=(-(params(16)/2*1/(y(37)*params(20)+params(51)*(1-params(20)))*2*(y(24)/(y(37)*params(20)+params(51)*(1-params(20)))-1)));
  g1(117,25)=1;
  g1(117,37)=(-(params(16)/2*2*(y(24)/(y(37)*params(20)+params(51)*(1-params(20)))-1)*(-(y(24)*params(20)))/((y(37)*params(20)+params(51)*(1-params(20)))*(y(37)*params(20)+params(51)*(1-params(20))))));
  g1(118,24)=(-(((y(24)*params(20)+params(51)*(1-params(20)))*(params(16)*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)+y(24)*params(16)*T2914)-params(20)*y(24)*params(16)*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1))/((y(24)*params(20)+params(51)*(1-params(20)))*(y(24)*params(20)+params(51)*(1-params(20))))));
  g1(118,26)=1;
  g1(119,24)=(-(((y(24)*params(20)+params(51)*(1-params(20)))*(2*y(24)*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)*(-params(16))+T343*(-params(16))*T2914)-params(20)*T343*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)*(-params(16)))/((y(24)*params(20)+params(51)*(1-params(20)))*(y(24)*params(20)+params(51)*(1-params(20))))));
  g1(119,27)=1;
  g1(120,5)=1;
  g1(120,16)=(-1);
  g1(120,38)=(-(1-params(9)));
  g1(121,16)=1;
  g1(121,17)=(-(T1264+y(17)*(-(params(10)/2*T2534*2*T271))));
  g1(121,36)=(-(y(17)*(-(params(10)/2*2*T271*T3170))));
  g1(122,18)=1;
  g1(123,6)=1;
  g1(123,17)=(-1);
  g1(123,19)=(-1);
  g1(123,20)=(-1);
  g1(124,6)=(-params(11));
  g1(124,20)=1;
  g1(125,8)=(-1);
  g1(125,21)=1;
  g1(125,42)=1;
  g1(126,14)=(-T2135);
  g1(126,15)=(-T2391);
  g1(126,22)=1;
  g1(127,23)=(-((-y(49))/(y(49)*(1+y(23))*y(49)*(1+y(23)))));
  g1(127,24)=(-1)/(y(24)*y(24));
  g1(127,49)=(-((-(1+y(23)))/(y(49)*(1+y(23))*y(49)*(1+y(23)))));
  g1(128,6)=(-((-y(13))/(y(6)*y(6))));
  g1(128,13)=(-(1/y(6)));
  g1(128,29)=1;
  g1(129,48)=1-params(32);
  g1(130,49)=1-params(36);
  g1(131,50)=1-params(38);
  g1(132,47)=1-params(30);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],132,17424);
end
end
