// Endogenous variables
var 
k, y, w, rs, lambdac, l, r, s, n, v, eta, in, ig, q, c, gc, spread, 
l2n, rmon, infl, phi, dphidp, dphidlp, sigma, n2y, Util1, Util2, bt;
//Util_nobias, Welf_nobias; 

// Exogenous variables      
var 
z, lambda, betavar, cpref;

varexo 
errz, errmon, errlambda, errbt, errbetavar, errcpref;

parameters 
alphap, gammap, chi0p, chip, betap, deltap,
psip,  omegagyp, lambdap, thetap, baromegap, 
s2n, phip, spreadp, nup, taup, indexp, 
xip, blife, 
rs_rslp, rs_inflp, rs_yp, bt_btlp, bt_sp,
rhozp, sigmazp, rholambdap, sigmalambdap,
rhobtp, sigmabtp, rhobetavarp, sigmabetavarp,
rhocprefp, sigmacprefp,
l_ss, q_ss, r_ss, y_ss, w_ss, k_ss, s_ss, n_ss, 
in_ss, ig_ss, gc_ss, infl_ss;

model;

/////////////////
// Policy bloc
/////////////////

// Utility, agent 1 
Util1 = (log(c-gammap*c(-1)+cpref)-chi0p*l^(chip+1)/(chip+1));

// Utility, agent 2
Util2 = (log(c-gammap*c(-1)+cpref)-chi0p*l^(chip+1)/(chip+1));

// Policy Rule, agent 1
rmon = r_ss +  rs_rslp *(rmon(-1) - (- 1 + infl_ss/betap ) ) 
	        +  (1-rs_rslp)*rs_inflp * (infl - infl_ss)
	        +  (1-rs_rslp)*rs_yp * (log(y)- log(y(-1)))+errmon;

// Policy Rule, agent 2
bt = bt_btlp*bt(-1) + bt_sp*(s-s(-1))+ errbt;

// Household preferences
//Util_nobias = (log(c-gammap*c(-1)+cpref)-chi0p*l^(chip+1)/(chip+1));

// Welfare of households
//Welf_nobias = Util_nobias + betap*Welf_nobias(1);


/////////////////////////
// Structural equations
/////////////////////////

// choice of optimal consumption
lambdac = 1/(c-gammap*c(-1)+cpref)-betavar*gammap/(c(1)-gammap*c+cpref(1));

// choice of optimal labor supply
chi0p*l^chip = lambdac*w;

// choice of optimal deposit holdings
lambdac(1)/lambdac = 1/(betavar*(1+r));

// leverage constraint
q*s = eta/(lambda-v)*n*(1-bt);

// evolution of bank equity
n = thetap *((rs-r(-1))*eta(-1)/(lambda(-1)-v(-1))+1+r(-1))*n(-1)*(1-bt(-1)) + baromegap*q*s(-1);

// marginal value of loans
v = (1-thetap)*betap*lambdac(1)/lambdac*(rs(1)-r)+thetap*betap*lambdac(1)/lambdac*( (eta(1)/(lambdap-v(1))) / (eta/(lambdap-v))*((rs(1)-r)*eta/(lambdap-v)+1+r))*(1-bt(1))*v(1);

// marginal value of equity
eta = (1-thetap)+thetap*betap*lambdac(1)/lambdac*((rs(1)-r)*eta/(lambdap-v)+1+r)*(1-bt(1))*eta(1);

// equity financing for capital (next period)
k = s;

// production function
y = exp(z)*k(-1)^alphap*l^(1-alphap);

// choice of optimal labor input
l = (1-alphap)*sigma*y/w;

// zero profit condition
1+rs = alphap*sigma*y/(q(-1)*k(-1))+(1-deltap)*q/q(-1);

// first order condition with respect to prices
0 = (-(1+taup)/nup + sigma*(1 + nup)/nup)*(1-phi)*y
    - ((1 + taup) - sigma)*y*dphidp
    - (1/(1+rmon))*((1+taup) - sigma(1))*y(1)*dphidlp(1);

// price adjustment costs and its derivatives
phi = (phip/2)*(infl/(indexp*infl(-1)+(1-indexp)*infl_ss) - 1)^2;
dphidp = phip*(infl/(indexp*infl(-1)+(1-indexp)*infl_ss) - 1)*infl/(indexp*infl(-1)+(1-indexp)*infl_ss);
dphidlp = -phip*(infl/(indexp*infl(-1)+(1-indexp)*infl_ss) - 1)*infl^2/(indexp*infl(-1)+(1-indexp)*infl_ss);

// evolution of physical capital
k = in+(1-deltap)*k(-1);

// investment adjustment costs
in = (1-psip/2*(ig/ig(-1)-1)^2)*ig;

// price of capital from optimal investment choice
q*(1-psip/2*(ig/ig(-1)-1)^2)-q*psip*(ig/ig(-1)-1)*ig/ig(-1)+betavar*lambdac(1)/lambdac*q(1)*psip*(ig(1)/ig-1)*ig(1)^2/ig^2 = 1;

// aggregate resource constraint
y = c+ig+gc;

// government spending
gc = omegagyp*y;

// loan spread
spread = rs - r(-1);

// ratio of loans to equity (pre-bt shock)
l2n = eta/(lambdap-v);

// risk-free interest rate
lambdac(1)/lambdac/infl(1) = 1/(betavar*(1+rmon));

// net worth to output ratio
n2y = n/y;

/////////////////////////
// exogenous variables
/////////////////////////

// shock process for lambda 
lambda - lambdap = rholambdap*(lambda(-1) - lambdap) + sigmalambdap*errlambda;

// shock to beta
betavar - betap = rhobetavarp*(betavar(-1)-betap)+sigmabetavarp*errbetavar;

// consumption preference shock
cpref = rhocprefp*cpref(-1) + sigmacprefp*errcpref;

// shock to technology
z = rhozp*z(-1)+sigmazp*errz;

end;


shocks;
  var errlambda; stderr 0;
  var errbetavar; stderr 0;
  var errcpref; stderr 0;
  var errz; stderr 0.015;
end;

//stoch_simul(order=2,nocorr,irf=0, pruning,periods=10000); 
stoch_simul(order=2,nocorr,irf=0,noprint); 
