function [residual, g1, g2] = rbcb_monprud_ramsey_infl_bt_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                    columns: equations in order of declaration
%                                                    rows: variables in declaration order
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: equations in order of declaration
%                                                       rows: variables in declaration order
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 94, 1);

%
% Model equations
%

T88 = log(y(19)-y(34)*params(5)+y(50))-params(6)*y(10)^(1+params(7))/(1+params(7));
T127 = params(12)-y(14);
T130 = 1+y(11)-y(15)*(y(11)-y(8))/T127;
T143 = T127*params(3)*y(15)*y(9);
T154 = 1+y(11)-y(35)*(y(11)-y(8))/(y(48)-y(45));
T161 = (y(19)+y(50)-y(34)*params(5))^2;
T165 = y(49)*params(5)^2;
T168 = (y(19)+y(50)-y(19)*params(5))^2;
T170 = 1/T161+T165/T168;
T216 = y(32)-1;
T222 = T216*(y(11)-y(8))*y(14)*y(15)*params(8)*y(9)*params(13);
T223 = T127*y(15)*y(9);
T227 = T130*T216*T127*y(14)*y(15)*params(8)*y(9)*params(13);
T230 = T127*y(9)*y(15)^2;
T232 = T222/T223+T227/T230;
T239 = T216*(y(11)-y(8))*y(15)*params(8)*y(9)*params(13)/(y(9)*T127)-1;
T276 = y(17)/y(36)-1;
T277 = T276^2;
T284 = params(10)*T277/2+T276*y(17)*params(10)/y(36)-1;
T292 = y(17)^2;
T297 = y(17)^3;
T304 = y(9)*y(17)^4;
T306 = y(18)*y(17)*params(10)/T292+y(18)*params(10)*y(9)*y(49)*T297/T304;
T341 = y(36)^2;
T348 = y(24)^2;
T355 = y(24)*params(20)-params(51)*(params(20)-1);
T356 = T355^2;
T361 = y(24)/T355-1;
T364 = T348*params(16)/T356+params(16)*2*y(24)*T361/T355;
T375 = y(24)*params(16)/T356+params(16)*T361/T355;
T387 = T355^3;
T393 = params(16)*params(20)*y(24)^3/T387+T361*params(16)*T348*params(20)/T356;
T401 = params(16)*T348*params(20)/T387+T361*params(16)*y(24)*params(20)/T356;
T409 = y(24)/(y(37)*params(20)-params(51)*(params(20)-1))-1;
T423 = (y(37)*params(20)-params(51)*(params(20)-1))^2;
T444 = y(10)^(1-params(4));
T457 = y(18)*y(38)^2;
T466 = params(6)*y(10)^params(7);
T482 = y(10)^params(4);
T483 = (params(4)-1)*exp(y(47))*y(77)*y(38)^params(4)/T482;
T493 = y(9)^2;
T498 = (y(11)-y(8))*params(8)*y(9)*(params(13)-1)/T493-T227/(T127*y(15)*T493);
T512 = T130*T216*T127*y(14)*y(15)*params(8)*params(13);
T514 = (params(13)-1)*params(8)*(y(11)-y(8))/y(9)-T512/T223;
T569 = (1+params(19))/params(18)-y(28)*(1+params(18))/params(18);
T581 = y(18)^2;
T587 = y(18)*(params(9)-1)/T581-y(6)*y(28)*params(4)/(y(38)*T581);
T601 = y(49)*(1+y(11))^2;
T605 = y(15)/T127;
T606 = T605-1;
T609 = T216*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T606;
T611 = params(8)*y(9)*(params(13)-1)/y(9)+T609/T223;
T633 = (1+y(23))^2;
T648 = T216*y(14)*y(15)*params(8)*y(9)*params(13);
T650 = params(8)*y(9)*(params(13)-1)/y(9)+T648/(y(9)*T127);
T713 = T127^2;
T716 = T130*T216*T127*y(15)*params(8)*y(9)*params(13)/T223+T227/(y(15)*y(9)*T713);
T724 = T130*T648/T223+T222/(T127*y(9)*T127)-1;
T734 = (y(48)-y(14))^2;
T745 = (y(48)-y(45))^2;
T754 = y(7)^2;
T771 = y(6)^2;
T817 = y(9)*params(8)*(1-params(13))/y(9);
T821 = y(9)*params(8)*params(13)/y(9);
T827 = (1-y(32))*T821*(y(11)+1+y(15)*(y(8)-y(11))/T127);
T835 = exp(y(47))*y(38)^params(4);
T851 = y(28)*(1+params(18))/params(18)+(-(1+params(19)))/params(18);
T853 = T851*(1-y(25));
T1012 = (-((-y(15))/T127));
T1324 = params(6)*getPowerDeriv(y(10),1+params(7),1)/(1+params(7));
T1332 = params(6)*getPowerDeriv(y(10),params(7),1);
T1348 = 1-T605;
T1447 = (-(y(15)*(y(11)-y(8))/(T127*T127)));
T1474 = T216*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T1447+T130*T216*(T127*y(15)*params(8)*y(9)*params(13)+(-(y(14)*y(15)*params(8)*y(9)*params(13))));
T1631 = (-((y(11)-y(8))/T127));
T1657 = T216*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T1631+T130*T216*T127*y(14)*params(13)*params(8)*y(9);
T1899 = (-(1/(y(19)-y(34)*params(5)+y(50))));
T1914 = (y(19)+y(50)-y(34)*params(5))*(y(19)+y(50)-y(34)*params(5));
T1934 = (-(params(5)*y(67)))/T1914+(-(params(5)*y(68)))/T1914-(-(params(5)*y(69)*2*(y(19)+y(50)-y(34)*params(5))))/(T161*T161);
T1991 = (T355-y(24)*params(20))/(T355*T355);
T2082 = (y(24)*params(20)+params(51)*(1-params(20))-y(24)*params(20))/((y(24)*params(20)+params(51)*(1-params(20)))*(y(24)*params(20)+params(51)*(1-params(20))));
T2295 = (-(y(24)*params(20)))/((y(37)*params(20)-params(51)*(params(20)-1))*(y(37)*params(20)-params(51)*(params(20)-1)));
lhs =y(1);
rhs =params(1)*y(30)+params(2)*y(31);
residual(1)= lhs-rhs;
lhs =y(2);
rhs =y(1)+y(2)*params(3);
residual(2)= lhs-rhs;
lhs =y(93);
rhs =y(30)+params(3)*y(93);
residual(3)= lhs-rhs;
lhs =y(94);
rhs =y(31)+params(3)*y(94);
residual(4)= lhs-rhs;
lhs =y(3);
rhs =y(24);
residual(5)= lhs-rhs;
lhs =y(4);
rhs =y(32);
residual(6)= lhs-rhs;
lhs =y(33);
rhs =y(32);
residual(7)= lhs-rhs;
lhs =y(34);
rhs =y(19);
residual(8)= lhs-rhs;
lhs =y(35);
rhs =y(15);
residual(9)= lhs-rhs;
lhs =y(36);
rhs =y(17);
residual(10)= lhs-rhs;
lhs =y(37);
rhs =y(24);
residual(11)= lhs-rhs;
lhs =y(38);
rhs =y(5);
residual(12)= lhs-rhs;
lhs =y(39);
rhs =y(10);
residual(13)= lhs-rhs;
lhs =y(40);
rhs =y(23);
residual(14)= lhs-rhs;
lhs =y(41);
rhs =y(18);
residual(15)= lhs-rhs;
lhs =y(42);
rhs =y(11);
residual(16)= lhs-rhs;
lhs =y(43);
rhs =y(13);
residual(17)= lhs-rhs;
lhs =y(44);
rhs =y(12);
residual(18)= lhs-rhs;
lhs =y(45);
rhs =y(14);
residual(19)= lhs-rhs;
lhs =y(46);
rhs =y(6);
residual(20)= lhs-rhs;
lhs =y(30);
rhs =T88-params(22)*(y(24)-params(51))^2;
residual(21)= lhs-rhs;
lhs =y(31);
rhs =T88-params(21)*(y(21)-params(17))^2;
residual(22)= lhs-rhs;
residual(23) = y(13)*y(15)*y(72)/(y(48)-y(14))-params(3)*y(53)-y(52)+y(15)*params(8)*y(9)*y(75)*params(13)*T130/(params(3)*y(9))+T130*T127*y(14)*params(13)*y(15)*params(8)*y(9)*y(74)/T143;
residual(24) = y(53)+params(13)*y(43)*y(73)*T154;
residual(25) = y(69)*T170-y(87)-params(3)*y(54)-y(67)/(y(19)+y(50)-y(34)*params(5))-y(68)/(y(19)+y(50)-y(34)*params(5))-y(69)*params(5)*y(49)/(params(3)*T168);
residual(26) = y(54)+params(5)*y(67)/(y(19)+y(50)-y(34)*params(5))+params(5)*y(68)/(y(19)+y(50)-y(34)*params(5))-params(5)*y(69)/T161;
residual(27) = y(83)+y(6)*y(80)*(1+params(19)-y(28))/(params(3)*(1+y(23)));
residual(28) = y(6)*y(80)*(1+params(19)-y(28))+y(82);
residual(29) = y(13)*y(72)*T216/(y(48)-y(14))-y(74)*T232-y(75)*T239-y(90)/T127-params(3)*y(55)+T130*T216*params(13)*y(75)*params(8)*y(9)/(params(3)*y(9))+T130*T216*T127*y(14)*params(13)*y(74)*params(8)*y(9)/T143;
residual(30) = y(55)-(y(11)-y(8))*params(13)*y(43)*y(73)*(y(33)-1)/(y(48)-y(45));
residual(31) = y(88)-y(87);
residual(32) = y(85)*T284-params(3)*y(56)-y(87)-y(86)*T306+y(86)*y(18)*params(10)*y(9)*y(49)*T292/(y(9)*T297)/params(3)+params(3)*y(86)*y(18)*params(10)*T292/T297;
residual(33) = y(56)-T276*params(10)*y(85)*T292/T341;
residual(34) = y(85)-y(84);
residual(35) = y(83)*T364-params(3)*y(57)-y(51)-y(82)*T375+params(22)*y(67)*(2*y(24)-2*params(51))-params(3)*y(83)*T393+params(3)*y(82)*T401-params(16)*y(81)*T409/(y(37)*params(20)-params(51)*(params(20)-1))-y(9)*y(91)/(params(3)*y(9)*T348);
residual(36) = y(57)+T409*params(16)*y(24)*params(20)*y(81)/T423;
residual(37) = y(51);
residual(38) = y(52);
residual(39) = y(84)+y(76)-params(3)*y(58);
residual(40) = y(58)+y(84)*(params(9)-1)-params(4)*y(38)^(params(4)-1)*T444*y(77)*exp(y(47))+y(6)*y(28)*params(4)*y(79)/T457;
residual(41) = y(78)-params(3)*y(59)+y(67)*T466+y(68)*T466+params(6)*params(7)*y(10)^(params(7)-1)*y(70)+T483;
residual(42) = y(90);
residual(43) = y(69)-y(70)*y(7)+y(74)*T498-y(9)*y(71)/T493-y(74)*T514/params(3)+y(71)/(params(3)*y(9))+y(91)/(params(3)*y(24)*y(9))-y(9)*y(91)/(y(24)*T493)-T130*y(15)*params(8)*y(9)*y(75)*params(13)*T216/T493+T130*T216*params(13)*y(15)*params(8)*y(75)/(params(3)*y(9));
residual(44) = y(59);
residual(45) = y(73)-params(3)*y(63)-y(92)/y(6)+y(15)*y(72)*T216/(y(48)-y(14));
residual(46) = y(92);
residual(47) = y(63)+T154*(y(33)-1)*params(13)*y(73);
residual(48) = y(81)-y(6)*y(80)*T569;
residual(49) = y(12)*y(72)-(-y(86))-params(3)*y(61)-params(3)*y(79)*T587+(params(9)-1)*y(79)/y(18)-y(44)*y(73)*params(14);
residual(50) = y(61);
residual(51) = y(71)/T601-y(74)*T611-params(3)*y(62)-(y(33)-1)*params(13)*y(43)*params(3)*y(73)*(y(35)/(y(48)-y(45))-1)-T216*y(15)*params(8)*y(9)*y(75)*params(13)*T606/y(9);
residual(52) = y(62)+y(89);
residual(53) = y(91)/(y(49)*T633)-params(3)*y(60)-(1+params(19)-y(28))*y(6)*y(80)*y(27)/T633;
residual(54) = y(60);
residual(55) = y(79)-y(89)+y(74)*T650/params(3)+(y(33)-1)*params(13)*y(43)*y(35)*y(73)/(y(48)-y(45))+T216*params(13)*y(75)*y(9)*y(15)*y(15)*params(8)/(T127*params(3)*y(9));
residual(56) = y(18)*y(72)-params(3)*y(64)-y(76);
residual(57) = (params(4)-1)*y(6)*y(78)/y(7)-y(80)*(y(6)*y(26)-y(6)*(1+params(18))*(y(25)-1)/params(18))-y(6)*params(4)*y(79)/(y(38)*y(18))-y(6)*y(80)*y(27)/(params(3)*(1+y(23)));
residual(58) = y(64)-y(18)*y(73)*params(14);
residual(59) = y(89)+params(21)*y(68)*(2*y(21)-2*params(17));
residual(60) = params(1)+y(67);
residual(61) = params(2)+y(68);
residual(62) = y(74)*T716/params(3)-y(74)*T724-y(15)*y(90)/T713-params(3)*y(65)+y(13)*y(15)*y(72)*T216/T734-T216*(y(11)-y(8))*params(13)*y(75)*y(9)*y(15)*y(15)*params(8)/(y(9)*T713);
residual(63) = y(65)-(y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(35)*y(73)/T745;
residual(64) = y(70)*(-y(9))-(params(4)-1)*y(6)*y(28)*y(78)/T754;
residual(65) = y(87)+y(77)-params(3)*y(66)-y(88)*params(11)+y(80)*((1+params(19)-y(28))*y(26)-T569*(y(25)-1))+y(13)*y(92)/T771+(params(4)-1)*y(28)*y(78)/y(7)-y(28)*params(4)*y(79)/(y(38)*y(18))+(1+params(19)-y(28))*y(80)*y(27)/(params(3)*(1+y(23)));
residual(66) = y(66);
lhs =y(9);
rhs =1/(y(19)-y(34)*params(5)+y(50))-params(5)*y(49)/(y(50)+y(19)-y(19)*params(5));
residual(67)= lhs-rhs;
lhs =T466;
rhs =y(9)*y(7);
residual(68)= lhs-rhs;
lhs =1;
rhs =1/(y(49)*(1+y(11)));
residual(69)= lhs-rhs;
lhs =y(18)*y(12);
rhs =y(13)*y(15)/(y(48)-y(14))*(1-y(32));
residual(70)= lhs-rhs;
lhs =y(13);
rhs =y(43)*params(13)*(y(11)+1+y(35)*(y(8)-y(11))/(y(48)-y(45)))*(1-y(33))+y(44)*y(18)*params(14);
residual(71)= lhs-rhs;
lhs =y(14);
rhs =(y(8)-y(11))*T817+y(14)*T827;
residual(72)= lhs-rhs;
lhs =y(15);
rhs =1-params(13)+y(15)*T827;
residual(73)= lhs-rhs;
lhs =y(5);
rhs =y(12);
residual(74)= lhs-rhs;
lhs =y(6);
rhs =T444*T835;
residual(75)= lhs-rhs;
lhs =y(10);
rhs =y(6)*y(28)*(1-params(4))/y(7);
residual(76)= lhs-rhs;
lhs =1+y(8);
rhs =y(6)*y(28)*params(4)/(y(38)*y(18))+y(18)*(1-params(9))/y(18);
residual(77)= lhs-rhs;
lhs =0;
rhs =y(6)*T853-y(26)*y(6)*(1+params(19)-y(28))-y(27)*y(6)*(1+params(19)-y(28))*1/(1+y(23));
residual(78)= lhs-rhs;
lhs =y(25);
rhs =params(16)/2*(y(24)/(y(37)*params(20)+params(51)*(1-params(20)))-1)^2;
residual(79)= lhs-rhs;
lhs =y(26);
rhs =y(24)*params(16)*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)/(y(24)*params(20)+params(51)*(1-params(20)));
residual(80)= lhs-rhs;
lhs =y(27);
rhs =T348*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)*(-params(16))/(y(24)*params(20)+params(51)*(1-params(20)));
residual(81)= lhs-rhs;
lhs =y(5);
rhs =y(16)+y(38)*(1-params(9));
residual(82)= lhs-rhs;
lhs =y(16);
rhs =y(17)*(1-T277*params(10)/2);
residual(83)= lhs-rhs;
lhs =y(18);
rhs =1;
residual(84)= lhs-rhs;
lhs =y(6);
rhs =y(19)+y(17)+y(20);
residual(85)= lhs-rhs;
lhs =y(20);
rhs =y(6)*params(11);
residual(86)= lhs-rhs;
lhs =y(21);
rhs =y(8)-y(42);
residual(87)= lhs-rhs;
lhs =y(22);
rhs =T605;
residual(88)= lhs-rhs;
lhs =1/y(24);
rhs =1/(y(49)*(1+y(23)));
residual(89)= lhs-rhs;
lhs =y(29);
rhs =y(13)/y(6);
residual(90)= lhs-rhs;
lhs =y(48)-params(12);
rhs =(y(48)-params(12))*params(32)+params(33)*x(3);
residual(91)= lhs-rhs;
lhs =y(49)-params(8);
rhs =(y(49)-params(8))*params(36)+params(37)*x(5);
residual(92)= lhs-rhs;
lhs =y(50);
rhs =y(50)*params(38)+params(39)*x(6);
residual(93)= lhs-rhs;
lhs =y(47);
rhs =y(47)*params(30)+params(31)*x(1);
residual(94)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(94, 94);

  %
  % Jacobian matrix
  %

  g1(1,1)=1;
  g1(1,30)=(-params(1));
  g1(1,31)=(-params(2));
  g1(2,1)=(-1);
  g1(2,2)=1-params(3);
  g1(3,30)=(-1);
  g1(3,93)=1-params(3);
  g1(4,31)=(-1);
  g1(4,94)=1-params(3);
  g1(5,3)=1;
  g1(5,24)=(-1);
  g1(6,4)=1;
  g1(6,32)=(-1);
  g1(7,32)=(-1);
  g1(7,33)=1;
  g1(8,19)=(-1);
  g1(8,34)=1;
  g1(9,15)=(-1);
  g1(9,35)=1;
  g1(10,17)=(-1);
  g1(10,36)=1;
  g1(11,24)=(-1);
  g1(11,37)=1;
  g1(12,5)=(-1);
  g1(12,38)=1;
  g1(13,10)=(-1);
  g1(13,39)=1;
  g1(14,23)=(-1);
  g1(14,40)=1;
  g1(15,18)=(-1);
  g1(15,41)=1;
  g1(16,11)=(-1);
  g1(16,42)=1;
  g1(17,13)=(-1);
  g1(17,43)=1;
  g1(18,12)=(-1);
  g1(18,44)=1;
  g1(19,14)=(-1);
  g1(19,45)=1;
  g1(20,6)=(-1);
  g1(20,46)=1;
  g1(21,10)=T1324;
  g1(21,19)=T1899;
  g1(21,24)=params(22)*2*(y(24)-params(51));
  g1(21,30)=1;
  g1(21,34)=(-((-params(5))/(y(19)-y(34)*params(5)+y(50))));
  g1(21,50)=T1899;
  g1(22,10)=T1324;
  g1(22,19)=T1899;
  g1(22,21)=params(21)*2*(y(21)-params(17));
  g1(22,31)=1;
  g1(22,34)=(-((-params(5))/(y(19)-y(34)*params(5)+y(50))));
  g1(22,50)=T1899;
  g1(23,8)=y(15)*params(8)*y(9)*y(75)*params(13)*T1012/(params(3)*y(9))+T127*y(14)*params(13)*y(15)*params(8)*y(9)*y(74)*T1012/T143;
  g1(23,9)=(params(3)*y(9)*T130*params(13)*y(15)*params(8)*y(75)-params(3)*y(15)*params(8)*y(9)*y(75)*params(13)*T130)/(params(3)*y(9)*params(3)*y(9))+(T143*T130*T127*y(14)*params(13)*y(15)*params(8)*y(74)-T130*T127*y(14)*params(13)*y(15)*params(8)*y(9)*y(74)*T127*params(3)*y(15))/(T143*T143);
  g1(23,11)=y(15)*params(8)*y(9)*y(75)*params(13)*T1348/(params(3)*y(9))+T127*y(14)*params(13)*y(15)*params(8)*y(9)*y(74)*T1348/T143;
  g1(23,13)=y(15)*y(72)/(y(48)-y(14));
  g1(23,14)=y(13)*y(15)*y(72)/((y(48)-y(14))*(y(48)-y(14)))+y(15)*params(8)*y(9)*y(75)*params(13)*T1447/(params(3)*y(9))+(T143*(T127*y(14)*params(13)*y(15)*params(8)*y(9)*y(74)*T1447+T130*((-(y(14)*params(13)*y(15)*params(8)*y(9)*y(74)))+T127*params(13)*y(15)*params(8)*y(9)*y(74)))-T130*T127*y(14)*params(13)*y(15)*params(8)*y(9)*y(74)*(-(params(3)*y(15)*y(9))))/(T143*T143);
  g1(23,15)=y(13)*y(72)/(y(48)-y(14))+(T130*params(13)*y(75)*params(8)*y(9)+y(15)*params(8)*y(9)*y(75)*params(13)*T1631)/(params(3)*y(9))+(T143*(T127*y(14)*params(13)*y(15)*params(8)*y(9)*y(74)*T1631+T130*T127*y(14)*params(13)*y(74)*params(8)*y(9))-T130*T127*y(14)*params(13)*y(15)*params(8)*y(9)*y(74)*T127*params(3)*y(9))/(T143*T143);
  g1(23,48)=(-(y(13)*y(15)*y(72)))/((y(48)-y(14))*(y(48)-y(14)));
  g1(23,52)=(-1);
  g1(23,53)=(-params(3));
  g1(23,72)=y(15)*y(13)/(y(48)-y(14));
  g1(23,74)=T130*T127*y(14)*y(15)*params(8)*y(9)*params(13)/T143;
  g1(23,75)=T130*y(15)*params(8)*y(9)*params(13)/(params(3)*y(9));
  g1(24,8)=params(13)*y(43)*y(73)*(-((-y(35))/(y(48)-y(45))));
  g1(24,11)=params(13)*y(43)*y(73)*(1-y(35)/(y(48)-y(45)));
  g1(24,35)=params(13)*y(43)*y(73)*(-((y(11)-y(8))/(y(48)-y(45))));
  g1(24,43)=T154*params(13)*y(73);
  g1(24,45)=params(13)*y(43)*y(73)*(-(y(35)*(y(11)-y(8))/((y(48)-y(45))*(y(48)-y(45)))));
  g1(24,48)=params(13)*y(43)*y(73)*(-((-(y(35)*(y(11)-y(8))))/((y(48)-y(45))*(y(48)-y(45)))));
  g1(24,53)=1;
  g1(24,73)=T154*y(43)*params(13);
  g1(25,19)=y(69)*((-(2*(y(19)+y(50)-y(34)*params(5))))/(T161*T161)+(-(T165*(1-params(5))*2*(y(19)+y(50)-y(19)*params(5))))/(T168*T168))-(-y(67))/T1914-(-y(68))/T1914-(-(y(69)*params(5)*y(49)*params(3)*(1-params(5))*2*(y(19)+y(50)-y(19)*params(5))))/(params(3)*T168*params(3)*T168);
  g1(25,34)=y(69)*(-(2*(y(19)+y(50)-y(34)*params(5))*(-params(5))))/(T161*T161)-(-(y(67)*(-params(5))))/T1914-(-(y(68)*(-params(5))))/T1914;
  g1(25,49)=y(69)*params(5)^2/T168-params(5)*y(69)/(params(3)*T168);
  g1(25,50)=y(69)*((-(2*(y(19)+y(50)-y(34)*params(5))))/(T161*T161)+(-(T165*2*(y(19)+y(50)-y(19)*params(5))))/(T168*T168))-(-y(67))/T1914-(-y(68))/T1914-(-(y(69)*params(5)*y(49)*params(3)*2*(y(19)+y(50)-y(19)*params(5))))/(params(3)*T168*params(3)*T168);
  g1(25,54)=(-params(3));
  g1(25,67)=(-(1/(y(19)+y(50)-y(34)*params(5))));
  g1(25,68)=(-(1/(y(19)+y(50)-y(34)*params(5))));
  g1(25,69)=T170-params(5)*y(49)/(params(3)*T168);
  g1(25,87)=(-1);
  g1(26,19)=T1934;
  g1(26,34)=(-(params(5)*y(67)*(-params(5))))/T1914+(-(params(5)*y(68)*(-params(5))))/T1914-(-(params(5)*y(69)*2*(y(19)+y(50)-y(34)*params(5))*(-params(5))))/(T161*T161);
  g1(26,50)=T1934;
  g1(26,54)=1;
  g1(26,67)=params(5)/(y(19)+y(50)-y(34)*params(5));
  g1(26,68)=params(5)/(y(19)+y(50)-y(34)*params(5));
  g1(26,69)=(-(params(5)/T161));
  g1(27,6)=y(80)*(1+params(19)-y(28))/(params(3)*(1+y(23)));
  g1(27,23)=(-(params(3)*y(6)*y(80)*(1+params(19)-y(28))))/(params(3)*(1+y(23))*params(3)*(1+y(23)));
  g1(27,28)=(-(y(6)*y(80)))/(params(3)*(1+y(23)));
  g1(27,80)=y(6)*(1+params(19)-y(28))/(params(3)*(1+y(23)));
  g1(27,83)=1;
  g1(28,6)=y(80)*(1+params(19)-y(28));
  g1(28,28)=(-(y(6)*y(80)));
  g1(28,80)=y(6)*(1+params(19)-y(28));
  g1(28,82)=1;
  g1(29,8)=(-(y(74)*(T216*(-(y(14)*y(15)*params(8)*y(9)*params(13)))/T223+T216*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T1012/T230)))-y(75)*T216*(-(y(15)*params(8)*y(9)*params(13)))/(y(9)*T127)+T216*params(13)*y(75)*params(8)*y(9)*T1012/(params(3)*y(9))+T216*T127*y(14)*params(13)*y(74)*params(8)*y(9)*T1012/T143;
  g1(29,9)=(-(y(74)*((T223*T216*(y(11)-y(8))*y(14)*y(15)*params(8)*params(13)-T222*y(15)*T127)/(T223*T223)+(T230*T512-T227*T127*y(15)^2)/(T230*T230))))-y(75)*(y(9)*T127*T216*(y(11)-y(8))*y(15)*params(8)*params(13)-T127*T216*(y(11)-y(8))*y(15)*params(8)*y(9)*params(13))/(y(9)*T127*y(9)*T127)+(params(3)*y(9)*T130*T216*params(13)*params(8)*y(75)-params(3)*T130*T216*params(13)*y(75)*params(8)*y(9))/(params(3)*y(9)*params(3)*y(9))+(T143*T130*T216*T127*y(14)*params(13)*params(8)*y(74)-T130*T216*T127*y(14)*params(13)*y(74)*params(8)*y(9)*T127*params(3)*y(15))/(T143*T143);
  g1(29,11)=(-(y(74)*(T648/T223+T216*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T1348/T230)))-y(75)*T216*y(15)*params(8)*y(9)*params(13)/(y(9)*T127)+T216*params(13)*y(75)*params(8)*y(9)*T1348/(params(3)*y(9))+T216*T127*y(14)*params(13)*y(74)*params(8)*y(9)*T1348/T143;
  g1(29,13)=y(72)*T216/(y(48)-y(14));
  g1(29,14)=y(13)*y(72)*T216/((y(48)-y(14))*(y(48)-y(14)))-y(74)*((T223*T216*(y(11)-y(8))*y(15)*params(8)*y(9)*params(13)-T222*(-(y(15)*y(9))))/(T223*T223)+(T230*T1474-T227*(-(y(9)*y(15)^2)))/(T230*T230))-y(75)*(-(T216*(y(11)-y(8))*y(15)*params(8)*y(9)*params(13)*(-y(9))))/(y(9)*T127*y(9)*T127)-y(90)/(T127*T127)+T216*params(13)*y(75)*params(8)*y(9)*T1447/(params(3)*y(9))+(T143*(T216*T127*y(14)*params(13)*y(74)*params(8)*y(9)*T1447+T130*T216*((-(y(14)*params(13)*y(74)*params(8)*y(9)))+T127*params(13)*y(74)*params(8)*y(9)))-T130*T216*T127*y(14)*params(13)*y(74)*params(8)*y(9)*(-(params(3)*y(15)*y(9))))/(T143*T143);
  g1(29,15)=(-(y(74)*((T223*T216*(y(11)-y(8))*y(14)*params(13)*params(8)*y(9)-T222*y(9)*T127)/(T223*T223)+(T230*T1657-T227*T127*y(9)*2*y(15))/(T230*T230))))-y(75)*T216*(y(11)-y(8))*params(13)*params(8)*y(9)/(y(9)*T127)+T216*params(13)*y(75)*params(8)*y(9)*T1631/(params(3)*y(9))+(T143*T216*T127*y(14)*params(13)*y(74)*params(8)*y(9)*T1631-T130*T216*T127*y(14)*params(13)*y(74)*params(8)*y(9)*T127*params(3)*y(9))/(T143*T143);
  g1(29,32)=y(13)*y(72)/(y(48)-y(14))-y(74)*((y(11)-y(8))*y(14)*y(15)*params(8)*y(9)*params(13)/T223+T130*T127*y(14)*y(15)*params(8)*y(9)*params(13)/T230)-y(75)*(y(11)-y(8))*y(15)*params(8)*y(9)*params(13)/(y(9)*T127)+T130*params(13)*y(75)*params(8)*y(9)/(params(3)*y(9))+T130*T127*y(14)*params(13)*y(74)*params(8)*y(9)/T143;
  g1(29,48)=(-(y(13)*y(72)*T216))/((y(48)-y(14))*(y(48)-y(14)));
  g1(29,55)=(-params(3));
  g1(29,72)=y(13)*T216/(y(48)-y(14));
  g1(29,74)=(-T232)+T130*T216*T127*y(14)*params(13)*params(8)*y(9)/T143;
  g1(29,75)=(-T239)+T130*T216*params(13)*params(8)*y(9)/(params(3)*y(9));
  g1(29,90)=(-(1/T127));
  g1(30,8)=(-((y(33)-1)*(-(params(13)*y(43)*y(73)))/(y(48)-y(45))));
  g1(30,11)=(-(params(13)*y(43)*y(73)*(y(33)-1)/(y(48)-y(45))));
  g1(30,33)=(-((y(11)-y(8))*params(13)*y(43)*y(73)/(y(48)-y(45))));
  g1(30,43)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(73)/(y(48)-y(45))));
  g1(30,45)=(-((y(11)-y(8))*params(13)*y(43)*y(73)*(y(33)-1)/((y(48)-y(45))*(y(48)-y(45)))));
  g1(30,48)=(-((-((y(11)-y(8))*params(13)*y(43)*y(73)*(y(33)-1)))/((y(48)-y(45))*(y(48)-y(45)))));
  g1(30,55)=1;
  g1(30,73)=(-((y(33)-1)*(y(11)-y(8))*y(43)*params(13)/(y(48)-y(45))));
  g1(31,87)=(-1);
  g1(31,88)=1;
  g1(32,9)=(-(y(86)*(T304*y(18)*params(10)*y(49)*T297-y(18)*params(10)*y(9)*y(49)*T297*y(17)^4)/(T304*T304)))+y(86)*(y(9)*T297*y(18)*params(10)*y(49)*T292-T297*y(18)*params(10)*y(9)*y(49)*T292)/(y(9)*T297*y(9)*T297)/params(3);
  g1(32,17)=y(85)*(params(10)*1/y(36)*2*T276/2+(y(17)*params(10)*1/y(36)+params(10)*T276)/y(36))-y(86)*((T292*y(18)*params(10)-y(18)*y(17)*params(10)*2*y(17))/(T292*T292)+(T304*y(18)*params(10)*y(9)*y(49)*T292*3-y(18)*params(10)*y(9)*y(49)*T297*y(9)*T297*4)/(T304*T304))+y(86)*(y(9)*T297*y(18)*params(10)*y(9)*y(49)*2*y(17)-y(18)*params(10)*y(9)*y(49)*T292*y(9)*T292*3)/(y(9)*T297*y(9)*T297)/params(3)+params(3)*y(86)*(T297*y(18)*params(10)*2*y(17)-y(18)*params(10)*T292*T292*3)/(T297*T297);
  g1(32,18)=(-(y(86)*(y(17)*params(10)/T292+params(10)*y(9)*y(49)*T297/T304)))+y(86)*params(10)*y(9)*y(49)*T292/(y(9)*T297)/params(3)+params(3)*y(86)*params(10)*T292/T297;
  g1(32,36)=y(85)*(params(10)*2*T276*(-y(17))/(y(36)*y(36))/2+(y(36)*y(17)*params(10)*(-y(17))/(y(36)*y(36))-T276*y(17)*params(10))/(y(36)*y(36)));
  g1(32,49)=(-(y(86)*y(18)*params(10)*y(9)*T297/T304))+y(86)*y(18)*params(10)*y(9)*T292/(y(9)*T297)/params(3);
  g1(32,56)=(-params(3));
  g1(32,85)=T284;
  g1(32,86)=(-T306)+y(18)*params(10)*y(9)*y(49)*T292/(y(9)*T297)/params(3)+params(3)*y(18)*params(10)*T292/T297;
  g1(32,87)=(-1);
  g1(33,17)=(-((params(10)*y(85)*T292*1/y(36)+T276*params(10)*y(85)*2*y(17))/T341));
  g1(33,36)=(-((T341*params(10)*y(85)*T292*(-y(17))/(y(36)*y(36))-T276*params(10)*y(85)*T292*2*y(36))/(T341*T341)));
  g1(33,56)=1;
  g1(33,85)=(-(T276*params(10)*T292/T341));
  g1(34,84)=(-1);
  g1(34,85)=1;
  g1(35,9)=(-((y(91)*params(3)*y(9)*T348-y(9)*y(91)*params(3)*T348)/(params(3)*y(9)*T348*params(3)*y(9)*T348)));
  g1(35,24)=y(83)*((T356*params(16)*2*y(24)-T348*params(16)*params(20)*2*T355)/(T356*T356)+(T355*(T361*2*params(16)+params(16)*2*y(24)*T1991)-params(20)*params(16)*2*y(24)*T361)/(T355*T355))-y(82)*((params(16)*T356-y(24)*params(16)*params(20)*2*T355)/(T356*T356)+(T355*params(16)*T1991-params(20)*params(16)*T361)/(T355*T355))+2*params(22)*y(67)-params(3)*y(83)*((T387*params(16)*params(20)*3*T348-params(16)*params(20)*y(24)^3*params(20)*3*T356)/(T387*T387)+(T356*(params(16)*T348*params(20)*T1991+T361*params(16)*params(20)*2*y(24))-T361*params(16)*T348*params(20)*params(20)*2*T355)/(T356*T356))+params(3)*y(82)*((T387*params(16)*params(20)*2*y(24)-params(16)*T348*params(20)*params(20)*3*T356)/(T387*T387)+(T356*(params(16)*y(24)*params(20)*T1991+T361*params(16)*params(20))-T361*params(16)*y(24)*params(20)*params(20)*2*T355)/(T356*T356))-params(16)*y(81)*1/(y(37)*params(20)-params(51)*(params(20)-1))/(y(37)*params(20)-params(51)*(params(20)-1))-(-(y(9)*y(91)*params(3)*y(9)*2*y(24)))/(params(3)*y(9)*T348*params(3)*y(9)*T348);
  g1(35,37)=(-(((y(37)*params(20)-params(51)*(params(20)-1))*params(16)*y(81)*T2295-params(20)*params(16)*y(81)*T409)/((y(37)*params(20)-params(51)*(params(20)-1))*(y(37)*params(20)-params(51)*(params(20)-1)))));
  g1(35,51)=(-1);
  g1(35,57)=(-params(3));
  g1(35,67)=params(22)*(2*y(24)-2*params(51));
  g1(35,81)=(-(params(16)*T409/(y(37)*params(20)-params(51)*(params(20)-1))));
  g1(35,82)=(-T375)+params(3)*T401;
  g1(35,83)=T364-params(3)*T393;
  g1(35,91)=(-(y(9)/(params(3)*y(9)*T348)));
  g1(36,24)=(params(16)*y(24)*params(20)*y(81)*1/(y(37)*params(20)-params(51)*(params(20)-1))+T409*params(16)*params(20)*y(81))/T423;
  g1(36,37)=(T423*params(16)*y(24)*params(20)*y(81)*T2295-T409*params(16)*y(24)*params(20)*y(81)*params(20)*2*(y(37)*params(20)-params(51)*(params(20)-1)))/(T423*T423);
  g1(36,57)=1;
  g1(36,81)=params(16)*y(24)*params(20)*T409/T423;
  g1(37,51)=1;
  g1(38,52)=1;
  g1(39,58)=(-params(3));
  g1(39,76)=1;
  g1(39,84)=1;
  g1(40,6)=y(28)*params(4)*y(79)/T457;
  g1(40,10)=(-(exp(y(47))*y(77)*params(4)*y(38)^(params(4)-1)*getPowerDeriv(y(10),1-params(4),1)));
  g1(40,18)=(-(y(6)*y(28)*params(4)*y(79)*y(38)^2))/(T457*T457);
  g1(40,28)=y(6)*params(4)*y(79)/T457;
  g1(40,38)=(-(exp(y(47))*y(77)*T444*params(4)*getPowerDeriv(y(38),params(4)-1,1)))+(-(y(6)*y(28)*params(4)*y(79)*y(18)*2*y(38)))/(T457*T457);
  g1(40,47)=(-(params(4)*y(38)^(params(4)-1)*T444*y(77)*exp(y(47))));
  g1(40,58)=1;
  g1(40,77)=(-(params(4)*y(38)^(params(4)-1)*T444*exp(y(47))));
  g1(40,79)=y(6)*y(28)*params(4)/T457;
  g1(40,84)=params(9)-1;
  g1(41,10)=y(67)*T1332+y(68)*T1332+y(70)*params(6)*params(7)*getPowerDeriv(y(10),params(7)-1,1)+(-((params(4)-1)*exp(y(47))*y(77)*y(38)^params(4)*getPowerDeriv(y(10),params(4),1)))/(T482*T482);
  g1(41,38)=(params(4)-1)*exp(y(47))*y(77)*getPowerDeriv(y(38),params(4),1)/T482;
  g1(41,47)=T483;
  g1(41,59)=(-params(3));
  g1(41,67)=T466;
  g1(41,68)=T466;
  g1(41,70)=params(6)*params(7)*y(10)^(params(7)-1);
  g1(41,77)=(params(4)-1)*T835/T482;
  g1(41,78)=1;
  g1(42,90)=1;
  g1(43,7)=(-y(70));
  g1(43,8)=y(74)*((params(13)-1)*(-(params(8)*y(9)))/T493-T216*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T1012/(T127*y(15)*T493))-y(74)*((params(13)-1)*(-params(8))/y(9)-T216*T127*y(14)*y(15)*params(8)*params(13)*T1012/T223)/params(3)-y(15)*params(8)*y(9)*y(75)*params(13)*T216*T1012/T493+T216*params(13)*y(15)*params(8)*y(75)*T1012/(params(3)*y(9));
  g1(43,9)=y(74)*((T493*(params(13)-1)*params(8)*(y(11)-y(8))-(y(11)-y(8))*params(8)*y(9)*(params(13)-1)*2*y(9))/(T493*T493)-(T127*y(15)*T493*T512-T227*T127*y(15)*2*y(9))/(T127*y(15)*T493*T127*y(15)*T493))-(T493*y(71)-y(9)*y(71)*2*y(9))/(T493*T493)-y(74)*((-((params(13)-1)*params(8)*(y(11)-y(8))))/(y(9)*y(9))-(-(T512*y(15)*T127))/(T223*T223))/params(3)+(-(params(3)*y(71)))/(params(3)*y(9)*params(3)*y(9))+(-(y(91)*params(3)*y(24)))/(params(3)*y(24)*y(9)*params(3)*y(24)*y(9))-(y(91)*y(24)*T493-y(9)*y(91)*y(24)*2*y(9))/(y(24)*T493*y(24)*T493)-(T493*T130*T216*params(13)*y(15)*params(8)*y(75)-T130*y(15)*params(8)*y(9)*y(75)*params(13)*T216*2*y(9))/(T493*T493)+(-(params(3)*T130*T216*params(13)*y(15)*params(8)*y(75)))/(params(3)*y(9)*params(3)*y(9));
  g1(43,11)=y(74)*(params(8)*y(9)*(params(13)-1)/T493-T216*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T1348/(T127*y(15)*T493))-y(74)*(params(8)*(params(13)-1)/y(9)-T216*T127*y(14)*y(15)*params(8)*params(13)*T1348/T223)/params(3)-y(15)*params(8)*y(9)*y(75)*params(13)*T216*T1348/T493+T216*params(13)*y(15)*params(8)*y(75)*T1348/(params(3)*y(9));
  g1(43,14)=y(74)*(-((T127*y(15)*T493*T1474-T227*(-(y(15)*T493)))/(T127*y(15)*T493*T127*y(15)*T493)))-y(74)*(-((T223*(T216*T127*y(14)*y(15)*params(8)*params(13)*T1447+T130*T216*(T127*y(15)*params(8)*params(13)+(-(y(14)*y(15)*params(8)*params(13)))))-T512*(-(y(15)*y(9))))/(T223*T223)))/params(3)-y(15)*params(8)*y(9)*y(75)*params(13)*T216*T1447/T493+T216*params(13)*y(15)*params(8)*y(75)*T1447/(params(3)*y(9));
  g1(43,15)=y(74)*(-((T127*y(15)*T493*T1657-T227*T127*T493)/(T127*y(15)*T493*T127*y(15)*T493)))-y(74)*(-((T223*(T216*T127*y(14)*y(15)*params(8)*params(13)*T1631+T130*T216*T127*y(14)*params(8)*params(13))-y(9)*T127*T512)/(T223*T223)))/params(3)-(T130*T216*params(13)*y(75)*params(8)*y(9)+y(15)*params(8)*y(9)*y(75)*params(13)*T216*T1631)/T493+(T130*T216*params(13)*params(8)*y(75)+T216*params(13)*y(15)*params(8)*y(75)*T1631)/(params(3)*y(9));
  g1(43,24)=(-(params(3)*y(9)*y(91)))/(params(3)*y(24)*y(9)*params(3)*y(24)*y(9))-(-(y(9)*y(91)*T493))/(y(24)*T493*y(24)*T493);
  g1(43,32)=y(74)*(-(T130*T127*y(14)*y(15)*params(8)*y(9)*params(13)/(T127*y(15)*T493)))-y(74)*(-(T130*T127*y(14)*y(15)*params(8)*params(13)/T223))/params(3)-y(15)*params(8)*y(9)*y(75)*params(13)*T130/T493+T130*params(13)*y(15)*params(8)*y(75)/(params(3)*y(9));
  g1(43,69)=1;
  g1(43,70)=(-y(7));
  g1(43,71)=(-(y(9)/T493))+1/(params(3)*y(9));
  g1(43,74)=T498-T514/params(3);
  g1(43,75)=(-(T130*T216*y(15)*params(8)*y(9)*params(13)/T493))+T130*T216*y(15)*params(8)*params(13)/(params(3)*y(9));
  g1(43,91)=1/(params(3)*y(24)*y(9))-y(9)/(y(24)*T493);
  g1(44,59)=1;
  g1(45,6)=(-((-y(92))/(y(6)*y(6))));
  g1(45,14)=y(15)*y(72)*T216/((y(48)-y(14))*(y(48)-y(14)));
  g1(45,15)=y(72)*T216/(y(48)-y(14));
  g1(45,32)=y(15)*y(72)/(y(48)-y(14));
  g1(45,48)=(-(y(15)*y(72)*T216))/((y(48)-y(14))*(y(48)-y(14)));
  g1(45,63)=(-params(3));
  g1(45,72)=y(15)*T216/(y(48)-y(14));
  g1(45,73)=1;
  g1(45,92)=(-(1/y(6)));
  g1(46,92)=1;
  g1(47,8)=(y(33)-1)*params(13)*y(73)*(-((-y(35))/(y(48)-y(45))));
  g1(47,11)=(y(33)-1)*params(13)*y(73)*(1-y(35)/(y(48)-y(45)));
  g1(47,33)=T154*params(13)*y(73);
  g1(47,35)=(y(33)-1)*params(13)*y(73)*(-((y(11)-y(8))/(y(48)-y(45))));
  g1(47,45)=(y(33)-1)*params(13)*y(73)*(-(y(35)*(y(11)-y(8))/((y(48)-y(45))*(y(48)-y(45)))));
  g1(47,48)=(y(33)-1)*params(13)*y(73)*(-((-(y(35)*(y(11)-y(8))))/((y(48)-y(45))*(y(48)-y(45)))));
  g1(47,63)=1;
  g1(47,73)=T154*params(13)*(y(33)-1);
  g1(48,6)=(-(y(80)*T569));
  g1(48,28)=(-(y(6)*y(80)*(-((1+params(18))/params(18)))));
  g1(48,80)=(-(y(6)*T569));
  g1(48,81)=1;
  g1(49,6)=(-(params(3)*y(79)*(-(y(28)*params(4)/(y(38)*T581)))));
  g1(49,12)=y(72);
  g1(49,18)=(-(params(3)*y(79)*(((params(9)-1)*T581-y(18)*(params(9)-1)*2*y(18))/(T581*T581)-(-(y(6)*y(28)*params(4)*y(38)*2*y(18)))/(y(38)*T581*y(38)*T581))))+(-((params(9)-1)*y(79)))/(y(18)*y(18));
  g1(49,28)=(-(params(3)*y(79)*(-(y(6)*params(4)/(y(38)*T581)))));
  g1(49,38)=(-(params(3)*y(79)*(-((-(T581*y(6)*y(28)*params(4)))/(y(38)*T581*y(38)*T581)))));
  g1(49,44)=(-(y(73)*params(14)));
  g1(49,61)=(-params(3));
  g1(49,72)=y(12);
  g1(49,73)=(-(y(44)*params(14)));
  g1(49,79)=(-(params(3)*T587))+(params(9)-1)/y(18);
  g1(49,86)=1;
  g1(50,61)=1;
  g1(51,9)=(-(y(74)*((y(9)*params(8)*(params(13)-1)-params(8)*y(9)*(params(13)-1))/(y(9)*y(9))+(T223*T216*T127*y(14)*y(15)*params(8)*params(13)*T606-T609*y(15)*T127)/(T223*T223))))-(y(9)*T216*params(13)*y(15)*params(8)*y(75)*T606-T216*y(15)*params(8)*y(9)*y(75)*params(13)*T606)/(y(9)*y(9));
  g1(51,11)=(-(y(71)*y(49)*2*(1+y(11))))/(T601*T601);
  g1(51,14)=(-(y(74)*(T223*T216*((-(y(14)*y(15)*params(8)*y(9)*params(13)*T606))+T127*(y(15)*params(8)*y(9)*params(13)*T606+y(14)*y(15)*params(8)*y(9)*params(13)*y(15)/(T127*T127)))-T609*(-(y(15)*y(9))))/(T223*T223)))-T216*y(15)*params(8)*y(9)*y(75)*params(13)*y(15)/(T127*T127)/y(9);
  g1(51,15)=(-(y(74)*(T223*T216*T127*(T606*y(14)*params(13)*params(8)*y(9)+y(14)*y(15)*params(8)*y(9)*params(13)*1/T127)-y(9)*T127*T609)/(T223*T223)))-T216*(params(13)*y(75)*params(8)*y(9)*T606+y(15)*params(8)*y(9)*y(75)*params(13)*1/T127)/y(9);
  g1(51,32)=(-(y(74)*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T606/T223))-y(15)*params(8)*y(9)*y(75)*params(13)*T606/y(9);
  g1(51,33)=(-(params(13)*y(43)*params(3)*y(73)*(y(35)/(y(48)-y(45))-1)));
  g1(51,35)=(-((y(33)-1)*params(13)*y(43)*params(3)*y(73)*1/(y(48)-y(45))));
  g1(51,43)=(-((y(33)-1)*(y(35)/(y(48)-y(45))-1)*params(13)*params(3)*y(73)));
  g1(51,45)=(-((y(33)-1)*params(13)*y(43)*params(3)*y(73)*y(35)/((y(48)-y(45))*(y(48)-y(45)))));
  g1(51,48)=(-((y(33)-1)*params(13)*y(43)*params(3)*y(73)*(-y(35))/((y(48)-y(45))*(y(48)-y(45)))));
  g1(51,49)=(-(y(71)*(1+y(11))^2))/(T601*T601);
  g1(51,62)=(-params(3));
  g1(51,71)=1/T601;
  g1(51,73)=(-((y(33)-1)*(y(35)/(y(48)-y(45))-1)*params(13)*params(3)*y(43)));
  g1(51,74)=(-T611);
  g1(51,75)=(-(T216*y(15)*params(8)*y(9)*params(13)*T606/y(9)));
  g1(52,62)=1;
  g1(52,89)=1;
  g1(53,6)=(-((1+params(19)-y(28))*y(80)*y(27)/T633));
  g1(53,23)=(-(y(91)*y(49)*2*(1+y(23))))/(y(49)*T633*y(49)*T633)-(-((1+params(19)-y(28))*y(6)*y(80)*y(27)*2*(1+y(23))))/(T633*T633);
  g1(53,27)=(-(y(6)*y(80)*(1+params(19)-y(28))/T633));
  g1(53,28)=(-((-(y(6)*y(80)*y(27)))/T633));
  g1(53,49)=(-(y(91)*T633))/(y(49)*T633*y(49)*T633);
  g1(53,60)=(-params(3));
  g1(53,80)=(-((1+params(19)-y(28))*y(6)*y(27)/T633));
  g1(53,91)=1/(y(49)*T633);
  g1(54,60)=1;
  g1(55,9)=y(74)*((y(9)*params(8)*(params(13)-1)-params(8)*y(9)*(params(13)-1))/(y(9)*y(9))+(y(9)*T127*T216*y(14)*y(15)*params(8)*params(13)-T127*T648)/(y(9)*T127*y(9)*T127))/params(3)+(T127*params(3)*y(9)*T216*params(13)*y(75)*y(15)*y(15)*params(8)-T216*params(13)*y(75)*y(9)*y(15)*y(15)*params(8)*params(3)*T127)/(T127*params(3)*y(9)*T127*params(3)*y(9));
  g1(55,14)=y(74)*(y(9)*T127*T216*y(15)*params(8)*y(9)*params(13)-T648*(-y(9)))/(y(9)*T127*y(9)*T127)/params(3)+(-(T216*params(13)*y(75)*y(9)*y(15)*y(15)*params(8)*(-(params(3)*y(9)))))/(T127*params(3)*y(9)*T127*params(3)*y(9));
  g1(55,15)=y(74)*T216*y(14)*params(13)*params(8)*y(9)/(y(9)*T127)/params(3)+T216*params(13)*y(75)*y(9)*(y(15)*params(8)+y(15)*params(8))/(T127*params(3)*y(9));
  g1(55,32)=y(74)*y(14)*y(15)*params(8)*y(9)*params(13)/(y(9)*T127)/params(3)+params(13)*y(75)*y(9)*y(15)*y(15)*params(8)/(T127*params(3)*y(9));
  g1(55,33)=params(13)*y(43)*y(35)*y(73)/(y(48)-y(45));
  g1(55,35)=params(13)*y(43)*y(73)*(y(33)-1)/(y(48)-y(45));
  g1(55,43)=(y(33)-1)*params(13)*y(35)*y(73)/(y(48)-y(45));
  g1(55,45)=(y(33)-1)*params(13)*y(43)*y(35)*y(73)/((y(48)-y(45))*(y(48)-y(45)));
  g1(55,48)=(-((y(33)-1)*params(13)*y(43)*y(35)*y(73)))/((y(48)-y(45))*(y(48)-y(45)));
  g1(55,73)=(y(33)-1)*params(13)*y(35)*y(43)/(y(48)-y(45));
  g1(55,74)=T650/params(3);
  g1(55,75)=T216*params(13)*y(9)*y(15)*y(15)*params(8)/(T127*params(3)*y(9));
  g1(55,79)=1;
  g1(55,89)=(-1);
  g1(56,18)=y(72);
  g1(56,64)=(-params(3));
  g1(56,72)=y(18);
  g1(56,76)=(-1);
  g1(57,6)=(params(4)-1)*y(78)/y(7)-y(80)*(y(26)-(1+params(18))*(y(25)-1)/params(18))-params(4)*y(79)/(y(38)*y(18))-y(80)*y(27)/(params(3)*(1+y(23)));
  g1(57,7)=(-((params(4)-1)*y(6)*y(78)))/(y(7)*y(7));
  g1(57,18)=(-((-(y(38)*y(6)*params(4)*y(79)))/(y(38)*y(18)*y(38)*y(18))));
  g1(57,23)=(-((-(params(3)*y(6)*y(80)*y(27)))/(params(3)*(1+y(23))*params(3)*(1+y(23)))));
  g1(57,25)=(-(y(80)*(-(y(6)*(1+params(18))/params(18)))));
  g1(57,26)=(-(y(6)*y(80)));
  g1(57,27)=(-(y(6)*y(80)/(params(3)*(1+y(23)))));
  g1(57,38)=(-((-(y(18)*y(6)*params(4)*y(79)))/(y(38)*y(18)*y(38)*y(18))));
  g1(57,78)=y(6)*(params(4)-1)/y(7);
  g1(57,79)=(-(y(6)*params(4)/(y(38)*y(18))));
  g1(57,80)=(-(y(6)*y(26)-y(6)*(1+params(18))*(y(25)-1)/params(18)))-y(6)*y(27)/(params(3)*(1+y(23)));
  g1(58,18)=(-(y(73)*params(14)));
  g1(58,64)=1;
  g1(58,73)=(-(y(18)*params(14)));
  g1(59,21)=2*params(21)*y(68);
  g1(59,68)=params(21)*(2*y(21)-2*params(17));
  g1(59,89)=1;
  g1(60,67)=1;
  g1(61,68)=1;
  g1(62,8)=y(74)*(T216*T127*y(15)*params(8)*y(9)*params(13)*T1012/T223+T216*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T1012/(y(15)*y(9)*T713))/params(3)-y(74)*(T648*T1012/T223+T216*(-(y(14)*y(15)*params(8)*y(9)*params(13)))/(T127*y(9)*T127))-T216*(-(params(13)*y(75)*y(9)*y(15)*y(15)*params(8)))/(y(9)*T713);
  g1(62,9)=y(74)*((T223*T130*T216*T127*y(15)*params(8)*params(13)-T130*T216*T127*y(15)*params(8)*y(9)*params(13)*y(15)*T127)/(T223*T223)+(T512*y(15)*y(9)*T713-T227*y(15)*T713)/(y(15)*y(9)*T713*y(15)*y(9)*T713))/params(3)-y(74)*((T223*T130*T216*y(14)*y(15)*params(8)*params(13)-T130*T648*y(15)*T127)/(T223*T223)+(T127*y(9)*T127*T216*(y(11)-y(8))*y(14)*y(15)*params(8)*params(13)-T222*T127*T127)/(T127*y(9)*T127*T127*y(9)*T127))-(y(9)*T713*T216*(y(11)-y(8))*params(13)*y(75)*y(15)*y(15)*params(8)-T713*T216*(y(11)-y(8))*params(13)*y(75)*y(9)*y(15)*y(15)*params(8))/(y(9)*T713*y(9)*T713);
  g1(62,11)=y(74)*(T216*T127*y(15)*params(8)*y(9)*params(13)*T1348/T223+T216*T127*y(14)*y(15)*params(8)*y(9)*params(13)*T1348/(y(15)*y(9)*T713))/params(3)-y(74)*(T648*T1348/T223+T648/(T127*y(9)*T127))-T216*params(13)*y(75)*y(9)*y(15)*y(15)*params(8)/(y(9)*T713);
  g1(62,13)=y(15)*y(72)*T216/T734;
  g1(62,14)=y(74)*((T223*(T216*T127*y(15)*params(8)*y(9)*params(13)*T1447+T130*T216*(-(y(15)*params(8)*y(9)*params(13))))-T130*T216*T127*y(15)*params(8)*y(9)*params(13)*(-(y(15)*y(9))))/(T223*T223)+(y(15)*y(9)*T713*T1474-T227*y(15)*y(9)*(-(2*T127)))/(y(15)*y(9)*T713*y(15)*y(9)*T713))/params(3)-y(74)*((T223*(T648*T1447+T130*T216*y(15)*params(8)*y(9)*params(13))-T130*T648*(-(y(15)*y(9))))/(T223*T223)+(T216*(y(11)-y(8))*y(15)*params(8)*y(9)*params(13)*T127*y(9)*T127-T222*((-(y(9)*T127))+T127*(-y(9))))/(T127*y(9)*T127*T127*y(9)*T127))-(-(y(15)*y(90)*(-(2*T127))))/(T713*T713)+(-(y(13)*y(15)*y(72)*T216*(-(2*(y(48)-y(14))))))/(T734*T734)-(-(T216*(y(11)-y(8))*params(13)*y(75)*y(9)*y(15)*y(15)*params(8)*y(9)*(-(2*T127))))/(y(9)*T713*y(9)*T713);
  g1(62,15)=y(74)*((T223*(T216*T127*y(15)*params(8)*y(9)*params(13)*T1631+T130*T216*T127*params(13)*params(8)*y(9))-y(9)*T127*T130*T216*T127*y(15)*params(8)*y(9)*params(13))/(T223*T223)+(y(15)*y(9)*T713*T1657-T227*y(9)*T713)/(y(15)*y(9)*T713*y(15)*y(9)*T713))/params(3)-y(74)*((T223*(T648*T1631+T130*T216*y(14)*params(13)*params(8)*y(9))-y(9)*T127*T130*T648)/(T223*T223)+T216*(y(11)-y(8))*y(14)*params(13)*params(8)*y(9)/(T127*y(9)*T127))-y(90)/T713+y(13)*y(72)*T216/T734-T216*(y(11)-y(8))*params(13)*y(75)*y(9)*(y(15)*params(8)+y(15)*params(8))/(y(9)*T713);
  g1(62,32)=y(74)*(T130*T127*y(15)*params(8)*y(9)*params(13)/T223+T130*T127*y(14)*y(15)*params(8)*y(9)*params(13)/(y(15)*y(9)*T713))/params(3)-y(74)*(T130*y(14)*y(15)*params(8)*y(9)*params(13)/T223+(y(11)-y(8))*y(14)*y(15)*params(8)*y(9)*params(13)/(T127*y(9)*T127))+y(13)*y(15)*y(72)/T734-(y(11)-y(8))*params(13)*y(75)*y(9)*y(15)*y(15)*params(8)/(y(9)*T713);
  g1(62,48)=(-(y(13)*y(15)*y(72)*T216*2*(y(48)-y(14))))/(T734*T734);
  g1(62,65)=(-params(3));
  g1(62,72)=T216*y(15)*y(13)/T734;
  g1(62,74)=T716/params(3)-T724;
  g1(62,75)=(-(T216*(y(11)-y(8))*params(13)*y(9)*y(15)*y(15)*params(8)/(y(9)*T713)));
  g1(62,90)=(-(y(15)/T713));
  g1(63,8)=(-((y(33)-1)*(-(params(13)*y(43)*y(35)*y(73)))/T745));
  g1(63,11)=(-((y(33)-1)*params(13)*y(43)*y(35)*y(73)/T745));
  g1(63,33)=(-((y(11)-y(8))*params(13)*y(43)*y(35)*y(73)/T745));
  g1(63,35)=(-((y(11)-y(8))*params(13)*y(43)*y(73)*(y(33)-1)/T745));
  g1(63,43)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(35)*y(73)/T745));
  g1(63,45)=(-((-((y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(35)*y(73)*(-(2*(y(48)-y(45))))))/(T745*T745)));
  g1(63,48)=(-((-((y(33)-1)*(y(11)-y(8))*params(13)*y(43)*y(35)*y(73)*2*(y(48)-y(45))))/(T745*T745)));
  g1(63,65)=1;
  g1(63,73)=(-((y(33)-1)*(y(11)-y(8))*params(13)*y(35)*y(43)/T745));
  g1(64,6)=(-((params(4)-1)*y(28)*y(78)/T754));
  g1(64,7)=(-((-((params(4)-1)*y(6)*y(28)*y(78)*2*y(7)))/(T754*T754)));
  g1(64,9)=(-y(70));
  g1(64,28)=(-((params(4)-1)*y(6)*y(78)/T754));
  g1(64,70)=(-y(9));
  g1(64,78)=(-((params(4)-1)*y(6)*y(28)/T754));
  g1(65,6)=(-(y(13)*y(92)*2*y(6)))/(T771*T771);
  g1(65,7)=(-((params(4)-1)*y(28)*y(78)))/(y(7)*y(7));
  g1(65,13)=y(92)/T771;
  g1(65,18)=(-((-(y(38)*y(28)*params(4)*y(79)))/(y(38)*y(18)*y(38)*y(18))));
  g1(65,23)=(-(params(3)*(1+params(19)-y(28))*y(80)*y(27)))/(params(3)*(1+y(23))*params(3)*(1+y(23)));
  g1(65,25)=y(80)*(-T569);
  g1(65,26)=y(80)*(1+params(19)-y(28));
  g1(65,27)=y(80)*(1+params(19)-y(28))/(params(3)*(1+y(23)));
  g1(65,28)=(params(4)-1)*y(78)/y(7)+y(80)*((-y(26))-(y(25)-1)*(-((1+params(18))/params(18))))-params(4)*y(79)/(y(38)*y(18))+(-(y(80)*y(27)))/(params(3)*(1+y(23)));
  g1(65,38)=(-((-(y(18)*y(28)*params(4)*y(79)))/(y(38)*y(18)*y(38)*y(18))));
  g1(65,66)=(-params(3));
  g1(65,77)=1;
  g1(65,78)=y(28)*(params(4)-1)/y(7);
  g1(65,79)=(-(y(28)*params(4)/(y(38)*y(18))));
  g1(65,80)=(1+params(19)-y(28))*y(26)-T569*(y(25)-1)+(1+params(19)-y(28))*y(27)/(params(3)*(1+y(23)));
  g1(65,87)=1;
  g1(65,88)=(-params(11));
  g1(65,92)=y(13)/T771;
  g1(66,66)=1;
  g1(67,9)=1;
  g1(67,19)=(-((-1)/((y(19)-y(34)*params(5)+y(50))*(y(19)-y(34)*params(5)+y(50)))-(-(params(5)*y(49)*(1-params(5))))/((y(50)+y(19)-y(19)*params(5))*(y(50)+y(19)-y(19)*params(5)))));
  g1(67,34)=(-(params(5)/((y(19)-y(34)*params(5)+y(50))*(y(19)-y(34)*params(5)+y(50)))));
  g1(67,49)=params(5)/(y(50)+y(19)-y(19)*params(5));
  g1(67,50)=(-((-1)/((y(19)-y(34)*params(5)+y(50))*(y(19)-y(34)*params(5)+y(50)))-(-(params(5)*y(49)))/((y(50)+y(19)-y(19)*params(5))*(y(50)+y(19)-y(19)*params(5)))));
  g1(68,7)=(-y(9));
  g1(68,9)=(-y(7));
  g1(68,10)=T1332;
  g1(69,11)=(-((-y(49))/(y(49)*(1+y(11))*y(49)*(1+y(11)))));
  g1(69,49)=(-((-(1+y(11)))/(y(49)*(1+y(11))*y(49)*(1+y(11)))));
  g1(70,12)=y(18);
  g1(70,13)=(-(y(15)/(y(48)-y(14))*(1-y(32))));
  g1(70,14)=(-((1-y(32))*y(13)*y(15)/((y(48)-y(14))*(y(48)-y(14)))));
  g1(70,15)=(-((1-y(32))*y(13)*1/(y(48)-y(14))));
  g1(70,18)=y(12);
  g1(70,32)=y(13)*y(15)/(y(48)-y(14));
  g1(70,48)=(-((1-y(32))*y(13)*(-y(15))/((y(48)-y(14))*(y(48)-y(14)))));
  g1(71,8)=(-((1-y(33))*y(43)*params(13)*y(35)/(y(48)-y(45))));
  g1(71,11)=(-((1-y(33))*y(43)*params(13)*(1+(-y(35))/(y(48)-y(45)))));
  g1(71,13)=1;
  g1(71,18)=(-(y(44)*params(14)));
  g1(71,33)=y(43)*params(13)*(y(11)+1+y(35)*(y(8)-y(11))/(y(48)-y(45)));
  g1(71,35)=(-((1-y(33))*y(43)*params(13)*(y(8)-y(11))/(y(48)-y(45))));
  g1(71,43)=(-(params(13)*(y(11)+1+y(35)*(y(8)-y(11))/(y(48)-y(45)))*(1-y(33))));
  g1(71,44)=(-(y(18)*params(14)));
  g1(71,45)=(-((1-y(33))*y(43)*params(13)*y(35)*(y(8)-y(11))/((y(48)-y(45))*(y(48)-y(45)))));
  g1(71,48)=(-((1-y(33))*y(43)*params(13)*(-(y(35)*(y(8)-y(11))))/((y(48)-y(45))*(y(48)-y(45)))));
  g1(72,8)=(-(T817+y(14)*(1-y(32))*T605*T821));
  g1(72,11)=(-((-T817)+y(14)*(1-y(32))*T821*(1+(-y(15))/T127)));
  g1(72,14)=1-(T827+y(14)*(1-y(32))*T821*y(15)*(y(8)-y(11))/(T127*T127));
  g1(72,15)=(-(y(14)*(1-y(32))*T821*(y(8)-y(11))/T127));
  g1(72,32)=(-(y(14)*(-(T821*(y(11)+1+y(15)*(y(8)-y(11))/T127)))));
  g1(73,8)=(-(y(15)*(1-y(32))*T605*T821));
  g1(73,11)=(-(y(15)*(1-y(32))*T821*(1+(-y(15))/T127)));
  g1(73,14)=(-(y(15)*(1-y(32))*T821*y(15)*(y(8)-y(11))/(T127*T127)));
  g1(73,15)=1-(T827+y(15)*(1-y(32))*T821*(y(8)-y(11))/T127);
  g1(73,32)=(-(y(15)*(-(T821*(y(11)+1+y(15)*(y(8)-y(11))/T127)))));
  g1(74,5)=1;
  g1(74,12)=(-1);
  g1(75,6)=1;
  g1(75,10)=(-(T835*getPowerDeriv(y(10),1-params(4),1)));
  g1(75,38)=(-(T444*exp(y(47))*getPowerDeriv(y(38),params(4),1)));
  g1(75,47)=(-(T444*T835));
  g1(76,6)=(-(y(28)*(1-params(4))/y(7)));
  g1(76,7)=(-((-(y(6)*y(28)*(1-params(4))))/(y(7)*y(7))));
  g1(76,10)=1;
  g1(76,28)=(-(y(6)*(1-params(4))/y(7)));
  g1(77,6)=(-(y(28)*params(4)/(y(38)*y(18))));
  g1(77,8)=1;
  g1(77,18)=(-((-(y(38)*y(6)*y(28)*params(4)))/(y(38)*y(18)*y(38)*y(18))));
  g1(77,28)=(-(y(6)*params(4)/(y(38)*y(18))));
  g1(77,38)=(-((-(y(18)*y(6)*y(28)*params(4)))/(y(38)*y(18)*y(38)*y(18))));
  g1(78,6)=(-(T853-y(26)*(1+params(19)-y(28))-y(27)*(1+params(19)-y(28))*1/(1+y(23))));
  g1(78,23)=y(27)*y(6)*(1+params(19)-y(28))*(-1)/((1+y(23))*(1+y(23)));
  g1(78,25)=(-(y(6)*(-T851)));
  g1(78,26)=y(6)*(1+params(19)-y(28));
  g1(78,27)=y(6)*(1+params(19)-y(28))*1/(1+y(23));
  g1(78,28)=(-(y(6)*(1-y(25))*(1+params(18))/params(18)-y(26)*(-y(6))-y(27)*y(6)*(-(1/(1+y(23))))));
  g1(79,24)=(-(params(16)/2*1/(y(37)*params(20)+params(51)*(1-params(20)))*2*(y(24)/(y(37)*params(20)+params(51)*(1-params(20)))-1)));
  g1(79,25)=1;
  g1(79,37)=(-(params(16)/2*2*(y(24)/(y(37)*params(20)+params(51)*(1-params(20)))-1)*(-(y(24)*params(20)))/((y(37)*params(20)+params(51)*(1-params(20)))*(y(37)*params(20)+params(51)*(1-params(20))))));
  g1(80,24)=(-(((y(24)*params(20)+params(51)*(1-params(20)))*(params(16)*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)+y(24)*params(16)*T2082)-params(20)*y(24)*params(16)*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1))/((y(24)*params(20)+params(51)*(1-params(20)))*(y(24)*params(20)+params(51)*(1-params(20))))));
  g1(80,26)=1;
  g1(81,24)=(-(((y(24)*params(20)+params(51)*(1-params(20)))*(2*y(24)*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)*(-params(16))+T348*(-params(16))*T2082)-params(20)*T348*(y(24)/(y(24)*params(20)+params(51)*(1-params(20)))-1)*(-params(16)))/((y(24)*params(20)+params(51)*(1-params(20)))*(y(24)*params(20)+params(51)*(1-params(20))))));
  g1(81,27)=1;
  g1(82,5)=1;
  g1(82,16)=(-1);
  g1(82,38)=(-(1-params(9)));
  g1(83,16)=1;
  g1(83,17)=(-(1-T277*params(10)/2+y(17)*(-(params(10)/2*1/y(36)*2*T276))));
  g1(83,36)=(-(y(17)*(-(params(10)/2*2*T276*(-y(17))/(y(36)*y(36))))));
  g1(84,18)=1;
  g1(85,6)=1;
  g1(85,17)=(-1);
  g1(85,19)=(-1);
  g1(85,20)=(-1);
  g1(86,6)=(-params(11));
  g1(86,20)=1;
  g1(87,8)=(-1);
  g1(87,21)=1;
  g1(87,42)=1;
  g1(88,14)=(-(y(15)/(T127*T127)));
  g1(88,15)=(-(1/T127));
  g1(88,22)=1;
  g1(89,23)=(-((-y(49))/(y(49)*(1+y(23))*y(49)*(1+y(23)))));
  g1(89,24)=(-1)/(y(24)*y(24));
  g1(89,49)=(-((-(1+y(23)))/(y(49)*(1+y(23))*y(49)*(1+y(23)))));
  g1(90,6)=(-((-y(13))/(y(6)*y(6))));
  g1(90,13)=(-(1/y(6)));
  g1(90,29)=1;
  g1(91,48)=1-params(32);
  g1(92,49)=1-params(36);
  g1(93,50)=1-params(38);
  g1(94,47)=1-params(30);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],94,8836);
end
end
