function [optys,check] = rbcb_monprud_ramsey_infl_bt_steadystate(junk,ys)
% TEMPLATE_FOR_RAMSEY_STEADYSTATE.M: This file will be copied when a new
% _ramsey.mod file is created, with rbcb_monprud_ramsey_infl_bt being replaced by
% the new .mod filename in all instances.

global M_ params paramlist param_switch sensitivity_switch paramfile_name
check = 0;

% set parameters -- replace with outfilename
rbcb_monprud_ramsey_infl_bt_paramfile

% export parameters
nparams = size(M_.param_names,1);
for icount = 1:nparams
    eval(['M_.params(icount) = ',M_.param_names(icount,:),';'])
end

% this calls a program that will be created with the _ramsey.mod file which
% will 'guess' the steady-state values for the endogenous variables. the
% program will be a copy of the original _steadystate.m file; therefore,
% all original endogenous variables will have their original steady-state
% values, and the Lagrangian multipliers will be set to 0 for now.
[ys] = guess_rbcb_monprud_ramsey_infl_bt_steadystate('');

% Solve for the steady-state from this initial guess.
nexog = M_.exo_nbr;
exog = zeros(nexog,1);
algo = char('active-set', 'trust-region-reflective', 'interior-point', 'interior-point-convex', 'levenberg-marquardt', 'trust-region-dogleg', 'lm-line-search','sqp');
options = optimset('Display','Iter','Jacobian','on','MaxFunEvals',1e4,'MaxIter',1e4,'TolFun',1e-9,'TolX',1e-9,'Algorithm',algo(5,:));
optys=fsolve(@(ys) rbcb_monprud_ramsey_infl_bt_static(ys,exog,M_.params),ys,options);
