var c1pi, c2pi, c1y, c2y, c1delta, c1u, c2u, 
    gammac1nkpc, gammac2nkpc, gammadelta, c1relc, c1q;

varexo c1uerr, c2uerr;   

parameters 
c1kappa, c1tau, c1chi, c1sigma, c1rhou, c1sigmau, c1beta, c1omegac,
c2kappa, c2tau, c2chi, c2sigma, c2rhou, c2sigmau, c2beta, c2omegac,
lambdac1pi, lambdac2pi, lambdac1y, lambdac2y, lambdac1delta;

model(linear);
////////////
// Policy
////////////

-lambdac1pi*c1pi + gammac1nkpc - gammac1nkpc(-1) = 0;

-lambdac2pi*c2pi + gammac2nkpc - gammac2nkpc(-1) = 0;

-lambdac1y*c1y - gammac1nkpc*c1kappa + gammadelta = 0;

-lambdac2y*c2y - gammac2nkpc*c2kappa - gammadelta = 0;

-lambdac1delta*c1delta 
-gammac1nkpc*c1kappa*c1tau/(c1chi+c1sigma)
+gammac2nkpc*c2kappa*c2tau/(c2chi+c2sigma)
-gammadelta*(1-2*c1tau)/c1sigma = 0;

/////////////////////////
// Structural equations
/////////////////////////

c1pi = c1kappa*(c1y +c1tau/(c1chi+c1sigma)*c1delta + c1u) + c1beta *c1pi(+1);

c2pi = c2kappa*(c2y -c2tau/(c2chi+c2sigma)*c1delta + c2u) + c2beta *c2pi(+1);

c1y - c2y = (1-2*c1tau)/c1sigma * c1delta;

c1relc = 1/c1sigma*c1q;

c1q = (c1omegac+c2omegac-1)*c1delta;

////////////
// Shocks
////////////

c1u = c1rhou*c1u(-1) + c1sigmau*c1uerr;

c2u = c2rhou*c2u(-1) + c2sigmau*c2uerr;

end;

steady;
check;
stoch_simul(order=1,nocorr,print,irf=0);