function [residual, g1, g2, g3] = LQBBCDL_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [M_.exo_nbr by nperiods] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           columns: equations in order of declaration
%                                                           rows: variables in order stored in M_.lead_lag_incidence
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              columns: equations in order of declaration
%                                                              rows: variables in order stored in M_.lead_lag_incidence
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(12, 1);
residual(1) = (-params(17))*y(5)+y(12)-y(3);
residual(2) = (-params(18))*y(6)+y(13)-y(4);
residual(3) = (-params(19))*y(7)-y(12)*params(1)+y(14);
residual(4) = (-params(20))*y(8)-y(13)*params(9)-y(14);
residual(5) = (-params(21))*y(9)-y(12)*params(1)*params(2)/(params(3)+params(4))+y(13)*params(9)*params(10)/(params(11)+params(12))-y(14)*(1-2*params(2))/params(4);
lhs =y(5);
rhs =params(1)*(y(7)+y(9)*params(2)/(params(3)+params(4))+y(10))+params(7)*y(17);
residual(6)= lhs-rhs;
lhs =y(6);
rhs =params(9)*(y(8)-y(9)*params(10)/(params(11)+params(12))+y(11))+params(15)*y(18);
residual(7)= lhs-rhs;
lhs =y(7)-y(8);
rhs =y(9)*(1-2*params(2))/params(4);
residual(8)= lhs-rhs;
lhs =y(15);
rhs =1/params(4)*y(16);
residual(9)= lhs-rhs;
lhs =y(16);
rhs =y(9)*(params(8)+params(16)-1);
residual(10)= lhs-rhs;
lhs =y(10);
rhs =params(5)*y(1)+params(6)*x(it_, 1);
residual(11)= lhs-rhs;
lhs =y(11);
rhs =params(13)*y(2)+params(14)*x(it_, 2);
residual(12)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(12, 20);

  %
  % Jacobian matrix
  %

  g1(1,5)=(-params(17));
  g1(1,3)=(-1);
  g1(1,12)=1;
  g1(2,6)=(-params(18));
  g1(2,4)=(-1);
  g1(2,13)=1;
  g1(3,7)=(-params(19));
  g1(3,12)=(-params(1));
  g1(3,14)=1;
  g1(4,8)=(-params(20));
  g1(4,13)=(-params(9));
  g1(4,14)=(-1);
  g1(5,9)=(-params(21));
  g1(5,12)=(-(params(1)*params(2)/(params(3)+params(4))));
  g1(5,13)=params(9)*params(10)/(params(11)+params(12));
  g1(5,14)=(-((1-2*params(2))/params(4)));
  g1(6,5)=1;
  g1(6,17)=(-params(7));
  g1(6,7)=(-params(1));
  g1(6,9)=(-(params(1)*params(2)/(params(3)+params(4))));
  g1(6,10)=(-params(1));
  g1(7,6)=1;
  g1(7,18)=(-params(15));
  g1(7,8)=(-params(9));
  g1(7,9)=(-(params(9)*(-(params(10)/(params(11)+params(12))))));
  g1(7,11)=(-params(9));
  g1(8,7)=1;
  g1(8,8)=(-1);
  g1(8,9)=(-((1-2*params(2))/params(4)));
  g1(9,15)=1;
  g1(9,16)=(-(1/params(4)));
  g1(10,9)=(-(params(8)+params(16)-1));
  g1(10,16)=1;
  g1(11,1)=(-params(5));
  g1(11,10)=1;
  g1(11,19)=(-params(6));
  g1(12,2)=(-params(13));
  g1(12,11)=1;
  g1(12,20)=(-params(14));
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],12,400);
end
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],12,8000);
end
end
