
% BBswitch = 0 parameterization as in manuscript Bodenstein & Guerrieri
% BBswitch = 1 parameterization as in Benigno and Benigno

BBswitch = 0;  
if BBswitch == 0
    % country 1
    c1lss      = 1;
    c1chi      = 0.5;
    c1sigma    = 2;
    c1beta     = 1/1.01;
    c1nup      = 1/9;
    c1telast   = 2;        
    c1rhoc     = 1/(c1telast-1);
    c1omegac   = 0.85;
    c1rhou     = 0;
    c1sigmau   = 0.004;
    c1xip      = 0.75;

    %country  2
    c2lss      = c1lss;
    c2chi      = c1chi;
    c2sigma    = c1sigma;
    c2beta     = c1beta;
    c2nup      = c1nup;
    c2rhoc     = c1rhoc;
    c2omegac   = c1omegac;
    c2rhou     = c1rhou;
    c2sigmau   = c1sigmau;
    c2xip      = c1xip; 
    
elseif BBswitch == 1
    % country 1
    c1lss      = 1;
    c1chi      = 0.47;
    c1sigma    = 2;
    c1beta     = 0.99;
    c1nup      = 1/5;
    c1telast   = 3;        
    c1rhoc     = 1/(c1telast-1);
    c1omegac   = 0.5;
    c1rhou     = 0;
    c1sigmau   = 1;
    c1xip      = 0.66;

    %country  2
    c2lss      = c1lss;
    c2chi      = c1chi;
    c2sigma    = c1sigma;
    c2beta     = c1beta;
    c2nup      = c1nup;
    c2rhoc     = c1rhoc;
    c2omegac   = c1omegac;
    c2rhou     = c1rhou;
    c2sigmau   = c1sigmau;
    c2xip      = 0.75; 
end

% composite parameters
c2lambda   = (1-c2beta*c2xip)*(1-c2xip)/c2xip/(1+(1+c2nup)/c2nup*c2chi);
c2kappa    = c2lambda*(c2chi+c2sigma);
c2tau      = -2*c2omegac*(1-c2omegac)*(c2sigma*(1+c2rhoc)/c2rhoc-1);

c1lambda   = (1-c1beta*c1xip)*(1-c1xip)/c1xip/(1+(1+c1nup)/c1nup*c1chi);
c1kappa    = c1lambda*(c1chi+c1sigma);
c1tau      = -2*c1omegac*(1-c1omegac)*(c1sigma*(1+c1rhoc)/c1rhoc-1);

% policymaker
lambdac1y  = c1chi+c1sigma;
lambdac2y  = c2chi+c2sigma;
lambdac1pi = 1/c1lambda*(1+c1nup)/c1nup;
lambdac2pi = 1/c2lambda*(1+c2nup)/c2nup;
lambdac1delta = (1-2*c1tau)/c1sigma*c1tau;





