function [residual, g1, g2] = LQBBCDL_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                    columns: equations in order of declaration
%                                                    rows: variables in declaration order
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: equations in order of declaration
%                                                       rows: variables in declaration order
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 12, 1);

%
% Model equations
%

residual(1) = (-params(17))*y(1)+y(8)-y(8);
residual(2) = (-params(18))*y(2)+y(9)-y(9);
residual(3) = (-params(19))*y(3)-y(8)*params(1)+y(10);
residual(4) = (-params(20))*y(4)-y(9)*params(9)-y(10);
residual(5) = (-params(21))*y(5)-y(8)*params(1)*params(2)/(params(3)+params(4))+y(9)*params(9)*params(10)/(params(11)+params(12))-y(10)*(1-2*params(2))/params(4);
lhs =y(1);
rhs =params(1)*(y(3)+y(5)*params(2)/(params(3)+params(4))+y(6))+y(1)*params(7);
residual(6)= lhs-rhs;
lhs =y(2);
rhs =params(9)*(y(4)-y(5)*params(10)/(params(11)+params(12))+y(7))+y(2)*params(15);
residual(7)= lhs-rhs;
lhs =y(3)-y(4);
rhs =y(5)*(1-2*params(2))/params(4);
residual(8)= lhs-rhs;
lhs =y(11);
rhs =1/params(4)*y(12);
residual(9)= lhs-rhs;
lhs =y(12);
rhs =y(5)*(params(8)+params(16)-1);
residual(10)= lhs-rhs;
lhs =y(6);
rhs =y(6)*params(5)+params(6)*x(1);
residual(11)= lhs-rhs;
lhs =y(7);
rhs =y(7)*params(13)+params(14)*x(2);
residual(12)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(12, 12);

  %
  % Jacobian matrix
  %

  g1(1,1)=(-params(17));
  g1(2,2)=(-params(18));
  g1(3,3)=(-params(19));
  g1(3,8)=(-params(1));
  g1(3,10)=1;
  g1(4,4)=(-params(20));
  g1(4,9)=(-params(9));
  g1(4,10)=(-1);
  g1(5,5)=(-params(21));
  g1(5,8)=(-(params(1)*params(2)/(params(3)+params(4))));
  g1(5,9)=params(9)*params(10)/(params(11)+params(12));
  g1(5,10)=(-((1-2*params(2))/params(4)));
  g1(6,1)=1-params(7);
  g1(6,3)=(-params(1));
  g1(6,5)=(-(params(1)*params(2)/(params(3)+params(4))));
  g1(6,6)=(-params(1));
  g1(7,2)=1-params(15);
  g1(7,4)=(-params(9));
  g1(7,5)=(-(params(9)*(-(params(10)/(params(11)+params(12))))));
  g1(7,7)=(-params(9));
  g1(8,3)=1;
  g1(8,4)=(-1);
  g1(8,5)=(-((1-2*params(2))/params(4)));
  g1(9,11)=1;
  g1(9,12)=(-(1/params(4)));
  g1(10,5)=(-(params(8)+params(16)-1));
  g1(10,12)=1;
  g1(11,6)=1-params(5);
  g1(12,7)=1-params(13);
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],12,144);
end
end
