function [] = edit_shocks(shockmat)

% edit_shocks.m

% PURPOSE: comment in/out the shocks on all .mod files in the current 
% folder. Before running, all .mod files should have a shocks block of the 
% following form:
%
% shocks;
% var shock_1 = ...;
% // var shock_2 = ...;
% ...
% var shock_n = ...;
% end;

% INPUT: shockmat, which can take one of three forms:
% - 'all': this will turn all shocks on
% - 'none': this will turn all shocks off
% - a character matrix of shocks to comment in; all other shocks will be
%   commented out.

% OUTPUT: all .mod files in the folder are edited to have the shocks in
% shockmat turned on 

mod_files = dir('*.mod');

for i = 1:size(mod_files,1)
    
    modfile = fopen(mod_files(i).name,'r');
    temp_modfile = fopen(['temp_',mod_files(i).name],'w');
    shocks_flag = 0;
    
    while ~feof(modfile)        
        current_line = fgets(modfile); 

       
        if shocks_flag
           if strfind(current_line,'end;');
               shocks_flag = 0;
               if strcmp(shockmat,'none')
                    current_line = ['//',current_line];
               else
                    current_line = strrep(current_line,'//','');
               end;
           else
               if strcmp(shockmat,'all')
                   current_line = strrep(current_line,'//','');
               elseif strcmp(shockmat,'none')
                   current_line = ['//',current_line];                    
               else
                   find_shock = 0;
                   
                   for j = 1:size(shockmat,1)
                       if ~isempty(strfind(current_line,[deblank(shockmat(j,:)),' '])) || ~isempty(strfind(current_line,[deblank(shockmat(j,:)),'=']))
                           find_shock = 1;
                           current_line = strrep(current_line,'//','');
                       end;
                   end;
                   if find_shock == 0
                       current_line = ['//',current_line];     
                   end;
               end;
           end;
        elseif strfind(current_line,'shocks;')
            shocks_flag = 1;
            if strcmp(shockmat,'none')
                current_line = ['//',current_line];
            else
                current_line = strrep(current_line,'//','');
            end;
        end;
        
        fprintf(temp_modfile,'%s',current_line);        
    end;
    
    fclose('all');
    
    delete(mod_files(i).name);
    movefile(['temp_',mod_files(i).name],mod_files(i).name);
    
end;

