%% Create the guess_RAMSEY_FILE_steadystate.m file.

fin = fopen([infilename,'_steadystate.m'],'r');
fout = fopen(['guess_',outfilename,'_steadystate.m'],'w');

% Replacing all instances of infilename with outfilename.
while ~feof(fin)
    s = fgets(fin);
    s = strrep(s,infilename,outfilename);
    fprintf(fout,'%s',s);
end;

fclose(fin);
fclose(fout);

%% Create the new _paramfile.m
cmd = [' copyfile ', infilename,'_paramfile.m ', outfilename,'_paramfile.m'];
eval(cmd);


%% Create the new _ss_defs.f file.
% Copying over the old file into the new filename.
cmd = [' copyfile ',infilename,'_ss_defs.m ', outfilename,'_ss_defs.m'];
eval(cmd);

fid=fopen([outfilename,'_ss_defs.m'],'a');

fprintf(fid,'\n');
f3in = fopen('template_for_initialization_lmss.m','r');
while ~feof(f3in)
    s = fgets(f3in);
    fprintf(fid,'%s',s);
end;
fclose(f3in);
fprintf(fid,'\n');

% Writing the line that will run the program to find the steady-state
% values for the Lagrangian multipliers.
fprintf(fid,'%s \n',[outfilename,'_lmss;']);

% Assigning the guesses to the Lagrangian multipliers.
for iindx =1:nbehaveqs
    
    out_s  = ['lmult',num2str(iindx),'=lmss_vals(',num2str(iindx),');'];
    fprintf(fid,'%s \n',out_s);
end

fclose(fid);

%% Create the new _steadystate.m file

f2in = fopen('template_for_ramsey_steadystate.m','r');
f2out = fopen([outfilename,'_steadystate.m'],'w');

while ~feof(f2in)
    s = fgets(fin);
    s = strrep(s,'RAMSEY_FILE',outfilename);
    fprintf(f2out,'%s',s);
end;

fclose(f2in);
fclose(f2out);