%% Program: one_country_ramsey.m
% Takes the original *infilename*.mod file and prepares a separate 
% *infilename*_1country.mod file which can be passed through get_ramsey.m.

% INPUTS: 
% infilename: the file name to be modified
% country_string: must be the string '1' or '2', representing the number of
% the country employing the Ramsey policy.

function []= one_country_ramsey(infilename, ramsey_country_string, instrument)

deleteUtil1 = 0;
deleteUtil2 = 0;
addWelf = 0;

var_block = 0;
model_block = 0;
param_block = 0;

outfilename = [infilename,'_country',ramsey_country_string];

if ramsey_country_string == '1'
    other_country_string = '2';
elseif ramsey_country_string == '2'
    other_country_string = '1';
else
    error('The second input must be 1 or 2, representing the number of the country employing Ramsey policy.');
end;

%% Edit .mod

fin = fopen([infilename,'.mod'],'r');
fout = fopen([outfilename,'.mod'],'w');

while ~feof(fin)
    in_line = fgets(fin);
    in_line_change = 0;
    
    % Adds Util and Welf to var block and takes out Util1 and Util2
    % This block is in place of template_for_NASH/RAMSEYpolicyvar.m.
    if strncmp(in_line,'var ',4) & var_block == 0,
        var_block = 1;
        out_line = in_line(5:end);
        in_line_change = 1;
        fprintf(fout,'%s \n','var Util,');
        fprintf(fout,'%s \n','Welf,');
    end;
    
    if deleteUtil1 == 0 & strfind(in_line,'Util1')
        if strfind(in_line,'Util1,')
            out_line = strrep(in_line,'Util1,','');
            in_line_change = 1; 
        elseif strfind(in_line,'Util1;')
            out_line = strrep(in_line,'Util1','');
            in_line_change = 1;
        end;
        deleteUtil1 = 1;
    end;
    
    if deleteUtil2 == 0 & strfind(in_line,'Util2')
        if strfind(in_line,'Util2,')
            out_line = strrep(in_line,'Util2,','');
            in_line_change = 1; 
        elseif strfind(in_line,'Util2;')
            out_line = strrep(in_line,'Util2','');
            in_line_change = 1; 
        end;
        deleteUtil2 = 1;
    end;
    
    % Adds nbeta to parameters block. This is important because nbeta is
    % the discount parameter that must be used to define welfare so the
    % program passes through get_ramsey.
    
    % This replaces template_for_NASH/RAMSEYpolicyparam.m.
    
    if strncmp(in_line,'parameters ',11) & param_block == 0,
        param_block = 1;
        fprintf(fout,'%s \n','parameters nbeta,');
        in_line_change = 1;
        out_line = in_line(12:end);
    end;
    
    % Adds Welf equation to model block, deletes the Util function of the
    % country who is not using Ramsey policy, and removes the "Policy Rule"
    % header before the country who is not using Nash policy.
    
    % This section replaces templace_for_NASH/RAMSEYpolicyblock.m.
    
    if model_block == 1 & addWelf == 0
        fprintf(fout,'%s','Welf = Util + nbeta*Welf(1);');
        addWelf = 1;
    end;
    
    if strncmp(in_line,'model;',6) & model_block == 0,
        model_block = 1;
    end;
    
    if strncmp(in_line,['Util',ramsey_country_string,' ='],7)
        out_line = strrep(in_line,['Util',ramsey_country_string],'Util');
        in_line_change = 1;
    end;
    
    if strncmp(in_line,['Util',other_country_string,' ='],7)
        out_line = '';
        in_line_change = 1; 
    end;
        
    if strncmp(in_line,'//',2) & strfind(in_line,'Policy Rule') & strfind(in_line,other_country_string)
        out_line = '';
        in_line_change = 1; 
    end;
    
    if in_line_change == 0
        out_line = in_line;
    end;
    
    if ~isempty(out_line)
        fprintf(fout,'%s',out_line);
    end;
end;
       
%% Edit _steadystate.m

f2in = fopen([infilename,'_steadystate.m'],'r');
f2out = fopen([outfilename,'_steadystate.m'],'w');

while ~feof(f2in)
    in_line = fgets(f2in);
    if strfind(in_line,infilename)
       out_line = strrep(in_line,infilename,outfilename);
    else
       out_line = in_line;
    end;
    fprintf(f2out,'%s',out_line);
end;

%% Edit _ss_defs.m. 

f3in = fopen([infilename,'_ss_defs.m'],'r');
f3out = fopen([outfilename,'_ss_defs.m'],'w');

while ~feof(f3in)
    in_line = fgets(f3in);
    fprintf(f3out,'%s',in_line);
end;

% Adds the SS definition for Util to be equal to the Util of the country using Ramsey policy
% This section of the code replaces template_for_NASH/RAMSEYsetss.m.
fprintf(f3out,'%s \n',['Util = Util',ramsey_country_string,';']);
fprintf(f3out,'%s \n',['Welf = Util/(1-nbeta);']);


%% Copy _paramfile.m
f4in = fopen([infilename,'_paramfile.m'],'r');
f4out = fopen([outfilename,'_paramfile.m'],'w');

while ~feof(f4in)
    in_line = fgets(f4in);
    fprintf(f4out,'%s',in_line);
end;

% Sets the value of nbeta in _paramfile.
f5in = fopen('template_for_one_country_ramseypolicyparamdef.m','r');

while ~feof(f5in)
    in_line = fgets(f5in);
    fprintf(f4out,'%s',in_line);
end;


%% Run get_aux.m to create the auxiliary .mod file replacing leads and lags of endogenous variables.
infilename = outfilename;
get_aux(infilename,'one_country_ramsey',instrument);

%% Run ramsey.m using the new modfile.
infilename = [infilename,'_aux'];
outfilename = [infilename,'_ramsey'];
get_ramsey;
make_ss_one_country_ramsey;