% Program: get_annealed_ss.m

% Function: Finds an initial guess for steady-state values for the
% .mod file that results after running convertmodfiles on the initial file.
function F = test_for_ss(modfile)

global M_ oo_

try
    eval(['dynare ',modfile,' noclearall']);
catch
    disp('Finding steady states.')    
    init_y = oo_.dr.ys;
    
    % Runs simulated annealing to find best guess for SS values.
    
    get_resid_static_anneal = @(y)get_resid_static_scalar(y,modfile);
    option = anneal();
    option.Verbosity = 2;
    [final_y_anneal, sum_resid_square] = anneal(get_resid_static_anneal,init_y);
    init_y = final_y_anneal;
    opt = optimset('Jacobian','on', 'Display', 'iter','MaxIter',500000, 'MaxFunEvals', 10000);
    
    y = fsolve(@(y) get_resid_static(y,modfile), init_y, opt);
    
    % Outputs new steady-state values and saves them in _ss_defs.m.
    
    for i=1:M_.endo_nbr,
        ss_eqs(i,1) =cellstr([M_.endo_names(i,:),'=',num2str(y(i),14),';']);
    end
    
    fid=fopen([modfile,'_ss_defs.m'],'w');
    
    for i = 1:length(ss_eqs)
        fprintf(fid,'%s \n',char(ss_eqs(i)));
    end;
    fclose(fid);
end;

