% Write out Ramsey model to dynare .MOD file
% Assumes that rawfile, focmat, lmult_string, and lmult_initstr
% have been set by dynmod2sym and get_ramsey

% if there's no initval block to set the steady-state values of the
% endogenous variables, check for a _steadystate.m file. If so, set
% endinitline = 1.
if exist([infilename,'_steadystate.m'],'file') && endinitline == 0
    endinitline = 1;
else
    error('Need to declare steady-states in the .mod file or in a _steadystate.m file.')
end;

% Confirm that modline, ruleline, endruleline, and endinitline
% have been determined by dynmod2sym

if ~modline | ~endinitline | ~rulecount,
  error('Key line in input file not found (modline, ruleline, or endinitline)');
end;


% Open output file (assumes that outfilename has been set)

[outfid,msg] = fopen([outfilename,'.mod'],'w');

% Copy all lines of input file prior to "model" keyword

for iline = 1:(modline-1),
  fprintf(outfid,'%s \n',char(rawfile(iline)));
end;

% Declare lagrange multipliers as dynare endogenous variables
% and declare lagrange multiplier steady states as "parameters".

% If policy_problem = 'nash' or 'ramsey', we add Welf1 and Welf2 back as
% variables in the model.

delim = ', ';
endline = ' ';
if isempty(strmatch(policy_problem,'one_agent_ramsey'))
    lmultlist = vertcat(lmultlist,{'Welf1';'Welf2'});
end;
writelist(outfid,'var',lmultlist,delim,endline);
%writelist(outfid,'parameters',lmss_list,delim,endline);

% Copy all lines from "model" keyword until first policy rule equation

for iline = modline:rulestartline(1),
  if strncmp('//Welf1 =',char(rawfile(iline)),8) | strncmp('//Welf2 =',char(rawfile(iline)),8)
      rawfile(iline) = cellfun(@(x) x(3:end), rawfile(iline), 'UniformOutput', false);
  end;
  fprintf(outfid,'%s \n',char(rawfile(iline)));
end;

% Write out Ramsey FOCs

fprintf(outfid,'%s \n', '// Policymaker''s First-Order Conditions');

for ifoc = 1:length(focmat),
  fprintf(outfid,'%s \n',char(focmat(ifoc)));
end;

% Copy input file lines (not including any other simple policy equations)
% prior to the end of the variable initialization block

startline = rulestopline(1) + 1;
for irule = 2:rulecount,
  stopline = rulestartline(irule);
  for iline = startline:stopline,
    fprintf(outfid,'%s \n',char(rawfile(iline)));
  end;
  startline = rulestopline(irule) + 1;
end;
 
% If endinitline was set to 1 above, then just print the new .mod file. If
% an initval block has been declared (which means that endinitline > 1),
% then write initial guesses for the Lagrange multipliers in the initval
% block and otherwise print the rest of the new .mod file as is.

if endinitline < 2,
  for iline = startline:length(rawfile),
    fprintf(outfid,'%s \n',char(rawfile(iline)));
  end;  
  
  
else
  for iline = startline:(endinitline-1),
    fprintf(outfid,'%s \n',char(rawfile(iline)));
  end;

% Write out initial guesses for Lagrange multipliers

  for ilm = 1:length(lmultlist),
    lmname = char(lmultlist(ilm));
    lmult_initstr = [lmname,' = 0;'];
    fprintf(outfid,'%s \n',lmult_initstr);
  end;

% Write out "end" keyword for initialization block,
% and then copy the rest of the input file

  for iline = endinitline:length(rawfile),
    fprintf(outfid,'%s \n',char(rawfile(iline)));
  end;
  
end;

fclose(outfid);