clear;

% sets the path to the AIM routines needed in solving the model
setpathaim;


modname = 'mod25';
paramfilename1 = 'paramfile50';
paramfilename2 = 'defmod25';


TT = 20;            %length of IRFs



%solve model
[decrule,endog_]=eggmodfun(modname,paramfilename1,paramfilename2);

eval(paramfilename1)


% generate model IRFs
% model name of variables whose true responses we want to save
wishlist = char('ule','ukp','ugdp','uif','ucc','util');

% var name of variables above
% hours, capital (next period), output, investment, consumption
plotlist = char('Nirftrue','kirftrue','yirftrue','iirftrue','cirftrue','utiltrue');% generate IRFs for wishlist. IRFs are save in ZDATA

% gets IRFs
zdata = mkdata(TT,decrule,endog_,wishlist,errlist,irfshock,scalefactormod);
% unpack ZDATA
nwishes = size(wishlist,1);
for i=1:nwishes
    eval([plotlist(i,:),'=zdata(:,i);']);
end

plothoardirf;

% to generate data use:
% nobs = 1000;
% %errlist can be tailored to vary the activity shocks in the MC experiment
% %remember to set a seed for the randn command (used in mkdata) to ensure 
% %replicability of the MC samples
% zdata = mkdata(nobs,decrule,endog_,wishlist,errlist);



